/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.cloud.endpoint.event.RefreshEventListener;
import org.springframework.cloud.logging.LoggingRebinder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.stereotype.Component;

@Configuration
@ConditionalOnClass(value={RefreshScope.class})
@ConditionalOnProperty(name={"spring.cloud.refresh.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class RefreshAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public static LoggingRebinder loggingRebinder() {
        return new LoggingRebinder();
    }

    @Bean
    @ConditionalOnMissingBean
    public ContextRefresher contextRefresher(ConfigurableApplicationContext context, RefreshScope scope) {
        return new ContextRefresher(context, scope);
    }

    @Bean
    public RefreshEventListener refreshEventListener(ContextRefresher contextRefresher) {
        return new RefreshEventListener(contextRefresher);
    }

    @Component
    protected static class RefreshScopeBeanDefinitionEnhancer
    implements BeanDefinitionRegistryPostProcessor {
        private Set<String> refreshables = new HashSet<String>(Arrays.asList("com.zaxxer.hikari.HikariDataSource"));
        private Environment environment;

        protected RefreshScopeBeanDefinitionEnhancer() {
        }

        public Set<String> getRefreshable() {
            return this.refreshables;
        }

        public void setRefreshable(Set<String> refreshables) {
            if (this.refreshables != refreshables) {
                this.refreshables.clear();
            }
            this.refreshables.addAll(refreshables);
        }

        public void setExtraRefreshable(Set<String> refreshables) {
            this.refreshables.addAll(refreshables);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            for (String name : registry.getBeanDefinitionNames()) {
                BeanDefinition definition = registry.getBeanDefinition(name);
                if (!this.isApplicable(registry, name, definition)) continue;
                BeanDefinitionHolder holder = new BeanDefinitionHolder(definition, name);
                BeanDefinitionHolder proxy = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry, (boolean)true);
                definition.setScope("refresh");
                registry.registerBeanDefinition(proxy.getBeanName(), proxy.getBeanDefinition());
            }
        }

        private boolean isApplicable(BeanDefinitionRegistry registry, String name, BeanDefinition definition) {
            Class cls;
            String scope = definition.getScope();
            if ("refresh".equals(scope)) {
                return false;
            }
            String type = definition.getBeanClassName();
            if (registry instanceof BeanFactory && (cls = ((BeanFactory)registry).getType(name)) != null) {
                type = cls.getName();
            }
            if (type != null) {
                if (this.environment == null && registry instanceof BeanFactory) {
                    this.environment = (Environment)((BeanFactory)registry).getBean(Environment.class);
                }
                if (this.environment == null) {
                    this.environment = new StandardEnvironment();
                }
                Binder.get((Environment)this.environment).bind("spring.cloud.refresh", Bindable.ofInstance((Object)this));
                return this.refreshables.contains(type);
            }
            return false;
        }
    }

    @Component
    @ConditionalOnMissingBean(value={RefreshScope.class})
    protected static class RefreshScopeConfiguration
    implements BeanDefinitionRegistryPostProcessor {
        protected RefreshScopeConfiguration() {
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            registry.registerBeanDefinition("refreshScope", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(RefreshScope.class).setRole(2).getBeanDefinition());
        }
    }
}

