/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client.reactive;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockClientHttpResponse
implements ClientHttpResponse {
    private final int status;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap();
    private Flux<DataBuffer> body = Flux.empty();

    public MockClientHttpResponse(HttpStatus status) {
        Assert.notNull((Object)status, (String)"HttpStatus is required");
        this.status = status.value();
    }

    public MockClientHttpResponse(int status) {
        Assert.isTrue((status > 99 && status < 1000 ? 1 : 0) != 0, (String)"Status must be between 100 and 999");
        this.status = status;
    }

    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf((int)this.status);
    }

    public int getRawStatusCode() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        if (!this.getCookies().isEmpty() && this.headers.get((Object)"Set-Cookie") == null) {
            this.getCookies().values().stream().flatMap(Collection::stream).forEach(cookie -> this.getHeaders().add("Set-Cookie", cookie.toString()));
        }
        return this.headers;
    }

    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.cookies;
    }

    public void setBody(Publisher<DataBuffer> body2) {
        this.body = Flux.from(body2);
    }

    public void setBody(String body2) {
        this.setBody(body2, StandardCharsets.UTF_8);
    }

    public void setBody(String body2, Charset charset) {
        DataBuffer buffer = this.toDataBuffer(body2, charset);
        this.body = Flux.just((Object)buffer);
    }

    private DataBuffer toDataBuffer(String body2, Charset charset) {
        byte[] bytes = body2.getBytes(charset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return DefaultDataBufferFactory.sharedInstance.wrap(byteBuffer);
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public Mono<String> getBodyAsString() {
        return DataBufferUtils.join(this.getBody()).map(buffer -> {
            String s = buffer.toString(this.getCharset());
            DataBufferUtils.release((DataBuffer)buffer);
            return s;
        }).defaultIfEmpty((Object)"");
    }

    private Charset getCharset() {
        Charset charset = null;
        MediaType contentType = this.getHeaders().getContentType();
        if (contentType != null) {
            charset = contentType.getCharset();
        }
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    public String toString() {
        HttpStatus code = HttpStatus.resolve((int)this.status);
        return (code != null ? code.name() + "(" + this.status + ")" : "Status (" + this.status + ")") + this.headers;
    }
}

