/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.session;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.fun.SaRetFunction;
import cn.dev33.satoken.session.TokenSign;
import cn.dev33.satoken.util.SaFoxUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class SaSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ROLE_LIST = "ROLE_LIST";
    public static final String PERMISSION_LIST = "PERMISSION_LIST";
    private String id;
    private long createTime;
    private final Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
    private final List<TokenSign> tokenSignList = new Vector<TokenSign>();

    public SaSession() {
    }

    public SaSession(String id) {
        this.id = id;
        this.createTime = System.currentTimeMillis();
        SaManager.getSaTokenListener().doCreateSession(id);
    }

    public String getId() {
        return this.id;
    }

    public SaSession setId(String id) {
        this.id = id;
        return this;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public SaSession setCreateTime(long createTime) {
        this.createTime = createTime;
        return this;
    }

    public List<TokenSign> getTokenSignList() {
        return new Vector<TokenSign>(this.tokenSignList);
    }

    public TokenSign getTokenSign(String tokenValue) {
        for (TokenSign tokenSign : this.getTokenSignList()) {
            if (!tokenSign.getValue().equals(tokenValue)) continue;
            return tokenSign;
        }
        return null;
    }

    public void addTokenSign(TokenSign tokenSign) {
        for (TokenSign tokenSign2 : this.getTokenSignList()) {
            if (!tokenSign2.getValue().equals(tokenSign.getValue())) continue;
            return;
        }
        this.tokenSignList.add(tokenSign);
        this.update();
    }

    public void addTokenSign(String tokenValue, String device) {
        this.addTokenSign(new TokenSign(tokenValue, device));
    }

    public void removeTokenSign(String tokenValue) {
        TokenSign tokenSign = this.getTokenSign(tokenValue);
        if (this.tokenSignList.remove(tokenSign)) {
            this.update();
        }
    }

    public void update() {
        SaManager.getSaTokenDao().updateSession(this);
    }

    public void logout() {
        SaManager.getSaTokenDao().deleteSession(this.id);
        SaManager.getSaTokenListener().doLogoutSession(this.id);
    }

    public void logoutByTokenSignCountToZero() {
        if (this.tokenSignList.size() == 0) {
            this.logout();
        }
    }

    public long getTimeout() {
        return SaManager.getSaTokenDao().getSessionTimeout(this.id);
    }

    public void updateTimeout(long timeout) {
        SaManager.getSaTokenDao().updateSessionTimeout(this.id, timeout);
    }

    public void updateMinTimeout(long minTimeout) {
        if (this.getTimeout() < minTimeout) {
            SaManager.getSaTokenDao().updateSessionTimeout(this.id, minTimeout);
        }
    }

    public void updateMaxTimeout(long maxTimeout) {
        if (this.getTimeout() > maxTimeout) {
            SaManager.getSaTokenDao().updateSessionTimeout(this.id, maxTimeout);
        }
    }

    public Object get(String key) {
        return this.dataMap.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        return this.getValueByDefaultValue(this.get(key), defaultValue);
    }

    public <T> T get(String key, SaRetFunction fun) {
        Object value = this.get(key);
        if (value == null) {
            value = fun.run();
            this.set(key, value);
        }
        return (T)value;
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public int getInt(String key) {
        return this.getValueByDefaultValue(this.get(key), 0);
    }

    public long getLong(String key) {
        return this.getValueByDefaultValue(this.get(key), 0L);
    }

    public double getDouble(String key) {
        return this.getValueByDefaultValue(this.get(key), 0.0);
    }

    public float getFloat(String key) {
        return this.getValueByDefaultValue(this.get(key), Float.valueOf(0.0f)).floatValue();
    }

    public <T> T getModel(String key, Class<T> cs) {
        return SaFoxUtil.getValueByType(this.get(key), cs);
    }

    public <T> T getModel(String key, Class<T> cs, Object defaultValue) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return (T)defaultValue;
        }
        return SaFoxUtil.getValueByType(value, cs);
    }

    public Set<String> keys() {
        return this.dataMap.keySet();
    }

    public SaSession set(String key, Object value) {
        this.dataMap.put(key, value);
        this.update();
        return this;
    }

    public SaSession setDefaultValue(String key, Object value) {
        if (!this.has(key)) {
            this.dataMap.put(key, value);
            this.update();
        }
        return this;
    }

    public boolean has(String key) {
        return !this.valueIsNull(this.get(key));
    }

    public SaSession delete(String key) {
        this.dataMap.remove(key);
        this.update();
        return this;
    }

    public void clear() {
        this.dataMap.clear();
        this.update();
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public void refreshDataMap(Map<String, Object> dataMap) {
        this.dataMap.clear();
        this.dataMap.putAll(dataMap);
        this.update();
    }

    public boolean valueIsNull(Object value) {
        return value == null || value.equals("");
    }

    protected <T> T getValueByDefaultValue(Object value, T defaultValue) {
        if (this.valueIsNull(value)) {
            return defaultValue;
        }
        Class<?> cs = defaultValue.getClass();
        return (T)SaFoxUtil.getValueByType(value, cs);
    }

    @Deprecated
    public void setAttribute(String key, Object value) {
        this.dataMap.put(key, value);
        this.update();
    }

    @Deprecated
    public Object getAttribute(String key) {
        return this.dataMap.get(key);
    }

    @Deprecated
    public Object getAttribute(String key, Object defaultValue) {
        Object value = this.getAttribute(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Deprecated
    public void removeAttribute(String key) {
        this.dataMap.remove(key);
        this.update();
    }

    @Deprecated
    public void clearAttribute() {
        this.dataMap.clear();
        this.update();
    }

    @Deprecated
    public boolean containsAttribute(String key) {
        return this.dataMap.containsKey(key);
    }

    @Deprecated
    public Set<String> attributeKeys() {
        return this.dataMap.keySet();
    }
}

