/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.validation;

import cn.hutool.extra.validation.BeanValidationResult;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public class ValidationUtil {
    private static final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public static Validator getValidator() {
        return validator;
    }

    public static <T> Set<ConstraintViolation<T>> validate(T bean, Class<?> ... groups) {
        return validator.validate(bean, (Class[])groups);
    }

    public static <T> Set<ConstraintViolation<T>> validateProperty(T bean, String propertyName, Class<?> ... groups) {
        return validator.validateProperty(bean, propertyName, (Class[])groups);
    }

    public static <T> BeanValidationResult warpValidate(T bean, Class<?> ... groups) {
        return ValidationUtil.warpBeanValidationResult(ValidationUtil.validate(bean, groups));
    }

    public static <T> BeanValidationResult warpValidateProperty(T bean, String propertyName, Class<?> ... groups) {
        return ValidationUtil.warpBeanValidationResult(ValidationUtil.validateProperty(bean, propertyName, groups));
    }

    private static <T> BeanValidationResult warpBeanValidationResult(Set<ConstraintViolation<T>> constraintViolations) {
        BeanValidationResult result = new BeanValidationResult(constraintViolations.isEmpty());
        for (ConstraintViolation<T> constraintViolation : constraintViolations) {
            BeanValidationResult.ErrorMessage errorMessage = new BeanValidationResult.ErrorMessage();
            errorMessage.setPropertyName(constraintViolation.getPropertyPath().toString());
            errorMessage.setMessage(constraintViolation.getMessage());
            errorMessage.setValue(constraintViolation.getInvalidValue());
            result.addErrorMessage(errorMessage);
        }
        return result;
    }
}

