/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.engine.freemark;

import cn.smallbun.screw.core.engine.AbstractTemplateEngine;
import cn.smallbun.screw.core.engine.EngineConfig;
import cn.smallbun.screw.core.engine.EngineTemplateType;
import cn.smallbun.screw.core.exception.ProduceException;
import cn.smallbun.screw.core.metadata.model.DataModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.FileUtils;
import cn.smallbun.screw.core.util.StringUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Objects;

public class FreemarkerTemplateEngine
extends AbstractTemplateEngine {
    private final Configuration configuration = new Configuration(Configuration.VERSION_2_3_30);

    public FreemarkerTemplateEngine(EngineConfig templateConfig) {
        super(templateConfig);
        try {
            String path = this.getEngineConfig().getCustomTemplate();
            if (StringUtils.isNotBlank(path) && FileUtils.isFileExists(path)) {
                String parent = Objects.requireNonNull(FileUtils.getFileByPath(path)).getParent();
                this.configuration.setDirectoryForTemplateLoading(new File(parent));
            } else {
                this.configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), EngineTemplateType.freemarker.getTemplateDir()));
            }
            this.configuration.setDefaultEncoding("UTF-8");
            this.configuration.setLocale(new Locale("zh_CN"));
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe(e);
        }
    }

    @Override
    public void produce(DataModel info, String docName) throws ProduceException {
        Assert.notNull(info, "DataModel can not be empty!", new Object[0]);
        String path = this.getEngineConfig().getCustomTemplate();
        try {
            Template template;
            if (StringUtils.isNotBlank(path) && FileUtils.isFileExists(path)) {
                String fileName = new File(path).getName();
                template = this.configuration.getTemplate(fileName);
            } else {
                template = this.configuration.getTemplate(this.getEngineConfig().getFileType().getTemplateNamePrefix() + EngineTemplateType.freemarker.getSuffix());
            }
            File file = this.getFile(docName);
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));){
                template.process((Object)info, (Writer)out);
                this.openOutputDir();
            }
        }
        catch (TemplateException | IOException e) {
            throw ExceptionUtils.mpe(e);
        }
    }
}

