/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.process;

import cn.smallbun.screw.core.Configuration;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.Database;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.metadata.Table;
import cn.smallbun.screw.core.metadata.model.ColumnModel;
import cn.smallbun.screw.core.metadata.model.DataModel;
import cn.smallbun.screw.core.metadata.model.TableModel;
import cn.smallbun.screw.core.process.AbstractProcess;
import cn.smallbun.screw.core.query.DatabaseQuery;
import cn.smallbun.screw.core.query.DatabaseQueryFactory;
import cn.smallbun.screw.core.util.BeanUtils;
import cn.smallbun.screw.core.util.CollectionUtils;
import cn.smallbun.screw.core.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DataModelProcess
extends AbstractProcess {
    public DataModelProcess(Configuration configuration) {
        super(configuration);
    }

    @Override
    public DataModel process() {
        DatabaseQuery query = new DatabaseQueryFactory(this.config.getDataSource()).newInstance();
        DataModel model = new DataModel();
        model.setTitle(this.config.getTitle());
        model.setOrganization(this.config.getOrganization());
        model.setOrganizationUrl(this.config.getOrganizationUrl());
        model.setVersion(this.config.getVersion());
        model.setDescription(this.config.getDescription());
        long start = System.currentTimeMillis();
        Database database = query.getDataBase();
        this.logger.debug("query the database time consuming:{}ms", (Object)(System.currentTimeMillis() - start));
        model.setDatabase(database.getDatabase());
        start = System.currentTimeMillis();
        List<? extends Table> tables = query.getTables();
        this.logger.debug("query the table time consuming:{}ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        List<? extends Column> columns = query.getTableColumns();
        this.logger.debug("query the column time consuming:{}ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        List<? extends PrimaryKey> primaryKeys = query.getPrimaryKeys();
        this.logger.debug("query the primary key time consuming:{}ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        ArrayList<TableModel> tableModels = new ArrayList<TableModel>();
        this.tablesCaching.put(database.getDatabase(), tables);
        for (Table table : tables) {
            this.columnsCaching.put(table.getTableName(), columns.stream().filter(i -> i.getTableName().equals(table.getTableName())).collect(Collectors.toList()));
            this.primaryKeysCaching.put(table.getTableName(), primaryKeys.stream().filter(i -> i.getTableName().equals(table.getTableName())).collect(Collectors.toList()));
        }
        for (Table table : tables) {
            TableModel tableModel = new TableModel();
            tableModel.setTableName(table.getTableName());
            tableModel.setRemarks(table.getRemarks());
            tableModels.add(tableModel);
            ArrayList<ColumnModel> columnModels = new ArrayList<ColumnModel>();
            List<String> keyList = ((List)this.primaryKeysCaching.get(table.getTableName())).stream().map(PrimaryKey::getColumnName).collect(Collectors.toList());
            for (Column column : (List)this.columnsCaching.get(table.getTableName())) {
                this.packageColumn(columnModels, keyList, column);
            }
            columnModels.forEach(BeanUtils::beanAttributeValueTrim);
            tableModel.setColumns(columnModels);
        }
        List<TableModel> ignore = this.handleIgnore(tableModels);
        ignore.forEach(BeanUtils::beanAttributeValueTrim);
        model.setTables(ignore);
        BeanUtils.beanAttributeValueTrim(model);
        this.logger.debug("encapsulation processing data time consuming:{}ms", (Object)(System.currentTimeMillis() - start));
        return model;
    }

    private void packageColumn(List<ColumnModel> columnModels, List<String> keyList, Column column) {
        ColumnModel columnModel = new ColumnModel();
        columnModel.setOrdinalPosition(column.getOrdinalPosition());
        columnModel.setColumnName(column.getColumnName());
        columnModel.setTypeName(column.getTypeName().toLowerCase());
        columnModel.setColumnSize(column.getColumnSize());
        columnModel.setDecimalDigits(StringUtils.defaultString(column.getDecimalDigits(), "0"));
        columnModel.setNullable("0".equals(column.getNullable()) ? "N" : "Y");
        columnModel.setPrimaryKey(keyList.contains(column.getColumnName()) ? "Y" : "N");
        columnModel.setColumnDef(column.getColumnDef());
        columnModel.setRemarks(column.getRemarks());
        columnModels.add(columnModel);
    }

    private List<TableModel> handleIgnore(List<TableModel> tables) {
        if (!Objects.isNull(this.config) && !Objects.isNull(this.config.getProduceConfig())) {
            List<String> list;
            if (CollectionUtils.isNotEmpty(this.config.getProduceConfig().getIgnoreTableName())) {
                list = this.config.getProduceConfig().getIgnoreTableName();
                for (String name : list) {
                    tables = tables.stream().filter(j -> !j.getTableName().equals(name)).collect(Collectors.toList());
                }
            }
            if (CollectionUtils.isNotEmpty(this.config.getProduceConfig().getIgnoreTablePrefix())) {
                list = this.config.getProduceConfig().getIgnoreTablePrefix();
                for (String prefix : list) {
                    tables = tables.stream().filter(j -> !j.getTableName().startsWith(prefix)).collect(Collectors.toList());
                }
            }
            if (CollectionUtils.isNotEmpty(this.config.getProduceConfig().getIgnoreTableSuffix())) {
                list = this.config.getProduceConfig().getIgnoreTableSuffix();
                for (String suffix : list) {
                    tables = tables.stream().filter(j -> !j.getTableName().endsWith(suffix)).collect(Collectors.toList());
                }
            }
            return tables;
        }
        return tables;
    }
}

