/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.util;

import cn.smallbun.screw.core.util.ExceptionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringEscapeUtils;

public class BeanUtils {
    public static void beanAttributeValueTrim(Object bean) {
        try {
            if (bean != null) {
                Field[] fields;
                for (Field f : fields = bean.getClass().getDeclaredFields()) {
                    String key;
                    Object value;
                    if (!"java.lang.String".equals(f.getType().getName()) || (value = BeanUtils.getFieldValue(bean, key = f.getName())) == null) continue;
                    BeanUtils.setFieldValue(bean, key, StringEscapeUtils.escapeXml((String)value.toString().trim()));
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe(e);
        }
    }

    private static Object getFieldValue(Object bean, String fieldName) throws Exception {
        String methodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Class[] classArr = new Class[]{};
        Method method = bean.getClass().getMethod(methodName, classArr);
        Object rObject = method.invoke(bean, new Object[0]);
        return rObject;
    }

    private static void setFieldValue(Object bean, String fieldName, Object value) throws Exception {
        String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Class[] classArr = new Class[]{"java.lang.String".getClass()};
        Method method = bean.getClass().getMethod(methodName, classArr);
        method.invoke(bean, value);
    }
}

