/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.util;

import cn.smallbun.screw.core.query.DatabaseType;
import cn.smallbun.screw.core.util.ExceptionUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;

public class JdbcUtils
implements Serializable {
    public static void close(ResultSet rs) {
        if (!Objects.isNull(rs)) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw ExceptionUtils.mpe(e);
            }
        }
    }

    public static void close(Connection conn) {
        if (!Objects.isNull(conn)) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw ExceptionUtils.mpe(e);
            }
        }
    }

    public static void close(ResultSet rs, Connection conn) {
        if (!Objects.isNull(rs)) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw ExceptionUtils.mpe(e);
            }
        }
        if (!Objects.isNull(conn)) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw ExceptionUtils.mpe(e);
            }
        }
    }

    public static void close(ResultSet rs, Statement st, Connection conn) {
        if (!Objects.isNull(rs)) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw ExceptionUtils.mpe(e);
            }
        }
        if (!Objects.isNull(st)) {
            try {
                st.close();
            }
            catch (SQLException e) {
                throw ExceptionUtils.mpe(e);
            }
        }
        if (!Objects.isNull(conn)) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw ExceptionUtils.mpe(e);
            }
        }
    }

    public static DatabaseType getDbType(String jdbcUrl) {
        if (jdbcUrl.contains(":mysql:") || jdbcUrl.contains(":cobar:")) {
            return DatabaseType.MYSQL;
        }
        if (jdbcUrl.contains(":mariadb:")) {
            return DatabaseType.MARIADB;
        }
        if (jdbcUrl.contains(":oracle:")) {
            return DatabaseType.ORACLE;
        }
        if (jdbcUrl.contains(":sqlserver:") || jdbcUrl.contains(":microsoft:")) {
            return DatabaseType.SQL_SERVER2005;
        }
        if (jdbcUrl.contains(":sqlserver2012:")) {
            return DatabaseType.SQL_SERVER;
        }
        if (jdbcUrl.contains(":postgresql:")) {
            return DatabaseType.POSTGRE_SQL;
        }
        if (jdbcUrl.contains(":hsqldb:")) {
            return DatabaseType.HSQL;
        }
        if (jdbcUrl.contains(":db2:")) {
            return DatabaseType.DB2;
        }
        if (jdbcUrl.contains(":sqlite:")) {
            return DatabaseType.SQLITE;
        }
        if (jdbcUrl.contains(":h2:")) {
            return DatabaseType.H2;
        }
        if (jdbcUrl.contains(":dm:")) {
            return DatabaseType.DM;
        }
        if (jdbcUrl.contains(":xugu:")) {
            return DatabaseType.XU_GU;
        }
        if (jdbcUrl.contains(":kingbase:") || jdbcUrl.contains(":kingbase8:")) {
            return DatabaseType.KINGBASE_ES;
        }
        if (jdbcUrl.contains(":phoenix:")) {
            return DatabaseType.PHOENIX;
        }
        if (jdbcUrl.contains(":Cache:")) {
            return DatabaseType.CACHEDB;
        }
        return DatabaseType.OTHER;
    }
}

