/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.nacos.parser.AbstractNacosDataParser;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class NacosDataXmlParser
extends AbstractNacosDataParser {
    public NacosDataXmlParser() {
        super("xml");
    }

    @Override
    protected Properties doParse(String data) throws IOException {
        if (StringUtils.isEmpty((Object)data)) {
            return null;
        }
        Map<String, String> map = this.parseXml2Map(data);
        return this.generateProperties(this.reloadMap(map));
    }

    private Map<String, String> parseXml2Map(String xml) throws IOException {
        xml = xml.replaceAll("\\r", "").replaceAll("\\n", "").replaceAll("\\t", "");
        HashMap<String, String> map = new HashMap<String, String>(32);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(xml)));
            if (null == document) {
                return null;
            }
            this.parseNodeList(document.getChildNodes(), map, "");
        }
        catch (Exception e) {
            throw new IOException("The xml content parse error.", e.getCause());
        }
        return map;
    }

    private void parseNodeList(NodeList nodeList, Map<String, String> map, String parentKey) {
        if (nodeList == null || nodeList.getLength() < 1) {
            return;
        }
        parentKey = parentKey == null ? "" : parentKey;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String value = node.getNodeValue();
            value = value == null ? "" : value.trim();
            String name = node.getNodeName();
            String string = name = name == null ? "" : name.trim();
            if (StringUtils.isEmpty((Object)name)) continue;
            String key = StringUtils.isEmpty((Object)parentKey) ? name : parentKey + "." + name;
            NamedNodeMap nodeMap = node.getAttributes();
            this.parseNodeAttr(nodeMap, map, key);
            if (node.getNodeType() == 1 && node.hasChildNodes()) {
                this.parseNodeList(node.getChildNodes(), map, key);
                continue;
            }
            if (value.length() < 1) continue;
            map.put(parentKey, value);
        }
    }

    private void parseNodeAttr(NamedNodeMap nodeMap, Map<String, String> map, String parentKey) {
        if (null == nodeMap || nodeMap.getLength() < 1) {
            return;
        }
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Node node = nodeMap.item(i);
            if (null == node || node.getNodeType() != 2 || StringUtils.isEmpty((Object)node.getNodeName()) || StringUtils.isEmpty((Object)node.getNodeValue())) continue;
            map.put(String.join((CharSequence)".", parentKey, node.getNodeName()), node.getNodeValue());
        }
    }
}

