/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.seata.feign;

import com.alibaba.cloud.seata.feign.SeataFeignObjectWrapper;
import feign.Client;
import feign.Request;
import feign.Response;
import io.seata.core.context.RootContext;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.util.StringUtils;

public class SeataLoadBalancerFeignClient
extends LoadBalancerFeignClient {
    private static final int MAP_SIZE = 16;
    private final BeanFactory beanFactory;

    SeataLoadBalancerFeignClient(Client delegate, CachingSpringLoadBalancerFactory lbClientFactory, SpringClientFactory clientFactory, BeanFactory beanFactory) {
        super(SeataLoadBalancerFeignClient.wrap(delegate, beanFactory), lbClientFactory, clientFactory);
        this.beanFactory = beanFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        Request modifiedRequest = this.getModifyRequest(request);
        return super.execute(modifiedRequest, options);
    }

    private static Client wrap(Client delegate, BeanFactory beanFactory) {
        return (Client)new SeataFeignObjectWrapper(beanFactory).wrap(delegate);
    }

    private Request getModifyRequest(Request request) {
        String xid = RootContext.getXID();
        if (StringUtils.isEmpty((Object)xid)) {
            return request;
        }
        HashMap headers = new HashMap(16);
        headers.putAll(request.headers());
        ArrayList<String> seataXid = new ArrayList<String>();
        seataXid.add(xid);
        headers.put("TX_XID", seataXid);
        return Request.create((String)request.method(), (String)request.url(), headers, (byte[])request.body(), (Charset)request.charset());
    }
}

