/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.configdata;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.Profiles;
import org.springframework.util.StringUtils;

public class NacosConfigDataResource
extends ConfigDataResource {
    private final NacosConfigProperties properties;
    private final boolean optional;
    private final Profiles profiles;
    private final Log log;
    private final NacosItemConfig config;

    public NacosConfigDataResource(NacosConfigProperties properties, boolean optional, Profiles profiles, Log log, NacosItemConfig config) {
        this.properties = properties;
        this.optional = optional;
        this.profiles = profiles;
        this.log = log;
        this.config = config;
    }

    public NacosConfigProperties getProperties() {
        return this.properties;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getProfiles() {
        return StringUtils.collectionToCommaDelimitedString(this.getAcceptedProfiles());
    }

    List<String> getAcceptedProfiles() {
        return this.profiles.getAccepted();
    }

    public Log getLog() {
        return this.log;
    }

    public NacosItemConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NacosConfigDataResource that = (NacosConfigDataResource)((Object)o);
        return this.optional == that.optional && Objects.equals(this.properties, that.properties) && Objects.equals(this.profiles, that.profiles) && Objects.equals(this.log, that.log) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.optional, this.profiles, this.log, this.config);
    }

    public String toString() {
        return "NacosConfigDataResource{properties=" + this.properties + ", optional=" + this.optional + ", profiles=" + this.profiles + ", config=" + this.config + '}';
    }

    public static class NacosItemConfig {
        private String group;
        private String dataId;
        private String suffix;
        private boolean refreshEnabled;

        public NacosItemConfig() {
        }

        public NacosItemConfig(String group, String dataId, String suffix, boolean refreshEnabled) {
            this.group = group;
            this.dataId = dataId;
            this.suffix = suffix;
            this.refreshEnabled = refreshEnabled;
        }

        public NacosItemConfig setGroup(String group) {
            this.group = group;
            return this;
        }

        public NacosItemConfig setDataId(String dataId) {
            this.dataId = dataId;
            return this;
        }

        public NacosItemConfig setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public NacosItemConfig setRefreshEnabled(boolean refreshEnabled) {
            this.refreshEnabled = refreshEnabled;
            return this;
        }

        public String getGroup() {
            return this.group;
        }

        public String getDataId() {
            return this.dataId;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean isRefreshEnabled() {
            return this.refreshEnabled;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NacosItemConfig that = (NacosItemConfig)o;
            return this.refreshEnabled == that.refreshEnabled && Objects.equals(this.group, that.group) && Objects.equals(this.dataId, that.dataId) && Objects.equals(this.suffix, that.suffix);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.dataId, this.suffix, this.refreshEnabled);
        }

        public String toString() {
            return "NacosItemConfig{group='" + this.group + '\'' + ", dataId='" + this.dataId + '\'' + ", suffix='" + this.suffix + '\'' + ", refreshEnabled=" + this.refreshEnabled + '}';
        }
    }
}

