/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONValidException;
import com.alibaba.fastjson2.util.UUIDUtils;
import java.math.BigInteger;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

final class JSONReaderStr
extends JSONReader {
    protected final String str;
    protected final int length;
    protected final int start;
    protected final int end;
    protected int nameBegin;
    protected int nameEnd;
    protected int nameLength;
    protected int referenceBegin;

    JSONReaderStr(JSONReader.Context ctx, String str) {
        this(ctx, str, 0, str.length());
    }

    JSONReaderStr(JSONReader.Context ctx, String str, int offset, int length) {
        super(ctx);
        this.str = str;
        this.offset = offset;
        this.length = length;
        this.start = offset;
        this.end = offset + length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = str.charAt(offset);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = str.charAt(this.offset);
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        while (this.ch == '/') {
            this.next();
            if (this.ch == '/') {
                this.skipLineComment();
                continue;
            }
            throw new JSONException("input not support " + this.ch + ", offset " + offset);
        }
    }

    @Override
    public boolean nextIfMatch(char ch) {
        if (this.ch != ch) {
            return false;
        }
        if (ch == ',') {
            this.comma = true;
        }
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        this.ch = this.str.charAt(this.offset);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = this.str.charAt(this.offset);
        }
        ++this.offset;
        return true;
    }

    @Override
    public boolean nextIfEmptyString() {
        char first = this.ch;
        if (first != '\"' && first != '\'' || this.offset >= this.end || this.str.charAt(this.offset) != first) {
            return false;
        }
        ++this.offset;
        this.ch = (char)(this.offset == this.end ? 26 : (int)this.str.charAt(this.offset));
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = this.str.charAt(this.offset);
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = this.str.charAt(this.offset++);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
        }
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        this.ch = this.str.charAt(this.offset);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = this.str.charAt(this.offset);
        }
        ++this.offset;
        return true;
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2) {
        if (this.ch != c0) {
            return false;
        }
        int offset2 = this.offset + 2;
        if (offset2 > this.end || this.str.charAt(this.offset) != c1 || this.str.charAt(this.offset + 1) != c2) {
            return false;
        }
        if (offset2 == this.end) {
            this.offset = offset2;
            this.ch = (char)26;
            return true;
        }
        int offset = offset2;
        int ch = this.str.charAt(offset);
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.str.charAt(offset);
        }
        if (offset == offset2) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        if (this.ch != c0) {
            return false;
        }
        int offset3 = this.offset + 3;
        if (offset3 > this.end || this.str.charAt(this.offset) != c1 || this.str.charAt(this.offset + 1) != c2 || this.str.charAt(this.offset + 2) != c3) {
            return false;
        }
        if (offset3 == this.end) {
            this.offset = offset3;
            this.ch = (char)26;
            return true;
        }
        int offset = offset3;
        int ch = this.str.charAt(offset);
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.str.charAt(offset);
        }
        if (offset == offset3 && ch != 40 && ch != 44 && ch != 93) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        if (this.ch != c0) {
            return false;
        }
        int offset5 = this.offset + 5;
        if (offset5 > this.end || this.str.charAt(this.offset) != c1 || this.str.charAt(this.offset + 1) != c2 || this.str.charAt(this.offset + 2) != c3 || this.str.charAt(this.offset + 3) != c4 || this.str.charAt(this.offset + 4) != c5) {
            return false;
        }
        if (offset5 == this.end) {
            this.offset = offset5;
            this.ch = (char)26;
            return true;
        }
        int offset = offset5;
        int ch = this.str.charAt(offset);
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = this.str.charAt(offset);
        }
        if (offset == offset5 && ch != 40) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public boolean nextIfSet() {
        if (this.ch == 'S' && this.offset + 1 < this.end && this.str.charAt(this.offset) == 'e' && this.str.charAt(this.offset + 1) == 't') {
            this.offset += 2;
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = this.str.charAt(this.offset++);
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        break;
                    }
                    this.ch = this.str.charAt(this.offset++);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void next() {
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = this.str.charAt(this.offset);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.str.charAt(this.offset);
        }
        ++this.offset;
    }

    @Override
    public long readFieldNameHashCodeUnquote() {
        this.nameEscape = false;
        this.nameBegin = this.offset - 1;
        long hashCode = -3750763034362895579L;
        int i = 0;
        block8: while (true) {
            if (this.ch == '\\') {
                this.nameEscape = true;
                this.ch = this.str.charAt(this.offset++);
                switch (this.ch) {
                    case 'u': {
                        char c1 = this.str.charAt(this.offset++);
                        char c2 = this.str.charAt(this.offset++);
                        char c3 = this.str.charAt(this.offset++);
                        char c4 = this.str.charAt(this.offset++);
                        this.ch = JSONReaderStr.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.str.charAt(this.offset++);
                        char c2 = this.str.charAt(this.offset++);
                        this.ch = JSONReaderStr.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': 
                    case '\\': {
                        break;
                    }
                    default: {
                        this.ch = JSONReaderStr.char1(this.ch);
                    }
                }
                hashCode ^= (long)this.ch;
                hashCode *= 1099511628211L;
                this.next();
            } else {
                switch (this.ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case '\u001a': 
                    case ' ': 
                    case '!': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.nameLength = i;
                        this.nameEnd = this.ch == '\u001a' ? this.offset : this.offset - 1;
                        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                            this.next();
                        }
                        break block8;
                    }
                    default: {
                        hashCode ^= (long)this.ch;
                        hashCode *= 1099511628211L;
                        this.ch = (char)(this.offset >= this.end ? 26 : (int)this.str.charAt(this.offset++));
                    }
                }
            }
            ++i;
        }
        if (this.ch == ':') {
            this.ch = this.offset == this.end ? (char)26 : this.str.charAt(this.offset++);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    break;
                }
                this.ch = this.str.charAt(this.offset++);
            }
        }
        return hashCode;
    }

    @Override
    public long readFieldNameHashCode() {
        char c;
        if (this.ch != '\"' && this.ch != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (this.ch == '}' || this.isNull()) {
                return -1L;
            }
            throw new JSONException("illegal character " + this.ch);
        }
        char quote = this.ch;
        this.stringValue = null;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long hashCode = -3750763034362895579L;
        int i = 0;
        while (true) {
            if ((c = this.str.charAt(offset)) == '\\') {
                this.nameEscape = true;
                c = this.str.charAt(++offset);
                switch (c) {
                    case 117: {
                        char c1 = this.str.charAt(++offset);
                        char c2 = this.str.charAt(++offset);
                        char c3 = this.str.charAt(++offset);
                        char c4 = this.str.charAt(++offset);
                        c = JSONReaderStr.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 120: {
                        char c1 = this.str.charAt(++offset);
                        char c2 = this.str.charAt(++offset);
                        c = JSONReaderStr.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = JSONReaderStr.char1(c);
                    }
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    if (offset < this.end) {
                        c = this.str.charAt(offset);
                        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                            c = this.str.charAt(++offset);
                        }
                    } else {
                        this.ch = (char)26;
                    }
                    if (c != ':') {
                        return -1L;
                    }
                    c = ++offset == this.end ? (char)'\u001a' : (char)this.str.charAt(offset);
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = this.str.charAt(++offset);
                    }
                    break;
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
            ++i;
        }
        this.offset = offset + 1;
        this.ch = c;
        return hashCode;
    }

    @Override
    public long readValueHashCode() {
        int c;
        if (this.ch != '\"') {
            return -1L;
        }
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long hashCode = -3750763034362895579L;
        int i = 0;
        while (true) {
            if ((c = this.str.charAt(offset)) == 92) {
                this.nameEscape = true;
                c = this.str.charAt(++offset);
                switch (c) {
                    case 117: {
                        char c1 = this.str.charAt(++offset);
                        char c2 = this.str.charAt(++offset);
                        char c3 = this.str.charAt(++offset);
                        char c4 = this.str.charAt(++offset);
                        c = JSONReaderStr.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 120: {
                        char c1 = this.str.charAt(++offset);
                        char c2 = this.str.charAt(++offset);
                        c = JSONReaderStr.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = JSONReaderStr.char1(c);
                    }
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            } else {
                if (c == 34) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    this.stringValue = null;
                    c = offset == this.end ? 26 : (int)this.str.charAt(offset);
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.str.charAt(++offset);
                    }
                    if (c == 44) {
                        this.comma = true;
                        c = ++offset == this.end ? 26 : (int)this.str.charAt(offset);
                        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                            c = this.str.charAt(++offset);
                        }
                    }
                    break;
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
            ++i;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        long hashCode = -3750763034362895579L;
        int offset = this.nameBegin;
        while (true) {
            char c1;
            char c;
            if ((c = this.str.charAt(offset)) == '\\') {
                c = this.str.charAt(++offset);
                switch (c) {
                    case 'u': {
                        c1 = this.str.charAt(++offset);
                        char c2 = this.str.charAt(++offset);
                        char c3 = this.str.charAt(++offset);
                        char c4 = this.str.charAt(++offset);
                        c = JSONReaderStr.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        c1 = this.str.charAt(++offset);
                        char c2 = this.str.charAt(++offset);
                        c = JSONReaderStr.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = JSONReaderStr.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if ((c == '_' || c == '-') && (c1 = this.str.charAt(++offset)) != '\"' && c1 != '\'' && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public String getFieldName() {
        if (!this.nameEscape) {
            return this.str.substring(this.nameBegin, this.nameEnd);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (offset < this.nameEnd) {
            char c = this.str.charAt(offset);
            if (c == '\\') {
                c = this.str.charAt(++offset);
                switch (c) {
                    case 'u': {
                        char c1 = this.str.charAt(++offset);
                        char c2 = this.str.charAt(++offset);
                        char c3 = this.str.charAt(++offset);
                        char c4 = this.str.charAt(++offset);
                        c = JSONReaderStr.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.str.charAt(++offset);
                        char c2 = this.str.charAt(++offset);
                        c = JSONReaderStr.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = JSONReaderStr.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i] = c;
            ++offset;
            ++i;
        }
        return new String(chars);
    }

    @Override
    public String readFieldName() {
        if (this.ch != '\"' && this.ch != '\'') {
            return null;
        }
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int i = 0;
        while (offset < this.end) {
            char c = this.str.charAt(offset);
            if (c == '\\') {
                this.nameEscape = true;
                c = this.str.charAt(++offset);
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = offset < this.end ? (char)this.str.charAt(offset) : (char)'\u001a';
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = this.str.charAt(++offset);
                    }
                    if (c != ':') {
                        throw new JSONException("syntax error : " + offset);
                    }
                    c = ++offset == this.end ? (char)'\u001a' : (char)this.str.charAt(offset);
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = this.str.charAt(++offset);
                    }
                    this.offset = offset + 1;
                    this.ch = c;
                    break;
                }
                ++offset;
            }
            ++i;
        }
        if (!this.nameEscape) {
            return this.str.substring(this.nameBegin, this.nameEnd);
        }
        return this.getFieldName();
    }

    @Override
    public boolean skipName() {
        char c;
        if (this.ch != '\"') {
            throw new JSONException("not support unquoted name");
        }
        int offset = this.offset;
        while (true) {
            if ((c = this.str.charAt(offset)) == '\\') {
                c = this.str.charAt(++offset);
                switch (c) {
                    case 'u': {
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
                continue;
            }
            if (c == '\"') {
                c = this.str.charAt(++offset);
                while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                    c = this.str.charAt(++offset);
                }
                if (c != ':') {
                    throw new JSONException("syntax error, expect ',', but '" + c + "'");
                }
                c = this.str.charAt(++offset);
                while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                    c = this.str.charAt(++offset);
                }
                break;
            }
            ++offset;
        }
        this.offset = offset + 1;
        this.ch = c;
        return true;
    }

    @Override
    public int readInt32Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        int intValue = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.str.charAt(this.offset++);
        } else if (this.ch == '+') {
            this.ch = this.str.charAt(this.offset++);
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                int intValue10 = intValue * 10 + (this.ch - 48);
                if (intValue10 < intValue) {
                    overflow = true;
                    break;
                }
                intValue = intValue10;
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                try {
                    return bigInteger.intValueExact();
                }
                catch (ArithmeticException ex) {
                    throw new JSONException("int overflow, value " + bigInteger);
                }
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.wasNull = firstOffset + 1 == this.offset;
            this.ch = (char)(this.offset == this.end ? 26 : (int)this.str.charAt(this.offset++));
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.str.charAt(this.offset++);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = (char)(this.offset == this.end ? 26 : (int)this.str.charAt(this.offset++));
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public Integer readInt32() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        int intValue = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.str.charAt(this.offset++);
            if (this.ch == quote) {
                if (this.offset == this.end) {
                    this.ch = (char)26;
                } else {
                    this.ch = this.str.charAt(this.offset++);
                    this.nextIfMatch(',');
                }
                return null;
            }
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.str.charAt(this.offset++);
        } else if (this.ch == '+') {
            this.ch = this.str.charAt(this.offset++);
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                int intValue10 = intValue * 10 + (this.ch - 48);
                if (intValue10 < intValue) {
                    overflow = true;
                    break;
                }
                intValue = intValue10;
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.wasNull) {
                return null;
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.ch = this.offset < this.end ? this.str.charAt(this.offset++) : (char)26;
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.str.charAt(this.offset++);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = this.str.charAt(this.offset++);
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.str.charAt(this.offset++);
                }
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public long readInt64Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.str.charAt(this.offset++);
        } else if (this.ch == '+') {
            this.ch = this.str.charAt(this.offset++);
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                long intValue10 = longValue * 10L + (long)(this.ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                    break;
                }
                longValue = intValue10;
            }
            if (this.offset >= this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                try {
                    return bigInteger.longValueExact();
                }
                catch (ArithmeticException ex) {
                    throw new JSONException("long overflow, value " + bigInteger.toString());
                }
            }
            return this.getInt64Value();
        }
        if (quote != '\u0000') {
            this.wasNull = firstOffset + 1 == this.offset;
            this.ch = (char)(this.offset == this.end ? 26 : (int)this.str.charAt(this.offset++));
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.str.charAt(this.offset++);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = (char)(this.offset == this.end ? 26 : (int)this.str.charAt(this.offset++));
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
        }
        return negative ? -longValue : longValue;
    }

    @Override
    public Long readInt64() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.str.charAt(this.offset++);
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.str.charAt(this.offset++);
                this.nextIfMatch(',');
                return null;
            }
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = this.str.charAt(this.offset++);
        } else if (this.ch == '+') {
            this.ch = this.str.charAt(this.offset++);
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                long intValue10 = longValue * 10L + (long)(this.ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                    break;
                }
                longValue = intValue10;
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            return this.getInt64();
        }
        if (quote != '\u0000') {
            this.ch = this.offset < this.end ? this.str.charAt(this.offset++) : (char)26;
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.str.charAt(this.offset++);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = this.str.charAt(this.offset++);
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.str.charAt(this.offset++);
                }
            }
        }
        return negative ? -longValue : longValue;
    }

    protected void skipString() {
        block10: {
            char quote = this.ch;
            this.ch = this.str.charAt(this.offset++);
            while (true) {
                if (this.ch == '\\') {
                    this.ch = this.str.charAt(this.offset++);
                    if (this.ch == '\\' || this.ch == '\"') {
                        this.ch = this.str.charAt(this.offset++);
                        continue;
                    }
                    if (this.ch == 'u') {
                        this.offset += 4;
                        this.ch = this.str.charAt(this.offset++);
                        continue;
                    }
                    JSONReaderStr.char1(this.ch);
                    continue;
                }
                if (this.ch == quote) {
                    this.ch = this.offset < this.end ? this.str.charAt(this.offset++) : (char)26;
                    break block10;
                }
                if (this.offset >= this.end) break;
                this.ch = this.str.charAt(this.offset++);
            }
            this.ch = (char)26;
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == ',') {
            this.comma = true;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.str.charAt(this.offset);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                ++this.offset;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.str.charAt(this.offset);
            }
            ++this.offset;
        }
    }

    @Override
    public void skipLineComment() {
        while (true) {
            if (this.ch == '\n') {
                ++this.offset;
                if (this.offset >= this.length) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.str.charAt(this.offset);
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    ++this.offset;
                    if (this.offset >= this.length) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = this.str.charAt(this.offset);
                }
                ++this.offset;
                break;
            }
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.str.charAt(this.offset);
        }
    }

    @Override
    public String getString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (!this.nameEscape) {
            return this.str.substring(this.nameBegin, this.nameEnd);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (true) {
            char c;
            if ((c = this.str.charAt(offset)) == '\\') {
                c = this.str.charAt(++offset);
                switch (c) {
                    case 'u': {
                        char c1 = this.str.charAt(++offset);
                        char c2 = this.str.charAt(++offset);
                        char c3 = this.str.charAt(++offset);
                        char c4 = this.str.charAt(++offset);
                        c = JSONReaderStr.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = this.str.charAt(++offset);
                        char c2 = this.str.charAt(++offset);
                        c = JSONReaderStr.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = JSONReaderStr.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i] = c;
            ++offset;
            ++i;
        }
        this.stringValue = new String(chars);
        return this.stringValue;
    }

    protected void readString0() {
        String str;
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            char c;
            if ((c = this.str.charAt(offset)) == '\\') {
                this.valueEscape = true;
                c = this.str.charAt(++offset);
                switch (c) {
                    case 'u': {
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) break;
                ++offset;
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = this.str.charAt(offset)) == '\\') {
                    c = this.str.charAt(++offset);
                    switch (c) {
                        case 'u': {
                            char c1 = this.str.charAt(++offset);
                            char c2 = this.str.charAt(++offset);
                            char c3 = this.str.charAt(++offset);
                            char c4 = this.str.charAt(++offset);
                            c = JSONReaderStr.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = this.str.charAt(++offset);
                            char c2 = this.str.charAt(++offset);
                            c = JSONReaderStr.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = JSONReaderStr.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i2] = c;
                ++offset;
                ++i2;
            }
            str = new String(chars);
        } else {
            str = this.str.substring(this.offset, offset);
        }
        int b = ++offset == this.end ? 26 : (int)this.str.charAt(offset);
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.str.charAt(++offset);
        }
        if (b == 44) {
            this.comma = true;
            this.offset = offset + 1;
            this.ch = this.str.charAt(this.offset++);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
        } else {
            this.offset = offset + 1;
            this.ch = (char)b;
        }
        this.stringValue = str;
    }

    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            String str;
            int offset;
            char quote = this.ch;
            int start = offset = this.offset;
            boolean valueEscape = false;
            int i = 0;
            while (true) {
                if (offset >= this.end) {
                    throw new JSONException("invalid escape character EOI");
                }
                char c = this.str.charAt(offset);
                if (c == '\\') {
                    valueEscape = true;
                    c = this.str.charAt(++offset);
                    switch (c) {
                        case 'u': {
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            offset += 2;
                            break;
                        }
                    }
                    ++offset;
                } else {
                    if (c == quote) break;
                    ++offset;
                }
                ++i;
            }
            int valueLength = i;
            if (valueEscape) {
                char[] chars = new char[valueLength];
                offset = start;
                int i2 = 0;
                while (true) {
                    char c;
                    if ((c = this.str.charAt(offset)) == '\\') {
                        c = this.str.charAt(++offset);
                        switch (c) {
                            case 'u': {
                                char c1 = this.str.charAt(++offset);
                                char c2 = this.str.charAt(++offset);
                                char c3 = this.str.charAt(++offset);
                                char c4 = this.str.charAt(++offset);
                                c = JSONReaderStr.char4(c1, c2, c3, c4);
                                break;
                            }
                            case 'x': {
                                char c1 = this.str.charAt(++offset);
                                char c2 = this.str.charAt(++offset);
                                c = JSONReaderStr.char2(c1, c2);
                                break;
                            }
                            case '\"': 
                            case '\\': {
                                break;
                            }
                            default: {
                                c = JSONReaderStr.char1(c);
                                break;
                            }
                        }
                    } else if (c == quote) break;
                    chars[i2] = c;
                    ++offset;
                    ++i2;
                }
                str = new String(chars);
            } else {
                str = this.str.substring(this.offset, offset);
            }
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            if (offset + 1 == this.end) {
                this.offset = this.end;
                this.ch = (char)26;
                return str;
            }
            char b = this.str.charAt(++offset);
            while (b <= ' ' && (1L << b & 0x100003700L) != 0L) {
                b = this.str.charAt(++offset);
            }
            if (b == ',') {
                this.comma = true;
                this.offset = offset + 1;
                this.ch = (char)(this.offset == this.end ? 26 : (int)this.str.charAt(this.offset++));
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.str.charAt(this.offset++);
                }
            } else {
                this.offset = offset + 1;
                this.ch = b;
            }
            return str;
        }
        switch (this.ch) {
            case '[': {
                return this.toString(this.readArray());
            }
            case '{': {
                return this.toString(this.readObject());
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.readNumber0();
                Number number = this.getNumber();
                return number.toString();
            }
            case 'f': 
            case 't': {
                this.boolValue = this.readBoolValue();
                return this.boolValue ? "true" : "false";
            }
            case 'n': {
                this.readNull();
                return null;
            }
        }
        throw new JSONException("TODO : " + this.ch);
    }

    @Override
    public void skipValue() {
        block0 : switch (this.ch) {
            case '[': {
                this.next();
                int i = 0;
                while (true) {
                    if (this.ch == ']') {
                        this.next();
                        break block0;
                    }
                    if (i != 0 && !this.comma) {
                        throw new JSONValidException("offset " + this.offset);
                    }
                    this.comma = false;
                    this.skipValue();
                    ++i;
                }
            }
            case '{': {
                this.next();
                while (true) {
                    if (this.ch == '}') {
                        this.next();
                        break block0;
                    }
                    this.skipName();
                    this.skipValue();
                }
            }
            case '\"': {
                this.skipString();
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'f': 
            case 'n': 
            case 't': {
                do {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        break block0;
                    }
                    this.ch = this.str.charAt(this.offset++);
                    if (this.ch == '}' || this.ch == ']' || this.ch == '{' || this.ch == '[') break block0;
                } while (this.ch != ',');
                this.comma = true;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.str.charAt(this.offset);
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    ++this.offset;
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = this.str.charAt(this.offset);
                }
                ++this.offset;
                break;
            }
            default: {
                throw new JSONException("TODO : " + this.ch);
            }
        }
        if (this.ch == ',') {
            this.comma = true;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.str.charAt(this.offset);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                ++this.offset;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = this.str.charAt(this.offset);
            }
            ++this.offset;
        } else if (!this.comma && this.ch != '}' && this.ch != ']' && this.ch != '\u001a') {
            throw new JSONValidException("offset " + this.offset);
        }
    }

    @Override
    public void readNumber0() {
        int digit;
        int multmin;
        int limit;
        this.wasNull = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = this.str.charAt(this.offset++);
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : this.str.charAt(this.offset++);
                this.nextIfMatch(',');
                this.wasNull = true;
                return;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            limit = Integer.MIN_VALUE;
            multmin = -214748364;
            this.negative = true;
            this.ch = this.str.charAt(this.offset++);
        } else {
            if (this.ch == '+') {
                this.ch = this.str.charAt(this.offset++);
            }
            limit = -2147483647;
            multmin = -214748364;
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!intOverflow) {
                digit = this.ch - 48;
                this.mag3 *= 10;
                if (this.mag3 < multmin || this.mag3 < limit + digit) {
                    intOverflow = true;
                } else {
                    this.mag3 -= digit;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    }
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = this.str.charAt(this.offset++);
            while (this.ch >= '0' && this.ch <= '9') {
                if (!intOverflow) {
                    digit = this.ch - 48;
                    this.mag3 *= 10;
                    if (this.mag3 < multmin || this.mag3 < limit + digit) {
                        intOverflow = true;
                    } else {
                        this.mag3 -= digit;
                        if (this.mag3 < multmin) {
                            intOverflow = true;
                        }
                    }
                }
                this.scale = (byte)(this.scale + 1);
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = this.str.charAt(this.offset++);
            }
        }
        if (intOverflow) {
            int numDigits;
            int numStart = this.negative ? start : start - 1;
            int n = numDigits = this.scale > 0 ? this.offset - 2 - numStart : this.offset - 1 - numStart;
            if (numDigits > 38) {
                this.valueType = (byte)8;
                this.stringValue = this.str.substring(numStart, this.offset - 1);
            } else {
                this.bigInt(numStart, this.offset - 1);
            }
        } else {
            this.mag3 = -this.mag3;
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = this.str.charAt(this.offset++);
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = this.str.charAt(this.offset++);
            } else if (this.ch == '+') {
                this.ch = this.str.charAt(this.offset++);
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 512) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    break;
                }
                this.ch = this.str.charAt(this.offset++);
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (byte)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.str.charAt(this.offset++) == 'u' && this.str.charAt(this.offset++) == 'l' && this.str.charAt(this.offset++) == 'l') {
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.str.charAt(this.offset++);
                    }
                }
            } else if (this.ch == 't') {
                if (this.str.charAt(this.offset++) == 'r' && this.str.charAt(this.offset++) == 'u' && this.str.charAt(this.offset++) == 'e') {
                    this.boolValue = true;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.str.charAt(this.offset++);
                    }
                }
            } else if (this.ch == 'f') {
                if (this.str.charAt(this.offset++) == 'a' && this.str.charAt(this.offset++) == 'l' && this.str.charAt(this.offset++) == 's' && this.str.charAt(this.offset++) == 'e') {
                    this.boolValue = false;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = this.str.charAt(this.offset++);
                    }
                }
            } else {
                if (this.ch == '{' && quote == '\u0000') {
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (this.ch == '[' && quote == '\u0000') {
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            this.ch = this.offset < this.end ? this.str.charAt(this.offset++) : (char)26;
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : this.str.charAt(this.offset++);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = this.str.charAt(this.offset++);
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.str.charAt(this.offset++);
                }
            }
        }
    }

    @Override
    public boolean readIfNull() {
        if (this.ch == 'n' && this.str.charAt(this.offset) == 'u' && this.str.charAt(this.offset + 1) == 'l' && this.str.charAt(this.offset + 2) == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.str.charAt(this.offset + 3);
            this.offset += 4;
        } else {
            return false;
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = (char)(this.offset == this.end ? 26 : (int)this.str.charAt(this.offset++));
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
        }
        return true;
    }

    @Override
    public boolean isNull() {
        return this.ch == 'n' && this.offset < this.end && this.str.charAt(this.offset) == 'u';
    }

    @Override
    public Date readNullOrNewDate() {
        Date date = null;
        if (this.offset + 2 < this.end && this.str.charAt(this.offset) == 'u' && this.str.charAt(this.offset + 1) == 'l' && this.str.charAt(this.offset + 2) == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.str.charAt(this.offset + 3);
            this.offset += 4;
        } else if (this.offset + 1 < this.end && this.str.charAt(this.offset) == 'e' && this.str.charAt(this.offset + 1) == 'w') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.str.charAt(this.offset + 2);
            this.offset += 3;
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
            if (this.offset + 4 < this.end && this.ch == 'D' && this.str.charAt(this.offset) == 'a' && this.str.charAt(this.offset + 1) == 't' && this.str.charAt(this.offset + 2) == 'e') {
                this.ch = this.offset + 3 == this.end ? (char)26 : this.str.charAt(this.offset + 3);
                this.offset += 4;
            } else {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
            if (this.ch != '(' || this.offset >= this.end) {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            this.ch = this.str.charAt(this.offset++);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
            long millis = this.readInt64Value();
            if (this.ch != ')') {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            this.ch = this.offset >= this.end ? (char)26 : this.str.charAt(this.offset++);
            date = new Date(millis);
        } else {
            throw new JSONException("json syntax error, not match null or new Date" + this.offset);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = (char)(this.offset == this.end ? 26 : (int)this.str.charAt(this.offset++));
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
        }
        return date;
    }

    @Override
    public boolean nextIfNull() {
        if (this.ch == 'n' && this.offset + 2 < this.end && this.str.charAt(this.offset) == 'u') {
            this.readNull();
            return true;
        }
        return false;
    }

    @Override
    public void readNull() {
        if (this.str.charAt(this.offset) == 'u' && this.str.charAt(this.offset + 1) == 'l' && this.str.charAt(this.offset + 2) == 'l') {
            this.ch = this.offset + 3 == this.end ? (char)26 : this.str.charAt(this.offset + 3);
            this.offset += 4;
        } else {
            throw new JSONException("json syntax error, not match null" + this.offset);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = this.str.charAt(this.offset++);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
        }
    }

    @Override
    public UUID readUUID() {
        if (this.ch == 'n') {
            this.readNull();
            return null;
        }
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException(this.info("syntax error, can not read uuid"));
        }
        char quote = this.ch;
        if (this.offset + 32 < this.end && this.str.charAt(this.offset + 32) == quote) {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            long msb1 = UUIDUtils.parse4Nibbles(this.str, this.offset + 0);
            if ((msb1 | (msb2 = UUIDUtils.parse4Nibbles(this.str, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.str, this.offset + 8)) | (msb4 = UUIDUtils.parse4Nibbles(this.str, this.offset + 12)) | (lsb1 = UUIDUtils.parse4Nibbles(this.str, this.offset + 16)) | (lsb2 = UUIDUtils.parse4Nibbles(this.str, this.offset + 20)) | (lsb3 = UUIDUtils.parse4Nibbles(this.str, this.offset + 24)) | (lsb4 = UUIDUtils.parse4Nibbles(this.str, this.offset + 28))) >= 0L) {
                this.offset += 33;
                this.ch = this.offset == this.end ? (char)26 : this.str.charAt(this.offset++);
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.str.charAt(this.offset++);
                }
                if (this.ch == ',') {
                    this.comma = true;
                    this.next();
                }
                return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
            }
        } else if (this.offset + 36 < this.str.length() && this.str.charAt(this.offset + 36) == quote) {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            long msb1;
            char ch1 = this.str.charAt(this.offset + 8);
            char ch2 = this.str.charAt(this.offset + 13);
            char ch3 = this.str.charAt(this.offset + 18);
            char ch4 = this.str.charAt(this.offset + 23);
            if (ch1 == '-' && ch2 == '-' && ch3 == '-' && ch4 == '-' && ((msb1 = UUIDUtils.parse4Nibbles(this.str, this.offset + 0)) | (msb2 = UUIDUtils.parse4Nibbles(this.str, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.str, this.offset + 9)) | (msb4 = UUIDUtils.parse4Nibbles(this.str, this.offset + 14)) | (lsb1 = UUIDUtils.parse4Nibbles(this.str, this.offset + 19)) | (lsb2 = UUIDUtils.parse4Nibbles(this.str, this.offset + 24)) | (lsb3 = UUIDUtils.parse4Nibbles(this.str, this.offset + 28)) | (lsb4 = UUIDUtils.parse4Nibbles(this.str, this.offset + 32))) >= 0L) {
                this.offset += 37;
                this.ch = this.offset == this.end ? (char)26 : this.str.charAt(this.offset++);
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.str.charAt(this.offset++);
                }
                if (this.ch == ',') {
                    this.comma = true;
                    this.next();
                }
                return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
            }
        }
        String str = this.readString();
        return UUID.fromString(str);
    }

    @Override
    public int getStringLength() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char quote = this.ch;
        int len = 0;
        int i = this.offset;
        while (i < this.end && this.str.charAt(i) != quote) {
            ++i;
            ++len;
        }
        return len;
    }

    @Override
    protected LocalDateTime readLocalDateTime16() {
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        char c10 = this.str.charAt(this.offset + 10);
        char c11 = this.str.charAt(this.offset + 11);
        char c12 = this.str.charAt(this.offset + 12);
        char c13 = this.str.charAt(this.offset + 13);
        char c14 = this.str.charAt(this.offset + 14);
        char c15 = this.str.charAt(this.offset + 15);
        int s0 = 48;
        int s1 = 48;
        if (c4 == '-' && c7 == '-' && (c10 == 'T' || c10 == ' ') && c13 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
        } else if (c8 == 'T' && c15 == 'Z') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
            h0 = c9;
            h1 = c10;
            i0 = c11;
            i1 = c12;
            s0 = c13;
            s1 = c14;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 17;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTime17() {
        int s1;
        int s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        int d0;
        int m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        int c5 = this.str.charAt(this.offset + 5);
        int c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        int c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        char c10 = this.str.charAt(this.offset + 10);
        char c11 = this.str.charAt(this.offset + 11);
        char c12 = this.str.charAt(this.offset + 12);
        char c13 = this.str.charAt(this.offset + 13);
        char c14 = this.str.charAt(this.offset + 14);
        char c15 = this.str.charAt(this.offset + 15);
        char c16 = this.str.charAt(this.offset + 16);
        if (c4 == '-' && c7 == '-' && (c10 == 'T' || c10 == ' ') && c13 == ':' && c16 == 'Z') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
        } else if (c4 == '-' && c6 == 45 && (c8 == 32 || c8 == 84) && c11 == ':' && c14 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
            h0 = c9;
            h1 = c10;
            i0 = c12;
            i1 = c13;
            s0 = c15;
            s1 = c16;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 18;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTime18() {
        char s1;
        int s0;
        char i1;
        int i0;
        char h1;
        int h0;
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        int c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        int c10 = this.str.charAt(this.offset + 10);
        char c11 = this.str.charAt(this.offset + 11);
        char c12 = this.str.charAt(this.offset + 12);
        int c13 = this.str.charAt(this.offset + 13);
        char c14 = this.str.charAt(this.offset + 14);
        char c15 = this.str.charAt(this.offset + 15);
        int c16 = this.str.charAt(this.offset + 16);
        char c17 = this.str.charAt(this.offset + 17);
        if (c4 == '-' && c6 == '-' && (c9 == ' ' || c9 == 'T') && c12 == ':' && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c9 == ' ' || c9 == 'T') && c12 == ':' && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c12 == ':' && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = 48;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 19;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalTime readLocalTime8() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        if (c2 != ':' || c5 != ':') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        this.offset += 9;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return LocalTime.of(hour, minute, seccond);
    }

    @Override
    public LocalDateTime readLocalDate8() {
        LocalDateTime ldt;
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        int c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        int c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        if (c4 == 45 && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 49 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 51 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        try {
            ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        }
        catch (DateTimeException e) {
            throw new JSONException(this.info(), e);
        }
        this.offset += 9;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDateTime readLocalDate9() {
        LocalDateTime ldt;
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        if (c4 == '\u5e74' && c6 == '\u6708' && c8 == '\u65e5') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c4 == '\ub144' && c6 == '\uc6d4' && c8 == '\uc77c') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c4 == '-' && c6 == '-') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == '-' && c7 == '-') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        try {
            ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        }
        catch (DateTimeException e) {
            throw new JSONException(this.info(), e);
        }
        this.offset += 10;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDateTime readLocalDate10() {
        LocalDateTime ldt;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        int c0 = this.str.charAt(this.offset + 0);
        int c1 = this.str.charAt(this.offset + 1);
        int c2 = this.str.charAt(this.offset + 2);
        int c3 = this.str.charAt(this.offset + 3);
        int c4 = this.str.charAt(this.offset + 4);
        int c5 = this.str.charAt(this.offset + 5);
        int c6 = this.str.charAt(this.offset + 6);
        int c7 = this.str.charAt(this.offset + 7);
        int c8 = this.str.charAt(this.offset + 8);
        int c9 = this.str.charAt(this.offset + 9);
        if (c4 == 45 && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == 47 && c7 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == 46 && c5 == 46) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 45 && c5 == 45) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c4 == 24180 && c6 == 26376 && c9 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == 45380 && c6 == 50900 && c9 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == 24180 && c7 == 26376 && c9 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == 45380 && c7 == 50900 && c9 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        try {
            ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        }
        catch (DateTimeException e) {
            throw new JSONException(this.info(), e);
        }
        this.offset += 11;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDateTime readLocalDate11() {
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        char c10 = this.str.charAt(this.offset + 10);
        if (c4 == '\u5e74' && c7 == '\u6708' && c10 == '\u65e5') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == '\ub144' && c7 == '\uc6d4' && c10 == '\uc77c') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        this.offset += 12;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return ldt;
    }

    @Override
    protected ZonedDateTime readZonedDateTimeX(int len) {
        ZoneId zoneId;
        int zoneIdBegin;
        int S8;
        char S7;
        char S6;
        char S5;
        char S4;
        char S3;
        char S2;
        char S1;
        char S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        char c20;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        if (len < 19) {
            return null;
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        char c10 = this.str.charAt(this.offset + 10);
        char c11 = this.str.charAt(this.offset + 11);
        char c12 = this.str.charAt(this.offset + 12);
        char c13 = this.str.charAt(this.offset + 13);
        char c14 = this.str.charAt(this.offset + 14);
        char c15 = this.str.charAt(this.offset + 15);
        char c16 = this.str.charAt(this.offset + 16);
        char c17 = this.str.charAt(this.offset + 17);
        char c18 = this.str.charAt(this.offset + 18);
        int c19 = len == 19 ? 32 : (int)this.str.charAt(this.offset + 19);
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        int c28 = 48;
        int c29 = 0;
        switch (len) {
            case 19: 
            case 20: {
                c20 = '\u0000';
                break;
            }
            case 21: {
                c20 = this.str.charAt(this.offset + 20);
                break;
            }
            case 22: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                break;
            }
            case 23: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                break;
            }
            case 24: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                break;
            }
            case 25: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                break;
            }
            case 26: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                c25 = this.str.charAt(this.offset + 25);
                break;
            }
            case 27: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                c25 = this.str.charAt(this.offset + 25);
                c26 = this.str.charAt(this.offset + 26);
                break;
            }
            case 28: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                c25 = this.str.charAt(this.offset + 25);
                c26 = this.str.charAt(this.offset + 26);
                c27 = this.str.charAt(this.offset + 27);
                break;
            }
            case 29: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                c25 = this.str.charAt(this.offset + 25);
                c26 = this.str.charAt(this.offset + 26);
                c27 = this.str.charAt(this.offset + 27);
                c28 = this.str.charAt(this.offset + 28);
                break;
            }
            default: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                c25 = this.str.charAt(this.offset + 25);
                c26 = this.str.charAt(this.offset + 26);
                c27 = this.str.charAt(this.offset + 27);
                c28 = this.str.charAt(this.offset + 28);
                c29 = this.str.charAt(this.offset + 29);
            }
        }
        boolean isTimeZone = false;
        if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 91 && c19 != 90 && c19 != 43 && c19 != 45 && c19 != 32)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = '0';
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 19;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 21 && c21 != '[' && c21 != '+' && c21 != '-' && c21 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 21;
            isTimeZone = c21 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 22 && c22 != '[' && c22 != '+' && c22 != '-' && c22 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 22;
            isTimeZone = c22 == '|';
        } else if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == 'Z' && c17 == '[' && len == 22 && c21 == ']') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = '0';
            s1 = '0';
            S0 = '0';
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            isTimeZone = true;
            zoneIdBegin = 17;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 23 && c23 != '[' && c23 != '|' && c23 != '+' && c23 != '-' && c23 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = c23 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 24 && c24 != '[' && c24 != '|' && c24 != '+' && c24 != '-' && c24 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = c24 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 25 && c25 != '[' && c25 != '|' && c25 != '+' && c25 != '-' && c25 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = c25 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 26 && c26 != '[' && c26 != '|' && c26 != '+' && c26 != '-' && c26 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 26;
            isTimeZone = c26 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 27 && c27 != '[' && c27 != '|' && c27 != '+' && c27 != '-' && c27 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 27;
            isTimeZone = c27 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 28 && c28 != 91 && c28 != 124 && c28 != 43 && c28 != 45 && c28 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = 48;
            zoneIdBegin = 28;
            isTimeZone = c28 == 124;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 29 && c29 != 91 && c29 != 124 && c29 != 43 && c29 != 45 && c29 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = c28;
            zoneIdBegin = 29;
            isTimeZone = c29 == 124;
        } else if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':' && c19 == 46 && len == 23) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = false;
        } else {
            return null;
        }
        char first = this.str.charAt(this.offset + zoneIdBegin);
        LocalDateTime ldt = JSONReaderStr.getLocalDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, (char)S8);
        if (isTimeZone) {
            String tzStr = this.str.substring(this.offset + zoneIdBegin, this.offset + len);
            TimeZone timeZone = TimeZone.getTimeZone(tzStr);
            zoneId = timeZone.toZoneId();
        } else if (first == 'Z') {
            zoneId = UTC;
        } else {
            String zoneIdStr = first == '+' || first == '-' ? this.str.substring(this.offset + zoneIdBegin, this.offset + len) : (first == ' ' ? this.str.substring(this.offset + zoneIdBegin + 1, this.offset + len) : (zoneIdBegin < len ? this.str.substring(this.offset + zoneIdBegin + 1, this.offset + len - 1) : null));
            zoneId = this.getZoneId(ldt, zoneIdStr);
        }
        ZonedDateTime zdt = ldt.atZone(zoneId);
        if (zdt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return zdt;
    }

    @Override
    protected LocalDateTime readLocalDateTime19() {
        int millis;
        int S2;
        int S1;
        int S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        char c10 = this.str.charAt(this.offset + 10);
        char c11 = this.str.charAt(this.offset + 11);
        char c12 = this.str.charAt(this.offset + 12);
        char c13 = this.str.charAt(this.offset + 13);
        char c14 = this.str.charAt(this.offset + 14);
        char c15 = this.str.charAt(this.offset + 15);
        char c16 = this.str.charAt(this.offset + 16);
        char c17 = this.str.charAt(this.offset + 17);
        char c18 = this.str.charAt(this.offset + 18);
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 >= 48 && S0 <= 57 && S1 >= 48 && S1 <= 57 && S2 >= 48 && S2 <= 57) {
            millis = (S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second, millis);
        this.offset += 20;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTimeX(int len) {
        char c20;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        if (len < 21 || len > 29) {
            throw new JSONException("illeal localdatetime string : " + this.readString());
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        char c10 = this.str.charAt(this.offset + 10);
        char c11 = this.str.charAt(this.offset + 11);
        char c12 = this.str.charAt(this.offset + 12);
        char c13 = this.str.charAt(this.offset + 13);
        char c14 = this.str.charAt(this.offset + 14);
        char c15 = this.str.charAt(this.offset + 15);
        char c16 = this.str.charAt(this.offset + 16);
        char c17 = this.str.charAt(this.offset + 17);
        char c18 = this.str.charAt(this.offset + 18);
        char c19 = this.str.charAt(this.offset + 19);
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        char c28 = '0';
        switch (len) {
            case 21: {
                c20 = this.str.charAt(this.offset + 20);
                break;
            }
            case 22: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                break;
            }
            case 23: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                break;
            }
            case 24: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                break;
            }
            case 25: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                break;
            }
            case 26: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                c25 = this.str.charAt(this.offset + 25);
                break;
            }
            case 27: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                c25 = this.str.charAt(this.offset + 25);
                c26 = this.str.charAt(this.offset + 26);
                break;
            }
            case 28: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                c25 = this.str.charAt(this.offset + 25);
                c26 = this.str.charAt(this.offset + 26);
                c27 = this.str.charAt(this.offset + 27);
                break;
            }
            default: {
                c20 = this.str.charAt(this.offset + 20);
                c21 = this.str.charAt(this.offset + 21);
                c22 = this.str.charAt(this.offset + 22);
                c23 = this.str.charAt(this.offset + 23);
                c24 = this.str.charAt(this.offset + 24);
                c25 = this.str.charAt(this.offset + 25);
                c26 = this.str.charAt(this.offset + 26);
                c27 = this.str.charAt(this.offset + 27);
                c28 = this.str.charAt(this.offset + 28);
            }
        }
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        LocalDateTime ldt = JSONReaderStr.getLocalDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return ldt;
    }

    static LocalDateTime getLocalDateTime(char y0, char y1, char y2, char y3, char m0, char m1, char d0, char d1, char h0, char h1, char i0, char i1, char s0, char s1, char S0, char S1, char S2, char S3, char S4, char S5, char S6, char S7, char S8) {
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < '0' || S0 > '9' || S1 < '0' || S1 > '9' || S2 < '0' || S2 > '9' || S3 < '0' || S3 > '9' || S4 < '0' || S4 > '9' || S5 < '0' || S5 > '9' || S6 < '0' || S6 > '9' || S7 < '0' || S7 > '9' || S8 < '0' || S8 > '9') {
            return null;
        }
        int nanos = (S0 - 48) * 100000000 + (S1 - 48) * 10000000 + (S2 - 48) * 1000000 + (S3 - 48) * 100000 + (S4 - 48) * 10000 + (S5 - 48) * 1000 + (S6 - 48) * 100 + (S7 - 48) * 10 + (S8 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second, nanos);
        return ldt;
    }

    @Override
    protected LocalTime readLocalTime10() {
        int millis;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        int m1 = 48;
        int m2 = 48;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= 48 && m1 <= 57 && m2 >= 48 && m2 <= 57) {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 11;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return LocalTime.of(hour, minute, seccond, millis);
    }

    @Override
    protected LocalTime readLocalTime11() {
        int millis;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        char c10 = this.str.charAt(this.offset + 10);
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        int m2 = 48;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9' && m2 >= 48 && m2 <= 57) {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 12;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return LocalTime.of(hour, minute, seccond, millis);
    }

    @Override
    protected LocalTime readLocalTime12() {
        int millis;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        char c10 = this.str.charAt(this.offset + 10);
        char c11 = this.str.charAt(this.offset + 11);
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        char m2 = c11;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9' && m2 >= '0' && m2 <= '9') {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 13;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return LocalTime.of(hour, minute, seccond, millis);
    }

    @Override
    protected LocalTime readLocalTime18() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        char c0 = this.str.charAt(this.offset + 0);
        char c1 = this.str.charAt(this.offset + 1);
        char c2 = this.str.charAt(this.offset + 2);
        char c3 = this.str.charAt(this.offset + 3);
        char c4 = this.str.charAt(this.offset + 4);
        char c5 = this.str.charAt(this.offset + 5);
        char c6 = this.str.charAt(this.offset + 6);
        char c7 = this.str.charAt(this.offset + 7);
        char c8 = this.str.charAt(this.offset + 8);
        char c9 = this.str.charAt(this.offset + 9);
        char c10 = this.str.charAt(this.offset + 10);
        char c11 = this.str.charAt(this.offset + 11);
        char c12 = this.str.charAt(this.offset + 12);
        char c13 = this.str.charAt(this.offset + 13);
        char c14 = this.str.charAt(this.offset + 14);
        char c15 = this.str.charAt(this.offset + 15);
        char c16 = this.str.charAt(this.offset + 16);
        char c17 = this.str.charAt(this.offset + 17);
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        char m2 = c11;
        char m3 = c12;
        char m4 = c13;
        char m5 = c14;
        char m6 = c15;
        char m7 = c16;
        char m8 = c17;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9' || m2 < '0' || m2 > '9' || m3 < '0' || m3 > '9' || m4 < '0' || m4 > '9' || m5 < '0' || m5 > '9' || m6 < '0' || m6 > '9' || m7 < '0' || m7 > '9' || m8 < '0' || m8 > '9') {
            return null;
        }
        int millis = (m0 - 48) * 100000000 + (m1 - 48) * 10000000 + (m2 - 48) * 1000000 + (m3 - 48) * 100000 + (m4 - 48) * 10000 + (m5 - 48) * 1000 + (m6 - 48) * 100 + (m7 - 48) * 10 + (m8 - 48);
        this.offset += 19;
        this.next();
        if (this.ch == ',') {
            this.comma = true;
            this.next();
        }
        return LocalTime.of(hour, minute, seccond, millis);
    }

    @Override
    public String readPattern() {
        char c;
        if (this.ch != '/') {
            throw new JSONException("illegal pattern");
        }
        int offset = this.offset;
        int i = 0;
        while ((c = this.str.charAt(offset)) != '/' && ++offset < this.end) {
            ++i;
        }
        String str = this.str.substring(this.offset, offset);
        if (offset + 1 == this.end) {
            this.offset = this.end;
            this.ch = (char)26;
            return str;
        }
        char b = this.str.charAt(++offset);
        while (b <= ' ' && (1L << b & 0x100003700L) != 0L) {
            b = this.str.charAt(++offset);
        }
        if (b == ',') {
            this.offset = offset + 1;
            this.comma = true;
            this.ch = this.str.charAt(this.offset++);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = this.str.charAt(this.offset++);
            }
        } else {
            this.offset = offset + 1;
            this.ch = b;
        }
        return str;
    }

    void bigInt(int off, int len) {
        char c;
        int cursor = off;
        int numDigits = len - cursor;
        if (this.scale > 0) {
            --numDigits;
        }
        if (numDigits > 38) {
            throw new JSONException("number too large : " + this.str.substring(off, off + numDigits));
        }
        int firstGroupLen = numDigits % 9;
        if (firstGroupLen == 0) {
            firstGroupLen = 9;
        }
        int start = cursor;
        cursor += firstGroupLen;
        int end = cursor++;
        if ((c = this.str.charAt(start++)) == '.') {
            c = this.str.charAt(start++);
        }
        int result = c - 48;
        for (int index = start; index < end; ++index) {
            c = this.str.charAt(index);
            if (c == '.') {
                c = this.str.charAt(++index);
                ++cursor;
                if (end < len) {
                    ++end;
                }
            }
            int nextVal = c - 48;
            result = 10 * result + nextVal;
        }
        this.mag3 = result;
        while (cursor < len) {
            char c2;
            int start2 = cursor;
            cursor += 9;
            int end2 = cursor++;
            if ((c2 = this.str.charAt(start2++)) == '.') {
                c2 = this.str.charAt(start2++);
                ++end2;
            }
            int result2 = c2 - 48;
            for (int index = start2; index < end2; ++index) {
                c2 = this.str.charAt(index);
                if (c2 == '.') {
                    c2 = this.str.charAt(++index);
                    ++cursor;
                    ++end2;
                }
                int nextVal = c2 - 48;
                result2 = 10 * result2 + nextVal;
            }
            int groupVal = result2;
            long ylong = 1000000000L;
            long product = 0L;
            long carry = 0L;
            for (int i = 3; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        product = ylong * ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)product;
                        break;
                    }
                    case 1: {
                        product = ylong * ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)product;
                        break;
                    }
                    case 2: {
                        product = ylong * ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)product;
                        break;
                    }
                    case 3: {
                        product = ylong * ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)product;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = product >>> 32;
            }
            long zlong = (long)groupVal & 0xFFFFFFFFL;
            long sum = ((long)this.mag3 & 0xFFFFFFFFL) + zlong;
            this.mag3 = (int)sum;
            carry = sum >>> 32;
            for (int i = 2; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        sum = ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)sum;
                        break;
                    }
                    case 1: {
                        sum = ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)sum;
                        break;
                    }
                    case 2: {
                        sum = ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)sum;
                        break;
                    }
                    case 3: {
                        sum = ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)sum;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = sum >>> 32;
            }
        }
    }

    @Override
    public boolean isReference() {
        if (this.ch != '{') {
            return false;
        }
        int start = this.offset;
        if (this.offset == this.end) {
            return false;
        }
        this.ch = this.str.charAt(this.offset);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.offset = start;
                this.ch = (char)123;
                return false;
            }
            this.ch = this.str.charAt(this.offset);
        }
        char quote = this.ch;
        if (quote != '\"' && quote != '\'' || this.offset + 5 >= this.end) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        if (this.str.charAt(this.offset + 1) != '$' || this.str.charAt(this.offset + 2) != 'r' || this.str.charAt(this.offset + 3) != 'e' || this.str.charAt(this.offset + 4) != 'f' || this.str.charAt(this.offset + 5) != quote || this.offset + 6 >= this.end) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        this.offset += 6;
        this.ch = this.str.charAt(this.offset);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.offset = start;
                this.ch = (char)123;
                return false;
            }
            this.ch = this.str.charAt(this.offset);
        }
        if (this.ch != ':' || this.offset + 1 >= this.end) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        this.ch = this.str.charAt(++this.offset);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.offset = start;
                this.ch = (char)123;
                return false;
            }
            this.ch = this.str.charAt(this.offset);
        }
        if (this.ch != quote) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        this.referenceBegin = this.offset;
        this.offset = start;
        this.ch = (char)123;
        return true;
    }

    @Override
    public String readReference() {
        if (this.referenceBegin == this.end) {
            return null;
        }
        this.offset = this.referenceBegin;
        this.ch = this.str.charAt(this.offset++);
        String reference = this.readString();
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return reference;
            }
            this.ch = this.str.charAt(this.offset);
        }
        if (this.ch != '}') {
            throw new JSONException("illegal reference : " + reference);
        }
        this.ch = this.offset == this.end ? (char)26 : this.str.charAt(this.offset++);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = this.str.charAt(this.offset++);
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = this.str.charAt(this.offset++);
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = this.str.charAt(this.offset++);
                }
            }
        }
        return reference;
    }

    @Override
    public String info(String message) {
        int line = 1;
        int column = 1;
        int i = 0;
        while (i < this.offset && i < this.end) {
            if (this.str.charAt(i) == '\n') {
                column = 1;
                ++line;
            }
            ++i;
            ++column;
        }
        StringBuilder buf = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            buf.append(message).append(", ");
        }
        buf.append("offset ").append(this.offset).append(", character ").append(this.ch).append(", line ").append(line).append(", column ").append(column).append(", fastjson-version ").append("2.0.9").append(line > 1 ? (char)'\n' : ' ');
        buf.append(this.str, this.start, this.length < 65535 ? this.length : 65535);
        return buf.toString();
    }
}

