/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.funtions;

import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class FunctionDef {
    private final String name;
    private final SQLDataType returnType;
    private final List<SQLDataType> parameterTypes = new ArrayList<SQLDataType>();
    private final boolean varArgs;
    private long nameHash;

    public FunctionDef(String name, boolean varArgs, SQLDataType returnType, SQLDataType ... parameterTypes) {
        this.name = name;
        this.varArgs = varArgs;
        this.returnType = returnType;
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.parameterTypes.add(parameterTypes[i]);
        }
    }

    public String getName() {
        return this.name;
    }

    public SQLDataType getReturnType() {
        return this.returnType;
    }

    public List<SQLDataType> getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public long nameHash64() {
        if (this.nameHash == 0L) {
            this.nameHash = FnvHash.fnv1a_64_lower(this.name);
        }
        return this.nameHash;
    }

    public SQLDataType getLastParameterType() {
        if (this.parameterTypes.size() == 0) {
            return null;
        }
        return this.parameterTypes.get(this.parameterTypes.size() - 1);
    }

    public SQLDataType getParemeterType(int paramIndex) {
        if (paramIndex < this.parameterTypes.size()) {
            return this.parameterTypes.get(paramIndex);
        }
        if (this.isVarArgs()) {
            return this.parameterTypes.get(this.parameterTypes.size() - 1);
        }
        return null;
    }
}

