/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.interpreter;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateOutlineStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.visitor.ParameterizedOutputVisitorUtils;
import com.alibaba.fastsql.sql.visitor.ParameterizedVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OutlineImpl {
    private final DbType dbType;
    private ConcurrentMap<Long, Entry> mapping = new ConcurrentHashMap<Long, Entry>();

    public OutlineImpl(DbType dbType) {
        this.dbType = dbType;
    }

    public void create(SQLCreateOutlineStatement stmt) {
        SQLStatement on = stmt.getOn();
        if (on == null) {
            return;
        }
        if (stmt.getTo() == null) {
            return;
        }
        Filter[] filters = this.buildFilters(stmt);
        StringBuilder out = new StringBuilder();
        ParameterizedVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, on.getDbType());
        if (on.hasBeforeComment()) {
            on.getBeforeCommentsDirect().clear();
        }
        on.accept(visitor);
        long hashCode = FnvHash.fnv1a_64(out);
        this.mapping.putIfAbsent(hashCode, new Entry(stmt, filters));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Filter[] buildFilters(SQLCreateOutlineStatement stmt) {
        SQLExpr where = stmt.getWhere();
        if (where == null) {
            return null;
        }
        List<SQLExpr> items = SQLBinaryOpExpr.split(where, SQLBinaryOperator.BooleanAnd);
        Filter[] filters = new Filter[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            SQLExpr item = items.get(i);
            if (!(item instanceof SQLBinaryOpExpr)) throw new ParserException("not support filter : " + item);
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)item;
            SQLExpr left = binaryOpExpr.getLeft();
            SQLExpr right = binaryOpExpr.getRight();
            if (!(left instanceof SQLVariantRefExpr) || !(right instanceof SQLValuableExpr)) throw new ParserException("not support filter : " + item);
            String varName = ((SQLVariantRefExpr)left).getName();
            if (varName.length() != 2 || varName.charAt(0) != '$' || varName.charAt(1) < '0' || varName.charAt(1) > '9') {
                throw new ParserException("illegal variant name : " + varName);
            }
            int varIndex = varName.charAt(1) - 48;
            Object value = ((SQLValuableExpr)right).getValue();
            switch (binaryOpExpr.getOperator()) {
                case Equality: 
                case NotEqual: 
                case LessThanOrGreater: {
                    break;
                }
                default: {
                    throw new ParserException("not support filter : " + item);
                }
            }
            filters[i] = new BinaryOpFilter(varIndex, binaryOpExpr.getOperator(), value);
        }
        return filters;
    }

    public String apply(String sql) {
        SQLStatement stmt = SQLUtils.parseSingleStatement(sql, this.dbType, new SQLParserFeature[0]);
        String result = this.apply((SQLSelectStatement)stmt);
        if (result == null) {
            return sql;
        }
        return result;
    }

    private String apply(SQLSelectStatement stmt) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        SQLStatement to = null;
        StringBuilder out = new StringBuilder();
        ParameterizedVisitor visitor = ParameterizedOutputVisitorUtils.createParameterizedOutputVisitor(out, stmt.getDbType());
        visitor.setOutputParameters(parameters);
        if (stmt.hasBeforeComment()) {
            stmt.getBeforeCommentsDirect().clear();
        }
        stmt.accept(visitor);
        long hashCode = FnvHash.fnv1a_64(out);
        Entry entry = (Entry)this.mapping.get(hashCode);
        if (entry == null) {
            return null;
        }
        to = entry.stmt.getTo();
        Filter[] filters = entry.filters;
        if (filters != null) {
            for (Filter filter : filters) {
                int paramIndex = filter.index - 1;
                if (paramIndex < 0 || paramIndex >= parameters.size()) {
                    return null;
                }
                Object param = parameters.get(paramIndex);
                if (filter.apply(param)) continue;
                return null;
            }
        }
        if (to == null) {
            return null;
        }
        out = new StringBuilder();
        SQLASTOutputVisitor v = SQLUtils.createOutputVisitor(out, stmt.getDbType());
        v.setInputParameters(parameters);
        to.accept(v);
        return out.toString();
    }

    static class BinaryOpFilter
    extends Filter {
        final Object value;
        final SQLBinaryOperator operator;

        public BinaryOpFilter(int index, SQLBinaryOperator operator, Object value) {
            super(index);
            this.operator = operator;
            this.value = value;
        }

        @Override
        public boolean apply(Object param) {
            switch (this.operator) {
                case Equality: {
                    if (param == this.value) {
                        return true;
                    }
                    if (param == null || this.value == null) {
                        return false;
                    }
                    return this.value.equals(param);
                }
                case NotEqual: 
                case LessThanOrGreater: {
                    if (param == this.value) {
                        return false;
                    }
                    if (param == null || this.value == null) {
                        return true;
                    }
                    return !this.value.equals(param);
                }
            }
            return false;
        }
    }

    static abstract class Filter {
        final int index;

        public Filter(int index) {
            this.index = index;
        }

        public abstract boolean apply(Object var1);
    }

    static class Entry {
        final SQLCreateOutlineStatement stmt;
        final Filter[] filters;

        public Entry(SQLCreateOutlineStatement stmt, Filter[] filters) {
            this.stmt = stmt;
            this.filters = filters;
        }
    }
}

