/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.interpreter.filters;

import com.alibaba.fastsql.interpreter.filters.BinaryOp;
import com.alibaba.fastsql.interpreter.filters.ConstFilter;
import com.alibaba.fastsql.interpreter.filters.FieldValueProvider;

public class LongFilter
implements ConstFilter<Long> {
    protected final long value;
    protected final BinaryOp operator;
    protected final FieldValueProvider fieldValueProvider;

    public LongFilter(long value, BinaryOp operator, FieldValueProvider fieldValueProvider) {
        this.value = value;
        this.operator = operator;
        this.fieldValueProvider = fieldValueProvider;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    public Object getFieldValue(Object object) throws Exception {
        return this.fieldValueProvider.getFieldValue(object);
    }

    @Override
    public boolean test(Object o) throws Exception {
        Object fieldValue = this.getFieldValue(o);
        if (fieldValue instanceof Integer || fieldValue instanceof Short || fieldValue instanceof Byte) {
            int intVal = ((Number)fieldValue).intValue();
            switch (this.operator) {
                case Eq: {
                    return (long)intVal == this.value;
                }
                case Ne: {
                    return (long)intVal != this.value;
                }
                case Ge: {
                    return (long)intVal >= this.value;
                }
                case Gt: {
                    return (long)intVal > this.value;
                }
                case Le: {
                    return (long)intVal <= this.value;
                }
                case Lt: {
                    return (long)intVal < this.value;
                }
            }
            throw new UnsupportedOperationException();
        }
        if (fieldValue instanceof Long) {
            long longValue = (Long)fieldValue;
            switch (this.operator) {
                case Eq: {
                    return longValue == this.value;
                }
                case Ne: {
                    return longValue != this.value;
                }
                case Ge: {
                    return longValue >= this.value;
                }
                case Gt: {
                    return longValue > this.value;
                }
                case Le: {
                    return longValue <= this.value;
                }
                case Lt: {
                    return longValue < this.value;
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }
}

