/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.interpreter.filters;

import com.alibaba.fastsql.interpreter.filters.BinaryOp;
import com.alibaba.fastsql.interpreter.filters.ConstFilter;
import com.alibaba.fastsql.interpreter.filters.FieldValueProvider;

public class StringFilter
implements ConstFilter<String> {
    protected final String value;
    protected final BinaryOp operator;
    protected final FieldValueProvider fieldValueProvider;

    public StringFilter(String value, BinaryOp operator, FieldValueProvider fieldValueProvider) {
        this.value = value;
        this.operator = operator;
        this.fieldValueProvider = fieldValueProvider;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public Object getFieldValue(Object object) throws Exception {
        return this.fieldValueProvider.getFieldValue(object);
    }

    @Override
    public boolean test(Object o) throws Exception {
        Object fieldValue = this.getFieldValue(o);
        if (fieldValue instanceof String) {
            String strVal = (String)fieldValue;
            switch (this.operator) {
                case Eq: {
                    return this.value.equalsIgnoreCase(strVal);
                }
                case Ne: {
                    return !this.value.equalsIgnoreCase(strVal);
                }
                case Ge: {
                    return this.value.compareToIgnoreCase(strVal) <= 0;
                }
                case Gt: {
                    return this.value.compareToIgnoreCase(strVal) < 0;
                }
                case Le: {
                    return this.value.compareToIgnoreCase(strVal) >= 0;
                }
                case Lt: {
                    return this.value.compareToIgnoreCase(strVal) > 0;
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }
}

