/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLKeep;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.SQLOver;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateOption;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SQLAggregateExpr
extends SQLMethodInvokeExpr
implements Serializable,
SQLReplaceable {
    private static final long serialVersionUID = 1L;
    protected SQLAggregateOption option;
    protected SQLKeep keep;
    protected SQLExpr filter;
    protected SQLOver over;
    protected SQLName overRef;
    protected SQLOrderBy withinGroup;
    protected Boolean ignoreNulls = false;

    public SQLAggregateExpr(String methodName) {
        this.methodName = methodName;
    }

    public SQLAggregateExpr(String methodName, SQLAggregateOption option) {
        this.methodName = methodName;
        this.option = option;
    }

    public SQLAggregateExpr(String methodName, SQLAggregateOption option, SQLExpr ... arguments) {
        this.methodName = methodName;
        this.option = option;
        if (arguments != null) {
            for (SQLExpr argument : arguments) {
                if (argument == null) continue;
                this.addArgument(argument);
            }
        }
    }

    public SQLOrderBy getWithinGroup() {
        return this.withinGroup;
    }

    public void setWithinGroup(SQLOrderBy withinGroup) {
        if (withinGroup != null) {
            withinGroup.setParent(this);
        }
        this.withinGroup = withinGroup;
    }

    public SQLAggregateOption getOption() {
        return this.option;
    }

    public void setOption(SQLAggregateOption option) {
        this.option = option;
    }

    public boolean isDistinct() {
        return this.option == SQLAggregateOption.DISTINCT;
    }

    public SQLOver getOver() {
        return this.over;
    }

    public void setOver(SQLOver x) {
        if (x != null) {
            x.setParent(this);
        }
        this.over = x;
    }

    public SQLName getOverRef() {
        return this.overRef;
    }

    public void setOverRef(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.overRef = x;
    }

    public SQLKeep getKeep() {
        return this.keep;
    }

    public void setKeep(SQLKeep keep) {
        if (keep != null) {
            keep.setParent(this);
        }
        this.keep = keep;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls != null && this.ignoreNulls != false;
    }

    public Boolean getIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.owner != null) {
                this.owner.accept(visitor);
            }
            for (SQLExpr arg : this.arguments) {
                if (arg == null) continue;
                arg.accept(visitor);
            }
            if (this.keep != null) {
                this.keep.accept(visitor);
            }
            if (this.filter != null) {
                this.filter.accept(visitor);
            }
            if (this.over != null) {
                this.over.accept(visitor);
            }
            if (this.overRef != null) {
                this.overRef.accept(visitor);
            }
            if (this.withinGroup != null) {
                this.withinGroup.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public List getChildren() {
        ArrayList<SQLObjectImpl> children = new ArrayList<SQLObjectImpl>();
        children.addAll(this.arguments);
        if (this.keep != null) {
            children.add(this.keep);
        }
        if (this.over != null) {
            children.add(this.over);
        }
        if (this.withinGroup != null) {
            children.add(this.withinGroup);
        }
        return children;
    }

    public SQLExpr getFilter() {
        return this.filter;
    }

    public void setFilter(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.filter = x;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SQLAggregateExpr that = (SQLAggregateExpr)o;
        if (this.option != that.option) {
            return false;
        }
        if (this.keep != null ? !this.keep.equals(that.keep) : that.keep != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.over != null ? !this.over.equals(that.over) : that.over != null) {
            return false;
        }
        if (this.overRef != null ? !this.overRef.equals(that.overRef) : that.overRef != null) {
            return false;
        }
        if (this.withinGroup != null ? !this.withinGroup.equals(that.withinGroup) : that.withinGroup != null) {
            return false;
        }
        return this.ignoreNulls != null ? this.ignoreNulls.equals(that.ignoreNulls) : that.ignoreNulls == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.option != null ? this.option.hashCode() : 0);
        result = 31 * result + (this.keep != null ? this.keep.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.over != null ? this.over.hashCode() : 0);
        result = 31 * result + (this.overRef != null ? this.overRef.hashCode() : 0);
        result = 31 * result + (this.withinGroup != null ? this.withinGroup.hashCode() : 0);
        result = 31 * result + (this.ignoreNulls != null ? this.ignoreNulls.hashCode() : 0);
        return result;
    }

    @Override
    public SQLAggregateExpr clone() {
        SQLAggregateExpr x = new SQLAggregateExpr(this.methodName);
        x.option = this.option;
        for (SQLExpr sQLExpr : this.arguments) {
            x.addArgument(sQLExpr.clone());
        }
        if (this.keep != null) {
            x.setKeep(this.keep.clone());
        }
        if (this.over != null) {
            x.setOver(this.over.clone());
        }
        if (this.overRef != null) {
            x.setOverRef(this.overRef.clone());
        }
        if (this.withinGroup != null) {
            x.setWithinGroup(this.withinGroup.clone());
        }
        x.ignoreNulls = this.ignoreNulls;
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof SQLObject) {
                    value = ((SQLObject)value).clone();
                }
                x.putAttribute(key, value);
            }
        }
        return x;
    }

    @Override
    public SQLDataType computeDataType() {
        SQLDataType dataType;
        if (this.resolvedReturnDataType != null) {
            return this.resolvedReturnDataType;
        }
        long hash = this.methodNameHashCode64();
        if (hash == FnvHash.Constants.COUNT || hash == FnvHash.Constants.ROW_NUMBER) {
            return SQLIntegerExpr.DATA_TYPE;
        }
        if (this.arguments.size() > 0 && (dataType = ((SQLExpr)this.arguments.get(0)).computeDataType()) != null) {
            return dataType;
        }
        if (hash == FnvHash.Constants.SUM) {
            return SQLNumberExpr.DATA_TYPE_DOUBLE;
        }
        if (hash == FnvHash.Constants.WM_CONCAT || hash == FnvHash.Constants.GROUP_CONCAT) {
            return SQLCharExpr.DATA_TYPE;
        }
        return null;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (target == null) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != expr) continue;
            this.arguments.set(i, target);
            target.setParent(this);
            return true;
        }
        if (this.overRef == expr) {
            this.setOverRef((SQLName)target);
            return true;
        }
        if (this.filter != null) {
            this.filter = target;
            target.setParent(this);
        }
        return false;
    }
}

