/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.expr;

import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class SQLDecimalExpr
extends SQLNumericLiteralExpr
implements SQLValuableExpr,
Comparable<SQLDecimalExpr> {
    public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("DECIMAL");
    private BigDecimal value;
    private transient String literal;

    public SQLDecimalExpr() {
    }

    public SQLDecimalExpr(BigDecimal value) {
        this.value = value;
    }

    public SQLDecimalExpr(String value) {
        this.value = new BigDecimal(value);
        this.literal = value;
    }

    public String getLiteral() {
        return this.literal;
    }

    @Override
    public SQLDecimalExpr clone() {
        return new SQLDecimalExpr(this.value);
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Number getNumber() {
        return this.value;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLDecimalExpr other = (SQLDecimalExpr)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void setNumber(Number number) {
        if (number == null) {
            this.setValue(null);
            return;
        }
        this.setValue((BigDecimal)number);
    }

    @Override
    public int compareTo(SQLDecimalExpr o) {
        return this.value.compareTo(o.value);
    }
}

