/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.statement;

import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLStatementImpl;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLPartitionRef;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLAnalyzeTableStatement
extends SQLStatementImpl {
    protected final List<SQLExprTableSource> tableSources = new ArrayList<SQLExprTableSource>();
    private SQLPartitionRef partition;
    private boolean forColums = false;
    private boolean cacheMetadata;
    private boolean noscan;
    private boolean computeStatistics;

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSources);
            this.acceptChild(visitor, this.partition);
        }
        visitor.endVisit(this);
    }

    public List<SQLExprTableSource> getTables() {
        return this.tableSources;
    }

    public SQLExprTableSource getTable() {
        if (this.tableSources.size() == 0) {
            return null;
        }
        if (this.tableSources.size() == 1) {
            return this.tableSources.get(0);
        }
        throw new UnsupportedOperationException();
    }

    public void setTable(SQLExprTableSource table) {
        if (table != null) {
            table.setParent(this);
        }
        if (this.tableSources.size() == 0) {
            if (table == null) {
                return;
            }
            this.tableSources.add(table);
            return;
        }
        if (this.tableSources.size() == 1) {
            if (table == null) {
                this.tableSources.remove(0);
            } else {
                this.tableSources.set(0, table);
            }
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void setTable(SQLName table) {
        this.setTable(new SQLExprTableSource(table));
    }

    public SQLPartitionRef getPartition() {
        return this.partition;
    }

    public void setPartition(SQLPartitionRef x) {
        if (x != null) {
            x.setParent(this);
        }
        this.partition = x;
    }

    public boolean isForColums() {
        return this.forColums;
    }

    public void setForColums(boolean forColums) {
        this.forColums = forColums;
    }

    public boolean isCacheMetadata() {
        return this.cacheMetadata;
    }

    public void setCacheMetadata(boolean cacheMetadata) {
        this.cacheMetadata = cacheMetadata;
    }

    public boolean isNoscan() {
        return this.noscan;
    }

    public void setNoscan(boolean noscan) {
        this.noscan = noscan;
    }

    public boolean isComputeStatistics() {
        return this.computeStatistics;
    }

    public void setComputeStatistics(boolean computeStatistics) {
        this.computeStatistics = computeStatistics;
    }
}

