/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.statement;

import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLSubqueryTableSource
extends SQLTableSourceImpl {
    protected SQLSelect select;
    protected List<SQLName> columns = new ArrayList<SQLName>();

    public SQLSubqueryTableSource() {
    }

    public SQLSubqueryTableSource(String alias) {
        super(alias);
    }

    public SQLSubqueryTableSource(SQLSelect select, String alias) {
        super(alias);
        this.setSelect(select);
    }

    public SQLSubqueryTableSource(SQLSelect select) {
        this.setSelect(select);
    }

    public SQLSubqueryTableSource(SQLSelectQuery query) {
        this(new SQLSelect(query));
    }

    public SQLSubqueryTableSource(SQLSelectQuery query, String alias) {
        this(new SQLSelect(query), alias);
    }

    public SQLSelect getSelect() {
        return this.select;
    }

    public void setSelect(SQLSelect x) {
        if (x != null) {
            x.setParent(this);
        }
        this.select = x;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this) && this.select != null) {
            this.select.accept(visitor);
        }
        visitor.endVisit(this);
    }

    public void cloneTo(SQLSubqueryTableSource x) {
        x.alias = this.alias;
        if (this.select != null) {
            x.select = this.select.clone();
            x.select.setParent(x);
        }
        for (SQLName column : this.columns) {
            SQLName c2 = column.clone();
            c2.setParent(x);
            x.columns.add(c2);
        }
    }

    @Override
    public SQLSubqueryTableSource clone() {
        SQLSubqueryTableSource x = new SQLSubqueryTableSource();
        this.cloneTo(x);
        return x;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(String columnName) {
        if (this.select == null) {
            return null;
        }
        SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
        if (queryBlock == null) {
            return null;
        }
        if (queryBlock.findSelectItem(columnName) != null) {
            return this;
        }
        return null;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(long columnNameHash, String columnName, int option) {
        if (this.select == null) {
            return null;
        }
        SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
        if (queryBlock == null) {
            return null;
        }
        if (queryBlock.findSelectItem(columnNameHash) != null) {
            return this;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLSubqueryTableSource that = (SQLSubqueryTableSource)o;
        return this.select != null ? this.select.equals(that.select) : that.select == null;
    }

    @Override
    public int hashCode() {
        return this.select != null ? this.select.hashCode() : 0;
    }

    public List<SQLName> getColumns() {
        return this.columns;
    }

    public void addColumn(SQLName column) {
        column.setParent(this);
        this.columns.add(column);
    }

    @Override
    public SQLColumnDefinition findColumn(long columnNameHash) {
        SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
        if (queryBlock != null) {
            return queryBlock.findColumn(columnNameHash);
        }
        if (this.select.getQuery() instanceof SQLUnionQuery && ((SQLUnionQuery)this.select.getQuery()).getFirstQueryBlock() instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock left = ((SQLUnionQuery)this.select.getQuery()).getFirstQueryBlock();
            return left.findColumn(columnNameHash);
        }
        return null;
    }
}

