/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.mysql.ast.statement;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterStatement;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlStatementImpl;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class MySqlAlterUserStatement
extends MySqlStatementImpl
implements SQLAlterStatement {
    private boolean ifExists = false;
    private final List<AlterUser> alterUsers = new ArrayList<AlterUser>();
    private final List<AuthOption> authOptions = new ArrayList<AuthOption>();
    private PasswordOption passwordOption;

    @Override
    public void accept0(MySqlASTVisitor visitor) {
        if (visitor.visit(this)) {
            for (AlterUser alterUser : this.alterUsers) {
                this.acceptChild((SQLASTVisitor)visitor, alterUser.user);
            }
            for (AuthOption authOption : this.authOptions) {
                this.acceptChild((SQLASTVisitor)visitor, authOption.authString);
            }
            if (this.passwordOption != null && this.passwordOption.getIntervalDays() != null) {
                this.acceptChild((SQLASTVisitor)visitor, this.passwordOption.getIntervalDays());
            }
        }
        visitor.endVisit(this);
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public List<SQLExpr> getUsers() {
        ArrayList<SQLExpr> users = new ArrayList<SQLExpr>();
        for (AlterUser alterUser : this.alterUsers) {
            users.add(alterUser.user);
        }
        return users;
    }

    public List<AlterUser> getAlterUsers() {
        return this.alterUsers;
    }

    public List<AuthOption> getAuthOptions() {
        return this.authOptions;
    }

    public PasswordOption getPasswordOption() {
        return this.passwordOption;
    }

    public void setPasswordOption(PasswordOption passwordOption) {
        this.passwordOption = passwordOption;
    }

    public static enum PasswordExpire {
        PASSWORD_EXPIRE,
        PASSWORD_EXPIRE_DEFAULT,
        PASSWORD_EXPIRE_NEVER,
        PASSWORD_EXPIRE_INTERVAL;

    }

    public static class PasswordOption {
        private PasswordExpire expire;
        private SQLIntegerExpr intervalDays;

        public PasswordExpire getExpire() {
            return this.expire;
        }

        public void setExpire(PasswordExpire expire) {
            this.expire = expire;
        }

        public SQLIntegerExpr getIntervalDays() {
            return this.intervalDays;
        }

        public void setIntervalDays(SQLIntegerExpr intervalDays) {
            this.intervalDays = intervalDays;
        }
    }

    public static class AlterUser {
        private SQLExpr user;
        private AuthOption authOption;

        public SQLExpr getUser() {
            return this.user;
        }

        public void setUser(SQLExpr user) {
            this.user = user;
        }

        public AuthOption getAuthOption() {
            return this.authOption;
        }

        public void setAuthOption(AuthOption authOption) {
            this.authOption = authOption;
        }
    }

    public static class AuthOption {
        private SQLCharExpr authString;

        public SQLCharExpr getAuthString() {
            return this.authString;
        }

        public void setAuthString(SQLCharExpr authString) {
            this.authString = authString;
        }
    }
}

