/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.odps.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLObjectType;
import com.alibaba.fastsql.sql.ast.statement.SQLPrivilegeItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSetStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLShowPartitionsStmt;
import com.alibaba.fastsql.sql.ast.statement.SQLShowStatisticStmt;
import com.alibaba.fastsql.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.fastsql.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddFileStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddStatisticStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddTableStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsAddUserStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsGrantStmt;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsListStmt;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsReadStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsRemoveStatisticStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsRemoveUserStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSetLabelStatement;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsShowGrantsStmt;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsStatisticClause;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsCreateTableParser;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLCreateTableParser;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLSelectParser;
import com.alibaba.fastsql.sql.parser.SQLStatementParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;

public class OdpsStatementParser
extends SQLStatementParser {
    public OdpsStatementParser(String sql) {
        super(new OdpsExprParser(sql, new SQLParserFeature[0]));
    }

    public OdpsStatementParser(String sql, SQLParserFeature ... features) {
        super(new OdpsExprParser(sql, features));
    }

    public OdpsStatementParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLSelectStatement parseSelect() {
        SQLSelectQueryBlock queryBlock;
        SQLSelect select = new OdpsSelectParser(this.exprParser).select();
        if (select.getWithSubQuery() == null && select.getQuery() instanceof SQLSelectQueryBlock && (queryBlock = (SQLSelectQueryBlock)select.getQuery()).getFrom() == null && queryBlock.getWhere() != null) {
            throw new ParserException("none from query not support where clause.");
        }
        return new SQLSelectStatement(select, DbType.odps);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        OdpsCreateTableParser parser = new OdpsCreateTableParser(this.exprParser);
        return parser.parseCreateTable();
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new OdpsCreateTableParser(this.exprParser);
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.FROM) {
            SQLStatement stmt = this.parseInsert();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("ANALYZE")) {
            SQLStatement stmt = this.parseAnalyze();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("ADD")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("STATISTIC")) {
                this.lexer.nextToken();
                OdpsAddStatisticStatement stmt = new OdpsAddStatisticStatement();
                stmt.setTable(this.exprParser.name());
                stmt.setStatisticClause(this.parseStaticClause());
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                OdpsAddUserStatement stmt = new OdpsAddUserStatement();
                stmt.setUser((SQLIdentifierExpr)this.exprParser.name());
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                OdpsAddTableStatement stmt = new OdpsAddTableStatement();
                stmt.setTable(this.exprParser.name());
                if (this.lexer.token() == Token.PARTITION) {
                    this.lexer.nextToken();
                    this.exprParser.parseAssignItem(stmt.getPartitoins(), stmt);
                }
                if (this.lexer.token() == Token.AS) {
                    this.lexer.nextToken();
                    SQLName name = this.exprParser.name();
                    stmt.getTable().setAlias(name.toString());
                }
                if (this.lexer.token() == Token.COMMENT) {
                    this.lexer.nextToken();
                    stmt.setComment(this.exprParser.primary());
                }
                if (this.lexer.token() == Token.SUB) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("f");
                    stmt.setForce(true);
                }
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.FILE) || this.lexer.identifierEquals(FnvHash.Constants.JAR) || this.lexer.identifierEquals(FnvHash.Constants.PY) || this.lexer.identifierEquals(FnvHash.Constants.ARCHIVE)) {
                OdpsAddFileStatement stmt = new OdpsAddFileStatement();
                long hash = this.lexer.hash_lower();
                if (hash == FnvHash.Constants.JAR) {
                    stmt.setType(OdpsAddFileStatement.FileType.JAR);
                } else if (hash == FnvHash.Constants.PY) {
                    stmt.setType(OdpsAddFileStatement.FileType.PY);
                } else if (hash == FnvHash.Constants.ARCHIVE) {
                    stmt.setType(OdpsAddFileStatement.FileType.ARCHIVE);
                }
                this.lexer.nextPath();
                String path = this.lexer.stringVal();
                this.lexer.nextToken();
                stmt.setFile(path);
                if (this.lexer.token() == Token.AS) {
                    this.lexer.nextToken();
                    SQLName name = this.exprParser.name();
                    stmt.setAlias(name.toString());
                }
                if (this.lexer.token() == Token.COMMENT) {
                    this.lexer.nextToken();
                    stmt.setComment(this.exprParser.primary());
                }
                if (this.lexer.token() == Token.SUB) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("f");
                    stmt.setForce(true);
                }
                statementList.add(stmt);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals("REMOVE")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("STATISTIC")) {
                this.lexer.nextToken();
                OdpsRemoveStatisticStatement stmt = new OdpsRemoveStatisticStatement();
                stmt.setTable(this.exprParser.name());
                stmt.setStatisticClause(this.parseStaticClause());
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                OdpsRemoveUserStatement stmt = new OdpsRemoveUserStatement();
                stmt.setUser((SQLIdentifierExpr)this.exprParser.name());
                statementList.add(stmt);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals("READ")) {
            OdpsReadStatement stmt = new OdpsReadStatement();
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                stmt.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.lexer.nextToken();
            stmt.setTable(this.exprParser.name());
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartition(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setRowCount(this.exprParser.primary());
            }
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("LIST")) {
            OdpsListStmt stmt = new OdpsListStmt();
            this.lexer.nextToken();
            stmt.setObject(this.exprParser.expr());
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.DESC || this.lexer.identifierEquals("DESCRIBE")) {
            SQLStatement stmt = this.parseDescribe();
            statementList.add(stmt);
            return true;
        }
        return false;
    }

    protected OdpsStatisticClause parseStaticClause() {
        if (this.lexer.identifierEquals("TABLE_COUNT")) {
            this.lexer.nextToken();
            return new OdpsStatisticClause.TableCount();
        }
        if (this.lexer.identifierEquals("NULL_VALUE")) {
            this.lexer.nextToken();
            OdpsStatisticClause.NullValue null_value = new OdpsStatisticClause.NullValue();
            null_value.setColumn(this.exprParser.name());
            return null_value;
        }
        if (this.lexer.identifierEquals("COLUMN_SUM")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnSum column_sum = new OdpsStatisticClause.ColumnSum();
            column_sum.setColumn(this.exprParser.name());
            return column_sum;
        }
        if (this.lexer.identifierEquals("COLUMN_MAX")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnMax column_max = new OdpsStatisticClause.ColumnMax();
            column_max.setColumn(this.exprParser.name());
            return column_max;
        }
        if (this.lexer.identifierEquals("COLUMN_MIN")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnMin column_min = new OdpsStatisticClause.ColumnMin();
            column_min.setColumn(this.exprParser.name());
            return column_min;
        }
        if (this.lexer.identifierEquals("EXPRESSION_CONDITION")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ExpressionCondition expr_condition = new OdpsStatisticClause.ExpressionCondition();
            expr_condition.setExpr(this.exprParser.expr());
            return expr_condition;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    public SQLStatement parseInsert() {
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            HiveMultiInsertStatement stmt = new HiveMultiInsertStatement();
            if (this.lexer.token() == Token.IDENTIFIER) {
                SQLName tableName = this.exprParser.name();
                SQLExprTableSource from = new SQLExprTableSource(tableName);
                stmt.setFrom(from);
            } else {
                this.accept(Token.LPAREN);
                SQLSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                this.accept(Token.RPAREN);
                String alias = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                SQLSubqueryTableSource from = new SQLSubqueryTableSource(select, alias);
                stmt.setFrom(from);
            }
            do {
                HiveInsert insert = this.parseHiveInsert();
                stmt.addItem(insert);
            } while (this.lexer.token() == Token.INSERT);
            return stmt;
        }
        return this.parseHiveInsertStmt();
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new OdpsSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLStatement parseShow() {
        this.accept(Token.SHOW);
        if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
            this.lexer.nextToken();
            SQLShowPartitionsStmt stmt = new SQLShowPartitionsStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STATISTIC)) {
            this.lexer.nextToken();
            SQLShowStatisticStmt stmt = new SQLShowStatisticStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
            this.lexer.nextToken();
            SQLShowTablesStatement stmt = new SQLShowTablesStatement();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.GRANTS)) {
            this.lexer.nextToken();
            OdpsShowGrantsStmt stmt = new OdpsShowGrantsStmt();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                stmt.setUser(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                this.acceptIdentifier("type");
                stmt.setObjectType(this.exprParser.expr());
            }
            return stmt;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    public SQLStatement parseSet() {
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        this.accept(Token.SET);
        if (this.lexer.identifierEquals("LABEL")) {
            OdpsSetLabelStatement stmt = new OdpsSetLabelStatement();
            if (comments != null) {
                stmt.addBeforeComment(comments);
            }
            this.lexer.nextToken();
            stmt.setLabel(this.lexer.stringVal());
            this.lexer.nextToken();
            this.accept(Token.TO);
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                SQLName name = this.exprParser.name();
                stmt.setUser(name);
                return stmt;
            }
            this.accept(Token.TABLE);
            SQLName expr = this.exprParser.name();
            stmt.setTable(new SQLExprTableSource(expr));
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
            return stmt;
        }
        SQLSetStatement stmt = new SQLSetStatement(this.dbType);
        stmt.putAttribute("parser.set", Boolean.TRUE);
        if (comments != null) {
            stmt.addBeforeComment(comments);
        }
        this.parseAssignItems(stmt.getItems(), stmt);
        return stmt;
    }

    @Override
    public OdpsGrantStmt parseGrant() {
        this.accept(Token.GRANT);
        OdpsGrantStmt stmt = new OdpsGrantStmt();
        if (this.lexer.identifierEquals("LABEL")) {
            stmt.setLabel(true);
            this.lexer.nextToken();
            stmt.setLabel(this.exprParser.expr());
        } else {
            if (this.lexer.identifierEquals("SUPER")) {
                stmt.setSuper(true);
                this.lexer.nextToken();
            }
            this.parsePrivileages(stmt.getPrivileges(), stmt);
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("PROJECT")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.PROJECT);
            } else if (this.lexer.identifierEquals("PACKAGE")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.PACKAGE);
            } else if (this.lexer.token() == Token.FUNCTION) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.FUNCTION);
            } else if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.TABLE);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.names(stmt.getColumns(), stmt);
                    this.accept(Token.RPAREN);
                }
            } else if (this.lexer.identifierEquals("RESOURCE")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.RESOURCE);
            } else if (this.lexer.identifierEquals("INSTANCE")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.INSTANCE);
            } else if (this.lexer.identifierEquals("JOB")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.JOB);
            } else if (this.lexer.identifierEquals("VOLUME")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.VOLUME);
            } else if (this.lexer.identifierEquals("OfflineModel")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.OfflineModel);
            } else if (this.lexer.identifierEquals("XFLOW")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.XFLOW);
            }
            stmt.setResource(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                stmt.setSubjectType(SQLObjectType.USER);
            } else if (this.lexer.identifierEquals("ROLE")) {
                this.lexer.nextToken();
                stmt.setSubjectType(SQLObjectType.ROLE);
            }
            stmt.getUsers().add(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("EXP");
            stmt.setExpire(this.exprParser.expr());
        }
        return stmt;
    }

    @Override
    protected void parsePrivileages(List<SQLPrivilegeItem> privileges, SQLObject parent) {
        while (true) {
            String privilege = null;
            if (this.lexer.token() == Token.ALL) {
                this.lexer.nextToken();
                privilege = "ALL";
            } else if (this.lexer.token() == Token.SELECT) {
                privilege = "SELECT";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.UPDATE) {
                privilege = "UPDATE";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DELETE) {
                privilege = "DELETE";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.INSERT) {
                privilege = "INSERT";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                privilege = "DROP";
            } else if (this.lexer.token() == Token.ALTER) {
                this.lexer.nextToken();
                privilege = "ALTER";
            } else if (this.lexer.identifierEquals("DESCRIBE")) {
                privilege = "DESCRIBE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("READ")) {
                privilege = "READ";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("WRITE")) {
                privilege = "WRITE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("EXECUTE")) {
                this.lexer.nextToken();
                privilege = "EXECUTE";
            } else if (this.lexer.identifierEquals("LIST")) {
                this.lexer.nextToken();
                privilege = "LIST";
            } else if (this.lexer.identifierEquals("CreateTable")) {
                this.lexer.nextToken();
                privilege = "CreateTable";
            } else if (this.lexer.identifierEquals("CreateInstance")) {
                this.lexer.nextToken();
                privilege = "CreateInstance";
            } else if (this.lexer.identifierEquals("CreateFunction")) {
                this.lexer.nextToken();
                privilege = "CreateFunction";
            } else if (this.lexer.identifierEquals("CreateResource")) {
                this.lexer.nextToken();
                privilege = "CreateResource";
            } else if (this.lexer.identifierEquals("CreateJob")) {
                this.lexer.nextToken();
                privilege = "CreateJob";
            } else if (this.lexer.identifierEquals("CreateVolume")) {
                this.lexer.nextToken();
                privilege = "CreateVolume";
            } else if (this.lexer.identifierEquals("CreateOfflineModel")) {
                this.lexer.nextToken();
                privilege = "CreateOfflineModel";
            } else if (this.lexer.identifierEquals("CreateXflow")) {
                this.lexer.nextToken();
                privilege = "CreateXflow";
            }
            SQLExpr expr = null;
            expr = privilege != null ? new SQLIdentifierExpr(privilege) : this.exprParser.expr();
            SQLPrivilegeItem privilegeItem = new SQLPrivilegeItem();
            privilegeItem.setAction(expr);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                while (true) {
                    privilegeItem.getColumns().add(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            expr.setParent(parent);
            privileges.add(privilegeItem);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }
}

