/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLAnnIndex;
import com.alibaba.fastsql.sql.ast.SQLCurrentTimeExpr;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.SQLOrderingSpecification;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateOption;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCaseExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCastExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDecimalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLExtractExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMatchAgainstExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNullExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLQueryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLRealExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLSmallIntExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTextLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTinyIntExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLBlockStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCommitStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLForStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionOperator;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.fastsql.sql.optimizer.rules.ConstFolding;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.sql.repository.SchemaObject;
import com.alibaba.fastsql.sql.repository.SchemaRepository;
import com.alibaba.fastsql.sql.repository.SchemaResolveVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastsql.sql.visitor.functions.IfNull;
import com.alibaba.fastsql.stat.TableStat;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.MySqlUtils;
import com.alibaba.fastsql.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;

public class ADSRewrite
extends OptimizerVisitor {
    private static final long INFORMATION_SCHEMA_VIEWS = FnvHash.hashCode64("information_schema.views");
    private SchemaRepository repository;
    private boolean noLimitMerged = false;
    private long defaultLimit = -1L;
    private boolean clearSelectHint = true;
    private boolean backQuotedNames = false;

    public ADSRewrite() {
    }

    public ADSRewrite(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public ADSRewrite(SchemaRepository repository, TimeZone timeZone, long defaultLimit, boolean noLimitMerged) {
        this.repository = repository;
        this.timeZone = timeZone;
        this.defaultLimit = defaultLimit;
        this.noLimitMerged = noLimitMerged;
    }

    public boolean isClearSelectHint() {
        return this.clearSelectHint;
    }

    public void setClearSelectHint(boolean clearSelectHint) {
        this.clearSelectHint = clearSelectHint;
    }

    @Override
    public void preVisit(SQLObject x) {
        List<String> afterComments;
        List<String> beforeComments = x.getBeforeCommentsDirect();
        if (beforeComments != null && beforeComments.size() > 0) {
            beforeComments.clear();
        }
        if ((afterComments = x.getAfterCommentsDirect()) != null && afterComments.size() > 0) {
            afterComments.clear();
        }
        if (x instanceof SQLStatement) {
            ((SQLStatement)x).setAfterSemi(false);
        }
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        SQLObject parent;
        if (x.isWithRollUp() || x.isWithCube()) {
            x.setParen(true);
        }
        if ((parent = x.getParent()) instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)parent;
            List<SQLExpr> items = x.getItems();
            for (int i = items.size() - 1; i >= 0; --i) {
                SQLIdentifierExpr ident;
                SQLExpr item = items.get(i);
                if (!(item instanceof SQLCharExpr) || queryBlock.findSelectItem((ident = new SQLIdentifierExpr(((SQLCharExpr)item).getText())).nameHashCode64()) == null) continue;
                items.set(i, ident);
                ident.setParent(x);
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLCurrentTimeExpr x) {
        SQLMethodInvokeExpr funtionCall = new SQLMethodInvokeExpr(x.getType().name);
        if (SQLUtils.replaceInParent(x, funtionCall)) {
            funtionCall.accept(this);
            ++this.optimizedCount;
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        SQLExpr offset;
        if (x.getHintsSize() > 0 && this.clearSelectHint) {
            x.getHints().clear();
        }
        SQLExpr having = null;
        SQLSelectGroupByClause groupBy = x.getGroupBy();
        if (groupBy != null) {
            having = groupBy.getHaving();
        }
        if (having != null) {
            HavingRewrite havingRewrite = new HavingRewrite(x);
            having.accept(havingRewrite);
        }
        if (x.getLimit() != null && (offset = x.getLimit().getOffset()) != null && ((SQLNumericLiteralExpr)offset).getNumber().intValue() == 0) {
            x.getLimit().setOffset(null);
        }
        if (x.getParent().getParent() instanceof SQLStatement && x.getFrom() != null) {
            SQLLimit limit = x.getLimit();
            if (limit == null) {
                if (this.defaultLimit != -1L) {
                    x.setLimit(new SQLLimit(Long.valueOf(this.defaultLimit).intValue()));
                }
            } else if (!this.noLimitMerged) {
                SQLExpr rowCountExpr = limit.getRowCount();
                SQLExpr offsetExpr = limit.getOffset();
                if (rowCountExpr instanceof SQLNumericLiteralExpr && offsetExpr instanceof SQLNumericLiteralExpr) {
                    int rowCount = ((SQLNumericLiteralExpr)rowCountExpr).getNumber().intValue() + ((SQLNumericLiteralExpr)offsetExpr).getNumber().intValue();
                    x.setLimit(new SQLLimit(rowCount));
                }
            }
        }
        return super.visit(x);
    }

    /*
     * WARNING - void declaration
     */
    void handLargeInlist(SQLSelectQueryBlock queryBlock, SQLInListExpr inListExpr) {
        void var9_13;
        String string;
        if (inListExpr.isNot()) {
            return;
        }
        SQLExpr expr = inListExpr.getExpr();
        SQLName column = null;
        if (!(expr instanceof SQLName)) {
            return;
        }
        column = (SQLName)expr;
        List<SQLExpr> list = inListExpr.getTargetList();
        if (list.size() < 500) {
            return;
        }
        TreeSet<SQLExpr> set = new TreeSet<SQLExpr>();
        for (SQLExpr sQLExpr : list) {
            if (sQLExpr instanceof SQLValuableExpr) {
                set.add(sQLExpr);
                continue;
            }
            return;
        }
        SQLValuesTableSource values = new SQLValuesTableSource();
        for (SQLExpr sQLExpr : set) {
            SQLListExpr row = new SQLListExpr(sQLExpr);
            row.setParent(values);
            values.getValues().add(row);
        }
        SQLTableSource sQLTableSource = queryBlock.getFrom();
        if (sQLTableSource == null) {
            return;
        }
        String string2 = "in_0";
        for (int i = 0; i < 100 && sQLTableSource.findTableSource(string = "in_" + i) != null; ++i) {
        }
        values.setAlias((String)var9_13);
        SQLIdentifierExpr in_column = new SQLIdentifierExpr((String)var9_13 + "_col");
        values.addColumn(in_column);
        SQLBinaryOpExpr joinCondition = new SQLBinaryOpExpr((SQLExpr)column.clone(), SQLBinaryOperator.Equality, new SQLPropertyExpr((String)var9_13, in_column.getName()));
        SQLJoinTableSource in_join = new SQLJoinTableSource(sQLTableSource, SQLJoinTableSource.JoinType.INNER_JOIN, values, joinCondition);
        if (this.replaceInParent(inListExpr, null)) {
            queryBlock.setFrom(in_join);
        }
    }

    @Override
    public boolean visit(SQLIntegerExpr x) {
        return this.visitNum(x);
    }

    @Override
    public boolean visit(SQLNumberExpr x) {
        return this.visitNum(x);
    }

    public boolean visitNum(SQLNumericLiteralExpr x) {
        SQLDataType type;
        SQLExpr expr;
        SQLObject parent = x.getParent();
        boolean decimal = false;
        if (parent instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)parent;
            SQLDataType leftType = binaryOpExpr.getLeft().computeDataType();
            SQLDataType rightType = binaryOpExpr.getRight().computeDataType();
            if (leftType == null || rightType == null) {
                return false;
            }
            decimal = leftType.nameHashCode64() == FnvHash.Constants.DECIMAL || rightType.nameHashCode64() == FnvHash.Constants.DECIMAL;
        } else if (parent instanceof SQLInListExpr) {
            expr = ((SQLInListExpr)parent).getExpr();
            type = expr.computeDataType();
            decimal = type != null && type.nameHashCode64() == FnvHash.Constants.DECIMAL;
        } else if (parent instanceof SQLBetweenExpr) {
            expr = ((SQLBetweenExpr)parent).getTestExpr();
            type = expr.computeDataType();
            decimal = type != null && type.nameHashCode64() == FnvHash.Constants.DECIMAL;
        }
        Number number = x.getNumber();
        SQLDecimalExpr decimalExpr = number instanceof Integer ? new SQLDecimalExpr(new BigDecimal(number.intValue())) : (number instanceof Long ? new SQLDecimalExpr(new BigDecimal(number.longValue())) : (number instanceof Float ? new SQLDecimalExpr(new BigDecimal(number.floatValue())) : (number instanceof Double ? new SQLDecimalExpr(new BigDecimal(number.doubleValue())) : (number instanceof BigDecimal ? new SQLDecimalExpr((BigDecimal)number) : new SQLDecimalExpr(new BigDecimal(number.toString()))))));
        if (decimal && SQLUtils.replaceInParent(x, decimalExpr)) {
            ++this.optimizedCount;
        }
        return false;
    }

    @Override
    public boolean visit(SQLCastExpr x) {
        SQLMethodInvokeExpr func;
        SQLExpr expr;
        SQLDataType dataType = x.getDataType();
        if (dataType == null) {
            return true;
        }
        long hashCode64 = dataType.nameHashCode64();
        if (hashCode64 == FnvHash.Constants.CHAR || hashCode64 == FnvHash.Constants.STRING) {
            x.setDataType(new SQLCharacterDataType("VARCHAR"));
        } else if (hashCode64 == FnvHash.Constants.INT) {
            x.setDataType(new SQLCharacterDataType("INTEGER"));
        } else if (hashCode64 == FnvHash.Constants.FLOAT) {
            x.setDataType(new SQLCharacterDataType("DOUBLE"));
        } else if (hashCode64 == FnvHash.Constants.LONG) {
            x.setDataType(new SQLCharacterDataType("BIGINT"));
        } else if (hashCode64 == FnvHash.Constants.NUMERIC || hashCode64 == FnvHash.Constants.NUMBER) {
            SQLDataType dataType1 = dataType.clone();
            dataType1.setName("DECIMAL");
            x.setDataType(dataType1);
        }
        hashCode64 = x.getDataType().nameHashCode64();
        if (hashCode64 == FnvHash.Constants.VARCHAR && (expr = x.getExpr()) instanceof SQLMethodInvokeExpr && (func = (SQLMethodInvokeExpr)expr).methodNameHashCode64() == FnvHash.Constants.JSON_EXTRACT) {
            func.setMethodName("JSON_EXTRACT_SCALAR");
            this.replaceInParent(x, func);
        }
        return true;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String name2;
        SQLMethodInvokeExpr target;
        long nameHashCode64 = x.nameHashCode64();
        if ((nameHashCode64 == FnvHash.Constants.SYSTIMESTAMP || nameHashCode64 == FnvHash.Constants.LOCALTIMESTAMP) && SQLUtils.replaceInParent(x, target = new SQLMethodInvokeExpr(x.getName()))) {
            target.accept(this);
            ++this.optimizedCount;
            return false;
        }
        String name = x.getName();
        if (name != (name2 = this.quoteAlias(name))) {
            x.setName(name2);
        }
        return true;
    }

    public String quoteAlias(String name) {
        if (this.backQuotedNames) {
            return StringUtils.backquoteAlias(name);
        }
        return StringUtils.quoteAlias(name);
    }

    @Override
    public boolean visit(SQLWithSubqueryClause x) {
        List<SQLWithSubqueryClause.Entry> entries = x.getEntries();
        for (SQLWithSubqueryClause.Entry entry : entries) {
            entry.setAlias(SQLUtils.normalize(entry.getAlias()));
            entry.getSubQuery().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        String name2;
        String name = x.getName();
        if (name != (name2 = this.quoteAlias(name))) {
            x.setName(name2);
        }
        x.getOwner().accept(this);
        if (x.hashCode64() == INFORMATION_SCHEMA_VIEWS) {
            x.setName("view");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        SQLMethodInvokeExpr bitwise_and;
        SQLDataType rightDataType;
        SQLDataType leftDataType;
        if (this.isGroup(x)) {
            return super.visit(x);
        }
        SQLBinaryOperator operator = x.getOperator();
        if (operator == SQLBinaryOperator.DIV) {
            operator = SQLBinaryOperator.Divide;
            x.setOperator(operator);
        }
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        switch (operator) {
            case Equality: {
                SQLDataType dataType;
                if (right instanceof SQLNullExpr) {
                    operator = SQLBinaryOperator.Is;
                    x.setOperator(operator);
                    break;
                }
                if (!(right instanceof SQLCharExpr) || (dataType = left.computeDataType()) == null || dataType.nameHashCode64() != FnvHash.Constants.BOOLEAN) break;
                String chars = ((SQLCharExpr)right).getText();
                if ("Y".equals(chars)) {
                    right = new SQLBooleanExpr(true);
                    x.setRight(right);
                    break;
                }
                if (!"N".equals(chars)) break;
                right = new SQLBooleanExpr(false);
                x.setRight(right);
                break;
            }
            case NotEqual: 
            case LessThanOrGreater: {
                if (!(right instanceof SQLNullExpr)) break;
                operator = SQLBinaryOperator.IsNot;
                x.setOperator(operator);
                break;
            }
            case BitwiseAnd: 
            case BitwiseOr: 
            case BitwiseXor: 
            case LeftShift: 
            case RightShift: {
                leftDataType = left.computeDataType();
                if (leftDataType == null || !leftDataType.isInt()) {
                    left = new SQLCastExpr(left, new SQLDataTypeImpl("BIGINT"));
                    x.setLeft(left);
                }
                if ((rightDataType = right.computeDataType()) != null && rightDataType.isInt()) break;
                right = new SQLCastExpr(right, new SQLDataTypeImpl("BIGINT"));
                x.setRight(right);
                break;
            }
            case LessThanOrEqualOrGreaterThan: {
                SQLMethodInvokeExpr ifExpr = new SQLMethodInvokeExpr("if", null, SQLBinaryOpExpr.and(SQLBinaryOpExpr.isNull(left.clone()), SQLBinaryOpExpr.isNull(right.clone())), new SQLBooleanExpr(true), new SQLMethodInvokeExpr("if", null, SQLBinaryOpExpr.and(SQLBinaryOpExpr.isNotNull(left.clone()), SQLBinaryOpExpr.isNotNull(right.clone())), SQLBinaryOpExpr.eq(left.clone(), right.clone()), new SQLBooleanExpr(false)));
                this.replaceInParent(x, ifExpr);
                ifExpr.accept(this);
                return false;
            }
        }
        if (operator == SQLBinaryOperator.BitwiseAnd) {
            bitwise_and = new SQLMethodInvokeExpr("BITWISE_AND", null, left.clone(), right.clone());
            if (SQLUtils.replaceInParent(x, bitwise_and)) {
                ++this.optimizedCount;
                bitwise_and.accept(this);
                return false;
            }
        } else if (operator == SQLBinaryOperator.BitwiseOr) {
            bitwise_and = new SQLMethodInvokeExpr("BITWISE_OR", null, left.clone(), right.clone());
            if (SQLUtils.replaceInParent(x, bitwise_and)) {
                ++this.optimizedCount;
                bitwise_and.accept(this);
                return false;
            }
        } else if (operator == SQLBinaryOperator.LeftShift) {
            bitwise_and = new SQLMethodInvokeExpr("BITWISE_LEFT_SHIFT", null, left.clone(), right.clone());
            if (SQLUtils.replaceInParent(x, bitwise_and)) {
                ++this.optimizedCount;
                bitwise_and.accept(this);
                return false;
            }
        } else if (operator == SQLBinaryOperator.RightShift) {
            bitwise_and = new SQLMethodInvokeExpr("BITWISE_RIGHT_SHIFT", null, left.clone(), right.clone());
            if (SQLUtils.replaceInParent(x, bitwise_and)) {
                ++this.optimizedCount;
                bitwise_and.accept(this);
                return false;
            }
        } else if (operator == SQLBinaryOperator.BitwiseXor && SQLUtils.replaceInParent(x, bitwise_and = new SQLMethodInvokeExpr("BITWISE_XOR", null, left.clone(), right.clone()))) {
            ++this.optimizedCount;
            bitwise_and.accept(this);
            return false;
        }
        if (left instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExprLeft = (SQLBinaryOpExpr)left;
            if (binaryOpExprLeft.getOperator().isArithmetic()) {
                this.visit(binaryOpExprLeft);
            } else {
                binaryOpExprLeft.accept(this);
            }
        } else {
            left.accept(this);
        }
        right.accept(this);
        if (left instanceof SQLName && right instanceof SQLIntegerExpr) {
            this.handleNameAndLiteral((SQLName)left, (SQLIntegerExpr)right);
            return false;
        }
        if (left instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)left).methodNameHashCode64() == FnvHash.Constants.JSON_EXTRACT) {
            if (right instanceof SQLCharExpr) {
                ((SQLMethodInvokeExpr)left).setMethodName("JSON_EXTRACT_SCALAR");
            } else {
                SQLCastExpr cast;
                if (right instanceof SQLIntegerExpr) {
                    cast = new SQLCastExpr(left.clone(), SQLIntegerExpr.DATA_TYPE.clone());
                    x.setLeft(cast);
                    ++this.optimizedCount;
                    return false;
                }
                if (right instanceof SQLNumberExpr) {
                    cast = new SQLCastExpr(left.clone(), SQLNumberExpr.DATA_TYPE_DOUBLE.clone());
                    x.setLeft(cast);
                    ++this.optimizedCount;
                    return false;
                }
                if (right instanceof SQLBooleanExpr) {
                    cast = new SQLCastExpr(left.clone(), SQLBooleanExpr.DATA_TYPE.clone());
                    x.setLeft(cast);
                    ++this.optimizedCount;
                    return false;
                }
            }
        }
        leftDataType = left.computeDataType();
        rightDataType = right.computeDataType();
        if (leftDataType == null) {
            return true;
        }
        long leftTypeHash = leftDataType.nameHashCode64();
        switch (x.getOperator()) {
            case Equality: 
            case NotEqual: 
            case LessThanOrGreater: 
            case GreaterThan: 
            case GreaterThanOrEqual: 
            case LessThan: 
            case LessThanOrEqual: {
                if (rightDataType == null) return true;
                long rightTypeHash = rightDataType.nameHashCode64();
                if (leftTypeHash == FnvHash.Constants.BIGINT && (rightTypeHash == FnvHash.Constants.TIMESTAMP || rightTypeHash == FnvHash.Constants.DATE || rightTypeHash == FnvHash.Constants.DATETIME)) {
                    SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr("to_unixtime");
                    methodInvokeExpr.getArguments().add(right);
                    SQLUtils.replaceInParent(right, methodInvokeExpr);
                    return true;
                }
                if (rightTypeHash == FnvHash.Constants.BIGINT && (leftTypeHash == FnvHash.Constants.TIMESTAMP || leftTypeHash == FnvHash.Constants.DATE || leftTypeHash == FnvHash.Constants.DATETIME)) {
                    SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr("to_unixtime");
                    methodInvokeExpr.getArguments().add(left);
                    SQLUtils.replaceInParent(left, methodInvokeExpr);
                    return true;
                }
                if (rightTypeHash == FnvHash.Constants.CHAR && right instanceof SQLCharExpr && leftTypeHash == FnvHash.Constants.TIMESTAMP) {
                    if (!ConstFolding.repalceToTimestamp((SQLCharExpr)right, this.timeZone)) return true;
                    ++this.optimizedCount;
                    return true;
                }
                if (rightTypeHash == FnvHash.Constants.DATE && leftTypeHash == FnvHash.Constants.TIMESTAMP) {
                    if (!(x.getRight() instanceof SQLDateExpr)) return true;
                    String text = ((SQLDateExpr)x.getRight()).getLiteral();
                    Date date = MySqlUtils.parseDate(text, this.timeZone);
                    if (date == null) return true;
                    SQLTimestampExpr replaceTo = new SQLTimestampExpr(date, this.timeZone);
                    SQLUtils.replaceInParent(right, replaceTo);
                    return true;
                }
                if (leftTypeHash == FnvHash.Constants.BIGINT && (rightTypeHash == FnvHash.Constants.VARCHAR || rightTypeHash == FnvHash.Constants.CHAR) && x.isBothName()) {
                    SQLCastExpr try_cast = new SQLCastExpr();
                    try_cast.setExpr(right);
                    try_cast.setDataType(SQLIntegerExpr.DATA_TYPE);
                    try_cast.setTry(true);
                    SQLUtils.replaceInParent(right, try_cast);
                    return true;
                }
                if (leftTypeHash == FnvHash.Constants.DATE && right instanceof SQLCharExpr) {
                    void var12_35;
                    String text = ((SQLCharExpr)right).getText();
                    if (text.indexOf(45) < 0) {
                        SQLCastExpr cast = new SQLCastExpr(right.clone(), new SQLDataTypeImpl("DATE"));
                        cast.setTry(true);
                        SQLCastExpr sQLCastExpr = cast;
                    } else {
                        SQLDateExpr sQLDateExpr = new SQLDateExpr(text);
                    }
                    SQLUtils.replaceInParent(right, (SQLExpr)var12_35);
                    return true;
                }
                if (leftTypeHash == FnvHash.Constants.TIME && right instanceof SQLCharExpr) {
                    void var12_38;
                    String text = ((SQLCharExpr)right).getText();
                    if (text.indexOf(58) < 0) {
                        SQLCastExpr cast = new SQLCastExpr(right.clone(), new SQLDataTypeImpl("TIME"));
                        cast.setTry(true);
                        SQLCastExpr sQLCastExpr = cast;
                    } else {
                        SQLTimeExpr sQLTimeExpr = new SQLTimeExpr(text);
                    }
                    SQLUtils.replaceInParent(right, (SQLExpr)var12_38);
                    return true;
                }
                if (rightTypeHash == FnvHash.Constants.BIGINT && (leftTypeHash == FnvHash.Constants.VARCHAR || leftTypeHash == FnvHash.Constants.CHAR) && x.isBothName()) {
                    SQLCastExpr try_cast = new SQLCastExpr();
                    try_cast.setExpr(left.clone());
                    try_cast.setDataType(SQLIntegerExpr.DATA_TYPE);
                    try_cast.setTry(true);
                    SQLUtils.replaceInParent(left, try_cast);
                    return true;
                }
                if ((leftTypeHash == FnvHash.Constants.CHAR || leftTypeHash == FnvHash.Constants.VARCHAR) && right instanceof SQLNumericLiteralExpr) {
                    String str = right.toString();
                    SQLCharExpr sQLCharExpr = new SQLCharExpr(str);
                    x.setRight(sQLCharExpr);
                    ++this.optimizedCount;
                    return true;
                }
                if (leftTypeHash != FnvHash.Constants.INT) {
                    if (leftTypeHash != FnvHash.Constants.BIGINT) return true;
                }
                if (!(right instanceof SQLCharExpr)) return true;
                SQLCastExpr cast = new SQLCastExpr(right.clone(), new SQLDataTypeImpl("BIGINT"));
                x.setRight(cast);
                ++this.optimizedCount;
                return true;
            }
            case Subtract: {
                if (rightDataType == null) return true;
                long rightTypeHash = rightDataType.nameHashCode64();
                if (rightTypeHash != FnvHash.Constants.DATE) return true;
                if (leftTypeHash == FnvHash.Constants.DATE) {
                    SQLMethodInvokeExpr dateDiff = new SQLMethodInvokeExpr("DATE_DIFF", null, new SQLCharExpr("DAY"), right.clone(), left.clone());
                    this.replaceInParent(x, dateDiff);
                    return true;
                }
                if (leftTypeHash != FnvHash.Constants.CHAR) {
                    if (leftTypeHash != FnvHash.Constants.VARCHAR) return true;
                }
                SQLTextLiteralExpr leftTextLiteral = (SQLTextLiteralExpr)left;
                SQLMethodInvokeExpr sQLMethodInvokeExpr = new SQLMethodInvokeExpr("DATE_DIFF", null, new SQLCharExpr("DAY"), right.clone(), new SQLDateExpr(leftTextLiteral.getText()));
                this.replaceInParent(x, sQLMethodInvokeExpr);
                return true;
            }
            case Divide: 
            case Multiply: 
            case Modulus: {
                if (rightDataType == null) return true;
                long rightTypeHash = rightDataType.nameHashCode64();
                if (leftTypeHash == FnvHash.Constants.VARCHAR) {
                    if (rightTypeHash == FnvHash.Constants.DOUBLE) {
                        SQLCastExpr castExpr = new SQLCastExpr(left, new SQLDataTypeImpl("DOUBLE"));
                        castExpr.setTry(true);
                        x.setLeft(castExpr);
                        return true;
                    }
                    if (rightTypeHash == FnvHash.Constants.FLOAT) {
                        SQLCastExpr castExpr = new SQLCastExpr(left, new SQLDataTypeImpl("FLOAT"));
                        castExpr.setTry(true);
                        x.setLeft(castExpr);
                        return true;
                    }
                    if (rightTypeHash != FnvHash.Constants.INT && rightTypeHash != FnvHash.Constants.BIGINT && rightTypeHash != FnvHash.Constants.INTEGER && rightTypeHash != FnvHash.Constants.TINYINT) {
                        if (rightTypeHash != FnvHash.Constants.SMALLINT) return true;
                    }
                    SQLCastExpr castExpr = new SQLCastExpr(left, new SQLDataTypeImpl("BIGINT"));
                    castExpr.setTry(true);
                    x.setLeft(castExpr);
                    return true;
                }
                if (rightTypeHash != FnvHash.Constants.VARCHAR) return true;
                if (leftTypeHash == FnvHash.Constants.DOUBLE) {
                    SQLCastExpr castExpr = new SQLCastExpr(right, new SQLDataTypeImpl("DOUBLE"));
                    castExpr.setTry(true);
                    x.setRight(castExpr);
                    return true;
                }
                if (leftTypeHash == FnvHash.Constants.FLOAT) {
                    SQLCastExpr castExpr = new SQLCastExpr(right, new SQLDataTypeImpl("FLOAT"));
                    castExpr.setTry(true);
                    x.setRight(castExpr);
                    return true;
                }
                if (leftTypeHash != FnvHash.Constants.INT && leftTypeHash != FnvHash.Constants.BIGINT && leftTypeHash != FnvHash.Constants.INTEGER && leftTypeHash != FnvHash.Constants.TINYINT) {
                    if (leftTypeHash != FnvHash.Constants.SMALLINT) return true;
                }
                SQLCastExpr castExpr = new SQLCastExpr(left, new SQLDataTypeImpl("BIGINT"));
                castExpr.setTry(true);
                x.setRight(castExpr);
                return true;
            }
            case Add: {
                SQLMethodInvokeExpr dateAdd;
                if (rightDataType == null) return true;
                if (leftTypeHash != FnvHash.Constants.DATE) {
                    if (leftTypeHash != FnvHash.Constants.TIMESTAMP) return true;
                }
                if (rightDataType.nameHashCode64() != FnvHash.Constants.INTERVAL) return true;
                SQLExpr deltaExpr = right.clone();
                if (deltaExpr instanceof SQLBinaryOpExpr) {
                    SQLIntervalExpr intervalExpr;
                    SQLIntervalUnit intervalUnit;
                    String unit = null;
                    SQLBinaryOpExpr binaryOpRight = (SQLBinaryOpExpr)deltaExpr;
                    SQLExpr sQLExpr = binaryOpRight.getLeft();
                    SQLExpr rightRight = binaryOpRight.getRight();
                    if (rightRight instanceof SQLIntervalExpr && (intervalUnit = (intervalExpr = (SQLIntervalExpr)rightRight).getUnit()) != null) {
                        SQLExpr value = intervalExpr.getValue();
                        if (value instanceof SQLCharExpr) {
                            String str = ((SQLCharExpr)value).getText();
                            try {
                                long longValue = Long.parseLong(str);
                                value = SQLIntegerExpr.ofIntOrLong(longValue);
                            }
                            catch (NumberFormatException ex) {
                                return true;
                            }
                        } else if (value instanceof SQLMethodInvokeExpr && value.computeDataType() != null && value.computeDataType().isInt()) {
                            SQLIntervalExpr interval2 = intervalExpr.clone();
                            SQLBinaryOpExpr intervalValue2 = binaryOpRight.clone();
                            intervalValue2.setRight(value.clone());
                            interval2.setValue(intervalValue2);
                            SQLMethodInvokeExpr dateAdd2 = new SQLMethodInvokeExpr("DATE_ADD", null, left.clone(), interval2);
                            this.replaceInParent(x, dateAdd2);
                            return true;
                        }
                        binaryOpRight.setRight(value.clone());
                        unit = intervalUnit.toString();
                    }
                    if (unit == null) return true;
                    SQLMethodInvokeExpr dateAdd3 = new SQLMethodInvokeExpr("DATE_ADD", null, new SQLCharExpr(unit), deltaExpr, left.clone());
                    if (!this.replaceInParent(x, dateAdd3)) return true;
                    dateAdd3.accept(this);
                    return true;
                }
                if (!(deltaExpr instanceof SQLIntervalExpr)) return true;
                SQLIntervalExpr intervalExpr = (SQLIntervalExpr)deltaExpr;
                if (intervalExpr.getUnit() != null) {
                    String string = intervalExpr.getUnit().name;
                    dateAdd = new SQLMethodInvokeExpr("DATE_ADD", null, new SQLCharExpr(string), intervalExpr.getValue().clone(), left.clone());
                } else {
                    dateAdd = new SQLMethodInvokeExpr("DATE_ADD", null, left.clone(), deltaExpr);
                }
                if (!this.replaceInParent(x, dateAdd)) return true;
                dateAdd.accept(this);
                return true;
            }
        }
        return true;
    }

    private void handleNameAndLiteral(SQLName name, SQLLiteralExpr literal) {
        SQLDataType dataType = name.computeDataType();
        if (dataType == null) {
            return;
        }
        long hashCode64 = dataType.nameHashCode64();
        if (hashCode64 == FnvHash.Constants.SMALLINT) {
            if (literal instanceof SQLIntegerExpr && SQLUtils.replaceInParent(literal, new SQLSmallIntExpr(((SQLIntegerExpr)literal).getNumber().shortValue()))) {
                ++this.optimizedCount;
            }
        } else if (hashCode64 == FnvHash.Constants.TINYINT && literal instanceof SQLIntegerExpr && SQLUtils.replaceInParent(literal, new SQLTinyIntExpr(((SQLIntegerExpr)literal).getNumber().byteValue()))) {
            ++this.optimizedCount;
        }
    }

    @Override
    public boolean visit(SQLMatchAgainstExpr x) {
        for (SQLExpr column : x.getColumns()) {
            column.accept(this);
        }
        x.getAgainst().accept(this);
        ArrayList<SQLExpr> params = new ArrayList<SQLExpr>();
        params.addAll(x.getColumns());
        params.add(x.getAgainst());
        SQLMethodInvokeExpr fun = new SQLMethodInvokeExpr("MATCH_AGAINST", null, params);
        SQLObject parent = x.getParent();
        SQLBinaryOperator operator = null;
        if (parent instanceof SQLBinaryOpExpr) {
            operator = ((SQLBinaryOpExpr)parent).getOperator();
        } else if (parent instanceof SQLBinaryOpExprGroup) {
            operator = ((SQLBinaryOpExprGroup)parent).getOperator();
        }
        SQLExprImpl replaceTo = null;
        replaceTo = parent instanceof SQLSelectQueryBlock || operator != null && operator.isLogical() ? new SQLBinaryOpExpr((SQLExpr)fun, SQLBinaryOperator.GreaterThan, new SQLIntegerExpr(0)) : fun;
        SQLUtils.replaceInParent(x, replaceTo);
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        List<SQLExpr> args;
        SQLExpr arg0;
        long hash = x.methodNameHashCode64();
        String methodName = x.getMethodName();
        x.setMethodName(SQLUtils.normalize(methodName));
        List<SQLExpr> arguments = x.getArguments();
        for (SQLExpr argument : arguments) {
            argument.accept(this);
        }
        if (hash == FnvHash.Constants.DATEDIFF) {
            this.func_datediff(x);
        } else if (hash == FnvHash.Constants.ADD_MONTHS && arguments.size() == 2) {
            this.func_add_months(x);
        } else if (hash == FnvHash.Constants.DAYOFMONTH && arguments.size() == 1) {
            this.func_dayofmonth(x);
        } else if (hash == FnvHash.Constants.FROM_UNIXTIME) {
            this.func_from_unixtime(x);
        } else if (hash == FnvHash.Constants.TO_UNIXTIME) {
            this.func_to_unixtime(x);
        } else if (hash == FnvHash.Constants.DAYOFYEAR && arguments.size() == 1) {
            this.func_dayofyear(x);
        } else if (hash == FnvHash.Constants.DAYOFWEEK && arguments.size() == 1) {
            x.setMethodName("DAY_OF_WEEK");
        } else if (hash == FnvHash.Constants.TO_BASE64 && arguments.size() == 1) {
            arg0 = arguments.get(0);
            SQLCastExpr castExpr = new SQLCastExpr(arg0, new SQLDataTypeImpl("VARBINARY"));
            arguments.set(0, castExpr);
            ++this.optimizedCount;
        } else if (hash == FnvHash.Constants.DAYNAME && arguments.size() == 1) {
            x.setMethodName("DATE_FORMAT");
            arguments.add(1, new SQLCharExpr("%W"));
        } else if (hash == FnvHash.Constants.MONTH_BETWEEN && arguments.size() == 2) {
            this.func_month_between(x);
        } else if (hash == FnvHash.Constants.UNIX_TIMESTAMP) {
            this.func_unix_timestamp(x);
        } else if ((hash == FnvHash.Constants.HOUR || hash == FnvHash.Constants.MINUTE || hash == FnvHash.Constants.SECOND) && arguments.size() == 1) {
            arg0 = x.getArguments().get(0);
            if (arg0 instanceof SQLCharExpr || arg0 instanceof SQLIdentifierExpr) {
                x.getArguments().set(0, new SQLCastExpr(arg0, new SQLDataTypeImpl("TIME")));
            }
        } else if (hash == FnvHash.Constants.TIMESTAMPADD && arguments.size() == 3) {
            this.func_timestampadd(x);
        } else if (hash == FnvHash.Constants.WEEK) {
            this.func_week(x);
        } else if (hash == FnvHash.Constants.DATE_TRUNC && arguments.size() == 2) {
            this.func_date_trunc(x);
        } else if (hash == FnvHash.Constants.TIMESTAMPDIFF && arguments.size() == 3) {
            this.func_timestampdiff(x);
        } else if (hash == FnvHash.Constants.MONTHNAME && arguments.size() == 1) {
            this.func_monthname(x);
        } else if (hash == FnvHash.Constants.DECODE) {
            this.func_decode(x);
        } else if (hash == FnvHash.Constants.CONCAT) {
            this.func_concat(x);
        } else if (hash == FnvHash.Constants.WEEKOFYEAR) {
            this.func_weekofyear(x);
        } else if (hash == FnvHash.Constants.POSITION) {
            this.func_position(x);
        } else if (hash == FnvHash.Constants.YEARMONTH && arguments.size() == 1) {
            this.func_yearmonth(x);
        } else if (hash == FnvHash.Constants.TIMESTAMP) {
            this.func_timestamp(x);
        } else if (hash == FnvHash.Constants.TO_TIMESTAMP) {
            this.func_to_timestamp(x);
        } else if (hash == FnvHash.Constants.TO_CHAR) {
            this.func_to_char(x);
        } else if (hash == FnvHash.Constants.DATE_SUB || hash == FnvHash.Constants.SUBDATE) {
            this.func_date_sub(x);
        } else if (hash == FnvHash.Constants.DATE_ADD || hash == FnvHash.Constants.ADDDATE || hash == FnvHash.Constants.DATEADD) {
            if (this.argsAllConst(x)) {
                this.func_str_date_add(x);
            } else {
                this.func_date_add(x);
            }
        } else if (hash == FnvHash.Constants.CURDATE) {
            x.setMethodName("CURDATE");
        } else if (hash == FnvHash.Constants.SYSTIMESTAMP) {
            x.setMethodName("CURRENT_TIMESTAMP");
        } else if (hash == FnvHash.Constants.TIMEDIFF) {
            args = x.getArguments();
            SQLExpr arg02 = args.get(0);
            SQLExpr arg1 = args.get(1);
            if (arg02 instanceof SQLIdentifierExpr) {
                arguments.set(0, new SQLCastExpr(arg02, new SQLCharacterDataType("VARCHAR")));
            }
            if (arg1 instanceof SQLIdentifierExpr) {
                arguments.set(1, new SQLCastExpr(arg1, new SQLCharacterDataType("VARCHAR")));
            }
        } else if (hash == FnvHash.Constants.ADDTIME) {
            this.func_addtime(x);
        } else if (hash == FnvHash.Constants.NVL2 && arguments.size() == 3) {
            this.func_nvl2(x);
        } else if (hash == FnvHash.Constants.LOCATE) {
            this.func_locate(x);
        } else if (hash == FnvHash.Constants.GREATEST) {
            this.func_greatest(x);
        } else if (hash == FnvHash.Constants.LEAST) {
            this.func_least(x);
        } else if (hash == FnvHash.Constants.TRIM) {
            this.func_trim(x);
        } else if (hash == FnvHash.Constants.UDF_SYS_ROWCOUNT) {
            this.func_udf_sys_rowcount(x);
        } else if (hash == FnvHash.Constants.TRUNCATE) {
            this.func_truncate(x);
        } else if (hash == FnvHash.Constants.TRUNC) {
            this.func_trunc(x);
        } else if (hash == FnvHash.Constants.LEFT) {
            x.setMethodName("PRESTO_LEFT");
        } else if (hash == FnvHash.Constants.RIGHT) {
            x.setMethodName("PRESTO_RIGHT");
        } else if (hash == FnvHash.Constants.REGEXP_SUBSTR) {
            x.setMethodName("REGEXP_EXTRACT");
        } else if (hash == FnvHash.Constants.LCASE) {
            x.setMethodName("LOWER");
        } else if (hash == FnvHash.Constants.UCASE) {
            x.setMethodName("UPPER");
        } else if (hash == FnvHash.Constants.SUBSTR || hash == FnvHash.Constants.SUBSTRING) {
            this.func_substr(x);
        } else if (hash == FnvHash.Constants.LOCALTIMESTAMP) {
            x.setMethodName("LOCALTIMESTAMPFUNC");
        } else if (hash == FnvHash.Constants.SPACE) {
            x.setMethodName("rpad");
            arg0 = x.getArguments().get(0);
            x.getArguments().set(0, new SQLCharExpr(""));
            x.getArguments().add(arg0);
            x.getArguments().add(new SQLCharExpr(" "));
        } else if (hash == FnvHash.Constants.LOCALTIME) {
            x.setMethodName("LOCALTIMEFUNC");
        } else if (hash == FnvHash.Constants.SESSIONTIMEZONE) {
            x.setMethodName("CURRENT_TIMEZONE");
        } else if (hash == FnvHash.Constants.DBTIMEZONE) {
            x.setMethodName("CURRENT_TIMEZONE");
        } else if (hash == FnvHash.Constants.BITAND) {
            x.setMethodName("BITWISE_AND");
        } else if (hash == FnvHash.Constants.CURRENT_TIME) {
            x.setMethodName("CURRENTTIMEFUNC");
        } else if (hash == FnvHash.Constants.CURRENT_DATE) {
            x.setMethodName("curdate");
        } else if (hash == FnvHash.Constants.CURRENT_TIMESTAMP) {
            x.setMethodName("now");
        } else if (hash == FnvHash.Constants.JSON_EXTRACT) {
            this.func_json_extract(x);
        } else if (hash == FnvHash.Constants.JSON_EXTRACT_SCALAR) {
            this.func_json_extract_scalar(x);
        } else if (hash == FnvHash.Constants.CHAR_LENGTH || hash == FnvHash.Constants.CHARACTER_LENGTH) {
            x.setMethodName("LENGTH");
        } else if (hash == FnvHash.Constants.CHAR) {
            args = x.getArguments();
            for (int i = 0; i < args.size(); ++i) {
                SQLExpr arg = args.get(i);
                if (arg instanceof SQLCharExpr) {
                    String text = ((SQLCharExpr)arg).getText();
                    args.set(i, new SQLIntegerExpr(Integer.valueOf(text)));
                    continue;
                }
                if (!(arg instanceof SQLIdentifierExpr)) continue;
                SQLCastExpr castExpr = new SQLCastExpr(arg, new SQLDataTypeImpl("BIGINT"));
                args.set(i, castExpr);
            }
        } else if (hash == FnvHash.Constants.NULLIF) {
            this.func_nullif(x);
        } else if (hash == FnvHash.Constants.COALESCE || hash == FnvHash.Constants.IFNULL || hash == FnvHash.Constants.NVL) {
            this.func_ifnull(x);
        } else if (hash == FnvHash.Constants.ISNULL) {
            this.func_isnull(x);
        } else if (hash == FnvHash.Constants.CONVERT_TZ) {
            this.func_convert_tz(x);
        }
        SQLExpr owner = x.getOwner();
        if (owner != null) {
            owner.accept(this);
        }
        for (SQLExpr arg : x.getArguments()) {
            arg.accept(this);
        }
        return false;
    }

    private void func_substr(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (x.getFrom() != null) {
            if (x.getFor() != null) {
                x.getArguments().add(x.getFrom());
                x.getArguments().add(x.getFor());
                x.setFrom(null);
                x.setFor(null);
                x.setMethodName("SUBSTR");
            } else {
                x.setMethodName("SUBSTRING");
            }
        } else {
            SQLExpr arg0 = x.getArguments().get(0);
            SQLDataType arg0DateType = arg0.computeDataType();
            if (arg0DateType != null) {
                long bash64 = arg0DateType.nameHashCode64();
                if (arg0DateType != null && bash64 != FnvHash.Constants.CHAR && bash64 != FnvHash.Constants.VARCHAR) {
                    SQLCastExpr replace = new SQLCastExpr(arg0.clone(), new SQLDataTypeImpl("VARCHAR"));
                    arguments.set(0, replace);
                }
            }
            x.setMethodName("SUBSTR");
        }
    }

    private boolean argsAllConst(SQLMethodInvokeExpr x) {
        long hash = x.methodNameHashCode64();
        boolean allConst = true;
        for (int i = 0; i < x.getArguments().size(); ++i) {
            SQLExpr arg = x.getArguments().get(i);
            if (arg instanceof SQLValuableExpr || arg instanceof SQLIntervalExpr && ((SQLIntervalExpr)arg).getValue() instanceof SQLValuableExpr || hash == FnvHash.Constants.TIMESTAMPDIFF && i == 0 && arg instanceof SQLIdentifierExpr || hash == FnvHash.Constants.GET_FORMAT && i == 0 && arg instanceof SQLIdentifierExpr || hash == FnvHash.Constants.IF || hash == FnvHash.Constants.JSON_EXTRACT || hash == FnvHash.Constants.JSON_ARRAY_GET || hash == FnvHash.Constants.DATE_FORMAT) continue;
            allConst = false;
        }
        return allConst;
    }

    private void dateAdd(SQLMethodInvokeExpr x, SQLExpr arg0, SQLExpr arg1, boolean negative) {
        String text;
        boolean timestamp = false;
        if (arg0 instanceof SQLCharExpr) {
            text = ((SQLCharExpr)arg0).getText();
            if (text.length() > 10) {
                timestamp = true;
            }
        } else if (arg0 instanceof SQLDateExpr) {
            text = ((SQLDateExpr)arg0).getLiteral();
        } else {
            text = ((SQLTimestampExpr)arg0).getLiteral();
            timestamp = true;
        }
        SQLIntervalUnit unit = null;
        SQLExpr valueExpr = null;
        if (arg1 instanceof SQLIntegerExpr) {
            valueExpr = arg1;
            unit = SQLIntervalUnit.DAY;
        } else {
            SQLIntervalExpr interval = (SQLIntervalExpr)arg1;
            unit = interval.getUnit();
            valueExpr = interval.getValue();
        }
        Date date = MySqlUtils.parseDate(text, this.timeZone);
        if (date != null && this.timeZone != null && valueExpr instanceof SQLIntegerExpr && unit != null) {
            int delta = ((SQLIntegerExpr)valueExpr).getNumber().intValue();
            if (negative) {
                delta = -delta;
            }
            Calendar calendar = Calendar.getInstance(this.timeZone);
            calendar.setTime(date);
            switch (unit) {
                case YEAR: {
                    calendar.add(1, delta);
                    break;
                }
                case MONTH: {
                    calendar.add(2, delta);
                    break;
                }
                case DAY: {
                    calendar.add(6, delta);
                    break;
                }
                case HOUR: {
                    calendar.add(11, delta);
                    break;
                }
                case MINUTE: {
                    calendar.add(12, delta);
                    break;
                }
                case SECOND: {
                    calendar.add(13, delta);
                    break;
                }
                default: {
                    return;
                }
            }
            SimpleDateFormat tzFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            tzFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            tzFormat.setTimeZone(this.timeZone);
            String result = tzFormat.format(calendar.getTime());
            SQLExprImpl replaceTo = result.endsWith(" 00:00:00") && !timestamp ? new SQLDateExpr(result.substring(0, result.length() - 9)) : new SQLTimestampExpr(result);
            if (this.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_str_date_add(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 2 && (arguments.get(0) instanceof SQLCharExpr || arguments.get(0) instanceof SQLDateExpr || arguments.get(0) instanceof SQLTimestampExpr) && (arguments.get(1) instanceof SQLIntervalExpr || arguments.get(1) instanceof SQLIntegerExpr)) {
            this.dateAdd(x, arguments.get(0), arguments.get(1), false);
            return;
        }
        if (arguments.size() == 3 && arguments.get(0) instanceof SQLDateExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(2) instanceof SQLCharExpr) {
            SQLDateExpr dateCloned;
            SQLDateExpr dateExpr = (SQLDateExpr)arguments.get(0);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(2)).getText();
            if ("day".equalsIgnoreCase(type)) {
                SQLDateExpr dateCloned2 = dateExpr.clone();
                if (dateCloned2.addDay(delta) && this.replaceInParent(x, dateCloned2)) {
                    ++this.optimizedCount;
                }
            } else if ("month".equalsIgnoreCase(type) && (dateCloned = dateExpr.clone()).addMonth(delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(2) instanceof SQLDateExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(0) instanceof SQLCharExpr) {
            SQLDateExpr dateCloned;
            SQLDateExpr dateExpr = (SQLDateExpr)arguments.get(2);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(0)).getText();
            if ("day".equalsIgnoreCase(type)) {
                SQLDateExpr dateCloned3 = dateExpr.clone();
                if (dateCloned3.addDay(delta) && this.replaceInParent(x, dateCloned3)) {
                    ++this.optimizedCount;
                }
            } else if ("month".equalsIgnoreCase(type) && (dateCloned = dateExpr.clone()).addMonth(delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(0) instanceof SQLTimestampExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(2) instanceof SQLCharExpr) {
            SQLTimestampExpr dateCloned;
            SQLTimestampExpr dateExpr = (SQLTimestampExpr)arguments.get(0);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(2)).getText();
            if ("day".equalsIgnoreCase(type)) {
                SQLTimestampExpr dateCloned4 = dateExpr.clone();
                if (dateCloned4.addDay(delta) && this.replaceInParent(x, dateCloned4)) {
                    ++this.optimizedCount;
                }
            } else if ("month".equalsIgnoreCase(type) && (dateCloned = dateExpr.clone()).addMonth(delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(2) instanceof SQLTimestampExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(0) instanceof SQLCharExpr) {
            SQLTimestampExpr dateCloned;
            SQLTimestampExpr dateExpr = (SQLTimestampExpr)arguments.get(2);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(0)).getText();
            if ("day".equalsIgnoreCase(type)) {
                SQLTimestampExpr dateCloned5 = dateExpr.clone();
                if (dateCloned5.addDay(delta) && this.replaceInParent(x, dateCloned5)) {
                    ++this.optimizedCount;
                }
            } else if ("month".equalsIgnoreCase(type) && (dateCloned = dateExpr.clone()).addMonth(delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(2) instanceof SQLCharExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(0) instanceof SQLCharExpr) {
            SQLDataType dataType;
            String dateText = ((SQLCharExpr)arguments.get(2)).getText();
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(0)).getText();
            Date date = MySqlUtils.parseDate(dateText, this.timeZone);
            if (date == null) {
                return;
            }
            Calendar calendar = this.timeZone != null ? Calendar.getInstance(this.timeZone) : Calendar.getInstance();
            calendar.setTime(date);
            boolean isDate = calendar.get(14) == 0 && calendar.get(13) == 0 && calendar.get(12) == 0 && calendar.get(11) == 0;
            boolean isTimestampType = false;
            if (x.getParent() instanceof SQLBinaryOpExpr && (dataType = ((SQLBinaryOpExpr)x.getParent()).getLeft().computeDataType()) != null && dataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP) {
                isTimestampType = true;
            }
            SQLExprImpl replaceTo = null;
            if ("day".equalsIgnoreCase(type)) {
                calendar.add(5, delta);
                replaceTo = isTimestampType ? new SQLTimestampExpr(calendar.getTime(), this.timeZone) : (isDate ? new SQLDateExpr(calendar.getTime(), this.timeZone) : new SQLTimestampExpr(calendar.getTime(), this.timeZone));
            } else if ("month".equalsIgnoreCase(type)) {
                calendar.add(2, delta);
                replaceTo = isTimestampType ? new SQLTimestampExpr(calendar.getTime(), this.timeZone) : (isDate ? new SQLDateExpr(calendar.getTime(), this.timeZone) : new SQLTimestampExpr(calendar.getTime(), this.timeZone));
            } else {
                this.func_date_add(x);
            }
            if (replaceTo != null && this.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_truncate(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLCastExpr) {
            return;
        }
        if (arg0 instanceof SQLDecimalExpr) {
            return;
        }
        if (arg0 instanceof SQLNumericLiteralExpr) {
            SQLDecimalExpr decimalExpr = new SQLDecimalExpr(arg0.toString());
            arguments.set(0, decimalExpr);
        }
    }

    private void func_date_trunc(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        SQLExpr arg1 = arguments.get(1);
    }

    private void func_week(SQLMethodInvokeExpr x) {
        SQLExpr arg0;
        SQLDataType arg0Type;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1) {
            SQLExpr arg02 = arguments.get(0);
            SQLDataType arg0Type2 = arg02.computeDataType();
            if (arg0Type2 != null && arg0Type2.isInt()) {
                SQLCastExpr charCast = new SQLCastExpr(arg02.clone(), SQLCharExpr.DATA_TYPE.clone());
                SQLCastExpr cast = new SQLCastExpr(charCast, SQLDateExpr.DATA_TYPE.clone());
                x.setArgument(0, cast);
                ++this.optimizedCount;
            }
            arguments.add(new SQLIntegerExpr(0));
        } else if (arguments.size() == 2 && (arg0Type = (arg0 = arguments.get(0)).computeDataType()) != null && arg0Type.isString()) {
            SQLCastExpr cast = new SQLCastExpr(arg0.clone(), SQLDateExpr.DATA_TYPE.clone());
            x.setArgument(0, cast);
            ++this.optimizedCount;
        }
    }

    private void func_position(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 2) {
            x.setMethodName("STRPOS");
        } else if (arguments.size() == 3) {
            SQLMethodInvokeExpr subStrFun = new SQLMethodInvokeExpr("SUBSTR", null, arguments.get(1), arguments.get(2));
            SQLMethodInvokeExpr posFun = new SQLMethodInvokeExpr("STRPOS", null, subStrFun, arguments.get(0));
            if (SQLUtils.replaceInParent(x, posFun)) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_group_concat(SQLMethodInvokeExpr x) {
        SQLExpr arg0;
        if (x.getArguments().size() > 0 && !((arg0 = x.getArguments().get(0)) instanceof SQLCastExpr) && !(arg0 instanceof SQLCharExpr)) {
            SQLCastExpr cast = new SQLCastExpr(arg0.clone(), new SQLCharacterDataType("VARCHAR"));
            x.setArgument(0, cast);
        }
        if (x.getArguments().size() > 1) {
            SQLMethodInvokeExpr concat = new SQLMethodInvokeExpr("CONCAT", null, x.getArguments());
            x.getArguments().clear();
            x.getArguments().add(concat);
            ++this.optimizedCount;
        }
    }

    private void func_convert_tz(SQLMethodInvokeExpr x) {
        SQLExpr arg0;
        if (x.getArguments().size() == 3 && !((arg0 = x.getArguments().get(0)) instanceof SQLCastExpr) && !(arg0 instanceof SQLCharExpr)) {
            SQLCastExpr cast = new SQLCastExpr(arg0.clone(), new SQLCharacterDataType("VARCHAR"));
            x.setArgument(0, cast);
        }
    }

    private void func_concat(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        int size = arguments.size();
        if (size == 1) {
            SQLExpr arg = arguments.get(0);
            if (!(arg instanceof SQLCastExpr)) {
                Object replaceTo = null;
                SQLDataType dataType = arg.computeDataType();
                if (dataType == null) {
                    arguments.set(0, new SQLCastExpr(arg, new SQLDataTypeImpl("VARCHAR")));
                } else if (dataType != null && dataType.nameHashCode64() != FnvHash.Constants.CHAR && dataType.nameHashCode64() != FnvHash.Constants.VARCHAR) {
                    arguments.set(0, new SQLCastExpr(arg, new SQLDataTypeImpl("VARCHAR")));
                }
            }
            arguments.add(new SQLCharExpr(""));
        } else {
            for (int i = 0; i < arguments.size(); ++i) {
                SQLMethodInvokeExpr func;
                SQLExpr arg = arguments.get(i);
                if (arg instanceof SQLCastExpr) {
                    SQLDataType sqlDataType;
                    SQLExpr c0 = ((SQLCastExpr)arg).getExpr();
                    if (!(c0 instanceof SQLIdentifierExpr) || (sqlDataType = c0.computeDataType()) == null || !sqlDataType.isString()) continue;
                    this.replaceInParent(arg, c0);
                    continue;
                }
                if (arg instanceof SQLMethodInvokeExpr && (func = (SQLMethodInvokeExpr)arg).methodNameHashCode64() == FnvHash.Constants.JSON_EXTRACT) {
                    func.setMethodName("JSON_EXTRACT_SCALAR");
                    continue;
                }
                SQLDataType dataType = arg.computeDataType();
                if (dataType == null) {
                    arguments.set(i, new SQLCastExpr(arg, new SQLDataTypeImpl("VARCHAR")));
                    continue;
                }
                if (dataType == null || dataType.nameHashCode64() == FnvHash.Constants.CHAR || dataType.nameHashCode64() == FnvHash.Constants.VARCHAR) continue;
                arguments.set(i, new SQLCastExpr(arg, new SQLDataTypeImpl("VARCHAR")));
            }
        }
    }

    private void func_decode(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        int size = arguments.size();
        if (size < 3) {
            return;
        }
        SQLCaseExpr caseExpr = new SQLCaseExpr();
        caseExpr.setValueExpr(arguments.get(0).clone());
        int end = size % 2 == 1 ? size : size - 1;
        for (int i = 1; i < end; i += 2) {
            caseExpr.addItem(arguments.get(i), arguments.get(i + 1));
        }
        if (end != size) {
            caseExpr.setElseExpr(arguments.get(end));
        }
        if (SQLUtils.replaceInParent(x, caseExpr)) {
            ++this.optimizedCount;
        }
    }

    private void func_monthname(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        SQLExpr arg0 = arguments.get(0);
        SQLMethodInvokeExpr replaceTo = new SQLMethodInvokeExpr("DATE_FORMAT", null, arg0, new SQLCharExpr("%M"));
        if (SQLUtils.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
        }
    }

    private void func_yearmonth(SQLMethodInvokeExpr x) {
        SQLMethodInvokeExpr replaceTo;
        List<SQLExpr> arguments = x.getArguments();
        SQLExpr arg0 = arguments.get(0);
        if (!(arg0 instanceof SQLCastExpr)) {
            arg0 = new SQLCastExpr(arg0, new SQLDataTypeImpl("TIMESTAMP"));
        }
        if (SQLUtils.replaceInParent(x, replaceTo = new SQLMethodInvokeExpr("DATE_FORMAT", null, arg0, new SQLCharExpr("%Y-%m")))) {
            ++this.optimizedCount;
        }
    }

    private void func_timestampdiff(SQLMethodInvokeExpr x) {
        String text;
        List<SQLExpr> arguments = x.getArguments();
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        SQLExpr arg2 = arguments.get(2);
        if (arg0 instanceof SQLIdentifierExpr) {
            arg0 = new SQLCharExpr(((SQLIdentifierExpr)arg0).getName());
        }
        if (arg1 instanceof SQLIdentifierExpr) {
            arg1 = new SQLCastExpr(arg1, new SQLDataTypeImpl("TIMESTAMP"));
        } else if (arg1 instanceof SQLCharExpr) {
            text = ((SQLCharExpr)arg1).getText();
            arg1 = text.length() == 8 && text.charAt(2) == ':' && text.charAt(5) == ':' ? new SQLTimeExpr(((SQLCharExpr)arg1).getText()) : new SQLTimestampExpr(((SQLCharExpr)arg1).getText());
        }
        if (arg2 instanceof SQLIdentifierExpr) {
            arg2 = new SQLCastExpr(arg2, new SQLDataTypeImpl("TIMESTAMP"));
        } else if (arg2 instanceof SQLCharExpr) {
            text = ((SQLCharExpr)arg2).getText();
            arg2 = text.length() == 8 && text.charAt(2) == ':' && text.charAt(5) == ':' ? new SQLTimeExpr(((SQLCharExpr)arg2).getText()) : new SQLTimestampExpr(((SQLCharExpr)arg2).getText());
        }
        SQLMethodInvokeExpr replaceTo = new SQLMethodInvokeExpr("DATE_DIFF", null, arg0, arg1, arg2);
        if (SQLUtils.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
        }
    }

    private void func_timestampadd(SQLMethodInvokeExpr x) {
        SQLMethodInvokeExpr replaceTo;
        List<SQLExpr> arguments = x.getArguments();
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        SQLExpr arg2 = arguments.get(2);
        if (arg0 instanceof SQLIdentifierExpr) {
            arg0 = new SQLCharExpr(((SQLIdentifierExpr)arg0).getName());
        }
        if (arg2 instanceof SQLCharExpr) {
            String text = ((SQLCharExpr)arg2).getText();
            if (text.length() == 10) {
                arg2 = new SQLDateExpr(text);
            } else if (text.length() == 19) {
                arg2 = new SQLTimestampExpr(text);
            }
        }
        if (SQLUtils.replaceInParent(x, replaceTo = new SQLMethodInvokeExpr("DATE_ADD", null, arg0, arg1, arg2))) {
            ++this.optimizedCount;
        }
    }

    private void func_month_between(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        SQLMethodInvokeExpr replaceTo = new SQLMethodInvokeExpr("DATE_DIFF", null, new SQLCharExpr("MONTH"), arg0, arg1);
        if (SQLUtils.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
        }
    }

    private void func_unix_timestamp(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLDataType sqlDataType = arg0.computeDataType();
        if (sqlDataType != null && sqlDataType.isString()) {
            arguments.set(0, new SQLCastExpr(arg0, new SQLDataTypeImpl("TIMESTAMP")));
        }
    }

    private void func_add_months(SQLMethodInvokeExpr x) {
        SQLMethodInvokeExpr replaceTo;
        List<SQLExpr> arguments = x.getArguments();
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        SQLDataType dataType = arg0.computeDataType();
        if (dataType != null && (dataType.nameHashCode64() == FnvHash.Constants.CHAR || dataType.nameHashCode64() == FnvHash.Constants.VARCHAR)) {
            arg0 = new SQLCastExpr(arg0, new SQLDataTypeImpl("DATE"));
        }
        if (SQLUtils.replaceInParent(x, replaceTo = new SQLMethodInvokeExpr("DATE_ADD", null, new SQLCharExpr("MONTH"), arg1, arg0))) {
            ++this.optimizedCount;
        }
    }

    private void func_from_unixtime(SQLMethodInvokeExpr x) {
        String format;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg1 = arguments.get(1);
        if (arg1 instanceof SQLCharExpr && (format = ((SQLCharExpr)arg1).getText()).indexOf(37) >= 0) {
            SimpleDateFormat javaFormat = (SimpleDateFormat)MySqlUtils.toJavaFormat(format);
            String pattern = javaFormat.toPattern();
            SQLCharExpr patternExpr = new SQLCharExpr(pattern);
            x.setArgument(1, patternExpr);
        }
    }

    private void func_to_unixtime(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)arg0;
            if (!binaryOpExpr.getOperator().isArithmetic()) {
                return;
            }
            SQLDataType leftDataType = binaryOpExpr.getLeft().computeDataType();
            SQLDataType rightDataType = binaryOpExpr.getRight().computeDataType();
            if (leftDataType != null && leftDataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP && rightDataType != null && rightDataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP) {
                this.replaceInParent(x, arg0.clone());
            }
        }
    }

    private void func_trim(SQLMethodInvokeExpr x) {
        if (x.getFrom() != null) {
            x.getArguments().add(0, x.getFrom());
            x.setFrom(null);
            x.setTrimOption(null);
        }
    }

    private void func_greatest(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 0) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLDataType arg0DataType = arg0.computeDataType();
        if (arg0DataType != null) {
            boolean isDateType = false;
            SQLDataTypeImpl castType = null;
            if (arg0DataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP) {
                isDateType = true;
                castType = new SQLDataTypeImpl("TIMESTAMP");
            } else if (arg0DataType.nameHashCode64() == FnvHash.Constants.DATE) {
                isDateType = true;
                castType = new SQLDataTypeImpl("DATE");
            }
            if (isDateType) {
                for (int i = 1; i < arguments.size(); ++i) {
                    SQLCastExpr sqlCastExpr = new SQLCastExpr(arguments.get(i), castType);
                    arguments.set(i, sqlCastExpr);
                }
            }
        }
    }

    private void func_least(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 0) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLDataType arg0DataType = arg0.computeDataType();
        if (arg0DataType != null) {
            boolean isDateType = false;
            SQLDataTypeImpl castType = null;
            if (arg0DataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP) {
                isDateType = true;
                castType = new SQLDataTypeImpl("TIMESTAMP");
            } else if (arg0DataType.nameHashCode64() == FnvHash.Constants.DATE) {
                isDateType = true;
                castType = new SQLDataTypeImpl("DATE");
            }
            if (isDateType) {
                for (int i = 1; i < arguments.size(); ++i) {
                    SQLCastExpr sqlCastExpr = new SQLCastExpr(arguments.get(i), castType);
                    arguments.set(i, sqlCastExpr);
                }
            }
        }
    }

    private void func_locate(SQLMethodInvokeExpr x) {
        SQLExprImpl delta;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2 && arguments.size() != 3) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        if (arguments.size() == 2) {
            SQLMethodInvokeExpr strpos = new SQLMethodInvokeExpr("STRPOS", null, arg1.clone(), arg0.clone());
            if (SQLUtils.replaceInParent(x, strpos)) {
                ++this.optimizedCount;
            }
            return;
        }
        SQLExpr arg2 = arguments.get(2);
        SQLMethodInvokeExpr substr = new SQLMethodInvokeExpr("SUBSTR", null, arg1.clone(), arg2.clone());
        SQLMethodInvokeExpr strpos = new SQLMethodInvokeExpr("STRPOS", null, substr, arg0.clone());
        SQLBinaryOperator op = SQLBinaryOperator.Add;
        if (arg2 instanceof SQLIntegerExpr) {
            int deltaVal = ((SQLIntegerExpr)arg2).getNumber().intValue() - 1;
            if (deltaVal < 0) {
                deltaVal = -deltaVal;
                op = SQLBinaryOperator.Subtract;
            }
            delta = new SQLIntegerExpr(deltaVal);
        } else {
            delta = new SQLBinaryOpExpr(arg2.clone(), SQLBinaryOperator.Subtract, new SQLIntegerExpr(1));
        }
        SQLBinaryOpExpr gt = new SQLBinaryOpExpr(strpos, SQLBinaryOperator.GreaterThan, new SQLIntegerExpr(0), this.dbType);
        SQLMethodInvokeExpr replaceTo = new SQLMethodInvokeExpr("IF", null, gt, new SQLBinaryOpExpr(strpos, op, delta, this.dbType), new SQLIntegerExpr(0));
        if (SQLUtils.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
        }
    }

    private void func_json_extract(SQLMethodInvokeExpr x) {
    }

    private void func_json_extract_scalar(SQLMethodInvokeExpr x) {
        SQLMethodInvokeExpr json_extract;
        String path;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        if (arg1 instanceof SQLCharExpr && (path = ((SQLCharExpr)arg1).getText()).startsWith("$.") && arg0 instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)arg0).methodNameHashCode64() == FnvHash.Constants.JSON_EXTRACT && (json_extract = (SQLMethodInvokeExpr)arg0).getArguments().size() == 2 && json_extract.getArguments().get(1) instanceof SQLCharExpr) {
            String path2 = ((SQLCharExpr)json_extract.getArguments().get(1)).getText();
            SQLExpr r_arg0 = json_extract.getArguments().get(0).clone();
            String r_path = path2 + path.substring(1);
            SQLCharExpr r_arg1 = new SQLCharExpr(r_path);
            x.setArgument(0, r_arg0);
            x.setArgument(1, r_arg1);
        }
    }

    private void func_addtime(SQLMethodInvokeExpr x) {
        List<SQLExpr> args = x.getArguments();
        SQLExpr arg0 = args.get(0);
        if (arg0 instanceof SQLName) {
            x.setArgument(0, new SQLCastExpr(arg0.clone(), new SQLCharacterDataType("VARCHAR")));
        }
    }

    private void func_nvl2(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 3) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        SQLExpr arg2 = arguments.get(2);
        SQLMethodInvokeExpr ifExpr = new SQLMethodInvokeExpr("IF", null, SQLBinaryOpExpr.isNull(arg0.clone()), arg2.clone(), arg1.clone());
        if (SQLUtils.replaceInParent(x, ifExpr)) {
            ++this.optimizedCount;
        }
    }

    private void func_nullif(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 2) {
            SQLExpr arg0 = arguments.get(0);
            SQLExpr arg1 = arguments.get(1);
            if (arg0 instanceof SQLName && arg1 instanceof SQLLiteralExpr) {
                this.handleNameLiteral(x, arg0, (SQLLiteralExpr)arg1);
            } else if (arg1 instanceof SQLName && arg0 instanceof SQLLiteralExpr) {
                this.handleNameLiteral(x, arg1, (SQLLiteralExpr)arg0);
            }
            return;
        }
    }

    private void func_isnull(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1) {
            SQLBinaryOpExpr isNullExpr = SQLBinaryOpExpr.isNull(arguments.get(0).clone());
            this.replaceInParent(x, isNullExpr);
            isNullExpr.accept(this);
            ++this.optimizedCount;
            return;
        }
        if (arguments.size() == 2) {
            x.setMethodName("COALESCE");
            this.func_ifnullCast(x);
            ++this.optimizedCount;
            return;
        }
        x.setMethodName("COALESCE");
        ++this.optimizedCount;
    }

    private void func_ifnull(SQLMethodInvokeExpr x) {
        x.setMethodName("COALESCE");
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        this.func_ifnullCast(x);
        ++this.optimizedCount;
    }

    private void func_ifnullCast(SQLMethodInvokeExpr x) {
        List<SQLExpr> args = x.getArguments();
        if (args.size() == 2) {
            SQLExpr arg0 = args.get(0);
            SQLExpr arg1 = args.get(1);
            if (arg0 instanceof SQLValuableExpr && arg1 instanceof SQLValuableExpr) {
                Object val = IfNull.instance.eval(x);
                if (val instanceof Integer) {
                    if (this.replaceInParent(x, new SQLIntegerExpr((Integer)val))) {
                        ++this.optimizedCount;
                    }
                    return;
                }
                if (val instanceof String) {
                    if (this.replaceInParent(x, new SQLCharExpr((String)val))) {
                        ++this.optimizedCount;
                    }
                    return;
                }
            } else {
                SQLDataType arg0DateType = arg0.computeDataType();
                SQLDataType arg1DateType = arg1.computeDataType();
                if (arg0 instanceof SQLName && arg0DateType != null && (arg0DateType.isInt() || arg0DateType.isNumberic()) && arg1 instanceof SQLLiteralExpr && arg1DateType != null && (arg1DateType.isInt() || arg1DateType.isNumberic())) {
                    return;
                }
                if (arg0DateType == null && arg1DateType != null) {
                    if (arg1DateType.nameHashCode64() == FnvHash.Constants.NUMBER || arg1DateType.nameHashCode64() == FnvHash.Constants.NUMERIC) {
                        SQLCastExpr castExpr = new SQLCastExpr(arg0, new SQLDataTypeImpl("DOUBLE"));
                        castExpr.setTry(true);
                        args.set(0, castExpr);
                    } else {
                        SQLCastExpr castExpr = new SQLCastExpr(arg0, new SQLDataTypeImpl(arg1DateType.getName()));
                        castExpr.setTry(true);
                        args.set(0, castExpr);
                    }
                    return;
                }
                if (arg1DateType != null) {
                    long arg0Hash = arg0DateType.nameHashCode64();
                    long arg1Hash = arg1DateType.nameHashCode64();
                    if (!(arg0Hash != FnvHash.Constants.VARCHAR && arg0Hash != FnvHash.Constants.CHAR || arg1Hash != FnvHash.Constants.VARCHAR && arg1Hash != FnvHash.Constants.CHAR)) {
                        return;
                    }
                    if (!(arg0Hash != FnvHash.Constants.INT && arg0Hash != FnvHash.Constants.BIGINT && arg0Hash != FnvHash.Constants.INTEGER || arg1Hash != FnvHash.Constants.INT && arg1Hash != FnvHash.Constants.BIGINT && arg1Hash != FnvHash.Constants.INTEGER)) {
                        return;
                    }
                    if (arg0 instanceof SQLAggregateExpr && (arg1DateType.isInt() || arg1Hash == FnvHash.Constants.DOUBLE || arg1Hash == FnvHash.Constants.FLOAT || arg1Hash == FnvHash.Constants.DECIMAL)) {
                        return;
                    }
                    if (x.getParent() instanceof SQLMethodInvokeExpr && x.getParent() instanceof SQLAggregateExpr && arg1 instanceof SQLNumericLiteralExpr && !arg0DateType.isInt() && arg0Hash != FnvHash.Constants.DOUBLE && arg0Hash != FnvHash.Constants.FLOAT && arg0Hash != FnvHash.Constants.DECIMAL) {
                        SQLCastExpr castExpr = new SQLCastExpr(arg0, new SQLDataTypeImpl("BIGINT"));
                        castExpr.setTry(true);
                        args.set(0, castExpr);
                        return;
                    }
                    if (arg1Hash == FnvHash.Constants.VARCHAR || arg1Hash == FnvHash.Constants.CHAR || arg1Hash == FnvHash.Constants.TEXT || arg1Hash == FnvHash.Constants.CLOB) {
                        SQLCastExpr castExpr = new SQLCastExpr(arg0, new SQLDataTypeImpl("VARCHAR"));
                        castExpr.setTry(true);
                        args.set(0, castExpr);
                    } else if (arg1DateType.isInt() && (arg0Hash == FnvHash.Constants.VARCHAR || arg0Hash == FnvHash.Constants.CHAR || arg0Hash == FnvHash.Constants.STRING)) {
                        SQLCastExpr castExpr = new SQLCastExpr(arg1, new SQLDataTypeImpl("VARCHAR"));
                        args.set(1, castExpr);
                    } else if (arg1DateType.isInt() && (arg0Hash == FnvHash.Constants.NUMBER || arg0Hash == FnvHash.Constants.FLOAT || arg0Hash == FnvHash.Constants.DOUBLE || arg0Hash == FnvHash.Constants.DECIMAL)) {
                        SQLCastExpr castExpr = new SQLCastExpr(arg1, new SQLDataTypeImpl("DOUBLE"));
                        args.set(1, castExpr);
                    } else {
                        SQLCastExpr castExpr = arg1DateType.isInt() ? new SQLCastExpr(arg0, new SQLDataTypeImpl("BIGINT")) : (arg1Hash == FnvHash.Constants.NUMBER || arg1Hash == FnvHash.Constants.FLOAT || arg1Hash == FnvHash.Constants.DOUBLE || arg1Hash == FnvHash.Constants.DECIMAL ? new SQLCastExpr(arg0, new SQLDataTypeImpl("DOUBLE")) : (arg1Hash == FnvHash.Constants.CHAR ? new SQLCastExpr(arg0, new SQLDataTypeImpl("VARCHAR")) : new SQLCastExpr(arg0, new SQLDataTypeImpl(arg1DateType.getName()))));
                        castExpr.setTry(true);
                        args.set(0, castExpr);
                    }
                }
            }
        }
    }

    private void func_to_char(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        x.setMethodName("DATE_FORMAT");
        SQLDataType type0 = arg0.computeDataType();
        if (type0 == null) {
            return;
        }
        long hash = type0.nameHashCode64();
        if (hash == FnvHash.Constants.CHAR || hash == FnvHash.Constants.VARCHAR) {
            SQLExprImpl replaceTo = null;
            if (arg0 instanceof SQLCharExpr) {
                String text = ((SQLCharExpr)arg0).getText();
                replaceTo = new SQLTimestampExpr(text);
            } else {
                replaceTo = new SQLCastExpr(arg0.clone(), new SQLDataTypeImpl("TIMESTAMP"));
            }
            if (replaceTo != null) {
                arguments.set(0, replaceTo);
            }
        }
    }

    private void func_to_timestamp(SQLMethodInvokeExpr x) {
        x.setMethodName("DATE_PARSE");
        ++this.optimizedCount;
    }

    private void func_timestamp(SQLMethodInvokeExpr x) {
        SQLCharExpr charExpr;
        String fmt;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg1 = arguments.get(1);
        if (arg1 instanceof SQLCharExpr && "yyyy-MM-dd HH:mm:ss".equals(fmt = (charExpr = (SQLCharExpr)arg1).getText())) {
            charExpr.setText("%Y-%m-%d %k:%i:%s");
        }
        ++this.optimizedCount;
    }

    private void func_weekofyear(SQLMethodInvokeExpr x) {
        x.setMethodName("WEEK");
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1) {
            arguments.add(1, new SQLIntegerExpr(3));
            ++this.optimizedCount;
        }
    }

    private void func_dayofmonth(SQLMethodInvokeExpr x) {
        x.setMethodName("DAY_OF_MONTH");
        ++this.optimizedCount;
    }

    private void func_dayofyear(SQLMethodInvokeExpr x) {
        x.setMethodName("DAY_OF_YEAR");
        SQLExpr arg0 = x.getArguments().get(0);
        if (arg0 instanceof SQLIdentifierExpr) {
            x.getArguments().set(0, new SQLCastExpr(arg0, new SQLDataTypeImpl("TIMESTAMP")));
        } else if (arg0 instanceof SQLCharExpr) {
            x.getArguments().set(0, new SQLTimestampExpr(((SQLCharExpr)arg0).getText()));
        }
        ++this.optimizedCount;
    }

    private void func_udf_sys_rowcount(SQLMethodInvokeExpr x) {
        SQLAggregateExpr count = new SQLAggregateExpr("COUNT");
        for (SQLExpr arg : x.getArguments()) {
            count.addArgument(arg.clone());
        }
        if (SQLUtils.replaceInParent(x, count)) {
            ++this.optimizedCount;
        }
    }

    private void func_trunc(SQLMethodInvokeExpr x) {
        long typeHash;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1 && arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLDataType type0 = arg0.computeDataType();
        if (type0 == null) {
            return;
        }
        if (arguments.size() == 1 && ((typeHash = type0.nameHashCode64()) == FnvHash.Constants.TINYINT || typeHash == FnvHash.Constants.SMALLINT || typeHash == FnvHash.Constants.INT || typeHash == FnvHash.Constants.INTEGER || typeHash == FnvHash.Constants.BIGINT || typeHash == FnvHash.Constants.FLOAT || typeHash == FnvHash.Constants.DOUBLE || typeHash == FnvHash.Constants.NUMBER || typeHash == FnvHash.Constants.DECIMAL)) {
            x.setMethodName("TRUNCATE");
        }
    }

    private void func_date_sub(SQLMethodInvokeExpr x) {
        String unit;
        SQLExpr intervalValue;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        SQLDataType type0 = arg0.computeDataType();
        SQLDataType type1 = arg1.computeDataType();
        if (arg1 instanceof SQLIntervalExpr) {
            SQLIntervalExpr interval = (SQLIntervalExpr)arg1;
            intervalValue = interval.getValue();
            unit = interval.getUnit().name();
        } else {
            intervalValue = arg1;
            unit = "Day";
        }
        SQLMethodInvokeExpr dateAdd = new SQLMethodInvokeExpr("DATE_ADD");
        dateAdd.addArgument(new SQLCharExpr(unit));
        dateAdd.addArgument(new SQLUnaryExpr(SQLUnaryOperator.Negative, intervalValue.clone()));
        dateAdd.addArgument(arg0.clone());
        if (SQLUtils.replaceInParent(x, dateAdd)) {
            dateAdd.accept(this);
            ++this.optimizedCount;
        }
    }

    private void func_date_add(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 2) {
            long unitHash;
            String unit;
            SQLExpr intervalValue;
            SQLExpr arg0 = arguments.get(0);
            SQLExpr arg1 = arguments.get(1);
            if (arg1 instanceof SQLIntervalExpr) {
                SQLIntervalExpr interval = (SQLIntervalExpr)arg1;
                intervalValue = interval.getValue();
                unit = interval.getUnit().name();
            } else {
                intervalValue = arg1;
                unit = "Day";
            }
            SQLMethodInvokeExpr dateAdd = new SQLMethodInvokeExpr("DATE_ADD");
            dateAdd.addArgument(new SQLCharExpr(unit));
            dateAdd.addArgument(intervalValue.clone());
            SQLExpr arg2 = arg0.clone();
            SQLDataType arg2DataType = arg2.computeDataType();
            if (arg2DataType != null && arg2DataType.nameHashCode64() == FnvHash.Constants.DATE && ((unitHash = FnvHash.hashCode64(unit)) == FnvHash.Constants.SECOND || unitHash == FnvHash.Constants.MINUTE || unitHash == FnvHash.Constants.HOUR)) {
                arg2 = new SQLCastExpr(arg2, new SQLDataTypeImpl("TIMESTAMP"));
            }
            dateAdd.addArgument(arg2);
            if (SQLUtils.replaceInParent(x, dateAdd)) {
                ++this.optimizedCount;
                dateAdd.accept(this);
                return;
            }
        } else if (arguments.size() == 3) {
            long unitHash;
            long arg2Hash;
            SQLExpr arg0 = arguments.get(0);
            SQLExpr arg2 = arguments.get(2);
            SQLDataType type2 = arg2.computeDataType();
            long l = arg2Hash = type2 != null ? type2.nameHashCode64() : 0L;
            if (arg2Hash == FnvHash.Constants.TIMESTAMP || arg2Hash == FnvHash.Constants.DATETIME) {
                return;
            }
            if (arg2Hash == FnvHash.Constants.DATE && ((unitHash = FnvHash.hashCode64(arg0.toString())) == FnvHash.Constants.SECOND || unitHash == FnvHash.Constants.MINUTE || unitHash == FnvHash.Constants.HOUR)) {
                arg2 = new SQLCastExpr(arg2, new SQLDataTypeImpl("TIMESTAMP"));
                arg2.setParent(x);
                arguments.set(2, arg2);
                return;
            }
            if (arg2 instanceof SQLTextLiteralExpr) {
                int length = ((SQLTextLiteralExpr)arg2).getText().length();
                if (length == 10) {
                    arguments.set(2, new SQLCastExpr(arg2, new SQLDataTypeImpl("DATE")));
                } else if (length >= 19) {
                    arguments.set(2, new SQLCastExpr(arg2, new SQLDataTypeImpl("TIMESTAMP")));
                }
            } else if (arg2Hash == FnvHash.Constants.CHAR || arg2Hash == FnvHash.Constants.VARCHAR) {
                arguments.set(2, new SQLCastExpr(arg2, new SQLDataTypeImpl("TIMESTAMP")));
            }
        }
    }

    private void func_datediff(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2 && arguments.size() != 3) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        SQLExpr arg2 = arguments.size() == 3 ? arguments.get(2) : null;
        SQLDataType type0 = arg0.computeDataType();
        SQLDataType type1 = arg1.computeDataType();
        if (type0 == null || type1 == null) {
            return;
        }
        if (arguments.size() == 2) {
            if (arg0 instanceof SQLCharExpr) {
                arguments.set(1, new SQLDateExpr(((SQLCharExpr)arg0).getText()));
            } else if (arg0 instanceof SQLIntegerExpr) {
                arguments.set(1, new SQLDateExpr(arg0.toString()));
            } else {
                arguments.set(1, new SQLCastExpr(arg0, new SQLCharacterDataType("DATE")));
            }
            if (arg1 instanceof SQLCharExpr) {
                arguments.set(0, new SQLDateExpr(((SQLCharExpr)arg1).getText()));
            } else if (arg1 instanceof SQLIntegerExpr) {
                arguments.set(0, new SQLDateExpr(arg1.toString()));
            } else {
                arguments.set(0, new SQLCastExpr(arg1, new SQLCharacterDataType("DATE")));
            }
            arguments.add(0, new SQLCharExpr("DAY"));
            for (SQLExpr arg : arguments) {
                arg.setParent(x);
            }
            x.setMethodName("DATE_DIFF");
        }
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        SQLExpr expr;
        String alias = x.getAlias();
        String alias2 = this.quoteAlias(alias);
        if (alias2 != alias) {
            x.setAlias(alias2);
        }
        if ((expr = x.getExpr()) instanceof SQLIdentifierExpr) {
            this.visit((SQLIdentifierExpr)expr);
        } else if (expr instanceof SQLPropertyExpr) {
            this.visit((SQLPropertyExpr)expr);
        } else {
            expr.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLBlockStatement x) {
        List<SQLStatement> stmtList = x.getStatementList();
        if (stmtList.size() == 2 && stmtList.get(1) instanceof SQLCommitStatement) {
            stmtList.remove(1);
        }
        return true;
    }

    @Override
    public boolean visit(SQLForStatement x) {
        SQLExpr range = x.getRange();
        if (!(range instanceof SQLQueryExpr)) {
            return true;
        }
        SQLSelect rangeSelect = ((SQLQueryExpr)range).getSubQuery();
        SQLSelectQueryBlock rangeQuery = rangeSelect.getQueryBlock();
        if (rangeQuery == null) {
            return true;
        }
        if (!(rangeQuery.getFrom() instanceof SQLExprTableSource)) {
            return true;
        }
        if (rangeQuery.getWhere() != null) {
            return true;
        }
        SQLExprTableSource rangeQueryFrom = (SQLExprTableSource)rangeQuery.getFrom();
        List<SQLStatement> stmtList = x.getStatements();
        if (stmtList.size() != 1 || !(stmtList.get(0) instanceof SQLUpdateStatement)) {
            return true;
        }
        if (!(x.getParent() instanceof SQLBlockStatement)) {
            return true;
        }
        SQLBlockStatement parent = (SQLBlockStatement)x.getParent();
        int index = parent.getStatementList().indexOf(x);
        if (index == -1) {
            return true;
        }
        SQLUpdateStatement update = (SQLUpdateStatement)stmtList.get(0);
        SQLExprTableSource joinRight = rangeQueryFrom.clone();
        joinRight.setAlias(x.getIndex().toString());
        SQLJoinTableSource join = new SQLJoinTableSource(update.getTableSource(), SQLJoinTableSource.JoinType.COMMA, joinRight, null);
        update.setTableSource(join);
        update.accept(this);
        parent.getStatementList().set(index, update);
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        SQLExpr expr;
        String alias = x.getAlias();
        String alias2 = this.quoteAlias(alias);
        if (alias2 != alias) {
            x.setAlias(alias2);
        }
        if ((expr = x.getExpr()) instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)expr).methodNameHashCode64() == FnvHash.Constants.ANN) {
            this.ann(x, (SQLMethodInvokeExpr)expr);
        }
        return super.visit(x);
    }

    private void ann(final SQLExprTableSource x, SQLMethodInvokeExpr ann) {
        SQLTableSourceImpl tableSource;
        String paramText;
        SQLIdentifierExpr identColumn;
        SQLColumnDefinition resolvedColumn;
        SQLObject parent = x.getParent();
        SQLSelectStatement stmt = null;
        SQLSelectQueryBlock parentQuery = null;
        boolean hasAnnDistance = false;
        for (SQLObject p = parent; p != null; p = p.getParent()) {
            if (p instanceof SQLSelectQueryBlock && parentQuery == null) {
                parentQuery = (SQLSelectQueryBlock)p;
                continue;
            }
            if (!(p instanceof SQLSelectStatement)) continue;
            stmt = (SQLSelectStatement)p;
            break;
        }
        if (stmt != null) {
            ANNCheckDistanceVisitor v = new ANNCheckDistanceVisitor(x);
            stmt.accept(v);
            hasAnnDistance = v.hasAnnDistance;
        }
        List<SQLExpr> arguments = ann.getArguments();
        SQLExpr query = arguments.get(0);
        SQLExpr column = arguments.get(1);
        SQLExpr input = arguments.get(2);
        SQLExpr topN = arguments.get(3);
        SQLExpr param = null;
        if (arguments.size() > 4) {
            param = arguments.get(4);
        }
        SQLOrderingSpecification orderBySpec = SQLOrderingSpecification.ASC;
        SQLAnnIndex.Distance distance = null;
        if (column instanceof SQLIdentifierExpr && (resolvedColumn = (identColumn = (SQLIdentifierExpr)column).getResolvedColumn()) != null && resolvedColumn.getAnnIndex() != null) {
            distance = resolvedColumn.getAnnIndex().getDistance();
        }
        if (param instanceof SQLCharExpr && (paramText = ((SQLCharExpr)param).getText()).toLowerCase().indexOf("distance_measure=dotproduct") != -1) {
            distance = SQLAnnIndex.Distance.DotProduct;
        }
        if (distance == SQLAnnIndex.Distance.DotProduct) {
            orderBySpec = SQLOrderingSpecification.DESC;
        }
        SQLMethodInvokeExpr ann2 = arguments.size() == 4 ? new SQLMethodInvokeExpr("ANN", null, column, input, topN) : new SQLMethodInvokeExpr("ANN", null, column, input, topN, arguments.get(4));
        SQLBinaryOpExpr where = new SQLBinaryOpExpr((SQLExpr)ann2, SQLBinaryOperator.GreaterThanOrEqual, new SQLRealExpr(0.0f));
        SQLName table = null;
        String ann_distance = "ann_distance";
        if (query instanceof SQLName) {
            table = (SQLName)query;
            tableSource = new SQLExprTableSource(query.clone());
        } else {
            SQLQueryExpr queryExpr = (SQLQueryExpr)query;
            tableSource = new SQLSubqueryTableSource(queryExpr.getSubQuery().clone());
        }
        SchemaRepository repository = this.repository;
        if (repository == null) {
            repository = new SchemaRepository(this.dbType);
        }
        MySqlSchemaStatVisitor statVisitor = new MySqlSchemaStatVisitor(repository){

            @Override
            public boolean visit(SQLExprTableSource x1) {
                if (x == x1) {
                    return false;
                }
                return super.visit(x1);
            }
        };
        if (parentQuery != null) {
            if (this.repository == null) {
                repository.resolve(parentQuery, new SchemaResolveVisitor.Option[0]);
            }
            statVisitor.visit(parentQuery);
            if (parentQuery.getWhere() == null && !parentQuery.hasSelectAggregation()) {
                parentQuery.setWhere(where);
                parentQuery.setFrom(tableSource);
                parentQuery.setLimit(new SQLLimit(topN));
                Integer selectIndex = null;
                for (int i = 0; i < parentQuery.getSelectList().size(); ++i) {
                    SQLSelectItem selectItem = parentQuery.getSelectList().get(i);
                    SQLExpr selectItemExpr = selectItem.getExpr();
                    if (!(selectItemExpr instanceof SQLName) || !((SQLName)selectItemExpr).getSimpleName().equalsIgnoreCase(ann_distance)) continue;
                    selectItem.setExpr(ann2.clone());
                    if (selectItem.getAlias() == null) {
                        selectItem.setAlias(ann_distance);
                    }
                    selectIndex = i + 1;
                }
                parentQuery.addOrderBy(selectIndex != null ? new SQLIntegerExpr(selectIndex) : ann2.clone(), orderBySpec);
                return;
            }
        }
        SQLSubqueryTableSource replaceTo = null;
        MySqlSelectQueryBlock queryBlock = new MySqlSelectQueryBlock();
        if (table != null && statVisitor.getColumns().size() > 0) {
            for (TableStat.Column statColumn : statVisitor.getColumns()) {
                if (FnvHash.hashCode64(statColumn.getTable()) != table.hashCode64()) continue;
                if (statColumn.getName().equalsIgnoreCase(ann_distance)) {
                    queryBlock.addSelectItem(ann2.clone(), ann_distance);
                    continue;
                }
                queryBlock.addSelectItem(new SQLIdentifierExpr(statColumn.getName()));
            }
        } else {
            queryBlock.addSelectItem(new SQLAllColumnExpr());
        }
        queryBlock.setFrom(tableSource);
        queryBlock.addWhere(where);
        queryBlock.setLimit(new SQLLimit(topN));
        if (hasAnnDistance && queryBlock.findSelectItem("ann_distance") == null) {
            queryBlock.addSelectItem(ann2, "ann_distance");
        }
        queryBlock.addOrderBy(ann2.clone(), orderBySpec);
        replaceTo = new SQLSubqueryTableSource(new SQLSelect(queryBlock), x.getAlias());
        if (SQLUtils.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
        }
    }

    @Override
    public boolean visit(SQLUnionQueryTableSource x) {
        String alias = x.getAlias();
        String alias2 = this.quoteAlias(alias);
        if (alias2 != alias) {
            x.setAlias(alias2);
        }
        return true;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        String alias = x.getAlias();
        String alias2 = this.quoteAlias(alias);
        if (alias2 != alias) {
            x.setAlias(alias2);
        }
        this.visit(x.getSelect());
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        String methodName = x.getMethodName();
        x.setMethodName(SQLUtils.normalize(methodName));
        long hash = x.methodNameHashCode64();
        if (hash == FnvHash.Constants.COUNT && x.getOption() == SQLAggregateOption.DISTINCT && arguments.size() > 1 && x.getOver() == null) {
            SQLListExpr listExpr = new SQLListExpr();
            for (SQLExpr arg : arguments) {
                listExpr.addItem(arg.clone());
            }
            arguments.clear();
            arguments.add(listExpr);
            ++this.optimizedCount;
        } else if (hash == FnvHash.Constants.GROUP_CONCAT) {
            this.func_group_concat(x);
        }
        return true;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        SQLJoinTableSource.JoinType joinType = x.getJoinType();
        if (joinType == SQLJoinTableSource.JoinType.COMMA && x.getLeft() instanceof SQLExprTableSource && x.getRight() instanceof SQLExprTableSource) {
            x.putAttribute("ads.comma_join", true);
        }
        return true;
    }

    private void visitUnion(SQLUnionQuery x) {
        SQLLimit limit;
        SQLUnionOperator operator = x.getOperator();
        SQLSelectQuery left = x.getLeft();
        SQLSelectQuery right = x.getRight();
        SQLOrderBy orderBy = x.getOrderBy();
        if (left instanceof SQLUnionQuery && ((SQLUnionQuery)left).getOperator() == operator && !right.isBracket() && orderBy == null) {
            SQLSelectQuery leftRight;
            SQLSelectQuery leftLeft;
            SQLUnionQuery leftUnion = (SQLUnionQuery)left;
            if (right instanceof SQLSelectQueryBlock) {
                if (x.getOperator() == SQLUnionOperator.UNION_ALL) {
                    right.setBracket(true);
                } else {
                    SQLSelectQueryBlock rightQueryBlock = (SQLSelectQueryBlock)right;
                    if (rightQueryBlock.getOrderBy() != null || rightQueryBlock.getLimit() != null) {
                        rightQueryBlock.setBracket(true);
                    }
                }
            }
            ArrayList<SQLSelectQuery> rights = new ArrayList<SQLSelectQuery>();
            rights.add(right);
            while (true) {
                leftLeft = leftUnion.getLeft();
                leftRight = leftUnion.getRight();
                if (leftRight instanceof SQLSelectQueryBlock) {
                    if (x.getOperator() == SQLUnionOperator.UNION_ALL) {
                        leftRight.setBracket(true);
                    } else {
                        SQLSelectQueryBlock leftRightQueryBlock = (SQLSelectQueryBlock)leftRight;
                        if (leftRightQueryBlock.getOrderBy() != null || leftRightQueryBlock.getLimit() != null) {
                            leftRightQueryBlock.setBracket(true);
                        }
                    }
                }
                if (leftUnion.isBracket() || leftUnion.getOrderBy() != null || leftLeft.isBracket() || leftRight.isBracket() || !(leftLeft instanceof SQLUnionQuery) || ((SQLUnionQuery)leftLeft).getOperator() != operator) break;
                rights.add(leftRight);
                leftUnion = (SQLUnionQuery)leftLeft;
            }
            rights.add(leftRight);
            rights.add(leftLeft);
            for (int i = rights.size() - 1; i >= 0; --i) {
                SQLSelectQuery item = (SQLSelectQuery)rights.get(i);
                item.accept(this);
            }
            return;
        }
        if (left != null) {
            if (left.getClass() == SQLUnionQuery.class) {
                SQLUnionQuery leftUnion = (SQLUnionQuery)left;
                SQLSelectQuery leftLeft = leftUnion.getLeft();
                SQLSelectQuery leftRigt = leftUnion.getRight();
                if (!leftUnion.isBracket() && leftUnion.getRight() instanceof SQLSelectQueryBlock && leftUnion.getLeft() != null && leftUnion.getOrderBy() == null) {
                    if (leftLeft.getClass() == SQLUnionQuery.class) {
                        this.visit((SQLUnionQuery)leftLeft);
                    } else {
                        leftLeft.accept(this);
                    }
                    leftRigt.accept(this);
                } else {
                    this.visit(leftUnion);
                }
            } else {
                left.accept(this);
            }
        }
        if (right == null) {
            return;
        }
        right.accept(this);
        if (orderBy != null) {
            orderBy.accept(this);
        }
        if ((limit = x.getLimit()) != null) {
            limit.accept(this);
        }
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        if (x.getRelations().size() > 2) {
            for (SQLSelectQuery relation : x.getRelations()) {
                relation.accept(this);
            }
            return false;
        }
        if (x.getLimit() == null && x.getOrderBy() == null && x.getLeft() instanceof SQLUnionQuery && ((SQLUnionQuery)x.getLeft()).getLeft() instanceof SQLUnionQuery) {
            this.visitUnion(x);
            return false;
        }
        SQLSelectQuery left = x.getLeft();
        if (left instanceof SQLSelectQueryBlock) {
            if (x.getOperator() == SQLUnionOperator.UNION_ALL) {
                left.setBracket(true);
            } else {
                SQLSelectQueryBlock leftQueryBlock = (SQLSelectQueryBlock)left;
                if (leftQueryBlock.getLimit() != null || leftQueryBlock.getOrderBy() != null) {
                    left.setBracket(true);
                }
            }
        }
        if (left instanceof SQLUnionQuery) {
            this.visit((SQLUnionQuery)left);
        } else {
            left.accept(this);
        }
        SQLSelectQuery right = x.getRight();
        if (right instanceof SQLSelectQueryBlock) {
            if (x.getOperator() == SQLUnionOperator.UNION_ALL) {
                right.setBracket(true);
            } else {
                SQLSelectQueryBlock rightQueryBlock = (SQLSelectQueryBlock)right;
                if (rightQueryBlock.getLimit() != null || rightQueryBlock.getOrderBy() != null) {
                    right.setBracket(true);
                }
            }
        }
        if (right instanceof SQLUnionQuery) {
            this.visit((SQLUnionQuery)right);
        } else {
            right.accept(this);
        }
        if (x.getOperator() == SQLUnionOperator.MINUS) {
            x.setOperator(SQLUnionOperator.EXCEPT);
        }
        boolean hasLimitOrderBy = x.getLimit() != null || x.getOrderBy() != null;
        SQLObject parent = x.getParent();
        if (parent instanceof SQLUnionQuery && hasLimitOrderBy) {
            x.setBracket(true);
        }
        return true;
    }

    @Override
    public boolean visit(SQLExtractExpr x) {
        SQLIntervalUnit unit = x.getUnit();
        SQLExpr value = x.getValue();
        switch (unit) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case QUARTER: {
                SQLUtils.replaceInParent(x, new SQLMethodInvokeExpr(unit.name(), null, value));
                break;
            }
            case WEEK: {
                SQLMethodInvokeExpr weekFun = new SQLMethodInvokeExpr("WEEK");
                weekFun.addArgument(new SQLCastExpr(value, new SQLDataTypeImpl("TIMESTAMP")));
                SQLUtils.replaceInParent(x, weekFun);
                break;
            }
            case DAY_OF_MONTH: {
                SQLUtils.replaceInParent(x, new SQLMethodInvokeExpr("DAY", null, value));
                break;
            }
            case DAY_OF_WEEK: 
            case DOW: {
                SQLUtils.replaceInParent(x, new SQLMethodInvokeExpr("DAY_OF_WEEK", null, value));
                break;
            }
            case DAY_OF_YEAR: 
            case DOY: {
                SQLMethodInvokeExpr invokeExpr = new SQLMethodInvokeExpr(null, null, value);
                this.func_dayofyear(invokeExpr);
                SQLUtils.replaceInParent(x, invokeExpr);
                break;
            }
            case YEAR_OF_WEEK: 
            case YOW: {
                if (value instanceof SQLCharExpr) {
                    SQLTimestampExpr replaceTo = new SQLTimestampExpr(((SQLCharExpr)value).getText());
                    SQLUtils.replaceInParent(x, new SQLMethodInvokeExpr("YEAR_OF_WEEK", null, replaceTo));
                    break;
                }
                if (!(value instanceof SQLIdentifierExpr)) break;
                SQLCastExpr replaceTo = new SQLCastExpr(value, new SQLDataTypeImpl("TIMESTAMP"));
                SQLUtils.replaceInParent(x, new SQLMethodInvokeExpr("YEAR_OF_WEEK", null, replaceTo));
                break;
            }
            case TIMEZONE_HOUR: 
            case TIMEZONE_MINUTE: {
                SQLUtils.replaceInParent(x, new SQLMethodInvokeExpr(unit.name(), null, new SQLCastExpr(value, new SQLDataTypeImpl("TIMESTAMP"))));
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLLimit x) {
        SQLExpr rowCount;
        SQLExpr offset = x.getOffset();
        if (offset != null) {
            if (offset.equals(new SQLIntegerExpr(0))) {
                x.setOffset(null);
            } else {
                offset.accept(this);
            }
        }
        if ((rowCount = x.getRowCount()) != null) {
            rowCount.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectOrderByItem x) {
        SQLObject parent = x.getParent();
        if (parent != null && parent.getParent() instanceof SQLSelectQueryBlock) {
            SQLExpr expr = x.getExpr();
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)parent.getParent();
            List<SQLSelectItem> selectList = queryBlock.getSelectList();
            boolean found = false;
            for (SQLSelectItem item : selectList) {
                if (!item.getExpr().equals(expr)) continue;
                found = true;
                break;
            }
            if (!found) {
                SQLAggregateExpr agg;
                if (expr instanceof SQLIdentifierExpr) {
                    long nameHashCode64 = ((SQLIdentifierExpr)expr).nameHashCode64();
                    for (SQLSelectItem item : selectList) {
                        if (item.alias_hash() == nameHashCode64) break;
                    }
                } else if (expr instanceof SQLAggregateExpr && (agg = (SQLAggregateExpr)expr).getArguments().size() == 1 && agg.getArguments().get(0) instanceof SQLIdentifierExpr) {
                    SQLIdentifierExpr ident = (SQLIdentifierExpr)agg.getArguments().get(0);
                    for (SQLSelectItem item : selectList) {
                        SQLPropertyExpr propertyExpr;
                        SQLExpr itemExpr = item.getExpr();
                        if (!(itemExpr instanceof SQLAggregateExpr) || ((SQLAggregateExpr)itemExpr).getArguments().size() != 1 || !(((SQLAggregateExpr)itemExpr).getArguments().get(0) instanceof SQLPropertyExpr) || (propertyExpr = (SQLPropertyExpr)((SQLAggregateExpr)itemExpr).getArguments().get(0)).nameHashCode64() != ident.nameHashCode64()) continue;
                        SQLAggregateExpr agg2 = agg.clone();
                        agg2.setArgument(0, propertyExpr.clone());
                        if (!agg2.equals(itemExpr)) continue;
                        x.setExpr(agg2);
                    }
                }
            }
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        x.getTestExpr().accept(this);
        x.getBeginExpr().accept(this);
        x.getEndExpr().accept(this);
        SQLExpr expr = x.getTestExpr();
        SQLExpr begin = x.getBeginExpr();
        SQLExpr end = x.getEndExpr();
        if (expr instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)expr).methodNameHashCode64() == FnvHash.Constants.JSON_EXTRACT) {
            if (begin instanceof SQLCharExpr) {
                ((SQLMethodInvokeExpr)expr).setMethodName("JSON_EXTRACT_SCALAR");
            } else {
                if (end instanceof SQLNumberExpr || begin instanceof SQLNumberExpr) {
                    SQLCastExpr cast = new SQLCastExpr(expr.clone(), SQLNumberExpr.DATA_TYPE_DOUBLE.clone());
                    x.setTestExpr(cast);
                    ++this.optimizedCount;
                    return false;
                }
                if (begin instanceof SQLIntegerExpr || end instanceof SQLIntegerExpr) {
                    SQLCastExpr cast = new SQLCastExpr(expr.clone(), SQLIntegerExpr.DATA_TYPE.clone());
                    x.setTestExpr(cast);
                    ++this.optimizedCount;
                    return false;
                }
                if (begin instanceof SQLBooleanExpr) {
                    SQLCastExpr cast = new SQLCastExpr(expr.clone(), SQLBooleanExpr.DATA_TYPE.clone());
                    x.setTestExpr(cast);
                    ++this.optimizedCount;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        SQLExpr expr = x.getExpr();
        expr.accept(this);
        if (x.getTargetList().size() == 0) {
            return true;
        }
        SQLExpr right = x.getTargetList().get(0);
        if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)expr;
            long methodHash = methodInvokeExpr.methodNameHashCode64();
            if (methodHash == FnvHash.Constants.JSON_EXTRACT) {
                if (right instanceof SQLCharExpr) {
                    methodInvokeExpr.setMethodName("JSON_EXTRACT_SCALAR");
                } else {
                    if (right instanceof SQLIntegerExpr) {
                        SQLCastExpr cast = new SQLCastExpr(expr.clone(), SQLIntegerExpr.DATA_TYPE.clone());
                        x.setExpr(cast);
                        ++this.optimizedCount;
                        return false;
                    }
                    if (right instanceof SQLNumberExpr) {
                        SQLCastExpr cast = new SQLCastExpr(expr.clone(), SQLNumberExpr.DATA_TYPE_DOUBLE.clone());
                        x.setExpr(cast);
                        ++this.optimizedCount;
                        return false;
                    }
                    if (right instanceof SQLBooleanExpr) {
                        SQLCastExpr cast = new SQLCastExpr(expr.clone(), SQLBooleanExpr.DATA_TYPE.clone());
                        x.setExpr(cast);
                        ++this.optimizedCount;
                        return false;
                    }
                }
            } else {
                for (SQLExpr target : x.getTargetList()) {
                    if (!(target instanceof SQLLiteralExpr)) continue;
                    SQLLiteralExpr literal = (SQLLiteralExpr)target;
                    this.handleNameLiteral(x, expr, literal);
                }
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLSelect x) {
        if (x.getHintsSize() > 0) {
            x.getHints().clear();
        }
        return super.visit(x);
    }

    public boolean isBackQuotedNames() {
        return this.backQuotedNames;
    }

    public void setBackQuotedNames(boolean backQuotedNames) {
        this.backQuotedNames = backQuotedNames;
    }

    public static class TypeResolve
    extends OptimizerVisitor {
        @Override
        public boolean visit(SQLMethodInvokeExpr x) {
            List<SQLExpr> arguments = x.getArguments();
            if (x.methodNameHashCode64() == FnvHash.Constants.FROM_UNIXTIME) {
                if (arguments.size() == 1) {
                    x.setResolvedReturnDataType(new SQLDataTypeImpl("TIMESTAMP"));
                } else if (arguments.size() == 2) {
                    x.setResolvedReturnDataType(new SQLCharacterDataType("VARCHAR"));
                }
                return true;
            }
            if (x.methodNameHashCode64() == FnvHash.Constants.STR_TO_DATE && arguments.size() == 2 && arguments.get(1) instanceof SQLCharExpr) {
                String fmt = ((SQLCharExpr)arguments.get(1)).getText();
                if ("%Y-%m-%d".equals(fmt)) {
                    x.setResolvedReturnDataType(new SQLDataTypeImpl("DATE"));
                }
                if (fmt.indexOf("%i") >= 0 || fmt.indexOf("%H") >= 0 || fmt.indexOf("%s") >= 0) {
                    x.setResolvedReturnDataType(new SQLDataTypeImpl("TIMESTAMP"));
                }
            }
            return true;
        }
    }

    class ViewRewrite
    extends SQLASTVisitorAdapter {
        ViewRewrite() {
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLName) {
                String name = ((SQLName)expr).getSimpleName();
                SQLTableSource resolvedTableSource = null;
                if (expr instanceof SQLIdentifierExpr) {
                    resolvedTableSource = ((SQLIdentifierExpr)expr).getResolvedTableSource();
                }
                if (resolvedTableSource == null) {
                    SchemaObject table = ADSRewrite.this.repository.findTable(name);
                    if (table != null) {
                        return true;
                    }
                    SchemaObject view = ADSRewrite.this.repository.findView(name);
                    if (view != null) {
                        SQLCreateViewStatement statement = (SQLCreateViewStatement)view.getStatement();
                        List<SQLTableElement> columns = statement.getColumns();
                        String string = statement.getSubQuery().toString();
                    }
                }
            }
            return true;
        }
    }

    class HavingRewrite
    extends SQLASTVisitorAdapter {
        private final SQLSelectQueryBlock queryBlock;

        public HavingRewrite(SQLSelectQueryBlock queryBlock) {
            this.queryBlock = queryBlock;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            if (x.getParent() instanceof SQLPropertyExpr) {
                return false;
            }
            SQLSelectItem selectItem = x.getResolvedSelectItem();
            if (selectItem == null) {
                List<SQLSelectItem> selectList = this.queryBlock.getSelectList();
                for (int i = 0; i < selectList.size(); ++i) {
                    SQLSelectItem item = selectList.get(i);
                    if (x.nameHashCode64() != item.alias_hash()) continue;
                    selectItem = item;
                    break;
                }
            }
            if (selectItem == null) {
                return false;
            }
            boolean isAgg = false;
            SQLObject item = selectItem.getExpr();
            while (!(item instanceof SQLSelectQueryBlock) && !(item instanceof SQLSelect)) {
                if (item instanceof SQLAggregateExpr) {
                    isAgg = true;
                    break;
                }
                item = item.getParent();
            }
            SQLExpr clonedItemExpr = selectItem.getExpr().clone();
            boolean allColumn = false;
            if (clonedItemExpr instanceof SQLAllColumnExpr || clonedItemExpr instanceof SQLPropertyExpr && ((SQLPropertyExpr)clonedItemExpr).getName().equals("*")) {
                allColumn = true;
            }
            if (!(allColumn || isAgg && x.getParent() instanceof SQLAggregateExpr)) {
                SQLUtils.replaceInParent(x, clonedItemExpr);
            }
            return true;
        }
    }

    private static class ANNCheckDistanceVisitor
    extends OptimizerVisitor {
        private boolean hasAnnDistance;
        private SQLExprTableSource x;

        public ANNCheckDistanceVisitor(SQLExprTableSource x) {
            this.x = x;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            if (x.nameHashCode64() == FnvHash.Constants.ANN_DISTANCE) {
                this.hasAnnDistance = true;
            }
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x1) {
            return this.x != x1;
        }
    }
}

