/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLCurrentTimeExpr;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprComparor;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCaseExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCastExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDecimalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLExistsExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLHexExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNotExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNullExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLQueryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.sql.visitor.functions.Concat;
import com.alibaba.fastsql.sql.visitor.functions.IfNull;
import com.alibaba.fastsql.sql.visitor.functions.Lcase;
import com.alibaba.fastsql.sql.visitor.functions.Length;
import com.alibaba.fastsql.sql.visitor.functions.Substring;
import com.alibaba.fastsql.sql.visitor.functions.Ucase;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.HexBin;
import com.alibaba.fastsql.util.Jdk8TimeUtils;
import com.alibaba.fastsql.util.MySqlUtils;
import com.alibaba.fastsql.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class ConstFolding
extends OptimizerVisitor {
    private boolean constFoldingNowFun;
    private Date now;

    public ConstFolding() {
    }

    public ConstFolding(DbType dbType, TimeZone timeZone, Boolean constFoldingNowFun) {
        this.dbType = dbType;
        this.timeZone = timeZone;
        this.constFoldingNowFun = constFoldingNowFun;
    }

    public ConstFolding(DbType dbType) {
        this.dbType = dbType;
    }

    @Override
    public void endVisit(MySqlSelectQueryBlock x) {
        this.endVisit((SQLSelectQueryBlock)x);
    }

    @Override
    public void endVisit(SQLSelectQueryBlock x) {
        SQLExpr where = x.getWhere();
        if (where instanceof SQLBooleanExpr) {
            SQLAggregateExpr aggExpr;
            SQLSelectItem selectItem;
            SQLExpr selectItemExpr;
            boolean value = ((SQLBooleanExpr)where).getValue();
            if (value) {
                x.setWhere(null);
            } else if (x.getGroupBy() == null && x.getSelectList().size() == 1 && (selectItemExpr = (selectItem = x.getSelectList().get(0)).getExpr()) instanceof SQLAggregateExpr && (aggExpr = (SQLAggregateExpr)selectItemExpr).methodNameHashCode64() == FnvHash.Constants.COUNT && aggExpr.getOver() == null) {
                selectItem.setExpr(new SQLIntegerExpr(0));
                x.setFrom((SQLTableSource)null);
                x.setOrderBy(null);
                x.setWhere(null);
                ++this.optimizedCount;
            }
        }
    }

    @Override
    public boolean visit(SQLUnaryExpr x) {
        x.getExpr().accept(this);
        SQLExpr expr = x.getExpr();
        SQLIntegerExpr replaceTo = null;
        if (x.getOperator() == SQLUnaryOperator.Negative && expr instanceof SQLValuableExpr) {
            Object value = ((SQLValuableExpr)expr).getValue();
            if (value instanceof Long) {
                long longVal = (Long)value;
                replaceTo = new SQLIntegerExpr(-longVal);
            } else if (value instanceof Integer) {
                long intValue = ((Integer)value).intValue();
                replaceTo = new SQLIntegerExpr(-intValue);
            }
        }
        if (replaceTo != null) {
            this.replaceInParent(x, replaceTo);
        }
        return false;
    }

    @Override
    public boolean visit(SQLNotExpr x) {
        x.getExpr().accept(this);
        SQLExpr expr = x.getExpr();
        SQLBooleanExpr replaceTo = null;
        if (expr instanceof SQLValuableExpr) {
            Object value = ((SQLValuableExpr)expr).getValue();
            if (value instanceof Boolean) {
                replaceTo = new SQLBooleanExpr((Boolean)value == false);
            } else if (value instanceof Integer) {
                int intVal = (Integer)value;
                if (intVal == 0) {
                    replaceTo = new SQLBooleanExpr(true);
                } else if (intVal == 1) {
                    replaceTo = new SQLBooleanExpr(false);
                }
            }
        }
        if (replaceTo != null) {
            this.replaceInParent(x, replaceTo);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean visit(SQLCaseExpr x) {
        void var7_15;
        SQLExpr valueExpr;
        if (x.getValueExpr() != null) {
            x.getValueExpr().accept(this);
        }
        boolean allChar = true;
        List<SQLCaseExpr.Item> items = x.getItems();
        for (SQLCaseExpr.Item item : items) {
            item.accept(this);
            if (item.getValueExpr() instanceof SQLCharExpr) continue;
            allChar = false;
        }
        SQLExpr elseExpr = x.getElseExpr();
        if (elseExpr != null) {
            SQLDataType sqlDataType = elseExpr.computeDataType();
            if (sqlDataType != null && elseExpr instanceof SQLValuableExpr && (sqlDataType.isNumberic() || sqlDataType.isInt()) && allChar) {
                this.replaceInParent(elseExpr, new SQLCharExpr(elseExpr.toString()));
            }
            elseExpr.accept(this);
        }
        if (x.getValueExpr() instanceof SQLName) {
            valueExpr = (SQLName)x.getValueExpr();
            for (SQLCaseExpr.Item item : items) {
                if (!(item.getConditionExpr() instanceof SQLLiteralExpr)) continue;
                this.handleNameLiteral(null, valueExpr, (SQLLiteralExpr)item.getConditionExpr());
            }
        }
        valueExpr = x.getValueExpr();
        Object value = null;
        if (valueExpr instanceof SQLValuableExpr) {
            value = ((SQLValuableExpr)valueExpr).getValue();
        }
        if (value != null) {
            for (SQLCaseExpr.Item item : items) {
                Object object;
                if (!(item.getConditionExpr() instanceof SQLValuableExpr) || !value.equals(object = ((SQLValuableExpr)item.getConditionExpr()).getValue()) || !this.replaceInParent(x, item.getValueExpr())) continue;
                return false;
            }
        } else {
            SQLObject sQLObject = x.getParent();
            for (SQLCaseExpr.Item item : items) {
                SQLExpr itemCondition = item.getConditionExpr();
                Boolean conditionIsTrue = false;
                if (itemCondition instanceof SQLValuableExpr) {
                    Object condition = ((SQLValuableExpr)itemCondition).getValue();
                    if (Boolean.TRUE.equals(condition)) {
                        conditionIsTrue = true;
                    } else if (Boolean.FALSE.equals(condition)) {
                        continue;
                    }
                } else if (sQLObject instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)sQLObject).getOperator().isRelational()) {
                    SQLBinaryOpExprGroup binaryOpParentGroup;
                    SQLObject parentParent = sQLObject.getParent();
                    if (parentParent instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr binaryOpParent = (SQLBinaryOpExpr)parentParent;
                        if (binaryOpParent.getOperator() == SQLBinaryOperator.BooleanAnd && (itemCondition.equals(binaryOpParent.getLeft()) || itemCondition.equals(binaryOpParent.getRight()))) {
                            conditionIsTrue = true;
                        }
                    } else if (parentParent instanceof SQLBinaryOpExprGroup && (binaryOpParentGroup = (SQLBinaryOpExprGroup)parentParent).getOperator() == SQLBinaryOperator.BooleanAnd && binaryOpParentGroup.getItems().contains(itemCondition)) {
                        conditionIsTrue = true;
                    }
                }
                if (conditionIsTrue.booleanValue() && this.replaceInParent(x, item.getValueExpr())) {
                    return false;
                }
                break;
            }
        }
        SQLExpr sQLExpr = x.getElseExpr();
        boolean bl = false;
        for (SQLCaseExpr.Item item : items) {
            SQLExpr conditionExpr = item.getConditionExpr();
            if (!(conditionExpr instanceof SQLBooleanExpr) || ((SQLBooleanExpr)conditionExpr).getBooleanValue()) continue;
            ++var7_15;
        }
        if (var7_15 == items.size() && sQLExpr != null) {
            this.replaceInParent(x, sQLExpr.clone());
            return false;
        }
        if (valueExpr == null && sQLExpr instanceof SQLQueryExpr) {
            SQLSelect sQLSelect = ((SQLQueryExpr)sQLExpr).getSubQuery().clone();
            if (x.getItems().size() == 1 && x.getItems().get(0).getConditionExpr() instanceof SQLBinaryOpExpr && x.getItems().get(0).getValueExpr() instanceof SQLQueryExpr) {
                SQLBinaryOpExpr itemConditionExpr = (SQLBinaryOpExpr)x.getItems().get(0).getConditionExpr();
                SQLQueryExpr itemValueExpr = (SQLQueryExpr)x.getItems().get(0).getValueExpr();
                if (itemConditionExpr.getLeft() instanceof SQLQueryExpr) {
                    SQLSelect itemConditionSelect = ((SQLQueryExpr)itemConditionExpr.getLeft()).getSubQuery().clone();
                    SQLSelect itemValueSelect = itemValueExpr.getSubQuery().clone();
                    SQLSelectQueryBlock elseQueryBlock = sQLSelect.getQueryBlock();
                    SQLSelectQueryBlock itemConditionQueryBlock = itemConditionSelect.getQueryBlock();
                    SQLSelectQueryBlock itemValueQueryBlock = itemValueSelect.getQueryBlock();
                    if (elseQueryBlock != null && itemConditionQueryBlock != null && elseQueryBlock.getSelectList().size() == 1 && itemConditionQueryBlock.getSelectList().size() == 1 && itemValueQueryBlock.getSelectList().size() == 1) {
                        SQLSelectItem elseSelectItem = elseQueryBlock.getSelectList().get(0);
                        SQLSelectItem itemConditionSelectItem = itemConditionQueryBlock.getSelectList().get(0);
                        SQLSelectItem itemValueSelectItem = itemValueQueryBlock.getSelectList().get(0);
                        SQLExpr elseSelectItemExpr = elseSelectItem.getExpr();
                        SQLExpr itemSelectItemExpr = itemConditionSelectItem.getExpr();
                        SQLExpr itemValueSelectItemExpr = itemValueSelectItem.getExpr();
                        elseSelectItem.setExpr(new SQLIntegerExpr(1));
                        itemConditionSelectItem.setExpr(new SQLIntegerExpr(1));
                        itemValueSelectItem.setExpr(new SQLIntegerExpr(1));
                        if (elseQueryBlock.equals(itemConditionQueryBlock) && elseQueryBlock.equals(itemValueQueryBlock)) {
                            SQLBinaryOpExpr condition2 = itemConditionExpr.clone();
                            condition2.setLeft(itemSelectItemExpr.clone());
                            SQLCaseExpr caseExpr2 = new SQLCaseExpr();
                            caseExpr2.addItem(condition2, itemValueSelectItemExpr);
                            caseExpr2.setElseExpr(elseSelectItemExpr);
                            itemConditionSelectItem.setExpr(caseExpr2);
                            SQLQueryExpr query2 = new SQLQueryExpr(itemConditionSelect);
                            if (this.replaceInParent(x, query2)) {
                                caseExpr2.accept(this);
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLCastExpr x) {
        String text;
        Date date;
        x.getExpr().accept(this);
        SQLDataType dataType = x.getDataType();
        SQLExpr expr = x.getExpr();
        long dataTypeHash = dataType.nameHashCode64();
        SQLExpr replaceTo = null;
        if (dataTypeHash == FnvHash.Constants.BIGINT) {
            if (expr instanceof SQLCharExpr) {
                String str = ((SQLCharExpr)expr).getText();
                try {
                    long val = Long.parseLong(str);
                    replaceTo = new SQLIntegerExpr(val);
                }
                catch (NumberFormatException val) {}
            }
        } else if (dataTypeHash == FnvHash.Constants.INT || dataTypeHash == FnvHash.Constants.INTEGER) {
            if (expr instanceof SQLCharExpr) {
                String str = ((SQLCharExpr)expr).getText();
                try {
                    int val = Integer.parseInt(str);
                    replaceTo = new SQLIntegerExpr(val);
                }
                catch (NumberFormatException val) {}
            }
        } else if (dataTypeHash == FnvHash.Constants.SMALLINT) {
            Number number;
            if (expr instanceof SQLCharExpr) {
                String str = ((SQLCharExpr)expr).getText();
                try {
                    short val = Short.parseShort(str);
                    replaceTo = new SQLIntegerExpr(val);
                }
                catch (NumberFormatException val) {}
            } else if (expr instanceof SQLIntegerExpr && (number = ((SQLIntegerExpr)expr).getNumber()) instanceof Integer && number.intValue() >= Short.MIN_VALUE && number.intValue() <= Short.MAX_VALUE) {
                replaceTo = expr.clone();
            }
        } else if (dataTypeHash == FnvHash.Constants.DECIMAL) {
            if (expr instanceof SQLCharExpr && dataType.getArguments().size() == 0) {
                String str = ((SQLCharExpr)expr).getText();
                try {
                    replaceTo = new SQLDecimalExpr(str);
                }
                catch (NumberFormatException val) {}
            }
        } else if (dataTypeHash == FnvHash.Constants.VARCHAR || dataTypeHash == FnvHash.Constants.VARCHAR2 || dataTypeHash == FnvHash.Constants.CHAR || dataTypeHash == FnvHash.Constants.TEXT || dataTypeHash == FnvHash.Constants.TINYTEXT || dataTypeHash == FnvHash.Constants.MEDIUMTEXT || dataTypeHash == FnvHash.Constants.LONGTEXT || dataTypeHash == FnvHash.Constants.CLOB || dataTypeHash == FnvHash.Constants.NCLOB || dataTypeHash == FnvHash.Constants.NVARCHAR || dataTypeHash == FnvHash.Constants.NVARCHAR2 || dataTypeHash == FnvHash.Constants.NCHAR_VARYING || dataTypeHash == FnvHash.Constants.STRING) {
            if (expr instanceof SQLNumericLiteralExpr) {
                String str = expr.toString();
                try {
                    replaceTo = new SQLCharExpr(str);
                }
                catch (NumberFormatException val) {}
            } else if (expr instanceof SQLDateExpr) {
                replaceTo = new SQLCharExpr(((SQLDateExpr)expr).getLiteral());
            } else {
                SQLDataType sqlDataType = expr.computeDataType();
                if (sqlDataType == null) {
                    return false;
                }
                long exprDataTypeHash = sqlDataType.nameHashCode64();
                if (exprDataTypeHash == FnvHash.Constants.VARCHAR || exprDataTypeHash == FnvHash.Constants.CHAR || exprDataTypeHash == FnvHash.Constants.TEXT || exprDataTypeHash == FnvHash.Constants.STRING) {
                    replaceTo = expr.clone();
                }
            }
        } else if (dataTypeHash == FnvHash.Constants.DATE) {
            if (expr instanceof SQLIntegerExpr && ((SQLIntegerExpr)expr).getNumber() instanceof Integer) {
                int intVal = ((SQLIntegerExpr)expr).getNumber().intValue();
                if (intVal >= 10000000 && intVal <= 99999999) {
                    int year = intVal / 10000;
                    int mmdd = intVal - year * 10000;
                    int mm = mmdd / 100;
                    int dd = mmdd % 100;
                    StringBuffer buf = new StringBuffer();
                    buf.append(year);
                    buf.append('-');
                    if (mm < 10) {
                        buf.append('0');
                    }
                    buf.append(mm);
                    buf.append('-');
                    if (dd < 10) {
                        buf.append('0');
                    }
                    buf.append(dd);
                    replaceTo = new SQLDateExpr(buf.toString());
                }
            } else if (expr instanceof SQLCharExpr) {
                String text2 = ((SQLCharExpr)expr).getText();
                Date date2 = MySqlUtils.parseDate(text2, this.timeZone);
                if (date2 != null) {
                    if (text2.length() == 8) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        if (this.timeZone != null) {
                            dateFormat.setTimeZone(this.timeZone);
                        }
                        text2 = dateFormat.format(date2);
                    }
                    replaceTo = new SQLDateExpr(text2);
                }
            } else if (expr instanceof SQLDateExpr) {
                replaceTo = expr.clone();
            }
        } else if (dataTypeHash == FnvHash.Constants.TIMESTAMP && expr instanceof SQLCharExpr && (date = MySqlUtils.parseDate(text = ((SQLCharExpr)expr).getText(), this.timeZone)) != null) {
            replaceTo = new SQLTimestampExpr(date, this.timeZone);
        }
        if (replaceTo != null && this.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
        }
        return false;
    }

    @Override
    public boolean visit(SQLCurrentTimeExpr x) {
        SQLExprImpl replaceTo;
        if (!this.constFoldingNowFun) {
            return false;
        }
        if (this.now == null) {
            this.now = new Date();
        }
        switch (x.getType()) {
            case CURRENT_DATE: 
            case CURDATE: {
                replaceTo = new SQLDateExpr(this.now, this.timeZone);
                break;
            }
            case LOCALTIME: 
            case CURRENT_TIME: 
            case CURTIME: {
                replaceTo = new SQLTimeExpr(this.now, this.timeZone);
                break;
            }
            default: {
                replaceTo = new SQLTimestampExpr(this.now, this.timeZone);
            }
        }
        if (this.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
        }
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        SQLSelectItem item;
        SQLSubqueryTableSource resolvedTableSource;
        SQLSelectQuery query;
        long hash = x.hashCode64();
        SQLExprImpl replaceTo = null;
        if (this.constFoldingNowFun && (hash == FnvHash.Constants.SYSDATE || hash == FnvHash.Constants.NOW || hash == FnvHash.Constants.CURRENT_TIMESTAMP || hash == FnvHash.Constants.LOCALTIMESTAMP || hash == FnvHash.Constants.SYSTIMESTAMP || hash == FnvHash.Constants.CURRENT_DATE || hash == FnvHash.Constants.CURDATE) && this.timeZone != null) {
            if (this.now == null) {
                this.now = new Date();
            }
            replaceTo = hash == FnvHash.Constants.CURRENT_DATE || hash == FnvHash.Constants.CURDATE ? new SQLDateExpr(this.now, this.timeZone) : new SQLTimestampExpr(this.now, this.timeZone);
        }
        if (replaceTo != null && this.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
            return false;
        }
        if (x.getResolvedColumn() == null && (x.getParent() instanceof SQLBinaryOpExpr || x.getParent() instanceof SQLMethodInvokeExpr || x.getParent() instanceof SQLCastExpr) && x.getResolvedTableSource() != null && x.getResolvedTableSource() instanceof SQLSubqueryTableSource && (query = (resolvedTableSource = (SQLSubqueryTableSource)x.getResolvedTableSource()).getSelect().getQuery()) instanceof MySqlSelectQueryBlock && (item = ((MySqlSelectQueryBlock)query).findSelectItem(x.getName())) != null && item.getExpr() instanceof SQLLiteralExpr) {
            this.replaceInParent(x, item.getExpr());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        Object val;
        Object arg0;
        List<SQLExpr> arguments;
        SQLExpr arg02;
        SQLDataType arg0DataType;
        String text;
        SQLExpr owner = x.getOwner();
        if (owner != null) {
            owner.accept(this);
        }
        for (SQLExpr arg : x.getArguments()) {
            arg.accept(this);
        }
        SQLExpr for_ = x.getFor();
        if (for_ != null) {
            for_.accept(this);
        }
        long hash = x.methodNameHashCode64();
        if (x.getArguments().size() == 1 && x.getArguments().get(0) instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)x.getArguments().get(0)).methodNameHashCode64() == FnvHash.Constants.FROM_UNIXTIME && ((SQLMethodInvokeExpr)x.getArguments().get(0)).getArguments().size() == 1 && ((SQLMethodInvokeExpr)x.getArguments().get(0)).getArguments().get(0) instanceof SQLTimestampExpr && (hash == FnvHash.Constants.YEAR || hash == FnvHash.Constants.MONTH || hash == FnvHash.Constants.DAY || hash == FnvHash.Constants.HOUR)) {
            SQLExpr ts = ((SQLMethodInvokeExpr)x.getArguments().get(0)).getArguments().get(0);
            x.setArgument(0, ts.clone());
        }
        if (this.constFoldingNowFun && this.timeZone != null && (hash == FnvHash.Constants.SYSDATE || hash == FnvHash.Constants.NOW || hash == FnvHash.Constants.CURRENT_TIMESTAMP || hash == FnvHash.Constants.LOCALTIMESTAMP || hash == FnvHash.Constants.SYSTIMESTAMP || hash == FnvHash.Constants.CURRENT_DATE || hash == FnvHash.Constants.CURDATE)) {
            SQLExprImpl sQLExprImpl;
            boolean date = hash == FnvHash.Constants.CURRENT_DATE || hash == FnvHash.Constants.CURDATE;
            SimpleDateFormat format = new SimpleDateFormat(date ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
            format.setTimeZone(this.timeZone);
            if (this.now == null) {
                this.now = new Date();
            }
            text = format.format(this.now);
            SQLExprImpl sQLExprImpl2 = sQLExprImpl = date ? new SQLDateExpr(text) : new SQLTimestampExpr(text);
            if (this.replaceInParent(x, sQLExprImpl)) {
                ++this.optimizedCount;
                return false;
            }
        }
        if (this.timeZone != null && (hash == FnvHash.Constants.CURRENT_TIME || hash == FnvHash.Constants.CURTIME)) {
            String text2;
            SQLTimeExpr timeExpr;
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            format.setTimeZone(this.timeZone);
            if (this.now == null) {
                this.now = new Date();
            }
            if (this.replaceInParent(x, timeExpr = new SQLTimeExpr(text2 = format.format(this.now)))) {
                ++this.optimizedCount;
                return false;
            }
        }
        if (!(hash != FnvHash.Constants.IFNULL && hash != FnvHash.Constants.ISNULL && hash != FnvHash.Constants.COALESCE || x.getArguments().size() <= 1 || (arg0DataType = (arg02 = (arguments = x.getArguments()).get(0)).computeDataType()) != null || arg02 instanceof SQLNullExpr)) {
            return false;
        }
        boolean allConst = ConstFolding.isAllConst(x);
        if (x.getArguments().size() >= 1) {
            boolean isNull = false;
            arg0 = x.getArguments().get(0);
            if (arg0 instanceof SQLNullExpr) {
                isNull = true;
            } else if (arg0 instanceof SQLCastExpr && ((SQLCastExpr)arg0).getExpr() instanceof SQLNullExpr) {
                isNull = true;
            }
            if (isNull && (hash == FnvHash.Constants.FLOOR || hash == FnvHash.Constants.FROM_DAYS || hash == FnvHash.Constants.DATE_ADD || hash == FnvHash.Constants.DATEADD || hash == FnvHash.Constants.DATE_SUB || hash == FnvHash.Constants.DATE_DIFF || hash == FnvHash.Constants.DATE_PARSE || hash == FnvHash.Constants.DATE_FORMAT || hash == FnvHash.Constants.YEAR || hash == FnvHash.Constants.MONTH || hash == FnvHash.Constants.DATE || hash == FnvHash.Constants.DAY || hash == FnvHash.Constants.QUARTER || hash == FnvHash.Constants.HOUR || hash == FnvHash.Constants.MINUTE || hash == FnvHash.Constants.CONCAT || hash == FnvHash.Constants.ADDDATE || hash == FnvHash.Constants.TO_DAYS) && this.replaceInParent(x, new SQLNullExpr())) {
                return false;
            }
        }
        if (!allConst) return false;
        List<SQLExpr> arguments2 = x.getArguments();
        if (hash == FnvHash.Constants.SUBSTR || hash == FnvHash.Constants.SUBSTRING) {
            Object object;
            if (x.getFrom() != null && x.getFor() != null) {
                x.getArguments().add(x.getFrom());
                x.getArguments().add(x.getFor());
                x.setFrom(null);
                x.setFor(null);
            }
            arg0 = arguments2.get(0);
            if (arguments2.size() == 3 && !(arg0 instanceof SQLCharExpr) && arg0 instanceof SQLValuableExpr) {
                String string = ((SQLValuableExpr)arg0).getValue().toString();
                arguments2.set(0, new SQLCharExpr(string));
            }
            if (!((object = Substring.instance.eval(x)) instanceof String)) return false;
            if (!this.replaceInParent(x, new SQLCharExpr((String)object))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.CONCAT) {
            val = Concat.instance.eval(x);
            if (!(val instanceof String)) return false;
            if (!this.replaceInParent(x, new SQLCharExpr((String)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.LCASE || hash == FnvHash.Constants.LOWER) {
            val = Lcase.instance.eval(x);
            if (!(val instanceof String)) return false;
            if (!this.replaceInParent(x, new SQLCharExpr((String)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.UCASE || hash == FnvHash.Constants.UPPER) {
            val = Ucase.instance.eval(x);
            if (!(val instanceof String)) return false;
            if (!this.replaceInParent(x, new SQLCharExpr((String)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.LENGTH || hash == FnvHash.Constants.LEN) {
            val = Length.instance.eval(x);
            if (!(val instanceof Integer)) return false;
            if (!this.replaceInParent(x, new SQLIntegerExpr((Integer)val))) return false;
            ++this.optimizedCount;
            return false;
        }
        if (hash == FnvHash.Constants.LEFT) {
            this.func_left(x);
            return false;
        } else if (hash == FnvHash.Constants.HEX) {
            this.func_hex(x);
            return false;
        } else {
            if (hash == FnvHash.Constants.UNHEX) return false;
            if (hash == FnvHash.Constants.ISNULL) {
                this.func_isnull(x);
                return false;
            } else if (hash == FnvHash.Constants.TO_UNIXTIME) {
                this.func_to_unixtime(x);
                return false;
            } else if (hash == FnvHash.Constants.LOCATE) {
                this.func_locate(x);
                return false;
            } else if (hash == FnvHash.Constants.REVERSE) {
                this.func_reverse(x);
                return false;
            } else if (hash == FnvHash.Constants.RIGHT) {
                this.func_right(x);
                return false;
            } else if (hash == FnvHash.Constants.RTRIM) {
                this.func_rtrim(x);
                return false;
            } else if (hash == FnvHash.Constants.LTRIM) {
                this.func_ltrim(x);
                return false;
            } else if (hash == FnvHash.Constants.TRIM) {
                this.func_trim(x);
                return false;
            } else if (hash == FnvHash.Constants.GREATEST) {
                this.func_greatest(x);
                return false;
            } else if (hash == FnvHash.Constants.LEAST) {
                this.func_least(x);
                return false;
            } else if (hash == FnvHash.Constants.IFNULL) {
                this.func_ifnull(x);
                return false;
            } else if (hash == FnvHash.Constants.COALESCE) {
                this.func_coalesce(x);
                return false;
            } else if (hash == FnvHash.Constants.IF) {
                this.func_if(x);
                return false;
            } else if (hash == FnvHash.Constants.NULLIF) {
                this.func_nullif(x);
                return false;
            } else if (hash == FnvHash.Constants.REPLACE) {
                if (arguments2.size() != 3) return false;
                try {
                    arg0 = ((SQLCharExpr)arguments2.get(0)).getText();
                    String string = ((SQLCharExpr)arguments2.get(1)).getText();
                    String arg2 = ((SQLCharExpr)arguments2.get(2)).getText();
                    String newStr = ((String)arg0).replaceAll(string, arg2);
                    this.replaceInParent(x, new SQLCharExpr(newStr));
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            } else if (hash == FnvHash.Constants.TO_DATE) {
                boolean supportDateExpr;
                boolean bl = supportDateExpr = this.dbType == DbType.mysql || this.dbType == DbType.ads || this.dbType == DbType.hive;
                if (arguments2.size() != 2 || !(arguments2.get(0) instanceof SQLCharExpr) || !(arguments2.get(1) instanceof SQLCharExpr) || !supportDateExpr) return false;
                String string = ((SQLCharExpr)arguments2.get(0)).getText();
                String format = ((SQLCharExpr)arguments2.get(1)).getText();
                DateFormat dateFormat = MySqlUtils.toJavaFormat(format);
                if (dateFormat == null) return false;
                try {
                    Date date = dateFormat.parse(string);
                    String dateLiteral = new SimpleDateFormat("yyyy-MM-dd").format(date);
                    if (!this.replaceInParent(x, new SQLDateExpr(dateLiteral))) return false;
                    ++this.optimizedCount;
                    return false;
                }
                catch (ParseException e) {
                    return false;
                }
            } else if (hash == FnvHash.Constants.STR_TO_DATE || hash == FnvHash.Constants.DATE_PARSE || hash == FnvHash.Constants.TO_DATE) {
                this.func_str_to_date(x);
                return false;
            } else if (hash == FnvHash.Constants.JSON_EXTRACT) {
                this.func_jsonExtract(x);
                return false;
            } else if (hash == FnvHash.Constants.JSON_ARRAY_GET) {
                this.func_json_arrayGet(x);
                return false;
            } else if (hash == FnvHash.Constants.ABS) {
                this.func_abs(x);
                return false;
            } else if (hash == FnvHash.Constants.FLOOR) {
                this.func_floor(x);
                return false;
            } else if (hash == FnvHash.Constants.INTERVAL) {
                this.func_interval(x);
                return false;
            } else if (hash == FnvHash.Constants.DATEADD || hash == FnvHash.Constants.DATE_ADD || hash == FnvHash.Constants.ADDDATE) {
                this.func_str_date_add(x, arguments2);
                return false;
            } else if (hash == FnvHash.Constants.DATE_SUB || hash == FnvHash.Constants.SUBDATE) {
                this.func_str_date_sub(x, arguments2);
                return false;
            } else if (hash == FnvHash.Constants.ADDTIME) {
                this.func_addTime(x, arguments2);
                return false;
            } else if (hash == FnvHash.Constants.SUBTIME) {
                this.func_subTime(x, arguments2);
                return false;
            } else if (hash == FnvHash.Constants.GET_FORMAT) {
                this.func_get_format(x);
                return false;
            } else if (hash == FnvHash.Constants.DAY_OF_WEEK || hash == FnvHash.Constants.DAYOFWEEK) {
                this.func_day_of_week(x);
                return false;
            } else if (hash == FnvHash.Constants.DATE_FORMAT) {
                this.func_date_format(x, arguments2);
                return false;
            } else if (hash == FnvHash.Constants.DATEDIFF || hash == FnvHash.Constants.DATE_DIFF) {
                this.func_datediff(x);
                return false;
            } else if (hash == FnvHash.Constants.DATE_TRUNC) {
                this.func_datetrunc(x);
                return false;
            } else if (hash == FnvHash.Constants.DATE) {
                this.func_date(x);
                return false;
            } else if (hash == FnvHash.Constants.TIME) {
                this.func_time(x);
                return false;
            } else if (hash == FnvHash.Constants.TIMESTAMP) {
                this.func_timestamp(x);
                return false;
            } else if (hash == FnvHash.Constants.TIMESTAMPDIFF) {
                this.func_timestamp_diff(x);
                return false;
            } else if (hash == FnvHash.Constants.MONTHNAME) {
                this.func_monthname(x);
                return false;
            } else if (hash == FnvHash.Constants.MONTH_BETWEEN) {
                this.func_month_between(x);
                return false;
            } else if (hash == FnvHash.Constants.TRUNC) {
                this.func_trunc(x);
                return false;
            } else if (hash == FnvHash.Constants.PERIOD_ADD) {
                this.func_period_add(x);
                return false;
            } else if (hash == FnvHash.Constants.YEAR || hash == FnvHash.Constants.QUARTER || hash == FnvHash.Constants.MONTH || hash == FnvHash.Constants.DAY || hash == FnvHash.Constants.WEEK || hash == FnvHash.Constants.WEEKDAY || hash == FnvHash.Constants.WEEKOFYEAR || hash == FnvHash.Constants.DAYOFMONTH || hash == FnvHash.Constants.HOUR || hash == FnvHash.Constants.MINUTE || hash == FnvHash.Constants.SECOND) {
                if (arguments2.size() == 1) {
                    void var9_26;
                    arg0 = arguments2.get(0);
                    Object var9_21 = null;
                    if (arg0 instanceof SQLCharExpr) {
                        String string = ((SQLCharExpr)arg0).getText();
                    } else if (arg0 instanceof SQLDateExpr) {
                        String string = ((SQLDateExpr)arg0).getLiteral();
                    } else if (arg0 instanceof SQLTimestampExpr) {
                        String string = ((SQLTimestampExpr)arg0).getLiteral();
                    } else if (arg0 instanceof SQLIntegerExpr) {
                        String string = String.valueOf(((SQLIntegerExpr)arg0).getNumber().intValue());
                    }
                    if (var9_26 == null) {
                        return false;
                    }
                    if (var9_26.length() == 10 && (hash == FnvHash.Constants.HOUR || hash == FnvHash.Constants.MINUTE || hash == FnvHash.Constants.SECOND)) {
                        return false;
                    }
                    Date d0 = MySqlUtils.parseDate((String)var9_26, this.timeZone);
                    if (d0 == null) {
                        return false;
                    }
                    Calendar calendar = this.timeZone != null ? Calendar.getInstance(this.timeZone) : Calendar.getInstance();
                    calendar.setTime(d0);
                    Integer value = null;
                    if (hash == FnvHash.Constants.YEAR) {
                        value = calendar.get(1);
                    } else if (hash == FnvHash.Constants.QUARTER) {
                        value = calendar.get(2) / 3 + 1;
                    } else if (hash == FnvHash.Constants.MONTH) {
                        value = calendar.get(2) + 1;
                    } else if (hash == FnvHash.Constants.DAY || hash == FnvHash.Constants.DAYOFMONTH) {
                        value = calendar.get(5);
                    } else if (hash == FnvHash.Constants.WEEK) {
                        value = calendar.get(3) - 1;
                    } else if (hash == FnvHash.Constants.WEEKOFYEAR) {
                        calendar.setFirstDayOfWeek(2);
                        value = calendar.get(3);
                    } else if (hash == FnvHash.Constants.WEEKDAY) {
                        value = (calendar.get(7) + 5) % 7;
                    } else if (hash == FnvHash.Constants.HOUR) {
                        value = calendar.get(11);
                    } else if (hash == FnvHash.Constants.MINUTE) {
                        value = calendar.get(12);
                    } else if (hash == FnvHash.Constants.SECOND) {
                        value = calendar.get(13);
                    }
                    if (value != null && this.replaceInParent(x, new SQLIntegerExpr(value))) {
                        ++this.optimizedCount;
                    }
                }
                if (arguments2.size() != 2) return false;
                text = null;
                SQLExpr sQLExpr = arguments2.get(0);
                if (sQLExpr instanceof SQLCharExpr) {
                    text = ((SQLCharExpr)sQLExpr).getText();
                }
                if (text == null || !this.replaceInParent(sQLExpr, new SQLDateExpr(text))) return false;
                ++this.optimizedCount;
                return false;
            } else if (hash == FnvHash.Constants.TO_CHAR) {
                this.func_to_char(x, arguments2);
                return false;
            } else if (hash == FnvHash.Constants.UNIX_TIMESTAMP) {
                this.func_unix_timestamp(x);
                return false;
            } else if (hash == FnvHash.Constants.FROM_UNIXTIME) {
                this.func_from_unixtime(x);
                return false;
            } else if (hash == FnvHash.Constants.LAST_DAY) {
                this.func_last_day(x);
                return false;
            } else if (hash == FnvHash.Constants.MAKEDATE) {
                this.func_makedate(x);
                return false;
            } else if (hash == FnvHash.Constants.ASCII) {
                this.func_ascii(x);
                return false;
            } else if (hash == FnvHash.Constants.DAYNAME) {
                this.func_dayname(x);
                return false;
            } else if (hash == FnvHash.Constants.ORD) {
                this.func_ord(x);
                return false;
            } else if (hash == FnvHash.Constants.REPEAT) {
                this.func_repeat(x);
                return false;
            } else if (hash == FnvHash.Constants.SPACE) {
                this.func_space(x);
                return false;
            } else {
                if (hash != FnvHash.Constants.SUBSTRING_INDEX) return false;
                this.func_substring_index(x);
            }
        }
        return false;
    }

    private void func_to_unixtime(SQLMethodInvokeExpr x) {
        SQLExpr arg0;
        if (x.getArguments().size() == 1 && (arg0 = x.getArguments().get(0)) instanceof SQLCharExpr) {
            String text = ((SQLCharExpr)arg0).getText();
            SQLTimestampExpr timestampExpr = new SQLTimestampExpr(text);
            x.getArguments().set(0, timestampExpr);
        }
    }

    private void func_time(SQLMethodInvokeExpr x) {
        if (x.getArguments().size() == 1) {
            SQLExpr arg0 = x.getArguments().get(0);
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            if (arg0 instanceof SQLTimestampExpr) {
                String text = format.format(((SQLTimestampExpr)arg0).getDate(this.timeZone));
                SQLCharExpr timeExpr = new SQLCharExpr(text);
                this.replaceInParent(x, timeExpr);
            } else if (arg0 instanceof SQLDateExpr) {
                String text = format.format(((SQLDateExpr)arg0).getDate(this.timeZone));
                SQLCharExpr timeExpr = new SQLCharExpr(text);
                this.replaceInParent(x, timeExpr);
            }
        }
    }

    private void func_to_char(SQLMethodInvokeExpr x, List<SQLExpr> arguments) {
        Date date;
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        if (!(arg1 instanceof SQLCharExpr)) {
            return;
        }
        String format = ((SQLCharExpr)arg1).getText();
        if (arg0 instanceof SQLDateExpr) {
            date = ((SQLDateExpr)arg0).getDate(this.timeZone);
        } else if (arg0 instanceof SQLTimestampExpr) {
            date = ((SQLTimestampExpr)arg0).getDate(this.timeZone);
        } else {
            return;
        }
        DateFormat javaFormat = MySqlUtils.toJavaFormat(format, this.timeZone);
        if (javaFormat == null) {
            return;
        }
        String chars = javaFormat.format(date);
        if (this.replaceInParent(x, new SQLCharExpr(chars))) {
            ++this.optimizedCount;
        }
    }

    private static boolean isAllConst(SQLMethodInvokeExpr x) {
        boolean allConst = true;
        long hash = x.methodNameHashCode64();
        for (int i = 0; i < x.getArguments().size(); ++i) {
            SQLExpr arg = x.getArguments().get(i);
            if (arg instanceof SQLValuableExpr || arg instanceof SQLIntervalExpr && ((SQLIntervalExpr)arg).getValue() instanceof SQLValuableExpr || hash == FnvHash.Constants.TIMESTAMPDIFF && i == 0 && arg instanceof SQLIdentifierExpr || hash == FnvHash.Constants.GET_FORMAT && i == 0 && arg instanceof SQLIdentifierExpr || hash == FnvHash.Constants.IF || hash == FnvHash.Constants.JSON_EXTRACT || hash == FnvHash.Constants.JSON_ARRAY_GET || hash == FnvHash.Constants.DATE_FORMAT || hash == FnvHash.Constants.DATE_ADD || hash == FnvHash.Constants.ADDDATE) continue;
            allConst = false;
        }
        return allConst;
    }

    private void func_substring_index(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 3) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        SQLExpr arg2 = arguments.get(2);
        if (arg0 instanceof SQLCharExpr && arg1 instanceof SQLCharExpr && arg2 instanceof SQLIntegerExpr) {
            SQLExpr replaceTo;
            String str0 = ((SQLCharExpr)arg0).getText();
            String str1 = ((SQLCharExpr)arg1).getText();
            int count = ((SQLIntegerExpr)arg2).getNumber().intValue();
            if (count > 0) {
                int index = -1;
                for (int i = 0; i < count && (index = str0.indexOf(str1, index + 1)) != -1; ++i) {
                }
                if (index == -1) {
                    replaceTo = arg0.clone();
                } else {
                    String result = str0.substring(0, index);
                    replaceTo = new SQLCharExpr(result);
                }
            } else if (count < 0) {
                int index = str0.length();
                for (int i = 0; i < -count && (index = str0.lastIndexOf(str1, index - 1)) != -1; ++i) {
                }
                if (index == -1) {
                    replaceTo = arg0.clone();
                } else {
                    String result = str0.substring(index + 1);
                    replaceTo = new SQLCharExpr(result);
                }
            } else {
                return;
            }
            if (this.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_space(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLIntegerExpr) {
            int val = ((SQLIntegerExpr)arg0).getNumber().intValue();
            char[] buf = new char[val];
            Arrays.fill(buf, ' ');
            if (this.replaceInParent(x, new SQLCharExpr(new String(buf)))) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_repeat(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        if (arg0 instanceof SQLCharExpr && arg1 instanceof SQLIntegerExpr) {
            String text = ((SQLCharExpr)arg0).getText();
            long val = ((SQLIntegerExpr)arg1).getNumber().longValue();
            if (val <= 0L || val > 100L) {
                return;
            }
            SQLExpr replaceTo = null;
            if (val == 1L) {
                replaceTo = arg0.clone();
            } else {
                StringBuffer buf = new StringBuffer(text.length() * (int)val);
                int i = 0;
                while ((long)i < val) {
                    buf.append(text);
                    ++i;
                }
                replaceTo = new SQLCharExpr(buf.toString());
            }
            if (this.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_ord(SQLMethodInvokeExpr x) {
        char ch;
        String text;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLCharExpr && (text = ((SQLCharExpr)arg0).getText()).length() == 1 && this.replaceInParent(x, new SQLIntegerExpr((int)(ch = text.charAt(0))))) {
            ++this.optimizedCount;
        }
    }

    private void func_day_of_week(SQLMethodInvokeExpr x) {
        String text;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLCharExpr) {
            text = ((SQLCharExpr)arg0).getText();
        } else if (arg0 instanceof SQLDateExpr) {
            text = ((SQLDateExpr)arg0).getLiteral();
        } else {
            return;
        }
        Date date = MySqlUtils.parseDate(text, this.timeZone);
        if (date == null) {
            return;
        }
        Calendar calendar = this.timeZone != null ? Calendar.getInstance(this.timeZone) : Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        if (this.replaceInParent(x, new SQLIntegerExpr(dayOfWeek))) {
            ++this.optimizedCount;
        }
    }

    private void func_date_format(SQLMethodInvokeExpr x, List<SQLExpr> arguments) {
        SQLExprImpl timestampExpr;
        if (arguments.size() != 2) {
            return;
        }
        if (arguments.get(0) instanceof SQLCharExpr) {
            String str = ((SQLCharExpr)arguments.get(0)).getText();
            Date date = MySqlUtils.parseDate(str, this.timeZone);
            if (date == null) {
                return;
            }
            if (str.length() == 19 || str.length() == 21) {
                SQLTimestampExpr ts = new SQLTimestampExpr(date, this.timeZone);
                ts.setParent(x);
                arguments.set(0, ts);
            } else if (str.length() == 10) {
                SQLDateExpr dateExpr = new SQLDateExpr(date, this.timeZone);
                dateExpr.setParent(x);
                arguments.set(0, dateExpr);
            }
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        if (arg0 instanceof SQLTimestampExpr && arg1 instanceof SQLCharExpr) {
            timestampExpr = (SQLTimestampExpr)arg0;
            String format = ((SQLCharExpr)arg1).getText();
            DateFormat dateFormat = ConstFolding.mysqlDateFormat(format, this.timeZone);
            if (dateFormat != null) {
                Date date = ((SQLTimestampExpr)timestampExpr).getDate(this.timeZone);
                if (date == null) {
                    return;
                }
                String text = dateFormat.format(date);
                if (this.replaceInParent(x, new SQLCharExpr(text))) {
                    ++this.optimizedCount;
                }
            }
        } else if (arg0 instanceof SQLDateExpr && arg1 instanceof SQLCharExpr) {
            timestampExpr = (SQLDateExpr)arg0;
            String format = ((SQLCharExpr)arg1).getText();
            if (format.contains("%u") || format.contains("%U")) {
                this.replaceInParent(timestampExpr, new SQLCharExpr(((SQLDateExpr)timestampExpr).getLiteral()));
            } else {
                DateFormat dateFormat = ConstFolding.mysqlDateFormat(format, this.timeZone);
                if (dateFormat != null) {
                    Date date = ((SQLDateExpr)timestampExpr).getDate(this.timeZone);
                    if (date == null) {
                        return;
                    }
                    String text = dateFormat.format(date);
                    if (this.replaceInParent(x, new SQLCharExpr(text))) {
                        ++this.optimizedCount;
                    }
                }
            }
        } else if (arg1 instanceof SQLCharExpr) {
            long parentFuncNameHash;
            String format = ((SQLCharExpr)arg1).getText();
            SQLObject parent = x.getParent();
            if (parent instanceof SQLMethodInvokeExpr && ((parentFuncNameHash = ((SQLMethodInvokeExpr)parent).methodNameHashCode64()) == FnvHash.Constants.DATE_DIFF || parentFuncNameHash == FnvHash.Constants.DATEDIFF) && ("%Y%m%d".equals(format) || "%Y-%m-%d".equals(format))) {
                SQLMethodInvokeExpr date = new SQLMethodInvokeExpr("DATE", null, arg0.clone());
                this.replaceInParent(x, date);
            }
        }
    }

    private void func_subTime(SQLMethodInvokeExpr x, List<SQLExpr> arguments) {
        long nameHashCode64;
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLNullExpr) {
            this.replaceInParent(x, new SQLNullExpr());
            return;
        }
        SQLDataType dataType = arg0.computeDataType();
        if (dataType != null && (nameHashCode64 = dataType.nameHashCode64()) == FnvHash.Constants.TIMESTAMP) {
            SQLCastExpr castExpr = new SQLCastExpr(arg0, new SQLDataTypeImpl("VARCHAR"));
            arguments.set(0, castExpr);
            ++this.optimizedCount;
        }
    }

    private void func_addTime(SQLMethodInvokeExpr x, List<SQLExpr> arguments) {
        String strVal;
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        if (arg0 instanceof SQLNullExpr) {
            this.replaceInParent(x, new SQLNullExpr());
            return;
        }
        Date date = null;
        if (arg0 instanceof SQLCharExpr) {
            strVal = ((SQLCharExpr)arg0).getText();
            date = MySqlUtils.parseDate(strVal, this.timeZone);
        } else if (arg0 instanceof SQLTimestampExpr) {
            strVal = ((SQLTimestampExpr)arg0).getLiteral();
            date = MySqlUtils.parseDate(strVal, this.timeZone);
        }
        if (date == null) {
            return;
        }
        if (!(arg1 instanceof SQLCharExpr)) {
            return;
        }
        String times = ((SQLCharExpr)arg1).getText();
        SQLTimestampExpr replaceTo = null;
        if (times.length() == 10) {
            if (times.charAt(1) == ' ' && times.charAt(4) == ':' && times.charAt(7) == ':') {
                char c0 = times.charAt(0);
                char c2 = times.charAt(2);
                char c3 = times.charAt(3);
                char c5 = times.charAt(5);
                char c6 = times.charAt(6);
                char c8 = times.charAt(8);
                char c9 = times.charAt(9);
                if (c0 >= '0' && c0 <= '9' && c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9' && c5 >= '0' && c5 <= '9' && c6 >= '0' && c6 <= '9' && c8 >= '0' && c8 <= '9' && c9 >= '0' && c9 <= '9') {
                    int days = c0 - 48;
                    int hours = (c2 - 48) * 10 + (c3 - 48);
                    int minutes = (c5 - 48) * 10 + (c6 - 48);
                    int seconds = (c8 - 48) * 10 + (c9 - 48);
                    Calendar calendar = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
                    calendar.setTime(date);
                    if (days != 0) {
                        calendar.add(6, days);
                    }
                    if (hours != 0) {
                        calendar.add(11, hours);
                    }
                    if (minutes != 0) {
                        calendar.add(12, minutes);
                    }
                    if (seconds != 0) {
                        calendar.add(13, seconds);
                    }
                    replaceTo = new SQLTimestampExpr(calendar.getTime(), this.timeZone);
                }
            }
            if (replaceTo != null) {
                this.replaceInParent(x, replaceTo);
            }
        }
    }

    private void func_str_date_add(SQLMethodInvokeExpr x, List<SQLExpr> arguments) {
        SQLExprImpl dateExpr;
        boolean supportDateAdd;
        SQLIntervalExpr intervalExpr;
        SQLExpr intervalExprValue;
        if (arguments.size() == 2 && arguments.get(1) instanceof SQLIntervalExpr && (intervalExprValue = (intervalExpr = (SQLIntervalExpr)arguments.get(1)).getValue()) instanceof SQLIntegerExpr && ((SQLIntegerExpr)intervalExprValue).getNumber() instanceof Integer && ((SQLIntegerExpr)intervalExprValue).getNumber().intValue() == 0) {
            SQLExpr arg0 = arguments.get(0);
            SQLDataType dateType = arg0.computeDataType();
            if (dateType == null || dateType.nameHashCode64() != FnvHash.Constants.TIMESTAMP && dateType.nameHashCode64() != FnvHash.Constants.TIMESTAMP) {
                SQLCastExpr cast = new SQLCastExpr(arg0.clone(), new SQLDataTypeImpl("TIMESTAMP"));
                this.replaceInParent(x, cast);
            } else {
                this.replaceInParent(x, arg0.clone());
            }
            return;
        }
        boolean bl = supportDateAdd = this.dbType == DbType.mysql || this.dbType == DbType.ads;
        if (arguments.size() == 2 && (arguments.get(0) instanceof SQLCharExpr || arguments.get(0) instanceof SQLDateExpr || arguments.get(0) instanceof SQLTimestampExpr) && (arguments.get(1) instanceof SQLIntervalExpr || arguments.get(1) instanceof SQLIntegerExpr)) {
            this.dateAdd(x, arguments.get(0), arguments.get(1), false);
            return;
        }
        if (arguments.size() == 3 && arguments.get(0) instanceof SQLDateExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(2) instanceof SQLCharExpr && supportDateAdd) {
            SQLDateExpr dateCloned;
            dateExpr = (SQLDateExpr)arguments.get(0);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(2)).getText();
            if ("day".equalsIgnoreCase(type)) {
                SQLDateExpr dateCloned2 = ((SQLDateExpr)dateExpr).clone();
                if (dateCloned2.addDay(delta) && this.replaceInParent(x, dateCloned2)) {
                    ++this.optimizedCount;
                }
            } else if ("month".equalsIgnoreCase(type) && (dateCloned = ((SQLDateExpr)dateExpr).clone()).addMonth(delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(2) instanceof SQLDateExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(0) instanceof SQLCharExpr && supportDateAdd) {
            SQLDateExpr dateCloned;
            dateExpr = (SQLDateExpr)arguments.get(2);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(0)).getText();
            if ("day".equalsIgnoreCase(type)) {
                SQLDateExpr dateCloned3 = ((SQLDateExpr)dateExpr).clone();
                if (dateCloned3.addDay(delta) && this.replaceInParent(x, dateCloned3)) {
                    ++this.optimizedCount;
                }
            } else if ("month".equalsIgnoreCase(type)) {
                SQLDateExpr dateCloned4 = ((SQLDateExpr)dateExpr).clone();
                if (dateCloned4.addMonth(delta) && this.replaceInParent(x, dateCloned4)) {
                    ++this.optimizedCount;
                }
            } else if ("year".equalsIgnoreCase(type) && (dateCloned = ((SQLDateExpr)dateExpr).clone()).addYear(delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(0) instanceof SQLTimestampExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(2) instanceof SQLCharExpr && supportDateAdd) {
            SQLTimestampExpr dateCloned;
            dateExpr = (SQLTimestampExpr)arguments.get(0);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(2)).getText();
            if ("day".equalsIgnoreCase(type)) {
                SQLTimestampExpr dateCloned5 = ((SQLTimestampExpr)dateExpr).clone();
                if (dateCloned5.addDay(delta) && this.replaceInParent(x, dateCloned5)) {
                    ++this.optimizedCount;
                }
            } else if ("month".equalsIgnoreCase(type) && (dateCloned = ((SQLTimestampExpr)dateExpr).clone()).addMonth(delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(2) instanceof SQLTimestampExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(0) instanceof SQLCharExpr && supportDateAdd) {
            SQLTimestampExpr dateCloned;
            dateExpr = (SQLTimestampExpr)arguments.get(2);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(0)).getText();
            if ("day".equalsIgnoreCase(type)) {
                SQLTimestampExpr dateCloned6 = ((SQLTimestampExpr)dateExpr).clone();
                if (dateCloned6.addDay(delta) && this.replaceInParent(x, dateCloned6)) {
                    ++this.optimizedCount;
                }
            } else if ("month".equalsIgnoreCase(type)) {
                SQLTimestampExpr dateCloned7 = ((SQLTimestampExpr)dateExpr).clone();
                if (dateCloned7.addMonth(delta) && this.replaceInParent(x, dateCloned7)) {
                    ++this.optimizedCount;
                }
            } else if ("hour".equalsIgnoreCase(type)) {
                SQLTimestampExpr dateCloned8 = ((SQLTimestampExpr)dateExpr).clone();
                if (dateCloned8.addHour(delta) && this.replaceInParent(x, dateCloned8)) {
                    ++this.optimizedCount;
                }
            } else if ("minute".equalsIgnoreCase(type) && (dateCloned = ((SQLTimestampExpr)dateExpr).clone()).addMiniute(delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(2) instanceof SQLCharExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(0) instanceof SQLCharExpr && supportDateAdd) {
            String dateText = ((SQLCharExpr)arguments.get(2)).getText();
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(0)).getText();
            Date date = MySqlUtils.parseDate(dateText, this.timeZone);
            if (date == null) {
                return;
            }
            Calendar calendar = this.timeZone != null ? Calendar.getInstance(this.timeZone) : Calendar.getInstance();
            calendar.setTime(date);
            boolean isDate = calendar.get(14) == 0 && calendar.get(13) == 0 && calendar.get(12) == 0 && calendar.get(11) == 0;
            SQLExprImpl replaceTo = null;
            if ("day".equalsIgnoreCase(type)) {
                calendar.add(5, delta);
                replaceTo = isDate ? new SQLDateExpr(calendar.getTime(), this.timeZone) : new SQLTimestampExpr(calendar.getTime(), this.timeZone);
            } else if ("month".equalsIgnoreCase(type)) {
                calendar.add(2, delta);
                replaceTo = isDate ? new SQLDateExpr(calendar.getTime(), this.timeZone) : new SQLTimestampExpr(calendar.getTime(), this.timeZone);
            }
            if (replaceTo != null && this.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_str_date_sub(SQLMethodInvokeExpr x, List<SQLExpr> arguments) {
        boolean supportDateAdd;
        boolean bl = supportDateAdd = this.dbType == DbType.mysql || this.dbType == DbType.ads;
        if (arguments.size() == 2 && (arguments.get(0) instanceof SQLCharExpr || arguments.get(0) instanceof SQLDateExpr || arguments.get(0) instanceof SQLTimestampExpr) && (arguments.get(1) instanceof SQLIntervalExpr || arguments.get(1) instanceof SQLIntegerExpr)) {
            this.dateAdd(x, arguments.get(0), arguments.get(1), true);
            return;
        }
        if (arguments.size() == 3 && arguments.get(0) instanceof SQLDateExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(2) instanceof SQLCharExpr && supportDateAdd) {
            SQLDateExpr dateCloned;
            SQLDateExpr dateExpr = (SQLDateExpr)arguments.get(0);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(2)).getText();
            if ("day".equalsIgnoreCase(type) && (dateCloned = dateExpr.clone()).addDay(-delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(2) instanceof SQLDateExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(0) instanceof SQLCharExpr && supportDateAdd) {
            SQLDateExpr dateCloned;
            SQLDateExpr dateExpr = (SQLDateExpr)arguments.get(2);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(0)).getText();
            if ("day".equalsIgnoreCase(type) && (dateCloned = dateExpr.clone()).addDay(-delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(0) instanceof SQLTimestampExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(2) instanceof SQLCharExpr && supportDateAdd) {
            SQLTimestampExpr dateCloned;
            SQLTimestampExpr dateExpr = (SQLTimestampExpr)arguments.get(0);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(2)).getText();
            if ("day".equalsIgnoreCase(type) && (dateCloned = dateExpr.clone()).addDay(-delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(2) instanceof SQLTimestampExpr && arguments.get(1) instanceof SQLIntegerExpr && arguments.get(0) instanceof SQLCharExpr && supportDateAdd) {
            SQLTimestampExpr dateCloned;
            SQLTimestampExpr dateExpr = (SQLTimestampExpr)arguments.get(2);
            int delta = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            String type = ((SQLCharExpr)arguments.get(0)).getText();
            if ("day".equalsIgnoreCase(type) && (dateCloned = dateExpr.clone()).addDay(-delta) && this.replaceInParent(x, dateCloned)) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_dayname(SQLMethodInvokeExpr x) {
        SQLExpr arg0;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1 && (arg0 = arguments.get(0)) instanceof SQLCharExpr) {
            String str0 = ((SQLCharExpr)arg0).getText();
            Date date = MySqlUtils.parseDate(str0, this.timeZone);
            if (date == null) {
                return;
            }
            if (str0.length() == 19) {
                SQLTimestampExpr ts = new SQLTimestampExpr(str0);
                ts.setParent(x);
                arguments.set(0, ts);
            } else if (str0.length() == 10) {
                SQLDateExpr dateExpr = new SQLDateExpr(str0);
                dateExpr.setParent(x);
                arguments.set(0, dateExpr);
            }
        }
        Date date = null;
        if (arguments.get(0) instanceof SQLDateExpr) {
            date = ((SQLDateExpr)arguments.get(0)).getDate(this.timeZone);
        } else if (arguments.size() > 1 && arguments.get(1) instanceof SQLTimestampExpr) {
            date = ((SQLTimestampExpr)arguments.get(0)).getDate(this.timeZone);
        }
        if (date == null) {
            return;
        }
        Calendar calendar = this.timeZone != null ? Calendar.getInstance(this.timeZone) : Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        String name = null;
        switch (dayOfWeek) {
            case 1: {
                name = "Sunday";
                break;
            }
            case 2: {
                name = "Monday";
                break;
            }
            case 3: {
                name = "Tuesday";
                break;
            }
            case 4: {
                name = "Wednesday";
                break;
            }
            case 5: {
                name = "Thursday";
                break;
            }
            case 6: {
                name = "Friday";
                break;
            }
            case 7: {
                name = "Saturday";
                break;
            }
        }
        if (name != null && this.replaceInParent(x, new SQLCharExpr(name))) {
            ++this.optimizedCount;
        }
    }

    private void func_ascii(SQLMethodInvokeExpr x) {
        String text;
        char ascii;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLCharExpr && this.replaceInParent(x, new SQLIntegerExpr((int)(ascii = (text = ((SQLCharExpr)arg0).getText()).length() > 0 ? text.charAt(0) : (char)'\u0000')))) {
            ++this.optimizedCount;
        }
    }

    private void func_makedate(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        if (arg0 instanceof SQLIntegerExpr && arg1 instanceof SQLIntegerExpr) {
            int year = ((SQLIntegerExpr)arg0).getNumber().intValue();
            int dayOfYear = ((SQLIntegerExpr)arg1).getNumber().intValue();
            if (dayOfYear > 0) {
                Calendar calendar = this.timeZone != null ? Calendar.getInstance(this.timeZone) : Calendar.getInstance();
                calendar.set(year, 0, 1, 0, 0, 0);
                calendar.set(14, 9);
                calendar.set(6, dayOfYear);
                Date date = calendar.getTime();
                if (this.replaceInParent(x, new SQLDateExpr(date, this.timeZone))) {
                    ++this.optimizedCount;
                }
            } else if (this.replaceInParent(x, new SQLNullExpr())) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_last_day(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        String text = null;
        if (arg0 instanceof SQLTimestampExpr) {
            text = ((SQLTimestampExpr)arg0).getLiteral();
        } else if (arg0 instanceof SQLCharExpr) {
            text = ((SQLCharExpr)arg0).getText();
        } else if (arg0 instanceof SQLDateExpr) {
            text = ((SQLDateExpr)arg0).getLiteral();
        }
        Date date = MySqlUtils.parseDate(text, this.timeZone);
        if (date == null) {
            return;
        }
        Calendar calendar = this.timeZone != null ? Calendar.getInstance(this.timeZone) : Calendar.getInstance();
        calendar.setTime(date);
        int val = calendar.getActualMaximum(5);
        calendar.set(5, val);
        Date lastDay = calendar.getTime();
        if (this.replaceInParent(x, new SQLDateExpr(lastDay, this.timeZone))) {
            ++this.optimizedCount;
        }
    }

    private void func_from_unixtime(SQLMethodInvokeExpr x) {
        long seconds;
        Date date;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLIntegerExpr && this.replaceInParent(x, new SQLTimestampExpr(date = new Date((seconds = (long)((SQLIntegerExpr)arg0).getNumber().intValue()) * 1000L), this.timeZone))) {
            ++this.optimizedCount;
        }
    }

    private void func_unix_timestamp(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        String text = null;
        if (arg0 instanceof SQLTimestampExpr) {
            text = ((SQLTimestampExpr)arg0).getLiteral();
        } else if (arg0 instanceof SQLCharExpr) {
            text = ((SQLCharExpr)arg0).getText();
        } else if (arg0 instanceof SQLDateExpr) {
            text = ((SQLDateExpr)arg0).getLiteral();
        }
        if (text == null) {
            return;
        }
        Date date = MySqlUtils.parseDate(text, this.timeZone);
        if (date == null) {
            return;
        }
        long millis = date.getTime();
        if (millis < 0L) {
            return;
        }
        int seconds = (int)(millis / 1000L);
        if (this.replaceInParent(x, new SQLIntegerExpr(seconds))) {
            ++this.optimizedCount;
        }
    }

    private void func_json_arrayGet(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        if (arg0 instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)arg0).methodNameHashCode64() == FnvHash.Constants.JSON_EXTRACT && ((SQLMethodInvokeExpr)arg0).getArguments().size() == 2 && ((SQLMethodInvokeExpr)arg0).getArguments().get(1) instanceof SQLCharExpr && arg1 instanceof SQLIntegerExpr) {
            SQLMethodInvokeExpr jsonExtract = (SQLMethodInvokeExpr)arg0;
            SQLExpr expr = jsonExtract.getArguments().get(0);
            SQLIntegerExpr arrayIndex = (SQLIntegerExpr)arg1;
            String path = ((SQLCharExpr)jsonExtract.getArguments().get(1)).getText();
            String path2 = path + "[" + arrayIndex.getNumber() + "]";
            SQLMethodInvokeExpr replaceTo = new SQLMethodInvokeExpr(x.getMethodName(), null, expr.clone(), new SQLCharExpr(path2));
            this.replaceInParent(x, replaceTo);
        }
    }

    private void func_jsonExtract(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        if (arg0 instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)arg0).methodNameHashCode64() == FnvHash.Constants.JSON_ARRAY_GET && ((SQLMethodInvokeExpr)arg0).getArguments().size() == 2 && ((SQLMethodInvokeExpr)arg0).getArguments().get(1) instanceof SQLIntegerExpr && arg1 instanceof SQLCharExpr) {
            SQLMethodInvokeExpr json_array_get = (SQLMethodInvokeExpr)arg0;
            SQLExpr expr = json_array_get.getArguments().get(0);
            SQLIntegerExpr arrayIndex = (SQLIntegerExpr)json_array_get.getArguments().get(1);
            String path = ((SQLCharExpr)arg1).getText();
            if (path.startsWith("$.") && arrayIndex.getNumber() instanceof Integer) {
                String rewritePath = "$[" + arrayIndex.getNumber() + "]." + path.substring(2);
                SQLMethodInvokeExpr replaceTo = new SQLMethodInvokeExpr(x.getMethodName(), null, expr.clone(), new SQLCharExpr(rewritePath));
                this.replaceInParent(x, replaceTo);
            }
        }
    }

    private void func_trunc(SQLMethodInvokeExpr x) {
        SQLExprImpl replaceTo;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        Date date0 = null;
        if (arg0 instanceof SQLTimestampExpr) {
            date0 = ((SQLTimestampExpr)arg0).getDate(this.timeZone);
        } else if (arg0 instanceof SQLCharExpr) {
            String str0 = ((SQLCharExpr)arg1).getText();
            date0 = MySqlUtils.parseDate(str0, this.timeZone);
        }
        if (date0 == null) {
            return;
        }
        if (!(arg1 instanceof SQLCharExpr)) {
            return;
        }
        Calendar calendar = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
        calendar.setTime(date0);
        long unitHash = FnvHash.hashCode64(((SQLCharExpr)arg1).getText());
        boolean timestamp = false;
        if (unitHash == FnvHash.Constants.YEAR) {
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else if (unitHash == FnvHash.Constants.MONTH) {
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else if (unitHash == FnvHash.Constants.DAY) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else if (unitHash == FnvHash.Constants.HOUR) {
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            timestamp = true;
        } else if (unitHash == FnvHash.Constants.MINUTE) {
            calendar.set(13, 0);
            calendar.set(14, 0);
            timestamp = true;
        } else if (unitHash == FnvHash.Constants.SECOND) {
            calendar.set(14, 0);
            timestamp = true;
        } else {
            return;
        }
        SQLExprImpl sQLExprImpl = replaceTo = timestamp ? new SQLTimestampExpr(calendar.getTime(), this.timeZone) : new SQLDateExpr(calendar.getTime(), this.timeZone);
        if (this.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
        }
    }

    private void func_month_between(SQLMethodInvokeExpr x) {
        Integer delta;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg1 = arguments.get(0);
        SQLExpr arg2 = arguments.get(1);
        String str1 = null;
        String str2 = null;
        if (arg1 instanceof SQLCharExpr) {
            str1 = ((SQLCharExpr)arg1).getText();
        }
        if (arg2 instanceof SQLCharExpr) {
            str2 = ((SQLCharExpr)arg2).getText();
        }
        if ((delta = Jdk8TimeUtils.monthBetween(str1, str2, this.timeZone)) != null && this.replaceInParent(x, new SQLIntegerExpr(delta))) {
            ++this.optimizedCount;
        }
    }

    private void func_monthname(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        Date date = null;
        if (arg0 instanceof SQLDateExpr) {
            date = ((SQLDateExpr)arg0).getDate(this.timeZone);
        } else if (arg0 instanceof SQLCharExpr) {
            String text = ((SQLCharExpr)arg0).getText();
            SimpleDateFormat format = text.length() == 10 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                date = format.parse(text);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            return;
        }
        Calendar calendar = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
        calendar.setTime(date);
        int month = calendar.get(2);
        String monthName = null;
        switch (month) {
            case 0: {
                monthName = "January";
                break;
            }
            case 1: {
                monthName = "February";
                break;
            }
            case 2: {
                monthName = "March";
                break;
            }
            case 3: {
                monthName = "April";
                break;
            }
            case 4: {
                monthName = "May";
                break;
            }
            case 5: {
                monthName = "June";
                break;
            }
            case 6: {
                monthName = "July";
                break;
            }
            case 7: {
                monthName = "August";
                break;
            }
            case 8: {
                monthName = "September";
                break;
            }
            case 9: {
                monthName = "October";
                break;
            }
            case 10: {
                monthName = "November";
                break;
            }
            case 11: {
                monthName = "December";
                break;
            }
        }
        if (monthName != null && this.replaceInParent(x, new SQLCharExpr(monthName))) {
            ++this.optimizedCount;
        }
    }

    private void func_date(SQLMethodInvokeExpr x) {
        String str0;
        Date date;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLCharExpr && (date = MySqlUtils.parseDate(str0 = ((SQLCharExpr)arg0).getText(), this.timeZone)) != null && this.replaceInParent(x, new SQLDateExpr(date, this.timeZone))) {
            ++this.optimizedCount;
        }
    }

    private void func_timestamp(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1) {
            Date date;
            String str0;
            SQLExpr arg0 = arguments.get(0);
            if (arg0 instanceof SQLCharExpr) {
                str0 = ((SQLCharExpr)arg0).getText();
                if (str0.indexOf(46) > 0) {
                    this.replaceInParent(x, new SQLTimestampExpr(str0));
                    return;
                }
            } else if (arg0 instanceof SQLIntegerExpr) {
                str0 = ((SQLIntegerExpr)arg0).getNumber().toString();
            } else {
                return;
            }
            if ((date = MySqlUtils.parseDate(str0, this.timeZone)) == null) {
                return;
            }
            this.replaceInParent(x, new SQLTimestampExpr(date, this.timeZone));
        } else if (arguments.size() == 2) {
            SQLExpr arg0 = arguments.get(0);
            SQLExpr arg1 = arguments.get(1);
            if (arg0 instanceof SQLCharExpr && arg1 instanceof SQLCharExpr) {
                String str = ((SQLCharExpr)arg0).getText();
                String fmt = ((SQLCharExpr)arg1).getText();
                DateFormat dateFormat = MySqlUtils.toJavaFormat(fmt, this.timeZone);
                if (dateFormat != null) {
                    try {
                        Date date = dateFormat.parse(str);
                        SQLTimestampExpr ts = new SQLTimestampExpr(date, this.timeZone);
                        this.replaceInParent(x, ts);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void func_datetrunc(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg1 = arguments.get(1);
        if (arg1 instanceof SQLCharExpr) {
            SQLTimestampExpr ts = new SQLTimestampExpr(((SQLCharExpr)arg1).getText());
            x.setArgument(1, ts);
        }
    }

    private void func_datediff(SQLMethodInvokeExpr x) {
        String str1;
        String str0;
        Integer days;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 2 && (arguments.get(0) instanceof SQLNullExpr || arguments.get(1) instanceof SQLNullExpr) && this.replaceInParent(x, new SQLNullExpr())) {
            ++this.optimizedCount;
        }
        if (arguments.size() == 2 && arguments.get(0) instanceof SQLCharExpr && arguments.get(1) instanceof SQLCharExpr && (days = Jdk8TimeUtils.dateDiff(str0 = ((SQLCharExpr)arguments.get(0)).getText(), str1 = ((SQLCharExpr)arguments.get(1)).getText(), this.timeZone)) != null && this.replaceInParent(x, new SQLIntegerExpr(days))) {
            ++this.optimizedCount;
        }
        if (arguments.size() == 3 && this.timeZone != null) {
            long unitHash;
            SQLExpr arg0 = arguments.get(0);
            SQLExpr arg1 = arguments.get(1);
            SQLExpr arg2 = arguments.get(2);
            if (arg0 instanceof SQLIdentifierExpr) {
                unitHash = ((SQLIdentifierExpr)arg0).nameHashCode64();
            } else if (arg0 instanceof SQLCharExpr) {
                String text = ((SQLCharExpr)arg0).getText();
                unitHash = FnvHash.hashCode64(text);
            } else {
                return;
            }
            if (arg1 instanceof SQLCharExpr && arg2 instanceof SQLTimeExpr) {
                arg1 = new SQLTimeExpr(((SQLCharExpr)arg1).getText());
                x.setArgument(1, arg1);
                return;
            }
            String str12 = null;
            String str2 = null;
            if (arg1 instanceof SQLCharExpr) {
                str12 = ((SQLCharExpr)arg1).getText();
            } else if (arg1 instanceof SQLDateExpr) {
                str12 = ((SQLDateExpr)arg1).getLiteral();
            } else if (arg1 instanceof SQLTimestampExpr) {
                str12 = ((SQLTimestampExpr)arg1).getLiteral();
            }
            if (arg2 instanceof SQLCharExpr) {
                str2 = ((SQLCharExpr)arg2).getText();
            } else if (arg2 instanceof SQLDateExpr) {
                str2 = ((SQLDateExpr)arg2).getLiteral();
            } else if (arg2 instanceof SQLTimestampExpr) {
                str2 = ((SQLTimestampExpr)arg2).getLiteral();
            }
            Integer delta = Jdk8TimeUtils.dateDiff1(unitHash, str12, str2, this.timeZone);
            if (delta != null && this.replaceInParent(x, new SQLIntegerExpr(delta))) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_timestamp_diff(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 3 && this.timeZone != null && arguments.get(0) instanceof SQLIdentifierExpr) {
            Integer delta;
            SQLExpr arg1 = arguments.get(1);
            SQLExpr arg2 = arguments.get(2);
            long unitHash = ((SQLIdentifierExpr)arguments.get(0)).nameHashCode64();
            String str1 = null;
            String str2 = null;
            if (arg1 instanceof SQLCharExpr) {
                str1 = ((SQLCharExpr)arg1).getText();
            }
            if (arg2 instanceof SQLCharExpr) {
                str2 = ((SQLCharExpr)arg2).getText();
            }
            if ((delta = Jdk8TimeUtils.timestampDiff(unitHash, str1, str2, this.timeZone)) == null) {
                return;
            }
            if (this.replaceInParent(x, new SQLIntegerExpr(delta))) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_get_format(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 2 && arguments.get(0) instanceof SQLIdentifierExpr && arguments.get(1) instanceof SQLCharExpr) {
            long nameHash = ((SQLIdentifierExpr)arguments.get(0)).nameHashCode64();
            String str1 = ((SQLCharExpr)arguments.get(1)).getText();
            SQLCharExpr replaceTo = null;
            if (nameHash == FnvHash.Constants.DATE) {
                if (str1.equals("USA")) {
                    replaceTo = new SQLCharExpr("%m.%d.%Y");
                } else if (str1.equals("JIS") || str1.equals("ISO")) {
                    replaceTo = new SQLCharExpr("%Y-%m-%d");
                } else if (str1.equals("EUR")) {
                    replaceTo = new SQLCharExpr("%d.%m.%Y");
                } else if (str1.equals("INTERNAL")) {
                    replaceTo = new SQLCharExpr("%Y%m%d");
                }
            } else if (nameHash == FnvHash.Constants.DATETIME) {
                if (str1.equals("USA") || str1.equals("EUR")) {
                    replaceTo = new SQLCharExpr("%Y-%m-%d %H.%i.%s");
                } else if (str1.equals("JIS") || str1.equals("ISO")) {
                    replaceTo = new SQLCharExpr("%Y-%m-%d %H:%i:%s");
                } else if (str1.equals("INTERNAL")) {
                    replaceTo = new SQLCharExpr("%Y%m%d%H%i%s");
                }
            } else if (nameHash == FnvHash.Constants.TIME) {
                if (str1.equals("USA")) {
                    replaceTo = new SQLCharExpr("%h:%i:%s %p");
                } else if (str1.equals("JIS") || str1.equals("ISO")) {
                    replaceTo = new SQLCharExpr("%H:%i:%s");
                } else if (str1.equals("EUR")) {
                    replaceTo = new SQLCharExpr("%H.%i.%s");
                } else if (str1.equals("INTERNAL")) {
                    replaceTo = new SQLCharExpr("%H%i%s");
                }
            }
            if (replaceTo != null && this.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_str_to_date(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 2 && arguments.get(0) instanceof SQLTimestampExpr) {
            SQLTimestampExpr ts = (SQLTimestampExpr)arguments.get(0);
            x.setArgument(0, new SQLCharExpr(ts.getLiteral()));
            ++this.optimizedCount;
        }
        if (arguments.size() == 2 && arguments.get(0) instanceof SQLCharExpr && arguments.get(1) instanceof SQLCharExpr) {
            String str = ((SQLCharExpr)arguments.get(0)).getText();
            String fmt = ((SQLCharExpr)arguments.get(1)).getText();
            if (fmt.indexOf("%Y") == -1 || fmt.indexOf("%m") == -1) {
                return;
            }
            SQLExprImpl replaceTo = null;
            if (fmt.equals("%Y-%m-%d %H:%i:%s")) {
                replaceTo = new SQLTimestampExpr(str);
            } else if (fmt.equals("%Y-%m-%d")) {
                replaceTo = new SQLDateExpr(str);
            } else {
                if (str.indexOf("-00") != -1 || str.indexOf("/00") != -1) {
                    return;
                }
                Date date = null;
                DateFormat dateFormat = ConstFolding.mysqlDateFormat(fmt, this.timeZone);
                if (dateFormat != null) {
                    try {
                        date = dateFormat.parse(str);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (date != null) {
                    Calendar calendar = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
                    calendar.setTime(date);
                    int hour = calendar.get(11);
                    int minute = calendar.get(12);
                    int second = calendar.get(13);
                    int millis = calendar.get(14);
                    replaceTo = hour == 0 && minute == 0 && second == 0 && millis == 0 ? new SQLDateExpr(date, this.timeZone) : new SQLTimestampExpr(date, this.timeZone);
                }
            }
            if (replaceTo != null && this.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_if(SQLMethodInvokeExpr x) {
        for (SQLExpr arg : x.getArguments()) {
            arg.accept(this);
        }
        if (x.getArguments().size() != 3) {
            return;
        }
        SQLExpr itemCondition = x.getArguments().get(0);
        SQLExpr trueValueExpr = x.getArguments().get(1);
        SQLExpr falseValueExpr = x.getArguments().get(2);
        if (itemCondition instanceof SQLValuableExpr) {
            Object condVal = ((SQLValuableExpr)itemCondition).getValue();
            if (condVal instanceof Boolean) {
                if (((Boolean)condVal).booleanValue()) {
                    this.replaceInParent(x, trueValueExpr);
                } else {
                    this.replaceInParent(x, falseValueExpr);
                }
            }
            return;
        }
        boolean conditionIsTrue = false;
        SQLObject parent = x.getParent();
        if (parent instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)parent).getOperator().isRelational()) {
            SQLBinaryOpExprGroup binaryOpParentGroup;
            SQLObject parentParent = parent.getParent();
            if (parentParent instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpParent = (SQLBinaryOpExpr)parentParent;
                if (binaryOpParent.getOperator() == SQLBinaryOperator.BooleanAnd && (itemCondition.equals(binaryOpParent.getLeft()) || itemCondition.equals(binaryOpParent.getRight()))) {
                    conditionIsTrue = true;
                }
            } else if (parentParent instanceof SQLBinaryOpExprGroup && (binaryOpParentGroup = (SQLBinaryOpExprGroup)parentParent).getOperator() == SQLBinaryOperator.BooleanAnd && binaryOpParentGroup.getItems().contains(itemCondition)) {
                conditionIsTrue = true;
            }
        }
        if (conditionIsTrue) {
            this.replaceInParent(x, trueValueExpr);
        }
    }

    private void func_coalesce(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        int nullCount = 0;
        for (SQLExpr arg : arguments) {
            if (!(arg instanceof SQLLiteralExpr)) continue;
            if (arg instanceof SQLNullExpr) {
                ++nullCount;
                continue;
            }
            if (!this.replaceInParent(x, arg.clone())) continue;
            ++this.optimizedCount;
            return;
        }
        if (nullCount == arguments.size() && this.replaceInParent(x, new SQLNullExpr())) {
            ++this.optimizedCount;
        }
    }

    private void func_ifnull(SQLMethodInvokeExpr x) {
        Object val = IfNull.instance.eval(x);
        if (val instanceof Integer) {
            if (this.replaceInParent(x, new SQLIntegerExpr((Integer)val))) {
                ++this.optimizedCount;
            }
            return;
        }
        if (val instanceof String) {
            if (this.replaceInParent(x, new SQLCharExpr((String)val))) {
                ++this.optimizedCount;
            }
            return;
        }
    }

    private void func_locate(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 2 && arguments.get(0) instanceof SQLCharExpr && arguments.get(1) instanceof SQLCharExpr) {
            String str0 = ((SQLCharExpr)arguments.get(0)).getText();
            String str1 = ((SQLCharExpr)arguments.get(1)).getText();
            int index = str1.indexOf(str0) + 1;
            if (this.replaceInParent(x, new SQLIntegerExpr(index))) {
                ++this.optimizedCount;
            }
        } else if (arguments.size() == 3 && arguments.get(0) instanceof SQLCharExpr && arguments.get(1) instanceof SQLCharExpr && arguments.get(2) instanceof SQLIntegerExpr) {
            String str0 = ((SQLCharExpr)arguments.get(0)).getText();
            String str1 = ((SQLCharExpr)arguments.get(1)).getText();
            int offset = ((SQLIntegerExpr)arguments.get(2)).getNumber().intValue();
            if (offset <= 0) {
                return;
            }
            int index = str1.indexOf(str0, offset - 1) + 1;
            if (this.replaceInParent(x, new SQLIntegerExpr(index))) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_left(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 2 && arguments.get(0) instanceof SQLCharExpr && arguments.get(1) instanceof SQLIntegerExpr) {
            String left;
            String str = ((SQLCharExpr)arguments.get(0)).getText();
            int len = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            if (len <= 0) {
                len = 0;
            }
            if (str.length() < len) {
                len = str.length();
            }
            if (this.replaceInParent(x, new SQLCharExpr(left = str.substring(0, len)))) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_right(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 2 && arguments.get(0) instanceof SQLCharExpr && arguments.get(1) instanceof SQLIntegerExpr) {
            String right;
            String str = ((SQLCharExpr)arguments.get(0)).getText();
            int len = ((SQLIntegerExpr)arguments.get(1)).getNumber().intValue();
            if (len <= 0) {
                len = 0;
            }
            if (len >= str.length()) {
                len = str.length();
            }
            if (this.replaceInParent(x, new SQLCharExpr(right = str.substring(str.length() - len, str.length())))) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_rtrim(SQLMethodInvokeExpr x) {
        String str;
        String rtrim;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1 && arguments.get(0) instanceof SQLCharExpr && (rtrim = StringUtils.rtrim(str = ((SQLCharExpr)arguments.get(0)).getText())) != str && this.replaceInParent(x, new SQLCharExpr(rtrim))) {
            ++this.optimizedCount;
        }
    }

    private void func_ltrim(SQLMethodInvokeExpr x) {
        String str;
        String ltrim;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1 && arguments.get(0) instanceof SQLCharExpr && (ltrim = StringUtils.ltrim(str = ((SQLCharExpr)arguments.get(0)).getText())) != str && this.replaceInParent(x, new SQLCharExpr(ltrim))) {
            ++this.optimizedCount;
        }
    }

    private void func_trim(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1 && arguments.get(0) instanceof SQLCharExpr) {
            String str = ((SQLCharExpr)arguments.get(0)).getText();
            String trim = str.trim();
            SQLExpr from = x.getFrom();
            if (from != null) {
                return;
            }
            if (trim != str && this.replaceInParent(x, new SQLCharExpr(trim))) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_reverse(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1 && arguments.get(0) instanceof SQLCharExpr) {
            String str = ((SQLCharExpr)arguments.get(0)).getText();
            char[] chars = new char[str.length()];
            for (int i = 0; i < str.length(); ++i) {
                chars[chars.length - i - 1] = str.charAt(i);
            }
            if (this.replaceInParent(x, new SQLCharExpr(new String(chars)))) {
                ++this.optimizedCount;
            }
        }
    }

    private void func_hex(SQLMethodInvokeExpr x) {
        String text;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLCharExpr) {
            String text2 = ((SQLCharExpr)arg0).getText();
            try {
                String str = HexBin.encode(text2.getBytes("UTF-8"));
                if (this.replaceInParent(x, new SQLCharExpr(str))) {
                    ++this.optimizedCount;
                }
            }
            catch (Exception exception) {}
        } else if (arg0 instanceof SQLHexExpr && this.replaceInParent(x, new SQLCharExpr(text = ((SQLHexExpr)arg0).getHex()))) {
            ++this.optimizedCount;
        }
    }

    private void func_isnull(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLNullExpr) {
            this.replaceInParent(x, new SQLBooleanExpr(true));
        } else if (arg0 instanceof SQLLiteralExpr) {
            this.replaceInParent(x, new SQLBooleanExpr(false));
        }
    }

    private void func_unhex(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLObject parent = x.getParent();
        if (parent instanceof SQLBinaryOpExpr) {
            SQLBinaryOperator operator = ((SQLBinaryOpExpr)parent).getOperator();
            switch (operator) {
                case BooleanAnd: 
                case BooleanOr: 
                case BooleanXor: 
                case BitwiseXor: 
                case BitwiseAnd: 
                case BitwiseOr: 
                case Is: 
                case IsNot: 
                case GreaterThan: 
                case GreaterThanOrEqual: 
                case LessThan: 
                case LessThanOrEqual: 
                case LeftShift: 
                case RightShift: {
                    return;
                }
            }
        } else if (parent instanceof SQLBetweenExpr || parent instanceof SQLInListExpr || parent instanceof SQLUnaryExpr) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        if (arg0 instanceof SQLCharExpr) {
            String text = ((SQLCharExpr)arg0).getText();
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') continue;
                return;
            }
            SQLHexExpr replaceTo = new SQLHexExpr(text);
            if (this.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
                replaceTo.accept(this);
            }
        }
    }

    private void func_interval(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() < 2) {
            return;
        }
        int[] values = new int[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            Number number;
            SQLExpr arg = arguments.get(i);
            if (arg instanceof SQLNumericLiteralExpr) {
                number = ((SQLNumericLiteralExpr)arg).getNumber();
                if (!(number instanceof Integer)) {
                    return;
                }
            } else {
                return;
            }
            values[i] = (Integer)number;
        }
        SQLIntegerExpr replaceTo = null;
        int first = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] == first) {
                replaceTo = new SQLIntegerExpr(i);
                continue;
            }
            if (values[i] <= first) continue;
            replaceTo = new SQLIntegerExpr(i - 1);
            break;
        }
        if (replaceTo == null) {
            replaceTo = new SQLIntegerExpr(values.length);
        }
        if (this.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
        }
    }

    private void func_abs(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg = arguments.get(0);
        if (arg instanceof SQLIntegerExpr) {
            Number num = ((SQLIntegerExpr)arg).getNumber();
            if (num instanceof Integer) {
                int intVal = (Integer)num;
                int absVal = Math.abs(intVal);
                if (this.replaceInParent(x, new SQLIntegerExpr(absVal))) {
                    ++this.optimizedCount;
                }
            } else if (num instanceof Long) {
                long intVal = (Long)num;
                long absVal = Math.abs(intVal);
                if (this.replaceInParent(x, new SQLIntegerExpr(absVal))) {
                    ++this.optimizedCount;
                }
            } else if (num instanceof BigInteger) {
                BigInteger absVal = ((BigInteger)num).abs();
                this.replaceInParent(x, new SQLIntegerExpr(absVal));
            }
        } else if (arg instanceof SQLNullExpr && this.replaceInParent(x, new SQLNullExpr())) {
            ++this.optimizedCount;
        }
    }

    private void func_floor(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        SQLExpr arg = arguments.get(0);
        if (arg instanceof SQLIntegerExpr) {
            this.replaceInParent(x, arg.clone());
            return;
        }
        if (arg instanceof SQLNumberExpr) {
            Number number = ((SQLNumberExpr)arg).getNumber();
            if (number instanceof BigDecimal) {
                long value = ((BigDecimal)number).setScale(0, 3).longValue();
                this.replaceInParent(x, SQLIntegerExpr.ofIntOrLong(value));
            }
            return;
        }
        if (arg instanceof SQLNullExpr && this.replaceInParent(x, new SQLNullExpr())) {
            ++this.optimizedCount;
        }
    }

    private void func_nullif(SQLMethodInvokeExpr x) {
        SQLObject parent;
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        boolean eq = false;
        if (arg0.equals(arg1)) {
            eq = true;
        }
        if ((parent = x.getParent()) instanceof SQLBetweenExpr) {
            return;
        }
        if (eq && this.replaceInParent(x, new SQLNullExpr())) {
            ++this.optimizedCount;
            return;
        }
    }

    private void func_greatest(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1) {
            if (this.replaceInParent(x, arguments.get(0).clone())) {
                ++this.optimizedCount;
            }
            return;
        }
        Object[] values = new Object[arguments.size()];
        Class<?> clazz = null;
        for (int i = 0; i < arguments.size(); ++i) {
            SQLExpr arg = arguments.get(i);
            if (arg instanceof SQLNullExpr) {
                if (this.replaceInParent(x, new SQLNullExpr())) {
                    ++this.optimizedCount;
                }
                return;
            }
            Object value = ((SQLValuableExpr)arg).getValue();
            if (i == 0) {
                clazz = value.getClass();
            } else if (value.getClass() != clazz) {
                return;
            }
            values[i] = value;
        }
        if (clazz == Integer.class) {
            int max = (Integer)values[0];
            for (int i = 1; i < values.length; ++i) {
                int intVal = (Integer)values[i];
                if (intVal <= max) continue;
                max = intVal;
            }
            if (this.replaceInParent(x, new SQLIntegerExpr(max))) {
                ++this.optimizedCount;
            }
            return;
        }
    }

    private void func_least(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() == 1) {
            if (this.replaceInParent(x, arguments.get(0).clone())) {
                ++this.optimizedCount;
            }
            return;
        }
        Object[] values = new Object[arguments.size()];
        Class<?> clazz = null;
        for (int i = 0; i < arguments.size(); ++i) {
            SQLExpr arg = arguments.get(i);
            if (arg instanceof SQLNullExpr) continue;
            Object value = ((SQLValuableExpr)arg).getValue();
            if (i == 0) {
                clazz = value.getClass();
            } else if (value.getClass() != clazz) {
                return;
            }
            values[i] = value;
        }
        if (clazz == Integer.class) {
            Integer min = null;
            for (int i = 0; i < values.length; ++i) {
                Integer obj = (Integer)values[i];
                if (obj == null || min != null && obj >= min) continue;
                min = obj;
            }
            if (min == null) {
                if (this.replaceInParent(x, new SQLNullExpr())) {
                    ++this.optimizedCount;
                }
            } else if (this.replaceInParent(x, new SQLIntegerExpr(min))) {
                ++this.optimizedCount;
            }
            return;
        }
    }

    private void func_period_add(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        if (arg0 instanceof SQLIntegerExpr && arg1 instanceof SQLIntegerExpr) {
            int year;
            int val = ((SQLIntegerExpr)arg0).getNumber().intValue();
            int delta = ((SQLIntegerExpr)arg1).getNumber().intValue();
            if (val == 0) {
                return;
            }
            if (val >= 100 && val < 10000) {
                val += 200000;
            }
            if ((year = val / 100) == 0) {
                year = 2000;
            }
            int month = val % 100 - 1;
            Calendar calendar = this.timeZone != null ? Calendar.getInstance(this.timeZone) : Calendar.getInstance();
            calendar.set(1, year);
            calendar.set(2, month);
            calendar.add(2, delta);
            int result = calendar.get(1) * 100 + calendar.get(2) + 1;
            if (this.replaceInParent(x, new SQLIntegerExpr(result))) {
                ++this.optimizedCount;
            }
        }
    }

    private void dateAdd(SQLMethodInvokeExpr x, SQLExpr arg0, SQLExpr arg1, boolean negative) {
        Object interval;
        String text;
        boolean timestamp = false;
        if (arg0 instanceof SQLCharExpr) {
            text = ((SQLCharExpr)arg0).getText();
            if (text.length() > 10) {
                timestamp = true;
            }
        } else if (arg0 instanceof SQLDateExpr) {
            text = ((SQLDateExpr)arg0).getLiteral();
        } else {
            text = ((SQLTimestampExpr)arg0).getLiteral();
            timestamp = true;
        }
        SQLIntervalUnit unit = null;
        SQLExpr valueExpr = null;
        if (arg1 instanceof SQLIntegerExpr) {
            valueExpr = arg1;
            unit = SQLIntervalUnit.DAY;
        } else {
            interval = (SQLIntervalExpr)arg1;
            unit = ((SQLIntervalExpr)interval).getUnit();
            valueExpr = ((SQLIntervalExpr)interval).getValue();
        }
        interval = null;
        if (valueExpr instanceof SQLIntegerExpr) {
            interval = ((SQLIntegerExpr)valueExpr).getNumber().intValue();
        } else if (valueExpr instanceof SQLCharExpr) {
            String intervalText = ((SQLCharExpr)valueExpr).getText();
            try {
                interval = Integer.parseInt(intervalText);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (interval == null) {
            return;
        }
        Date date = MySqlUtils.parseDate(text, this.timeZone);
        if (date != null && this.timeZone != null && unit != null) {
            int delta = (Integer)interval;
            if (negative) {
                delta = -delta;
            }
            Calendar calendar = Calendar.getInstance(this.timeZone);
            calendar.setTime(date);
            switch (unit) {
                case YEAR: {
                    calendar.add(1, delta);
                    break;
                }
                case MONTH: {
                    calendar.add(2, delta);
                    break;
                }
                case DAY: {
                    calendar.add(6, delta);
                    break;
                }
                case HOUR: {
                    calendar.add(11, delta);
                    break;
                }
                case MINUTE: {
                    calendar.add(12, delta);
                    break;
                }
                case SECOND: {
                    calendar.add(13, delta);
                    break;
                }
                default: {
                    return;
                }
            }
            SimpleDateFormat tzFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            tzFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            tzFormat.setTimeZone(this.timeZone);
            String result = tzFormat.format(calendar.getTime());
            SQLExprImpl replaceTo = result.endsWith(" 00:00:00") && !timestamp ? new SQLDateExpr(result.substring(0, result.length() - 9)) : new SQLTimestampExpr(result);
            if (this.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
            }
        }
    }

    static DateFormat dateFormatFromValue(String value) {
        return ConstFolding.dateFormatFromValue(value, null);
    }

    static DateFormat dateFormatFromValue(String value, TimeZone timeZone) {
        if (value == null) {
            return null;
        }
        SimpleDateFormat df = null;
        if (value.length() == 19) {
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        if (value.length() == 10) {
            if (value.endsWith("-00")) {
                return null;
            }
            df = new SimpleDateFormat("yyyy-MM-dd");
        }
        if (value.length() == 8) {
            df = new SimpleDateFormat("yyyyMMdd");
        }
        if (df != null && timeZone != null) {
            df.setTimeZone(timeZone);
        }
        return df;
    }

    static DateFormat mysqlDateFormat(String fmt, TimeZone timeZone) {
        if (fmt == null) {
            return null;
        }
        DateFormat df = MySqlUtils.toJavaFormat(fmt);
        if (df != null && timeZone != null) {
            df.setTimeZone(timeZone);
        }
        return df;
    }

    public void visitBinaryFunc(SQLBinaryOpExpr x) {
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        if (left instanceof SQLCastExpr && right instanceof SQLValuableExpr) {
            this.binaryOp_cast(x);
            return;
        }
        if (!(left instanceof SQLMethodInvokeExpr) || !(right instanceof SQLLiteralExpr)) {
            return;
        }
        SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)left;
        long methodNameHashCode64 = func.methodNameHashCode64();
        if (methodNameHashCode64 == FnvHash.Constants.DATE_FORMAT) {
            this.binaryOp_date_format(x);
        } else if (methodNameHashCode64 == FnvHash.Constants.DATE_DIFF || methodNameHashCode64 == FnvHash.Constants.DATEDIFF) {
            this.binaryOp_date_diff(x);
        } else if (methodNameHashCode64 == FnvHash.Constants.YEARMONTH) {
            this.binaryOp_yearmonth(x);
        } else if (methodNameHashCode64 == FnvHash.Constants.COALESCE) {
            this.binaryOp_coalesce(x);
        } else if (methodNameHashCode64 == FnvHash.Constants.ADDDATE || methodNameHashCode64 == FnvHash.Constants.DATE_ADD) {
            this.binaryOp_add_date(x);
        } else if (methodNameHashCode64 == FnvHash.Constants.SUBDATE) {
            this.binaryOp_sub_date(x);
        } else if (methodNameHashCode64 == FnvHash.Constants.FROM_UNIXTIME) {
            this.binaryOp_from_unixtime(x);
        } else if (methodNameHashCode64 == FnvHash.Constants.DATE) {
            this.binaryOp_date(x);
        }
    }

    public void binaryOp_cast(SQLBinaryOpExpr x) {
        SQLCastExpr cast = (SQLCastExpr)x.getLeft();
        SQLValuableExpr right = (SQLValuableExpr)x.getRight();
        SQLExpr expr = cast.getExpr();
        SQLDataType dataType = cast.getDataType();
        Object value = right.getValue();
        SQLDataType exprDataType = expr.computeDataType();
        if (exprDataType == null) {
            return;
        }
        if (!x.getOperator().isRelational()) {
            return;
        }
        SQLBinaryOperator op = x.getOperator();
        if (op == SQLBinaryOperator.Equality || op == SQLBinaryOperator.NotEqual || op == SQLBinaryOperator.LessThanOrGreater) {
            if (value instanceof String && dataType instanceof SQLCharacterDataType && exprDataType.isInt()) {
                try {
                    long longVal = Long.parseLong((String)value);
                    x.setRight(SQLIntegerExpr.ofIntOrLong(longVal));
                    x.setLeft(expr);
                }
                catch (NumberFormatException longVal) {}
            } else if (value instanceof Long && dataType.nameHashCode64() == FnvHash.Constants.BIGINT && exprDataType instanceof SQLCharacterDataType) {
                SQLCharExpr charExpr = new SQLCharExpr(value.toString());
                x.setRight(charExpr);
                x.setLeft(expr);
            } else if (value instanceof Long && dataType instanceof SQLCharacterDataType && exprDataType.nameHashCode64() == FnvHash.Constants.BIGINT) {
                x.setLeft(expr);
            }
        }
    }

    public void visitBinaryOpBinaryOpExpr(SQLBinaryOpExpr x) {
        if (!(x.getLeft() instanceof SQLBinaryOpExpr)) {
            return;
        }
        if (!(x.getRight() instanceof SQLNumericLiteralExpr)) {
            return;
        }
        SQLBinaryOpExpr left = (SQLBinaryOpExpr)x.getLeft();
        SQLExpr leftRight = left.getRight();
        if (!(leftRight instanceof SQLNumericLiteralExpr)) {
            return;
        }
        if (!x.getOperator().isRelational()) {
            return;
        }
        Number number = ((SQLNumericLiteralExpr)x.getRight()).getNumber();
        Number leftRightNumber = ((SQLNumericLiteralExpr)leftRight).getNumber();
        switch (left.getOperator()) {
            case DIV: 
            case Divide: {
                if (!(number instanceof Integer) || !(leftRightNumber instanceof Integer)) break;
                int intVal = number.intValue();
                int leftRightVal = leftRightNumber.intValue();
                long result = (long)intVal * (long)leftRightVal;
                x.setLeft(left.getLeft());
                x.setRight(SQLIntegerExpr.ofIntOrLong(result));
                this.visitBinaryFunc(x);
                this.visitBinaryOpBinaryOpExpr(x);
                break;
            }
            case Multiply: {
                if (!BigDecimal.ONE.equals(leftRightNumber) && !new BigDecimal("1.0").equals(leftRightNumber) || !(number instanceof Long)) break;
                x.setLeft(left.getLeft());
                break;
            }
        }
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        SQLSelectQueryBlock queryBlock;
        SQLExpr right;
        SQLBinaryOperator operator;
        block147: {
            SQLExpr left;
            if (this.isGroup(x)) {
                return super.visit(x);
            }
            x.getLeft().accept(this);
            x.getRight().accept(this);
            if (x.getLeft() instanceof SQLNullExpr || x.getRight() instanceof SQLNullExpr) {
                switch (x.getOperator()) {
                    case DIV: 
                    case Divide: 
                    case Multiply: 
                    case Add: 
                    case Subtract: {
                        if (!this.replaceInParent(x, new SQLNullExpr())) break;
                        return false;
                    }
                }
            }
            this.visitBinaryFunc(x);
            this.visitBinaryOpBinaryOpExpr(x);
            SQLExpr left2 = x.getLeft();
            SQLExpr right2 = x.getRight();
            switch (x.getOperator()) {
                case BooleanAnd: 
                case BooleanOr: 
                case BooleanXor: {
                    if (left2 instanceof SQLDateExpr || left2 instanceof SQLTimestampExpr) {
                        return false;
                    }
                    if (right2 instanceof SQLDateExpr || right2 instanceof SQLTimestampExpr) {
                        return false;
                    }
                    if (left2 instanceof SQLNumericLiteralExpr && right2 instanceof SQLBooleanExpr) {
                        boolean boolVal = ((SQLBooleanExpr)right2).getBooleanValue();
                        x.setRight(new SQLIntegerExpr(boolVal ? 1 : 0));
                        break;
                    }
                    if (left2 instanceof SQLBooleanExpr && right2 instanceof SQLNumericLiteralExpr) {
                        boolean boolVal = ((SQLBooleanExpr)left2).getBooleanValue();
                        x.setLeft(new SQLIntegerExpr(boolVal ? 1 : 0));
                        break;
                    }
                    if (right2 instanceof SQLBooleanExpr && (left2 instanceof SQLMethodInvokeExpr || left2 instanceof SQLCharExpr || left2 instanceof SQLName)) {
                        return false;
                    }
                    if (left2 instanceof SQLBooleanExpr && (right2 instanceof SQLMethodInvokeExpr || right2 instanceof SQLCharExpr || right2 instanceof SQLName)) {
                        return false;
                    }
                    if (left2 instanceof SQLBooleanExpr && right2 instanceof SQLBinaryOpExpr && !((SQLBinaryOpExpr)right2).getOperator().isRelational() && !((SQLBinaryOpExpr)right2).getOperator().isLogical()) {
                        return false;
                    }
                    if (!(right2 instanceof SQLBooleanExpr) || !(left2 instanceof SQLBinaryOpExpr) || ((SQLBinaryOpExpr)left2).getOperator().isRelational() || ((SQLBinaryOpExpr)left2).getOperator().isLogical()) break;
                    return false;
                }
                case Like: 
                case NotLike: 
                case RLike: 
                case NotRLike: {
                    if (left2 instanceof SQLIntegerExpr) {
                        x.setLeft(new SQLCharExpr(((SQLIntegerExpr)left2).getNumber().toString()));
                    }
                    if (!(right2 instanceof SQLIntegerExpr)) break;
                    x.setRight(new SQLCharExpr(((SQLIntegerExpr)right2).getNumber().toString()));
                    break;
                }
                case Multiply: {
                    SQLDataType leftDataType = left2.computeDataType();
                    if (right2 instanceof SQLIntervalExpr) {
                        SQLIntervalExpr newInterval;
                        SQLExpr value = ((SQLIntervalExpr)right2).getValue();
                        boolean one = false;
                        if (value instanceof SQLIntegerExpr && ((SQLIntegerExpr)value).getNumber() instanceof Integer && ((SQLIntegerExpr)value).getNumber().intValue() == 1) {
                            one = true;
                        } else if (value instanceof SQLCharExpr && ((SQLCharExpr)value).getText().equals("1")) {
                            one = true;
                        }
                        if (one && leftDataType != null && leftDataType.isInt() && this.replaceInParent(x, newInterval = new SQLIntervalExpr(left2.clone(), ((SQLIntervalExpr)right2).getUnit()))) {
                            return false;
                        }
                    }
                    if (!(right2 instanceof SQLIntegerExpr) || !(((SQLIntegerExpr)right2).getNumber() instanceof Integer) || ((SQLIntegerExpr)right2).getNumber().intValue() != 1) break;
                    this.replaceInParent(x, left2);
                    return false;
                }
                case COLLATE: {
                    if (!(left2 instanceof SQLCharExpr)) break;
                    this.replaceInParent(x, left2);
                    return false;
                }
            }
            left2 = x.getLeft();
            right2 = x.getRight();
            switch (x.getOperator()) {
                case Equality: {
                    boolean predicate;
                    if (left2 instanceof SQLNullExpr && right2 instanceof SQLLiteralExpr) {
                        this.replaceInParent(x, new SQLNullExpr());
                        break;
                    }
                    if (left2 instanceof SQLLiteralExpr && right2 instanceof SQLNullExpr) {
                        this.replaceInParent(x, new SQLNullExpr());
                        break;
                    }
                    if (left2 instanceof SQLLiteralExpr && right2 instanceof SQLLiteralExpr && left2.equals(right2)) {
                        this.replaceInParent(x, new SQLBooleanExpr(true));
                        break;
                    }
                    if (left2 instanceof SQLLiteralExpr && right2 instanceof SQLLiteralExpr && left2.getClass() == right2.getClass() && !left2.equals(right2)) {
                        this.replaceInParent(x, new SQLBooleanExpr(false));
                        break;
                    }
                    if (left2 instanceof SQLIdentifierExpr && right2 instanceof SQLIdentifierExpr && left2.equals(right2)) {
                        SQLColumnDefinition column = ((SQLIdentifierExpr)left2).getResolvedColumn();
                        if (column == null || !column.containsNotNullConstaint()) break;
                        this.replaceInParent(x, new SQLBooleanExpr(true));
                        break;
                    }
                    if (left2 instanceof SQLPropertyExpr && right2 instanceof SQLPropertyExpr && left2.equals(right2)) {
                        SQLColumnDefinition column = ((SQLPropertyExpr)left2).getResolvedColumn();
                        if (column != null && column.containsNotNullConstaint()) {
                            this.replaceInParent(x, new SQLBooleanExpr(true));
                            break;
                        }
                        this.replaceInParent(x, new SQLBinaryOpExpr(left2.clone(), SQLBinaryOperator.IsNot, new SQLNullExpr()));
                        break;
                    }
                    if (!(left2 instanceof SQLCastExpr)) break;
                    SQLCastExpr cast = (SQLCastExpr)left2;
                    SQLExpr castExpr = cast.getExpr();
                    boolean bl = predicate = x.getParent() instanceof SQLBinaryOpExprGroup || x.getParent() instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)x.getParent()).getOperator().isLogical();
                    if (!predicate || !(castExpr instanceof SQLIdentifierExpr) || castExpr.computeDataType() == null || !castExpr.computeDataType().isString() || !(right2 instanceof SQLIntegerExpr)) break;
                    this.replaceInParent(x, new SQLBinaryOpExpr(castExpr.clone(), SQLBinaryOperator.Equality, new SQLCharExpr(((SQLIntegerExpr)right2).getNumber().toString())));
                    break;
                }
                case GreaterThan: 
                case LessThan: {
                    SQLColumnDefinition column;
                    if (!(left2 instanceof SQLName) || !(right2 instanceof SQLName) || !left2.equals(right2) || (column = ((SQLName)left2).getResolvedColumn()) == null || !column.isPrimaryKey()) break;
                    this.replaceInParent(x, new SQLBooleanExpr(false));
                    break;
                }
                case NotEqual: 
                case LessThanOrGreater: {
                    if (!(left2 instanceof SQLLiteralExpr) || !(right2 instanceof SQLLiteralExpr) || left2.getClass() != right2.getClass()) break;
                    if (left2.equals(right2)) {
                        this.replaceInParent(x, new SQLBooleanExpr(false));
                        break;
                    }
                    this.replaceInParent(x, new SQLBooleanExpr(true));
                    break;
                }
                case BooleanOr: {
                    if (left2 instanceof SQLBooleanExpr) {
                        if (((SQLBooleanExpr)left2).getBooleanValue()) {
                            this.replaceInParent(x, left2);
                            break;
                        }
                        this.replaceInParent(x, right2);
                        break;
                    }
                    if (!(right2 instanceof SQLBooleanExpr)) break;
                    if (((SQLBooleanExpr)right2).getBooleanValue()) {
                        this.replaceInParent(x, right2);
                        break;
                    }
                    this.replaceInParent(x, left2);
                    break;
                }
                case BooleanAnd: {
                    if (left2 instanceof SQLBooleanExpr) {
                        if (((SQLBooleanExpr)left2).getBooleanValue()) {
                            this.replaceInParent(x, right2);
                            break;
                        }
                        this.replaceInParent(x, left2);
                        break;
                    }
                    if (!(right2 instanceof SQLBooleanExpr)) break;
                    if (((SQLBooleanExpr)right2).getBooleanValue()) {
                        this.replaceInParent(x, left2);
                        break;
                    }
                    this.replaceInParent(x, right2);
                    break;
                }
                case Like: {
                    SQLColumnDefinition column = null;
                    if (left2 instanceof SQLIdentifierExpr) {
                        column = ((SQLIdentifierExpr)left2).getResolvedColumn();
                    } else if (left2 instanceof SQLPropertyExpr) {
                        column = ((SQLPropertyExpr)left2).getResolvedColumn();
                    }
                    if (column == null || !column.containsNotNullConstaint() || !(right2 instanceof SQLCharExpr)) break;
                    boolean matchAll = false;
                    String pattern = ((SQLCharExpr)right2).getText();
                    if (pattern.length() > 0) {
                        int count = 0;
                        for (int i = 0; i < pattern.length(); ++i) {
                            char ch = pattern.charAt(i);
                            if (ch != '%') continue;
                            ++count;
                        }
                        if (count == pattern.length()) {
                            matchAll = true;
                        }
                    }
                    if (!matchAll) break;
                    this.replaceInParent(x, new SQLBooleanExpr(true));
                    break;
                }
            }
            operator = x.getOperator();
            if ((operator == SQLBinaryOperator.BooleanAnd || operator == SQLBinaryOperator.BooleanOr) && x.getLeft() instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)x.getLeft()).getOperator() == x.getOperator()) {
                SQLBinaryOpExprGroup group = new SQLBinaryOpExprGroup(operator, x.getDbType());
                group.add(x.getLeft());
                group.add(x.getRight());
                if (this.replaceInParent(x, group)) {
                    ++this.optimizedCount;
                    group.accept(this);
                    return false;
                }
            }
            if (x.getOperator() == SQLBinaryOperator.BooleanAnd) {
                boolean booleanValue;
                SQLExpr replaceTo;
                boolean booleanValue2;
                SQLExpr replaceTo2;
                left = x.getLeft();
                if (left instanceof SQLBooleanExpr && this.replaceInParent(x, replaceTo2 = (booleanValue2 = ((SQLBooleanExpr)left).getBooleanValue()) ? x.getRight() : x.getLeft())) {
                    ++this.optimizedCount;
                    return false;
                }
                SQLExpr right3 = x.getRight();
                if (right3 instanceof SQLBooleanExpr && this.replaceInParent(x, replaceTo = (booleanValue = ((SQLBooleanExpr)right3).getBooleanValue()) ? x.getLeft() : x.getRight())) {
                    ++this.optimizedCount;
                    return false;
                }
            }
            if (x.getOperator() == SQLBinaryOperator.BooleanOr) {
                SQLExpr right4;
                left = x.getLeft();
                if (left instanceof SQLBooleanExpr) {
                    if (((SQLBooleanExpr)left).getBooleanValue()) {
                        if (this.replaceInParent(x, x.getRight())) {
                            ++this.optimizedCount;
                            return false;
                        }
                    } else if (this.replaceInParent(x, new SQLBooleanExpr(true))) {
                        ++this.optimizedCount;
                        return false;
                    }
                }
                if ((right4 = x.getRight()) instanceof SQLBooleanExpr) {
                    if (((SQLBooleanExpr)right4).getBooleanValue()) {
                        if (this.replaceInParent(x, x.getLeft())) {
                            ++this.optimizedCount;
                            return false;
                        }
                    } else if (this.replaceInParent(x, new SQLBooleanExpr(true))) {
                        ++this.optimizedCount;
                        return false;
                    }
                }
            }
            if (operator == SQLBinaryOperator.Like && x.getRight() instanceof SQLCharExpr || operator != SQLBinaryOperator.NotLike || x.getRight() instanceof SQLCharExpr) {
                // empty if block
            }
            if (ConstFolding.isNameAndLiteral(x.getLeft()) && x.getRight() instanceof SQLLiteralExpr) {
                left = (SQLBinaryOpExpr)x.getLeft();
                SQLLiteralExpr right5 = (SQLLiteralExpr)x.getRight();
                if (((SQLBinaryOpExpr)left).getRight() instanceof SQLLiteralExpr) {
                    SQLLiteralExpr leftRight = (SQLLiteralExpr)((SQLBinaryOpExpr)left).getRight();
                    if (((SQLBinaryOpExpr)left).getOperator() == x.getOperator()) {
                        switch (((SQLBinaryOpExpr)left).getOperator()) {
                            case Multiply: 
                            case Add: 
                            case Concat: {
                                x.setLeft(((SQLBinaryOpExpr)left).getLeft());
                                x.setRight(new SQLBinaryOpExpr((SQLExpr)leftRight, ((SQLBinaryOpExpr)left).getOperator(), right5));
                                x.getRight().accept(this);
                                break;
                            }
                            case Subtract: {
                                x.setLeft(((SQLBinaryOpExpr)left).getLeft());
                                x.setRight(new SQLBinaryOpExpr((SQLExpr)leftRight, SQLBinaryOperator.Add, right5));
                                x.getRight().accept(this);
                                break;
                            }
                        }
                    }
                } else {
                    SQLLiteralExpr leftLeft = (SQLLiteralExpr)((SQLBinaryOpExpr)left).getLeft();
                    if (((SQLBinaryOpExpr)left).getOperator() == x.getOperator()) {
                        switch (((SQLBinaryOpExpr)left).getOperator()) {
                            case Multiply: 
                            case Add: 
                            case Concat: {
                                x.setLeft(((SQLBinaryOpExpr)left).getRight());
                                x.setRight(new SQLBinaryOpExpr((SQLExpr)leftLeft, ((SQLBinaryOpExpr)left).getOperator(), right5));
                                x.getRight().accept(this);
                                break;
                            }
                        }
                    }
                }
            }
            if (x.getLeft() instanceof SQLIntervalExpr && (x.getRight() instanceof SQLCharExpr || x.getRight() instanceof SQLDateExpr || x.getRight() instanceof SQLTimestampExpr)) {
                left = x.getLeft();
                SQLExpr right6 = x.getRight();
                x.setRight(left);
                x.setLeft(right6);
            }
            boolean charAddInterval = false;
            if (x.getLeft() instanceof SQLCharExpr && x.getRight() instanceof SQLIntervalExpr) {
                String text = ((SQLCharExpr)x.getLeft()).getText();
                Date date = MySqlUtils.parseDate(text, this.timeZone);
                if (date == null) {
                    return false;
                }
                if (text.length() <= 10) {
                    x.setLeft(new SQLDateExpr(date, this.timeZone));
                } else {
                    x.setLeft(new SQLTimestampExpr(date, this.timeZone));
                }
                charAddInterval = true;
            }
            if (x.getLeft() instanceof SQLValuableExpr && x.getRight() instanceof SQLValuableExpr) {
                this.handValueValue(x);
                return false;
            }
            if ((x.getLeft() instanceof SQLDateExpr || x.getLeft() instanceof SQLTimestampExpr) && x.getRight() instanceof SQLIntervalExpr && (operator == SQLBinaryOperator.Add || operator == SQLBinaryOperator.Subtract)) {
                Date dateChanged;
                Date date;
                int intervalInt;
                String text;
                boolean datetime = false;
                SQLExpr left3 = x.getLeft();
                if (left3 instanceof SQLDateExpr) {
                    text = ((SQLDateExpr)left3).getValue();
                } else {
                    text = ((SQLTimestampExpr)left3).getValue();
                    datetime = true;
                }
                right = (SQLIntervalExpr)x.getRight();
                if (((SQLIntervalExpr)right).getValue() instanceof SQLCharExpr) {
                    String intervalText = ((SQLCharExpr)((SQLIntervalExpr)right).getValue()).getText();
                    try {
                        intervalInt = Integer.parseInt(intervalText);
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                } else if (((SQLIntervalExpr)right).getValue() instanceof SQLIntegerExpr) {
                    intervalInt = ((SQLIntegerExpr)((SQLIntervalExpr)right).getValue()).getNumber().intValue();
                } else {
                    return false;
                }
                if (operator == SQLBinaryOperator.Subtract) {
                    intervalInt = -intervalInt;
                }
                if ((date = MySqlUtils.parseDate(text, this.timeZone)) == null) {
                    return false;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                boolean changed = SQLIntervalUnit.add(calendar, intervalInt, ((SQLIntervalExpr)right).getUnit());
                if (!changed) {
                    return false;
                }
                if (((SQLIntervalExpr)right).getUnit().isDateTime()) {
                    datetime = true;
                }
                if ((dateChanged = calendar.getTime()) != null) {
                    SQLExprImpl replaceTo;
                    if (charAddInterval) {
                        SimpleDateFormat dateFormat = datetime ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
                        if (this.timeZone != null) {
                            dateFormat.setTimeZone(this.timeZone);
                        }
                        replaceTo = new SQLCharExpr(dateFormat.format(dateChanged));
                    } else {
                        SQLExprImpl sQLExprImpl = replaceTo = datetime ? new SQLTimestampExpr(dateChanged, this.timeZone) : new SQLDateExpr(dateChanged, this.timeZone);
                    }
                    if (this.replaceInParent(x, replaceTo)) {
                        ++this.optimizedCount;
                        return false;
                    }
                }
            }
            if (x.isLeftLiteralAndRightName()) {
                SQLName right7 = (SQLName)x.getRight();
                SQLLiteralExpr left4 = (SQLLiteralExpr)x.getLeft();
                switch (x.getOperator()) {
                    case LessThan: {
                        x.setRight(left4);
                        x.setLeft(right7);
                        x.setOperator(SQLBinaryOperator.GreaterThan);
                        ++this.optimizedCount;
                        break;
                    }
                    case LessThanOrEqual: {
                        x.setRight(left4);
                        x.setLeft(right7);
                        x.setOperator(SQLBinaryOperator.GreaterThanOrEqual);
                        ++this.optimizedCount;
                        break;
                    }
                    case Equality: {
                        x.setRight(left4);
                        x.setLeft(right7);
                        break;
                    }
                    case GreaterThanOrEqual: {
                        x.setRight(left4);
                        x.setLeft(right7);
                        x.setOperator(SQLBinaryOperator.LessThanOrEqual);
                        ++this.optimizedCount;
                        break;
                    }
                    case GreaterThan: {
                        x.setRight(left4);
                        x.setLeft(right7);
                        x.setOperator(SQLBinaryOperator.LessThan);
                        ++this.optimizedCount;
                        break;
                    }
                }
            }
            if (x.isLeftNameAndRightLiteral()) {
                SQLName name = (SQLName)x.getLeft();
                SQLLiteralExpr literal = (SQLLiteralExpr)x.getRight();
                switch (operator) {
                    case Like: 
                    case NotLike: {
                        break;
                    }
                    default: {
                        this.handleNameLiteral(x, name, literal);
                    }
                }
            }
            if (x.isLeftFunctionAndRightLiteral()) {
                long dataTypeNameHash;
                SQLMethodInvokeExpr functionCall = (SQLMethodInvokeExpr)x.getLeft();
                SQLLiteralExpr literal = (SQLLiteralExpr)x.getRight();
                long nameHash = functionCall.methodNameHashCode64();
                SQLDataType dataType = functionCall.getResolvedReturnDataType();
                if (dataType != null && (dataTypeNameHash = dataType.nameHashCode64()) == FnvHash.Constants.BIGINT && literal instanceof SQLCharExpr) {
                    String text = ((SQLCharExpr)literal).getText();
                    try {
                        long val = Long.parseLong(text);
                        x.setRight(new SQLIntegerExpr(val));
                        ++this.optimizedCount;
                    }
                    catch (NumberFormatException ex) {
                        if (!this.replaceInParent(x, new SQLBooleanExpr(false))) break block147;
                        ++this.optimizedCount;
                        return false;
                    }
                }
            }
        }
        if (operator == SQLBinaryOperator.BooleanAnd) {
            if (ConstFolding.isLeftNameAndRightLiteral(x.getLeft()) && ConstFolding.isLeftNameAndRightLiteral(x.getRight())) {
                SQLBinaryOpExpr left = (SQLBinaryOpExpr)x.getLeft();
                SQLBinaryOpExpr right8 = (SQLBinaryOpExpr)x.getRight();
                this.mergeTwiceOp(x, left, right8);
            } else if (ConstFolding.isBothName(x.getLeft()) && ConstFolding.isLeftNameAndRightLiteral(x.getRight())) {
                SQLBinaryOpExpr left = (SQLBinaryOpExpr)x.getLeft();
                SQLBinaryOpExpr right9 = (SQLBinaryOpExpr)x.getRight();
                if (left.getOperator() == right9.getOperator()) {
                    if (left.isBothName()) {
                        SQLBinaryOpExpr replaceTo;
                        if (left.getLeft().equals(right9.getLeft())) {
                            SQLBinaryOpExpr left2 = left.clone();
                            left2.setLeft(right9.getRight().clone());
                            replaceTo = new SQLBinaryOpExpr((SQLExpr)left, SQLBinaryOperator.BooleanAnd, left2);
                            x.setLeft(replaceTo);
                            ++this.optimizedCount;
                        } else if (left.getRight().equals(right9.getLeft())) {
                            SQLBinaryOpExpr left2 = left.clone();
                            left2.setRight(right9.getRight().clone());
                            replaceTo = new SQLBinaryOpExpr((SQLExpr)left, SQLBinaryOperator.BooleanAnd, left2);
                            x.setLeft(replaceTo);
                            ++this.optimizedCount;
                        }
                    } else if (left.getLeft().equals(right9.getLeft())) {
                        left.setLeft(right9.getRight().clone());
                        ++this.optimizedCount;
                    } else if (left.getRight().equals(right9.getLeft())) {
                        left.setRight(right9.getRight().clone());
                        ++this.optimizedCount;
                    }
                }
            }
        } else if (operator == SQLBinaryOperator.BooleanOr && ConstFolding.isLeftNameAndRightLiteral(x.getLeft()) && ConstFolding.isLeftNameAndRightLiteral(x.getRight())) {
            SQLBinaryOpExpr left = (SQLBinaryOpExpr)x.getLeft();
            SQLBinaryOpExpr right10 = (SQLBinaryOpExpr)x.getRight();
            this.mergeTwiceOp(x, left, right10);
        }
        if (ConstFolding.isLeftNameAndRightLiteral(x.getLeft()) && x.getRight() instanceof SQLLiteralExpr && (operator == SQLBinaryOperator.Equality || operator == SQLBinaryOperator.NotEqual || operator == SQLBinaryOperator.LessThanOrGreater || operator == SQLBinaryOperator.LessThanOrEqual || operator == SQLBinaryOperator.LessThan || operator == SQLBinaryOperator.GreaterThanOrEqual || operator == SQLBinaryOperator.GreaterThan)) {
            SQLBinaryOpExpr left = (SQLBinaryOpExpr)x.getLeft();
            SQLExpr leftRight = left.getRight();
            SQLExpr leftLeft = left.getLeft();
            right = x.getRight();
            SQLNumberExpr valuExpr = null;
            switch (left.getOperator()) {
                case Add: {
                    if (leftRight instanceof SQLIntegerExpr && right instanceof SQLIntegerExpr) {
                        int val = ((SQLIntegerExpr)right).getNumber().intValue() - ((SQLIntegerExpr)leftRight).getNumber().intValue();
                        x.setRight(new SQLIntegerExpr(val));
                        x.setLeft(leftLeft);
                        ++this.optimizedCount;
                        return false;
                    }
                    if (!(leftRight instanceof SQLIntegerExpr) || !(right instanceof SQLNumberExpr)) break;
                    Number leftRightVal = ((SQLIntegerExpr)leftRight).getNumber();
                    Number rightVal = ((SQLNumberExpr)right).getNumber();
                    if (!(rightVal instanceof BigDecimal) || !(leftRightVal instanceof Integer)) break;
                    BigDecimal rightDecimal = (BigDecimal)rightVal;
                    BigDecimal leftRightDecimal = new BigDecimal(leftRightVal.intValue());
                    valuExpr = new SQLNumberExpr(rightDecimal.subtract(leftRightDecimal));
                    break;
                }
                case Subtract: {
                    if (leftRight instanceof SQLIntegerExpr && right instanceof SQLIntegerExpr) {
                        int val = ((SQLIntegerExpr)right).getNumber().intValue() + ((SQLIntegerExpr)leftRight).getNumber().intValue();
                        x.setRight(new SQLIntegerExpr(val));
                        x.setLeft(leftLeft);
                        ++this.optimizedCount;
                        return false;
                    }
                    if (!(leftRight instanceof SQLIntegerExpr) || !(right instanceof SQLNumberExpr)) break;
                    Number leftRightVal = ((SQLIntegerExpr)leftRight).getNumber();
                    Number rightVal = ((SQLNumberExpr)right).getNumber();
                    if (!(rightVal instanceof BigDecimal) || !(leftRightVal instanceof Integer)) break;
                    BigDecimal rightDecimal = (BigDecimal)rightVal;
                    BigDecimal leftRightDecimal = new BigDecimal(leftRightVal.intValue());
                    valuExpr = new SQLNumberExpr(rightDecimal.add(leftRightDecimal));
                    break;
                }
            }
            if (valuExpr != null) {
                x.setRight(valuExpr);
                x.setLeft(leftLeft);
                ++this.optimizedCount;
                return false;
            }
        }
        if (operator == SQLBinaryOperator.Equality && x.isLeftNameAndRightLiteral() && x.getParent() instanceof SQLSelectQueryBlock && (queryBlock = (SQLSelectQueryBlock)x.getParent()).getLimit() == null && queryBlock.getFrom() instanceof SQLJoinTableSource && ConstFolding.isBothName(((SQLJoinTableSource)queryBlock.getFrom()).getCondition())) {
            SQLJoinTableSource joinTableSource = (SQLJoinTableSource)queryBlock.getFrom();
            SQLBinaryOpExpr joinCondition = (SQLBinaryOpExpr)joinTableSource.getCondition();
            if (joinTableSource.getJoinType() == SQLJoinTableSource.JoinType.INNER_JOIN && joinCondition.getOperator() == SQLBinaryOperator.Equality && joinCondition.getLeft().equals(x.getLeft())) {
                SQLExpr to = SQLBinaryOpExpr.and(joinCondition.clone(), x.clone(), new SQLBinaryOpExpr(joinCondition.getRight().clone(), SQLBinaryOperator.Equality, x.getRight().clone()));
                if (this.replaceInParent(x, null)) {
                    joinTableSource.setCondition(to);
                    ++this.optimizedCount;
                    return false;
                }
            }
        }
        return false;
    }

    public void binaryOp_date(SQLBinaryOpExpr x) {
        SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)x.getLeft();
        if (func.getArguments().size() != 1) {
            return;
        }
        SQLExpr arg0 = func.getArguments().get(0);
        SQLExpr right = x.getRight();
        SQLDataType dataType = arg0.computeDataType();
        if (dataType == null) {
            return;
        }
        if (dataType.nameHashCode64() != FnvHash.Constants.TIMESTAMP && dataType.nameHashCode64() != FnvHash.Constants.DATETIME) {
            return;
        }
        Date date = null;
        if (right instanceof SQLCharExpr) {
            String text = ((SQLCharExpr)right).getText();
            SimpleDateFormat dateFormat = null;
            if (text.length() == 10) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            }
            if (dateFormat == null) {
                return;
            }
            if (this.timeZone != null) {
                dateFormat.setTimeZone(this.timeZone);
            }
            try {
                date = dateFormat.parse(text);
            }
            catch (ParseException parseException) {}
        } else if (right instanceof SQLDateExpr) {
            date = ((SQLDateExpr)right).getDate(this.timeZone);
        }
        if (date == null) {
            return;
        }
        SQLBinaryOpExpr replaceTo = null;
        switch (x.getOperator()) {
            case Equality: {
                Date nextDate = this.nextDate(date);
                SQLBinaryOpExpr ge = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.GreaterThanOrEqual, new SQLTimestampExpr(date, this.timeZone));
                SQLBinaryOpExpr lt = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.LessThan, new SQLTimestampExpr(nextDate, this.timeZone));
                replaceTo = new SQLBinaryOpExpr((SQLExpr)ge, SQLBinaryOperator.BooleanAnd, lt);
                break;
            }
            case NotEqual: 
            case LessThanOrGreater: {
                Date nextDate = this.nextDate(date);
                SQLBinaryOpExpr lt = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.LessThan, new SQLTimestampExpr(date, this.timeZone));
                SQLBinaryOpExpr ge = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.GreaterThanOrEqual, new SQLTimestampExpr(nextDate, this.timeZone));
                replaceTo = new SQLBinaryOpExpr((SQLExpr)lt, SQLBinaryOperator.BooleanOr, ge);
                break;
            }
            case LessThanOrEqual: {
                Date nextDate = this.nextDate(date);
                replaceTo = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.LessThan, new SQLTimestampExpr(nextDate, this.timeZone));
                break;
            }
            case GreaterThan: 
            case GreaterThanOrEqual: 
            case LessThan: {
                replaceTo = new SQLBinaryOpExpr(arg0.clone(), x.getOperator(), new SQLTimestampExpr(date, this.timeZone));
                break;
            }
        }
        if (replaceTo != null) {
            this.replaceInParent(x, replaceTo);
        }
    }

    private Date nextDate(Date date) {
        Calendar calendar = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public void binaryOp_coalesce(SQLBinaryOpExpr x) {
        SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)x.getLeft();
        if (func.getArguments().size() != 2) {
            return;
        }
        SQLExpr arg0 = func.getArguments().get(0);
        SQLExpr arg1 = func.getArguments().get(1);
        SQLExpr right = x.getRight();
        if (!(arg0 instanceof SQLName)) {
            return;
        }
        if (!(arg1 instanceof SQLLiteralExpr)) {
            return;
        }
        if (!(right instanceof SQLLiteralExpr)) {
            return;
        }
        SQLBinaryOpExpr replaceTo = null;
        switch (x.getOperator()) {
            case NotEqual: 
            case LessThanOrGreater: {
                if (!arg1.equals(right)) break;
                replaceTo = new SQLBinaryOpExpr((SQLExpr)SQLBinaryOpExpr.isNotNull(arg0.clone()), SQLBinaryOperator.BooleanAnd, new SQLBinaryOpExpr(arg0.clone(), x.getOperator(), right.clone()));
                break;
            }
        }
        if (replaceTo != null) {
            this.replaceInParent(x, replaceTo);
        }
    }

    public void binaryOp_yearmonth(SQLBinaryOpExpr x) {
        SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)x.getLeft();
        if (func.getArguments().size() != 1) {
            return;
        }
        SQLExpr arg0 = func.getArguments().get(0);
        SQLExpr right = x.getRight();
        if (!(right instanceof SQLCharExpr)) {
            return;
        }
        String text = ((SQLCharExpr)right).getText();
        Date date = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        try {
            date = dateFormat.parse(text);
        }
        catch (ParseException e) {
            return;
        }
        if (date == null) {
            return;
        }
        if (!(arg0 instanceof SQLName)) {
            return;
        }
        SQLDataType dataType = arg0.computeDataType();
        if (dataType == null) {
            return;
        }
        Calendar calendar = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
        SQLBinaryOpExpr replaceTo = null;
        SQLExprImpl ts = null;
        SQLExprImpl next_month = null;
        if (dataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP) {
            ts = new SQLTimestampExpr(date, this.timeZone);
            calendar.setTime(date);
            calendar.add(2, 1);
            next_month = new SQLTimestampExpr(calendar.getTime(), this.timeZone);
        } else if (dataType.nameHashCode64() == FnvHash.Constants.DATE) {
            ts = new SQLDateExpr(date, this.timeZone);
            calendar.setTime(date);
            calendar.add(2, 1);
            next_month = new SQLDateExpr(calendar.getTime(), this.timeZone);
        } else {
            return;
        }
        switch (x.getOperator()) {
            case Equality: {
                SQLBinaryOpExpr gteq = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.GreaterThanOrEqual, ts);
                SQLBinaryOpExpr le = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.LessThan, next_month);
                replaceTo = new SQLBinaryOpExpr((SQLExpr)gteq, SQLBinaryOperator.BooleanAnd, le);
                break;
            }
            case GreaterThanOrEqual: 
            case LessThan: {
                x.setLeft(arg0.clone());
                x.setRight(ts);
                ++this.optimizedCount;
                break;
            }
            case GreaterThan: {
                replaceTo = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.GreaterThanOrEqual, next_month);
                break;
            }
            case LessThanOrEqual: {
                replaceTo = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.LessThan, next_month);
                break;
            }
        }
        if (replaceTo != null && this.replaceInParent(x, replaceTo)) {
            ++this.optimizedCount;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void binaryOp_date_diff(SQLBinaryOpExpr x) {
        SQLTimestampExpr ts;
        int intVal;
        SQLExpr arg2;
        SQLExpr arg1;
        SQLExpr arg0;
        SQLExpr right = x.getRight();
        SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)x.getLeft();
        List<SQLExpr> arguments = func.getArguments();
        if (arguments.size() < 2) {
            return;
        }
        if (arguments.size() == 3) {
            arg0 = arguments.get(0);
            arg1 = arguments.get(1);
            arg2 = arguments.get(2);
        } else {
            if (arguments.size() != 2) return;
            arg0 = new SQLCharExpr("DAY");
            arg1 = arguments.get(0);
            arg2 = arguments.get(1);
        }
        Object value = null;
        if (right instanceof SQLValuableExpr) {
            value = ((SQLValuableExpr)right).getValue();
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            if (decimal.scale() == 0) {
                intVal = decimal.intValue();
            } else {
                if (decimal.scale() != 1 || !decimal.toString().endsWith(".0")) return;
                intVal = decimal.intValue();
            }
        } else if (value instanceof Integer) {
            intVal = (Integer)value;
        } else {
            if (!(value instanceof Long)) return;
            long longVal = (Long)value;
            if (longVal < Integer.MIN_VALUE || longVal > Integer.MAX_VALUE) return;
            intVal = (int)longVal;
        }
        int field = -1;
        if (arg0 instanceof SQLCharExpr) {
            long fieldHash = FnvHash.hashCode64(((SQLCharExpr)arg0).getText());
            if (FnvHash.Constants.HOUR == fieldHash) {
                field = 11;
            } else if (FnvHash.Constants.MINUTE == fieldHash) {
                field = 12;
            } else if (FnvHash.Constants.SECOND == fieldHash) {
                field = 13;
            } else if (FnvHash.Constants.DAY == fieldHash) {
                field = 5;
            } else if (FnvHash.Constants.MONTH == fieldHash) {
                field = 2;
            } else if (FnvHash.Constants.YEAR == fieldHash) {
                field = 1;
            }
        }
        if (field == -1) {
            return;
        }
        Calendar calendar = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
        Date date = null;
        SQLDataType dataType = null;
        SQLBinaryOpExpr replaceTo = null;
        if (arg1 instanceof SQLName && (arg2 instanceof SQLTimestampExpr || arg2 instanceof SQLDateExpr)) {
            if (arg2 instanceof SQLTimestampExpr) {
                date = ((SQLTimestampExpr)arg2).getDate(this.timeZone);
            } else if (arg2 instanceof SQLDateExpr) {
                date = ((SQLDateExpr)arg2).getDate(this.timeZone);
            }
            dataType = arg1.computeDataType();
        } else {
            if (!(arg2 instanceof SQLName) || !(arg1 instanceof SQLTimestampExpr) && !(arg1 instanceof SQLDateExpr) && !(arg1 instanceof SQLCharExpr)) return;
            if (arg1 instanceof SQLTimestampExpr) {
                date = ((SQLTimestampExpr)arg1).getDate(this.timeZone);
            } else if (arg1 instanceof SQLDateExpr) {
                date = ((SQLDateExpr)arg1).getDate(this.timeZone);
            } else if (arg1 instanceof SQLCharExpr) {
                String text = ((SQLCharExpr)arg1).getText();
                date = MySqlUtils.parseDate(text, this.timeZone);
            }
            dataType = arg2.computeDataType();
        }
        if (date == null) {
            return;
        }
        calendar.setTime(date);
        if (arg1 instanceof SQLName) {
            calendar.add(field, intVal);
        } else {
            calendar.add(field, -intVal);
        }
        if (dataType == null) {
            return;
        }
        if (arg1 instanceof SQLName) {
            if (dataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP) {
                switch (x.getOperator()) {
                    case GreaterThan: 
                    case GreaterThanOrEqual: 
                    case LessThan: 
                    case LessThanOrEqual: {
                        ts = new SQLTimestampExpr(calendar.getTime(), this.timeZone);
                        replaceTo = new SQLBinaryOpExpr(arg1.clone(), x.getOperator(), ts);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (dataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP) {
            ts = new SQLTimestampExpr(calendar.getTime(), this.timeZone);
            SQLBinaryOperator op = null;
            switch (x.getOperator()) {
                case LessThan: {
                    op = SQLBinaryOperator.GreaterThan;
                    break;
                }
                case LessThanOrEqual: {
                    op = SQLBinaryOperator.GreaterThanOrEqual;
                    break;
                }
                case GreaterThan: {
                    op = SQLBinaryOperator.LessThan;
                    break;
                }
                case GreaterThanOrEqual: {
                    op = SQLBinaryOperator.LessThanOrEqual;
                    break;
                }
            }
            if (op != null) {
                replaceTo = new SQLBinaryOpExpr(arg2.clone(), op, ts);
            }
        }
        if (replaceTo == null || !this.replaceInParent(x, replaceTo)) return;
        ++this.optimizedCount;
    }

    public void binaryOp_date_format(SQLBinaryOpExpr x) {
        block30: {
            SQLBinaryOperator op;
            Date date;
            String fmt;
            SQLDataType dataType;
            SQLExpr arg0;
            block29: {
                SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)x.getLeft();
                if (func.getArguments().size() != 2) {
                    return;
                }
                arg0 = func.getArguments().get(0);
                SQLExpr arg1 = func.getArguments().get(1);
                SQLLiteralExpr val = (SQLLiteralExpr)x.getRight();
                boolean timestampCastToDate = false;
                if (arg0 instanceof SQLCastExpr) {
                    SQLCastExpr cast = (SQLCastExpr)arg0;
                    SQLExpr expr = cast.getExpr();
                    if (expr == null) {
                        return;
                    }
                    SQLDataType exprDataType = expr.computeDataType();
                    if (exprDataType == null) {
                        return;
                    }
                    if (expr instanceof SQLName && exprDataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP && cast.dateTypeHashCode() == FnvHash.Constants.DATE) {
                        arg0 = expr;
                        timestampCastToDate = true;
                    }
                }
                dataType = null;
                if (!(arg0 instanceof SQLName)) {
                    return;
                }
                dataType = arg0.computeDataType();
                if (dataType == null) {
                    return;
                }
                fmt = null;
                DateFormat javaFormat = null;
                if (arg1 instanceof SQLCharExpr) {
                    boolean containsYMD;
                    fmt = ((SQLCharExpr)arg1).getText();
                    boolean bl = containsYMD = fmt.contains("%Y") && fmt.contains("%m") && fmt.contains("%d");
                    if (!containsYMD) {
                        return;
                    }
                    javaFormat = MySqlUtils.toJavaFormat(fmt, this.timeZone);
                }
                if (javaFormat == null) {
                    return;
                }
                if (timestampCastToDate && !"%Y%m%d".equals(fmt) && !"%Y-%m-%d".equals(fmt)) {
                    return;
                }
                date = null;
                if (val instanceof SQLCharExpr) {
                    try {
                        date = javaFormat.parse(((SQLCharExpr)val).getText());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (date == null) {
                    return;
                }
                op = x.getOperator();
                if (dataType.nameHashCode64() != FnvHash.Constants.TIMESTAMP) break block29;
                SQLTimestampExpr ts = new SQLTimestampExpr(date, this.timeZone);
                switch (op) {
                    case Equality: {
                        if (!"%Y%m%d".equals(fmt) && !"%Y-%m-%d".equals(fmt)) break;
                        SQLBinaryOpExpr gteq = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.GreaterThanOrEqual, ts.clone());
                        ts.addDay(1);
                        SQLBinaryOpExpr le = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.LessThan, ts);
                        SQLBinaryOpExpr replaceTo = new SQLBinaryOpExpr((SQLExpr)gteq, SQLBinaryOperator.BooleanAnd, le);
                        if (this.replaceInParent(x, replaceTo)) {
                            ++this.optimizedCount;
                            break;
                        }
                        break block30;
                    }
                    case GreaterThanOrEqual: 
                    case LessThan: {
                        x.setLeft(arg0.clone());
                        x.setRight(ts);
                        ++this.optimizedCount;
                        break;
                    }
                    case GreaterThan: {
                        if (!"%Y%m%d".equals(fmt) && !"%Y-%m-%d".equals(fmt)) break;
                        ts.addDay(1);
                        x.setLeft(arg0.clone());
                        x.setRight(ts);
                        x.setOperator(SQLBinaryOperator.GreaterThanOrEqual);
                        ++this.optimizedCount;
                        break;
                    }
                    case LessThanOrEqual: {
                        if (!"%Y%m%d".equals(fmt) && !"%Y-%m-%d".equals(fmt)) break;
                        ts.addDay(1);
                        x.setLeft(arg0.clone());
                        x.setRight(ts);
                        x.setOperator(SQLBinaryOperator.LessThan);
                        ++this.optimizedCount;
                        break;
                    }
                }
                break block30;
            }
            if (dataType.nameHashCode64() == FnvHash.Constants.DATE) {
                SQLDateExpr ts = new SQLDateExpr(date, this.timeZone);
                switch (op) {
                    case Equality: {
                        if (!"%Y%m%d".equals(fmt) && !"%Y-%m-%d".equals(fmt)) break;
                        SQLBinaryOpExpr gteq = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.GreaterThanOrEqual, ts.clone());
                        ts.addDay(1);
                        SQLBinaryOpExpr le = new SQLBinaryOpExpr(arg0.clone(), SQLBinaryOperator.LessThan, ts);
                        SQLBinaryOpExpr replaceTo = new SQLBinaryOpExpr((SQLExpr)gteq, SQLBinaryOperator.BooleanAnd, le);
                        if (!this.replaceInParent(x, replaceTo)) break;
                        ++this.optimizedCount;
                        break;
                    }
                    case GreaterThanOrEqual: 
                    case LessThan: {
                        x.setLeft(arg0.clone());
                        x.setRight(ts);
                        ++this.optimizedCount;
                        break;
                    }
                    case GreaterThan: {
                        if (!"%Y%m%d".equals(fmt) && !"%Y-%m-%d".equals(fmt)) break;
                        ts.addDay(1);
                        x.setLeft(arg0.clone());
                        x.setRight(ts);
                        x.setOperator(SQLBinaryOperator.GreaterThanOrEqual);
                        ++this.optimizedCount;
                        break;
                    }
                    case LessThanOrEqual: {
                        if (!"%Y%m%d".equals(fmt) && !"%Y-%m-%d".equals(fmt)) break;
                        ts.addDay(1);
                        x.setLeft(arg0.clone());
                        x.setRight(ts);
                        x.setOperator(SQLBinaryOperator.LessThan);
                        ++this.optimizedCount;
                        break;
                    }
                }
            }
        }
    }

    public void binaryOp_add_date(SQLBinaryOpExpr x) {
        SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)x.getLeft();
        List<SQLExpr> arguments = func.getArguments();
        if (arguments.size() == 2) {
            SQLExpr arg0 = func.getArguments().get(0);
            SQLExpr arg1 = func.getArguments().get(1);
            SQLLiteralExpr val = (SQLLiteralExpr)x.getRight();
            if (!(arg0 instanceof SQLName)) {
                return;
            }
            Date date = null;
            if (val instanceof SQLDateExpr) {
                date = ((SQLDateExpr)val).getDate(this.timeZone);
            } else if (val instanceof SQLCharExpr) {
                String chars = ((SQLCharExpr)val).getText();
                date = MySqlUtils.parseDate(chars, this.timeZone);
            }
            if (date == null) {
                return;
            }
            Calendar calendar = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
            calendar.setTime(date);
            int delta = 0;
            Integer field = null;
            if (arg1 instanceof SQLIntegerExpr && ((SQLIntegerExpr)arg1).getNumber() instanceof Integer) {
                field = 6;
                delta = ((SQLIntegerExpr)arg1).getNumber().intValue();
            }
            if (delta == 0 || field == null) {
                return;
            }
            calendar.add(field, -delta);
            SQLExprImpl replaceToValExpr = val instanceof SQLDateExpr ? new SQLDateExpr(calendar.getTime(), this.timeZone) : new SQLTimestampExpr(calendar.getTime(), this.timeZone);
            x.setLeft(arg0);
            x.setRight(replaceToValExpr);
            return;
        }
    }

    public void binaryOp_from_unixtime(SQLBinaryOpExpr x) {
        SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)x.getLeft();
        List<SQLExpr> arguments = func.getArguments();
        SQLExpr right = x.getRight();
        Date date = null;
        if (right instanceof SQLDateExpr) {
            date = ((SQLDateExpr)right).getDate(this.timeZone);
        } else if (right instanceof SQLCharExpr) {
            String chars = ((SQLCharExpr)right).getText();
            if (arguments.size() == 1) {
                date = MySqlUtils.parseDate(chars, this.timeZone);
            } else if (arguments.size() == 2 && arguments.get(1) instanceof SQLCharExpr) {
                String format = ((SQLCharExpr)arguments.get(1)).getText();
                if ("YYYY-MM-DD".equals(format) || "yyyy-MM-dd".equals(format)) {
                    format = "%Y-%m-%d";
                }
                if (format.indexOf("%Y") == -1 || format.indexOf("%m") == -1) {
                    return;
                }
                DateFormat dateFormat = MySqlUtils.toJavaFormat(format, this.timeZone);
                if (dateFormat == null) {
                    return;
                }
                try {
                    date = dateFormat.parse(chars);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        if (date == null) {
            return;
        }
        long unixtime = date.getTime() / 1000L;
        SQLIntegerExpr unixtimeRight = SQLIntegerExpr.ofIntOrLong(unixtime);
        if (arguments.size() == 1) {
            SQLExpr arg0 = func.getArguments().get(0);
            x.setRight(unixtimeRight);
            x.setLeft(arg0);
            return;
        }
        if (arguments.size() == 2) {
            SQLExpr arg0 = func.getArguments().get(0);
            x.setRight(unixtimeRight);
            x.setLeft(arg0);
            return;
        }
    }

    public void binaryOp_to_char(SQLBinaryOpExpr x) {
        DateFormat dateFormat;
        SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)x.getLeft();
        List<SQLExpr> arguments = func.getArguments();
        if (arguments.size() != 2) {
            return;
        }
        SQLExpr right = x.getRight();
        if (!(right instanceof SQLCharExpr)) {
            return;
        }
        String rightText = ((SQLCharExpr)right).getText();
        SQLExpr arg0 = func.getArguments().get(0);
        SQLExpr arg1 = func.getArguments().get(1);
        if (!(arg1 instanceof SQLCharExpr)) {
            return;
        }
        String format = ((SQLCharExpr)arg1).getText();
        Date date = null;
        if (format.equals("yyyymmdd")) {
            dateFormat = new SimpleDateFormat("yyyyMMdd");
            if (this.timeZone != null) {
                dateFormat.setTimeZone(this.timeZone);
            }
        } else {
            dateFormat = MySqlUtils.toJavaFormat(format, this.timeZone);
        }
        if (dateFormat == null) {
            return;
        }
        try {
            date = dateFormat.parse(rightText);
        }
        catch (ParseException e) {
            return;
        }
        if (date == null) {
            return;
        }
        x.setRight(new SQLDateExpr(date, this.timeZone));
        x.setLeft(arg0);
        this.visitBinaryFunc(x);
    }

    public void binaryOp_sub_date(SQLBinaryOpExpr x) {
        SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)x.getLeft();
        List<SQLExpr> arguments = func.getArguments();
        if (arguments.size() == 2) {
            SQLExpr arg0 = func.getArguments().get(0);
            SQLExpr arg1 = func.getArguments().get(1);
            SQLLiteralExpr val = (SQLLiteralExpr)x.getRight();
            if (!(arg0 instanceof SQLName)) {
                return;
            }
            Date date = null;
            if (val instanceof SQLDateExpr) {
                date = ((SQLDateExpr)val).getDate(this.timeZone);
            } else if (val instanceof SQLCharExpr) {
                String chars = ((SQLCharExpr)val).getText();
                date = MySqlUtils.parseDate(chars, this.timeZone);
            }
            if (date == null) {
                return;
            }
            Calendar calendar = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
            calendar.setTime(date);
            int delta = 0;
            Integer field = null;
            if (arg1 instanceof SQLIntegerExpr && ((SQLIntegerExpr)arg1).getNumber() instanceof Integer) {
                field = 6;
                delta = ((SQLIntegerExpr)arg1).getNumber().intValue();
            }
            if (delta == 0 || field == null) {
                return;
            }
            calendar.add(field, delta);
            SQLExprImpl replaceToValExpr = val instanceof SQLDateExpr ? new SQLDateExpr(calendar.getTime(), this.timeZone) : new SQLTimestampExpr(calendar.getTime(), this.timeZone);
            x.setLeft(arg0);
            x.setRight(replaceToValExpr);
            return;
        }
    }

    private SQLExpr mergeTwiceOp(SQLExpr x, SQLBinaryOpExpr left, SQLBinaryOpExpr right) {
        SQLBinaryOperator op;
        SQLBinaryOperator leftOp = left.getOperator();
        SQLBinaryOperator rightOp = right.getOperator();
        SQLExpr leftLeft = left.getLeft();
        SQLExpr rightLeft = right.getLeft();
        SQLExpr leftRight = left.getRight();
        SQLExpr rightRight = right.getRight();
        if (x instanceof SQLBinaryOpExprGroup) {
            op = ((SQLBinaryOpExprGroup)x).getOperator();
        } else if (x instanceof SQLBinaryOpExpr) {
            op = ((SQLBinaryOpExpr)x).getOperator();
        } else {
            return null;
        }
        SQLExpr replaceTo = null;
        if (leftLeft.equals(rightLeft)) {
            if (leftOp == SQLBinaryOperator.Is && rightOp == SQLBinaryOperator.IsNot && leftRight instanceof SQLNullExpr && rightRight instanceof SQLNullExpr) {
                if (op == SQLBinaryOperator.BooleanAnd) {
                    replaceTo = new SQLBooleanExpr(false);
                } else if (op == SQLBinaryOperator.BooleanOr) {
                    replaceTo = new SQLBooleanExpr(true);
                }
                if (replaceTo != null && this.replaceInParent(x, replaceTo)) {
                    ++this.optimizedCount;
                    return replaceTo;
                }
            }
            Object leftRightVal = null;
            Object rightRightVal = null;
            if (leftRight instanceof SQLNumericLiteralExpr) {
                leftRightVal = ((SQLNumericLiteralExpr)leftRight).getNumber();
            } else if (leftRight instanceof SQLTimestampExpr) {
                leftRightVal = ((SQLTimestampExpr)leftRight).getDate(this.timeZone);
            } else if (leftRight instanceof SQLDateExpr) {
                leftRightVal = ((SQLDateExpr)leftRight).getDate(this.timeZone);
            } else if (leftRight instanceof SQLCharExpr) {
                leftRightVal = ((SQLCharExpr)leftRight).getText();
            }
            if (rightRight instanceof SQLNumericLiteralExpr) {
                rightRightVal = ((SQLNumericLiteralExpr)rightRight).getNumber();
            } else if (rightRight instanceof SQLTimestampExpr) {
                rightRightVal = ((SQLTimestampExpr)rightRight).getDate(this.timeZone);
            } else if (rightRight instanceof SQLDateExpr) {
                rightRightVal = ((SQLDateExpr)rightRight).getDate(this.timeZone);
            } else if (rightRight instanceof SQLCharExpr) {
                rightRightVal = ((SQLCharExpr)rightRight).getText();
            }
            if (leftRightVal instanceof BigDecimal && rightRightVal instanceof Integer) {
                rightRightVal = new BigDecimal((Integer)rightRightVal);
            } else if (leftRightVal instanceof Integer && rightRightVal instanceof BigDecimal) {
                leftRightVal = new BigDecimal((Integer)leftRightVal);
            }
            if (leftRightVal == null || rightRightVal == null || leftRightVal.getClass() != rightRightVal.getClass() || !(rightRightVal instanceof Comparable)) {
                return null;
            }
            int compareResult = ((Comparable)leftRightVal).compareTo(rightRightVal);
            if (leftRightVal instanceof String && compareResult != 0 && ((String)leftRightVal).length() != ((String)rightRightVal).length()) {
                switch (left.getOperator()) {
                    case Like: 
                    case NotLike: 
                    case Equality: 
                    case NotEqual: 
                    case LessThanOrGreater: {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                switch (right.getOperator()) {
                    case Like: 
                    case NotLike: 
                    case Equality: 
                    case NotEqual: 
                    case LessThanOrGreater: {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (op == SQLBinaryOperator.BooleanAnd) {
                replaceTo = this.mergeTwiceOp_and(left, right, leftOp, rightOp, leftLeft, leftRight, compareResult, leftRightVal, rightRightVal);
            } else if (op == SQLBinaryOperator.BooleanOr) {
                replaceTo = this.mergeTwiceOp_or(left, right, leftOp, rightOp, leftLeft, compareResult);
            }
        }
        if (replaceTo == null) {
            return null;
        }
        if (x instanceof SQLBinaryOpExprGroup) {
            SQLBinaryOpExprGroup group = (SQLBinaryOpExprGroup)x;
            if (group.getItems().size() >= 2) {
                group.getItems().remove(left);
                group.getItems().remove(right);
                if (group.getItems().size() == 0) {
                    if (!this.replaceInParent(x, replaceTo)) {
                        group.add(replaceTo);
                    }
                } else {
                    group.add(replaceTo);
                }
                ++this.optimizedCount;
                replaceTo.accept(this);
                return replaceTo;
            }
        } else if (this.replaceInParent(left, replaceTo)) {
            this.replaceInParent(right, null);
            ++this.optimizedCount;
            return replaceTo;
        }
        return null;
    }

    private SQLExpr mergeTwiceOp_or(SQLBinaryOpExpr left, SQLBinaryOpExpr right, SQLBinaryOperator leftOp, SQLBinaryOperator rightOp, SQLExpr leftLeft, int compareResult) {
        SQLBinaryOpExpr replaceTo = null;
        block0 : switch (leftOp) {
            case Equality: {
                switch (rightOp) {
                    case Equality: {
                        if (compareResult != 0) break block0;
                        replaceTo = left;
                        break block0;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult == 0) {
                            replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case GreaterThanOrEqual: {
                        if (compareResult < 0) break block0;
                        replaceTo = right;
                        break block0;
                    }
                    case GreaterThan: {
                        if (compareResult > 0) {
                            replaceTo = right;
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = right;
                        right.setOperator(SQLBinaryOperator.GreaterThanOrEqual);
                        break block0;
                    }
                    case LessThanOrEqual: {
                        if (compareResult > 0) break block0;
                        replaceTo = right;
                        break block0;
                    }
                    case LessThan: {
                        if (compareResult < 0) {
                            replaceTo = right;
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = right;
                        right.setOperator(SQLBinaryOperator.LessThanOrEqual);
                        break block0;
                    }
                }
                break;
            }
            case NotEqual: 
            case LessThanOrGreater: {
                switch (rightOp) {
                    case Equality: {
                        if (compareResult == 0) {
                            replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                            break block0;
                        }
                        replaceTo = left;
                        break block0;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult == 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                        break block0;
                    }
                    case LessThan: {
                        if (compareResult >= 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                        break block0;
                    }
                    case LessThanOrEqual: {
                        if (compareResult > 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                        break block0;
                    }
                    case GreaterThan: {
                        if (compareResult <= 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                        break block0;
                    }
                    case GreaterThanOrEqual: {
                        if (compareResult < 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                        break block0;
                    }
                }
                break;
            }
            case GreaterThan: {
                switch (rightOp) {
                    case Equality: {
                        if (compareResult < 0) {
                            replaceTo = left;
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = left;
                        left.setOperator(SQLBinaryOperator.GreaterThanOrEqual);
                        break block0;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult < 0) {
                            replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case LessThan: {
                        if (compareResult < 0) {
                            replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = left;
                        left.setOperator(SQLBinaryOperator.LessThanOrGreater);
                        break block0;
                    }
                    case LessThanOrEqual: {
                        if (compareResult > 0) break block0;
                        replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                        break block0;
                    }
                    case GreaterThan: 
                    case GreaterThanOrEqual: {
                        if (compareResult < 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                }
                break;
            }
            case GreaterThanOrEqual: {
                switch (rightOp) {
                    case Equality: {
                        if (compareResult > 0) break block0;
                        replaceTo = left;
                        break block0;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult <= 0) {
                            replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case LessThan: 
                    case LessThanOrEqual: {
                        if (compareResult > 0) break block0;
                        replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                        break block0;
                    }
                    case GreaterThan: 
                    case GreaterThanOrEqual: {
                        if (compareResult <= 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                }
                break;
            }
            case LessThan: {
                switch (rightOp) {
                    case Equality: {
                        if (compareResult > 0) {
                            replaceTo = left;
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = left;
                        left.setOperator(SQLBinaryOperator.LessThanOrEqual);
                        break block0;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult > 0) {
                            replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case LessThan: 
                    case LessThanOrEqual: {
                        if (compareResult > 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case GreaterThan: {
                        if (compareResult > 0) {
                            replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = left;
                        left.setOperator(SQLBinaryOperator.LessThanOrGreater);
                        break block0;
                    }
                    case GreaterThanOrEqual: {
                        if (compareResult < 0) break block0;
                        replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                        break block0;
                    }
                }
                break;
            }
            case LessThanOrEqual: {
                switch (rightOp) {
                    case Equality: {
                        if (compareResult < 0) break block0;
                        replaceTo = left;
                        break block0;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult >= 0) {
                            replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case LessThan: 
                    case LessThanOrEqual: {
                        if (compareResult >= 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case GreaterThan: 
                    case GreaterThanOrEqual: {
                        if (compareResult < 0) break block0;
                        replaceTo = SQLBinaryOpExpr.isNotNull(leftLeft.clone());
                        break block0;
                    }
                }
                break;
            }
        }
        return replaceTo;
    }

    private SQLExpr mergeTwiceOp_and(SQLBinaryOpExpr left, SQLBinaryOpExpr right, SQLBinaryOperator leftOp, SQLBinaryOperator rightOp, SQLExpr leftLeft, SQLExpr leftRight, int compareResult, Object leftRightVal, Object rightRightVal) {
        SQLExprImpl replaceTo = null;
        block0 : switch (leftOp) {
            case LessThan: {
                switch (rightOp) {
                    case Equality: {
                        if (compareResult > 0) {
                            replaceTo = right;
                            break;
                        }
                        replaceTo = new SQLBooleanExpr(false);
                        break;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult > 0) break;
                        replaceTo = left;
                        break;
                    }
                    case LessThan: {
                        if (compareResult < 0) {
                            replaceTo = left;
                            break;
                        }
                        replaceTo = right;
                        break;
                    }
                    case LessThanOrEqual: {
                        if (compareResult <= 0) {
                            replaceTo = left;
                            break;
                        }
                        replaceTo = right;
                        break;
                    }
                    case GreaterThan: {
                        int rightRightValInt;
                        int leftRightValInt;
                        if (compareResult <= 0) {
                            replaceTo = new SQLBooleanExpr(false);
                            break;
                        }
                        SQLName leftName = (SQLName)left.getLeft();
                        SQLColumnDefinition resolvedColumn = leftName.getResolvedColumn();
                        if (resolvedColumn == null || resolvedColumn.getDataType() == null || !resolvedColumn.getDataType().isInt() || !(leftRightVal instanceof Integer) || !(rightRightVal instanceof Integer) || (leftRightValInt = ((Integer)leftRightVal).intValue()) - (rightRightValInt = ((Integer)rightRightVal).intValue()) != 2) break block0;
                        replaceTo = new SQLBinaryOpExpr(leftLeft.clone(), SQLBinaryOperator.Equality, new SQLIntegerExpr(rightRightValInt + 1));
                        break;
                    }
                    case GreaterThanOrEqual: {
                        if (compareResult > 0) break;
                        replaceTo = new SQLBooleanExpr(false);
                        break;
                    }
                }
                break;
            }
            case LessThanOrEqual: {
                switch (rightOp) {
                    case Equality: {
                        if (compareResult >= 0) {
                            replaceTo = right;
                            break block0;
                        }
                        replaceTo = new SQLBooleanExpr(false);
                        break block0;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult < 0) {
                            replaceTo = left;
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = left;
                        left.setOperator(SQLBinaryOperator.LessThan);
                        break block0;
                    }
                    case LessThan: {
                        if (compareResult < 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case LessThanOrEqual: {
                        if (compareResult < 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case GreaterThan: {
                        if (compareResult > 0) break block0;
                        replaceTo = new SQLBooleanExpr(false);
                        break block0;
                    }
                    case GreaterThanOrEqual: {
                        if (compareResult < 0) {
                            replaceTo = new SQLBooleanExpr(false);
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = new SQLBinaryOpExpr(leftLeft.clone(), SQLBinaryOperator.Equality, leftRight.clone());
                        break block0;
                    }
                }
                break;
            }
            case Equality: {
                switch (rightOp) {
                    case Equality: {
                        if (compareResult == 0) {
                            replaceTo = left;
                            break;
                        }
                        replaceTo = new SQLBooleanExpr(false);
                        break;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult == 0) {
                            replaceTo = new SQLBooleanExpr(false);
                            break;
                        }
                        replaceTo = left;
                        break;
                    }
                    case LessThan: {
                        if (compareResult >= 0) {
                            replaceTo = new SQLBooleanExpr(false);
                            break;
                        }
                        replaceTo = left;
                        break;
                    }
                    case LessThanOrEqual: {
                        if (compareResult <= 0) {
                            replaceTo = left;
                            break;
                        }
                        replaceTo = new SQLBooleanExpr(false);
                        break;
                    }
                    case GreaterThan: {
                        if (compareResult <= 0) {
                            replaceTo = new SQLBooleanExpr(false);
                            break;
                        }
                        replaceTo = left;
                        break;
                    }
                    case GreaterThanOrEqual: {
                        if (compareResult >= 0) {
                            replaceTo = left;
                            break;
                        }
                        replaceTo = new SQLBooleanExpr(false);
                        break;
                    }
                    case Like: {
                        if (!(right.getRight() instanceof SQLCharExpr)) break;
                        String text = ((SQLCharExpr)right.getRight()).getText();
                        if (text.indexOf(37) != -1 || text.indexOf(95) != -1) break block0;
                        if (compareResult == 0) {
                            replaceTo = left;
                            break;
                        }
                        replaceTo = new SQLBooleanExpr(false);
                        break;
                    }
                    case NotLike: {
                        if (!(right.getRight() instanceof SQLCharExpr)) break;
                        String text = ((SQLCharExpr)right.getRight()).getText();
                        if (text.indexOf(37) != -1 || text.indexOf(95) != -1 || compareResult != 0) break block0;
                        replaceTo = new SQLBooleanExpr(false);
                        break;
                    }
                }
                break;
            }
            case NotEqual: 
            case LessThanOrGreater: {
                switch (rightOp) {
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult != 0) break block0;
                        replaceTo = left;
                        break block0;
                    }
                    case Equality: {
                        if (compareResult == 0) {
                            replaceTo = new SQLBooleanExpr(false);
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case LessThan: {
                        if (compareResult < 0) break block0;
                        replaceTo = right;
                        break block0;
                    }
                    case LessThanOrEqual: {
                        if (compareResult > 0) {
                            replaceTo = right;
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = right;
                        right.setOperator(SQLBinaryOperator.LessThan);
                        break block0;
                    }
                    case GreaterThan: {
                        if (compareResult > 0) break block0;
                        replaceTo = right;
                        break block0;
                    }
                    case GreaterThanOrEqual: {
                        if (compareResult < 0) {
                            replaceTo = right;
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = right;
                        right.setOperator(SQLBinaryOperator.GreaterThan);
                        break block0;
                    }
                }
                break;
            }
            case GreaterThan: {
                switch (rightOp) {
                    case LessThan: {
                        if (compareResult >= 0) {
                            replaceTo = new SQLBooleanExpr(false);
                            break;
                        }
                        if (left.getLeft() instanceof SQLCastExpr) {
                            SQLDataType sqlDataType = left.getLeft().computeDataType();
                            if (sqlDataType == null || !sqlDataType.isInt() || !(leftRightVal instanceof Integer) || !(rightRightVal instanceof Integer)) break block0;
                            int leftRightValInt = (Integer)leftRightVal;
                            int rightRightValInt = (Integer)rightRightVal;
                            if (rightRightValInt - leftRightValInt != 2) break block0;
                            replaceTo = new SQLBinaryOpExpr(leftLeft.clone(), SQLBinaryOperator.Equality, new SQLIntegerExpr(leftRightValInt + 1));
                            break;
                        }
                        SQLName leftName = (SQLName)left.getLeft();
                        SQLColumnDefinition resolvedColumn = leftName.getResolvedColumn();
                        if (resolvedColumn == null || resolvedColumn.getDataType() == null || !resolvedColumn.getDataType().isInt() || !(leftRightVal instanceof Integer) || !(rightRightVal instanceof Integer)) break block0;
                        int leftRightValInt = (Integer)leftRightVal;
                        int rightRightValInt = (Integer)rightRightVal;
                        if (rightRightValInt - leftRightValInt != 2) break block0;
                        replaceTo = new SQLBinaryOpExpr(leftLeft.clone(), SQLBinaryOperator.Equality, new SQLIntegerExpr(leftRightValInt + 1));
                        break;
                    }
                    case LessThanOrEqual: {
                        if (compareResult <= 0) break;
                        replaceTo = new SQLBooleanExpr(false);
                        break;
                    }
                    case Equality: {
                        if (compareResult < 0) break;
                        replaceTo = new SQLBooleanExpr(false);
                        break;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult < 0) break;
                        replaceTo = left;
                        break;
                    }
                    case GreaterThan: {
                        if (compareResult > 0) {
                            replaceTo = left;
                            break;
                        }
                        replaceTo = right;
                        break;
                    }
                    case GreaterThanOrEqual: {
                        if (compareResult >= 0) {
                            replaceTo = left;
                            break;
                        }
                        replaceTo = right;
                        break;
                    }
                }
                break;
            }
            case GreaterThanOrEqual: {
                switch (rightOp) {
                    case GreaterThan: {
                        if (compareResult > 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case GreaterThanOrEqual: {
                        if (compareResult > 0) {
                            replaceTo = left;
                            break block0;
                        }
                        replaceTo = right;
                        break block0;
                    }
                    case LessThan: {
                        if (compareResult < 0) break block0;
                        replaceTo = new SQLBooleanExpr(false);
                        break block0;
                    }
                    case LessThanOrEqual: {
                        if (compareResult > 0) {
                            replaceTo = new SQLBooleanExpr(false);
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = new SQLBinaryOpExpr(leftLeft.clone(), SQLBinaryOperator.Equality, leftRight.clone());
                        break block0;
                    }
                    case Equality: {
                        if (compareResult <= 0) {
                            replaceTo = right;
                            break block0;
                        }
                        replaceTo = new SQLBooleanExpr(false);
                        break block0;
                    }
                    case NotEqual: 
                    case LessThanOrGreater: {
                        if (compareResult > 0) {
                            replaceTo = left;
                            break block0;
                        }
                        if (compareResult != 0) break block0;
                        replaceTo = left;
                        left.setOperator(SQLBinaryOperator.GreaterThan);
                        break block0;
                    }
                }
                break;
            }
            case Like: {
                switch (rightOp) {
                    case Equality: {
                        if (!(leftRight instanceof SQLCharExpr)) break;
                        String text = ((SQLCharExpr)leftRight).getText();
                        if (text.indexOf(37) != -1 || text.indexOf(95) != -1) break block0;
                        if (compareResult == 0) {
                            replaceTo = right;
                            break;
                        }
                        replaceTo = new SQLBooleanExpr(false);
                        break;
                    }
                }
                break;
            }
        }
        return replaceTo;
    }

    private void handValueValue(SQLBinaryOpExpr x) {
        SQLTimestampExpr tsExpr;
        String text;
        SQLExprImpl dateExpr;
        Date date;
        SQLBinaryOperator op = x.getOperator();
        SQLValuableExpr leftExpr = (SQLValuableExpr)x.getLeft();
        SQLValuableExpr rightExpr = (SQLValuableExpr)x.getRight();
        if (rightExpr instanceof SQLNullExpr) {
            SQLObject parent = x.getParent();
            if ((op == SQLBinaryOperator.Is || op == SQLBinaryOperator.IsNot) && parent instanceof SQLBinaryOpExpr) {
                SQLBinaryOperator parentOp = ((SQLBinaryOpExpr)parent).getOperator();
                switch (parentOp) {
                    case Like: 
                    case NotLike: 
                    case RLike: 
                    case NotRLike: 
                    case SoudsLike: {
                        return;
                    }
                }
            }
            SQLBooleanExpr replaceTo = null;
            if (op == SQLBinaryOperator.Is) {
                replaceTo = leftExpr instanceof SQLNullExpr ? new SQLBooleanExpr(true) : new SQLBooleanExpr(false);
            } else if (op == SQLBinaryOperator.IsNot) {
                replaceTo = leftExpr instanceof SQLNullExpr ? new SQLBooleanExpr(false) : new SQLBooleanExpr(true);
            }
            if (replaceTo != null && this.replaceInParent(x, replaceTo)) {
                ++this.optimizedCount;
            }
        }
        if (leftExpr instanceof SQLDateExpr && rightExpr instanceof SQLIntegerExpr && (date = ((SQLDateExpr)(dateExpr = (SQLDateExpr)leftExpr)).getDate()) != null && (this.dbType == DbType.mysql || this.dbType == DbType.ads)) {
            text = new SimpleDateFormat("yyyyMMdd").format(date);
            int dateIntValue = Integer.parseInt(text);
            leftExpr = new SQLIntegerExpr(dateIntValue);
            x.setLeft(leftExpr);
        }
        if (leftExpr instanceof SQLTimestampExpr && rightExpr instanceof SQLIntegerExpr && (date = ((SQLTimestampExpr)(dateExpr = (SQLTimestampExpr)leftExpr)).getDate(this.timeZone)) != null && (this.dbType == DbType.mysql || this.dbType == DbType.ads)) {
            text = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
            long dateIntValue = Long.parseLong(text);
            leftExpr = new SQLIntegerExpr(dateIntValue);
            x.setLeft(leftExpr);
        }
        if (leftExpr instanceof SQLCharExpr && (rightExpr instanceof SQLTimestampExpr || rightExpr instanceof SQLDateExpr) && (date = (tsExpr = new SQLTimestampExpr(((SQLCharExpr)leftExpr).getText())).getDate(this.timeZone)) != null && (this.dbType == DbType.mysql || this.dbType == DbType.ads)) {
            text = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
            SQLTimestampExpr replaceTo = new SQLTimestampExpr(text);
            leftExpr = replaceTo;
            x.setLeft(leftExpr);
        }
        if (leftExpr instanceof SQLTimestampExpr && rightExpr instanceof SQLTimestampExpr) {
            SQLTimestampExpr rightDateExpr;
            SQLTimestampExpr leftDateExpr = (SQLTimestampExpr)leftExpr;
            date = leftDateExpr.getDate(this.timeZone);
            if (date != null && (this.dbType == DbType.mysql || this.dbType == DbType.ads)) {
                text = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
                long dateIntValue = Long.parseLong(text);
                leftExpr = new SQLIntegerExpr(dateIntValue);
                x.setLeft(leftExpr);
            }
            if ((date = (rightDateExpr = (SQLTimestampExpr)rightExpr).getDate(this.timeZone)) != null && (this.dbType == DbType.mysql || this.dbType == DbType.ads)) {
                text = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
                long dateIntValue = Long.parseLong(text);
                rightExpr = new SQLIntegerExpr(dateIntValue);
                x.setRight(rightExpr);
            }
        }
        Object leftVal = leftExpr.getValue();
        Object rightVal = rightExpr.getValue();
        if (leftVal instanceof Integer && rightVal instanceof String) {
            long rightValLong;
            try {
                rightValLong = Long.parseLong((String)rightVal);
            }
            catch (NumberFormatException ex) {
                return;
            }
            rightVal = rightValLong >= Integer.MIN_VALUE && rightValLong <= Integer.MAX_VALUE ? (Number)((int)rightValLong) : (Number)rightValLong;
        } else if (leftVal instanceof Integer && rightVal instanceof byte[] && rightExpr instanceof SQLHexExpr) {
            byte[] bytes = (byte[])rightVal;
            long hex = 0L;
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                hex = hex * 16L + (long)b;
            }
            rightVal = hex >= Integer.MIN_VALUE && hex <= Integer.MAX_VALUE ? (Number)((int)hex) : (Number)hex;
        }
        if (leftVal instanceof Integer && rightVal instanceof Integer) {
            int leftIntVal = (Integer)leftVal;
            int rightIntVal = (Integer)rightVal;
            SQLExprImpl replaceTo = null;
            switch (op) {
                case Add: {
                    replaceTo = SQLIntegerExpr.ofIntOrLong((long)leftIntVal + (long)rightIntVal);
                    break;
                }
                case Subtract: {
                    long result = (long)leftIntVal - (long)rightIntVal;
                    replaceTo = SQLIntegerExpr.ofIntOrLong((long)leftIntVal - (long)rightIntVal);
                    break;
                }
                case Multiply: {
                    long result = (long)leftIntVal * (long)rightIntVal;
                    replaceTo = SQLIntegerExpr.ofIntOrLong(result);
                    break;
                }
                case Divide: {
                    if (rightIntVal == 0) break;
                    int div = leftIntVal / rightIntVal;
                    int mod = leftIntVal % rightIntVal;
                    if (mod != 0) break;
                    replaceTo = new SQLIntegerExpr(div);
                    break;
                }
                case Mod: 
                case Modulus: {
                    if (rightIntVal == 0) break;
                    int mod = leftIntVal % rightIntVal;
                    replaceTo = new SQLIntegerExpr(mod);
                    break;
                }
                case GreaterThan: {
                    boolean result = leftIntVal > rightIntVal;
                    replaceTo = new SQLBooleanExpr(result);
                    break;
                }
                case GreaterThanOrEqual: {
                    boolean result = leftIntVal >= rightIntVal;
                    replaceTo = new SQLBooleanExpr(result);
                    break;
                }
                case LessThan: {
                    boolean result = leftIntVal < rightIntVal;
                    replaceTo = new SQLBooleanExpr(result);
                    break;
                }
                case LessThanOrEqual: {
                    boolean result = leftIntVal <= rightIntVal;
                    replaceTo = new SQLBooleanExpr(result);
                    break;
                }
                case Equality: {
                    boolean result = leftIntVal == rightIntVal;
                    replaceTo = new SQLBooleanExpr(result);
                    break;
                }
                case NotEqual: {
                    boolean result = leftIntVal != rightIntVal;
                    replaceTo = new SQLBooleanExpr(result);
                    break;
                }
            }
            if (replaceTo != null) {
                this.replaceInParent(x, replaceTo);
                return;
            }
        }
        if (leftVal instanceof Integer && rightVal instanceof Long) {
            leftVal = new Long(((Integer)leftVal).intValue());
        } else if (leftVal instanceof Long && rightVal instanceof Integer) {
            rightVal = new Long(((Integer)rightVal).intValue());
        }
        if (leftVal instanceof Long && rightVal instanceof Long) {
            long lefLongVal = (Long)leftVal;
            long rightLongVal = (Long)rightVal;
            switch (op) {
                case Add: {
                    SQLIntegerExpr replaceTo = SQLIntegerExpr.add(lefLongVal, rightLongVal);
                    if (replaceTo.getNumber() instanceof BigInteger || !this.replaceInParent(x, replaceTo)) break;
                    ++this.optimizedCount;
                    return;
                }
                case Subtract: {
                    if (!this.replaceInParent(x, new SQLIntegerExpr(lefLongVal - rightLongVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Multiply: {
                    long result;
                    if (lefLongVal < Integer.MIN_VALUE || lefLongVal > Integer.MAX_VALUE || rightLongVal < Integer.MIN_VALUE || rightLongVal > Integer.MAX_VALUE || (result = lefLongVal * rightLongVal) == 0L || !this.replaceInParent(x, new SQLIntegerExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Divide: {
                    long result = lefLongVal / rightLongVal;
                    long mod = lefLongVal % rightLongVal;
                    if (mod != 0L || !this.replaceInParent(x, new SQLIntegerExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Mod: 
                case Modulus: {
                    long result = lefLongVal % rightLongVal;
                    if (!this.replaceInParent(x, new SQLIntegerExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
                case GreaterThan: {
                    boolean result;
                    boolean bl = result = lefLongVal > rightLongVal;
                    if (!this.replaceInParent(x, new SQLBooleanExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
                case GreaterThanOrEqual: {
                    boolean result;
                    boolean bl = result = lefLongVal >= rightLongVal;
                    if (!this.replaceInParent(x, new SQLBooleanExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
                case LessThan: {
                    boolean result;
                    boolean bl = result = lefLongVal < rightLongVal;
                    if (!this.replaceInParent(x, new SQLBooleanExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
                case LessThanOrEqual: {
                    boolean result;
                    boolean bl = result = lefLongVal <= rightLongVal;
                    if (!this.replaceInParent(x, new SQLBooleanExpr(result))) break;
                    ++this.optimizedCount;
                    return;
                }
            }
        }
        if (leftVal instanceof BigDecimal && (rightVal instanceof Long || rightVal instanceof Integer)) {
            rightVal = new BigDecimal(((Number)rightVal).longValue());
        } else if (rightExpr instanceof BigDecimal && (leftVal instanceof Long || leftVal instanceof Integer)) {
            leftVal = new BigDecimal(((Number)leftVal).longValue());
        }
        if (leftVal instanceof Double && rightVal instanceof Number) {
            rightVal = ((Number)rightVal).doubleValue();
        } else if (leftVal instanceof Float && rightVal instanceof Number) {
            leftVal = ((Float)leftVal).doubleValue();
            rightVal = ((Number)rightVal).doubleValue();
        } else if (leftVal instanceof Integer && rightVal instanceof BigDecimal) {
            leftVal = BigDecimal.valueOf(((Integer)leftVal).intValue());
        }
        if (leftVal instanceof BigDecimal && rightVal instanceof BigDecimal) {
            BigDecimal leftRealVal = (BigDecimal)leftVal;
            BigDecimal rightRealVal = (BigDecimal)rightVal;
            boolean decimalExpr = leftExpr instanceof SQLDecimalExpr || rightExpr instanceof SQLDecimalExpr;
            BigDecimal value = null;
            switch (op) {
                case Add: {
                    value = leftRealVal.add(rightRealVal);
                    break;
                }
                case Subtract: {
                    value = leftRealVal.subtract(rightRealVal);
                    break;
                }
                case Multiply: {
                    if (decimalExpr) break;
                    value = leftRealVal.multiply(rightRealVal);
                    break;
                }
                case Divide: {
                    if (decimalExpr || BigDecimal.ZERO.equals(rightRealVal)) break;
                    try {
                        value = leftRealVal.divide(rightRealVal);
                        ++this.optimizedCount;
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            if (value != null) {
                if (decimalExpr) {
                    this.replaceInParent(x, new SQLDecimalExpr(value));
                } else {
                    this.replaceInParent(x, new SQLNumberExpr(value));
                }
            }
        } else if (leftVal instanceof Double && rightVal instanceof Double) {
            double leftDoubleVal = (Double)leftVal;
            double rightDoubleVal = (Double)rightVal;
            switch (op) {
                case Add: {
                    if (!this.replaceInParent(x, new SQLNumberExpr(leftDoubleVal + rightDoubleVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Subtract: {
                    if (!this.replaceInParent(x, new SQLNumberExpr(leftDoubleVal - rightDoubleVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Multiply: {
                    if (!this.replaceInParent(x, new SQLNumberExpr(leftDoubleVal * rightDoubleVal))) break;
                    ++this.optimizedCount;
                    return;
                }
                case Divide: {
                    if (!this.replaceInParent(x, new SQLNumberExpr(leftDoubleVal / rightDoubleVal))) break;
                    ++this.optimizedCount;
                    return;
                }
            }
        } else if (leftVal instanceof String && rightVal instanceof String) {
            int compareTo = ((String)leftVal).compareTo((String)rightVal);
            switch (op) {
                case Concat: {
                    SQLCharExpr replaceTo = new SQLCharExpr((String)leftVal + (String)rightVal);
                    this.replaceInParent(x, replaceTo);
                    break;
                }
                case GreaterThanOrEqual: {
                    this.replaceInParent(x, new SQLBooleanExpr(compareTo > 0 || compareTo == 0));
                    break;
                }
                case GreaterThan: {
                    this.replaceInParent(x, new SQLBooleanExpr(compareTo > 0));
                    break;
                }
                case LessThanOrEqual: {
                    this.replaceInParent(x, new SQLBooleanExpr(compareTo < 0 || compareTo == 0));
                    break;
                }
                case LessThan: {
                    this.replaceInParent(x, new SQLBooleanExpr(compareTo < 0));
                    break;
                }
                case Equality: {
                    this.replaceInParent(x, new SQLBooleanExpr(compareTo == 0));
                }
            }
        } else if (leftVal instanceof String && rightVal instanceof Integer) {
            try {
                Integer leftInt = Integer.valueOf((String)leftVal);
                int compareTo = leftInt.compareTo((Integer)rightVal);
                switch (op) {
                    case GreaterThanOrEqual: {
                        this.replaceInParent(x, new SQLBooleanExpr(compareTo > 0 || compareTo == 0));
                        break;
                    }
                    case GreaterThan: {
                        this.replaceInParent(x, new SQLBooleanExpr(compareTo > 0));
                        break;
                    }
                    case LessThanOrEqual: {
                        this.replaceInParent(x, new SQLBooleanExpr(compareTo < 0 || compareTo == 0));
                        break;
                    }
                    case LessThan: {
                        this.replaceInParent(x, new SQLBooleanExpr(compareTo < 0));
                        break;
                    }
                    case Equality: {
                        this.replaceInParent(x, new SQLBooleanExpr(compareTo == 0));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.replaceInParent(x, new SQLBooleanExpr(false));
            }
        }
    }

    protected boolean visitGroupBoolean(SQLBinaryOpExprGroup x) {
        block5: {
            List<SQLExpr> items;
            SQLBinaryOperator operator;
            block4: {
                operator = x.getOperator();
                items = x.getItems();
                if (operator != SQLBinaryOperator.BooleanOr) break block4;
                for (int i = items.size() - 1; i >= 0; --i) {
                    SQLExpr expr = items.get(i);
                    if (!(expr instanceof SQLBooleanExpr)) continue;
                    boolean value = ((SQLBooleanExpr)expr).getBooleanValue();
                    if (value) {
                        if (!this.replaceInParent(x, new SQLBooleanExpr(true))) continue;
                        return true;
                    }
                    items.remove(i);
                    ++this.optimizedCount;
                }
                break block5;
            }
            if (operator != SQLBinaryOperator.BooleanAnd) break block5;
            for (int i = items.size() - 1; i >= 0; --i) {
                SQLExpr expr = items.get(i);
                if (!(expr instanceof SQLBooleanExpr)) continue;
                boolean value = ((SQLBooleanExpr)expr).getBooleanValue();
                if (value) {
                    items.remove(i);
                    ++this.optimizedCount;
                    continue;
                }
                if (!this.replaceInParent(x, new SQLBooleanExpr(false))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void endVisit(SQLBinaryOpExprGroup x) {
        this.visitGroupBoolean(x);
    }

    @Override
    public boolean visit(SQLBinaryOpExprGroup x) {
        SQLExpr replaceTo;
        SQLBinaryOpExpr right;
        List exprList;
        List<SQLBinaryOpExpr> exprList2;
        SQLExpr right2;
        SQLExpr left;
        SQLBinaryOpExpr binaryOpExpr;
        SQLExpr item;
        HashMap<SQLName, ArrayList<SQLBinaryOpExpr>> nameConditions;
        SQLExpr item2;
        int i;
        for (int i2 = 0; i2 < x.getItems().size(); ++i2) {
            SQLExpr item3 = x.getItems().get(i2);
            item3.accept(this);
        }
        SQLBinaryOperator operator = x.getOperator();
        List<SQLExpr> items = x.getItems();
        for (i = x.getItems().size() - 1; i >= 0; --i) {
            SQLExpr expr = items.get(i);
            if (items.indexOf(expr) >= i) continue;
            items.remove(i);
            ++this.optimizedCount;
        }
        if (x.getOperator() == SQLBinaryOperator.BooleanOr) {
            items = x.getItems();
            for (i = items.size() - 1; i >= 0; --i) {
                if (i == items.size() - 1) continue;
                item2 = items.get(i);
                SQLExpr postItem = items.get(i + 1);
                if (item2 instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)item2).isLeftNameAndRightLiteral() && ((SQLBinaryOpExpr)item2).getOperator() == SQLBinaryOperator.Equality) {
                    SQLBinaryOpExpr binaryOpExpr2 = (SQLBinaryOpExpr)item2;
                    SQLName leftName = (SQLName)binaryOpExpr2.getLeft();
                    SQLLiteralExpr right3 = (SQLLiteralExpr)binaryOpExpr2.getRight();
                    if (postItem instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)postItem).isLeftNameAndRightLiteral()) {
                        SQLBinaryOpExpr postBinaryOpExpr = (SQLBinaryOpExpr)postItem;
                        SQLName postLeft = (SQLName)postBinaryOpExpr.getLeft();
                        SQLLiteralExpr postRight = (SQLLiteralExpr)postBinaryOpExpr.getRight();
                        if (!leftName.equals(postLeft) || postBinaryOpExpr.getOperator() != SQLBinaryOperator.Equality || postRight instanceof SQLNullExpr) continue;
                        SQLInListExpr in = new SQLInListExpr(leftName.clone());
                        in.addTarget(right3.clone());
                        in.addTarget(postRight.clone());
                        in.setParent(x);
                        items.remove(i + 1);
                        items.set(i, in);
                        continue;
                    }
                    if (!(postItem instanceof SQLInListExpr) || !leftName.equals(((SQLInListExpr)postItem).getExpr()) || ((SQLInListExpr)postItem).isNot()) continue;
                    SQLInListExpr in = (SQLInListExpr)postItem;
                    in.addTarget(0, right3.clone());
                    items.remove(i);
                    continue;
                }
                if (!(item2 instanceof SQLInListExpr) || ((SQLInListExpr)item2).isNot()) continue;
                SQLInListExpr in = (SQLInListExpr)item2;
                SQLExpr expr = in.getExpr();
                if (postItem instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)postItem).isLeftNameAndRightLiteral() && ((SQLBinaryOpExpr)postItem).getOperator() == SQLBinaryOperator.Equality) {
                    SQLBinaryOpExpr postBinaryOpExpr = (SQLBinaryOpExpr)postItem;
                    SQLName postLeft = (SQLName)postBinaryOpExpr.getLeft();
                    SQLLiteralExpr postRight = (SQLLiteralExpr)postBinaryOpExpr.getRight();
                    if (!expr.equals(postLeft)) continue;
                    in.addTarget(postRight.clone());
                    items.remove(i + 1);
                    continue;
                }
                if (!(postItem instanceof SQLInListExpr) || !expr.equals(((SQLInListExpr)postItem).getExpr()) || ((SQLInListExpr)postItem).isNot()) continue;
                SQLInListExpr postIn = (SQLInListExpr)postItem;
                for (SQLExpr postValue : postIn.getTargetList()) {
                    in.addTarget(postValue.clone());
                }
                items.remove(i + 1);
            }
        }
        if (x.getItems().size() == 1) {
            SQLUtils.replaceInParent(x, x.getItems().get(0));
            return false;
        }
        if (this.visitGroupBoolean(x)) {
            return false;
        }
        items = new ArrayList<SQLExpr>(x.getItems());
        Collections.sort(items, SQLExprComparor.instance);
        if (operator == SQLBinaryOperator.BooleanAnd) {
            int i3;
            HashMap<SQLExpr, SQLExpr> constFields = new HashMap<SQLExpr, SQLExpr>();
            nameConditions = new HashMap<SQLName, ArrayList<SQLBinaryOpExpr>>();
            for (i3 = 0; i3 < items.size(); ++i3) {
                item = items.get(i3);
                if (!(item instanceof SQLBinaryOpExpr)) continue;
                binaryOpExpr = (SQLBinaryOpExpr)item;
                left = binaryOpExpr.getLeft();
                right2 = binaryOpExpr.getRight();
                if (binaryOpExpr.getOperator() == SQLBinaryOperator.Equality && left instanceof SQLName && right2 instanceof SQLValuableExpr) {
                    constFields.put(left, right2);
                }
                if (ConstFolding.isLeftNameAndRightLiteral(item)) {
                    exprList2 = (ArrayList<SQLBinaryOpExpr>)nameConditions.get(left);
                    if (exprList2 == null) {
                        exprList2 = new ArrayList<SQLBinaryOpExpr>();
                        nameConditions.put((SQLName)left, (ArrayList<SQLBinaryOpExpr>)exprList2);
                    }
                    exprList2.add((SQLBinaryOpExpr)item);
                }
                if (!(right2 instanceof SQLLiteralExpr) || !(left instanceof SQLCastExpr) || !(((SQLCastExpr)left).getExpr() instanceof SQLName)) continue;
                SQLName leftName = (SQLName)((SQLCastExpr)left).getExpr();
                ArrayList<SQLBinaryOpExpr> exprList3 = (ArrayList<SQLBinaryOpExpr>)nameConditions.get(leftName);
                if (exprList3 == null) {
                    exprList3 = new ArrayList<SQLBinaryOpExpr>();
                    nameConditions.put(leftName, exprList3);
                }
                exprList3.add((SQLBinaryOpExpr)item);
            }
            for (i3 = 0; i3 < items.size(); ++i3) {
                SQLExpr rightLiteral;
                item = items.get(i3);
                if (!(item instanceof SQLBinaryOpExpr)) continue;
                binaryOpExpr = (SQLBinaryOpExpr)item;
                left = binaryOpExpr.getLeft();
                right2 = binaryOpExpr.getRight();
                if (!(left instanceof SQLName) || !(right2 instanceof SQLName)) continue;
                SQLExpr leftLiteral = (SQLExpr)constFields.get(left);
                SQLObject parent = x.getParent();
                if (parent instanceof SQLSelectQueryBlock && !(((SQLSelectQueryBlock)parent).getFrom() instanceof SQLJoinTableSource)) {
                    SQLExpr rightLiteral2;
                    if (leftLiteral != null) {
                        binaryOpExpr.setLeft(leftLiteral.clone());
                    }
                    if ((rightLiteral2 = (SQLExpr)constFields.get(right2)) == null) continue;
                    binaryOpExpr.setRight(rightLiteral2.clone());
                    continue;
                }
                SQLBinaryOpExpr binaryOpExpr2 = null;
                if (leftLiteral != null) {
                    binaryOpExpr2 = binaryOpExpr.clone();
                    binaryOpExpr2.setLeft(leftLiteral.clone());
                }
                if ((rightLiteral = (SQLExpr)constFields.get(right2)) != null) {
                    binaryOpExpr2 = binaryOpExpr.clone();
                    binaryOpExpr2.setRight(rightLiteral.clone());
                }
                if (items.contains(binaryOpExpr2)) {
                    binaryOpExpr2 = null;
                }
                if (binaryOpExpr2 == null) continue;
                binaryOpExpr2.setParent(x);
                x.getItems().add(binaryOpExpr2);
                ++this.optimizedCount;
            }
            for (Map.Entry entry : nameConditions.entrySet()) {
                exprList = (List)entry.getValue();
                left = (SQLBinaryOpExpr)exprList.get(0);
                for (int i4 = 1; i4 < exprList.size(); ++i4) {
                    right = (SQLBinaryOpExpr)exprList.get(i4);
                    replaceTo = this.mergeTwiceOp(x, (SQLBinaryOpExpr)left, right);
                    if (replaceTo == null) {
                        left = right;
                        continue;
                    }
                    if (!(replaceTo instanceof SQLBinaryOpExpr)) continue;
                    left = (SQLBinaryOpExpr)replaceTo;
                }
            }
        } else if (operator == SQLBinaryOperator.BooleanOr) {
            HashMap<SQLExpr, SQLExpr> constFields = new HashMap<SQLExpr, SQLExpr>();
            nameConditions = new HashMap();
            for (int i5 = 0; i5 < items.size(); ++i5) {
                item = items.get(i5);
                if (!(item instanceof SQLBinaryOpExpr)) continue;
                binaryOpExpr = (SQLBinaryOpExpr)item;
                left = binaryOpExpr.getLeft();
                right2 = binaryOpExpr.getRight();
                if (binaryOpExpr.getOperator() == SQLBinaryOperator.Equality && left instanceof SQLName && right2 instanceof SQLValuableExpr) {
                    constFields.put(left, right2);
                }
                if (!ConstFolding.isLeftNameAndRightLiteral(item)) continue;
                exprList2 = (List)nameConditions.get(left);
                if (exprList2 == null) {
                    exprList2 = new ArrayList();
                    nameConditions.put((SQLName)left, (ArrayList<SQLBinaryOpExpr>)exprList2);
                }
                exprList2.add((SQLBinaryOpExpr)item);
            }
            for (Map.Entry entry : nameConditions.entrySet()) {
                exprList = (List)entry.getValue();
                left = (SQLBinaryOpExpr)exprList.get(0);
                for (int i6 = 1; i6 < exprList.size(); ++i6) {
                    right = (SQLBinaryOpExpr)exprList.get(i6);
                    replaceTo = this.mergeTwiceOp(x, (SQLBinaryOpExpr)left, right);
                    if (replaceTo == null) {
                        left = right;
                        continue;
                    }
                    if (!(replaceTo instanceof SQLBinaryOpExpr)) continue;
                    left = (SQLBinaryOpExpr)replaceTo;
                }
            }
        }
        for (int i7 = 0; i7 < items.size(); ++i7) {
            item2 = items.get(i7);
            item2.accept(this);
        }
        if (x.getItems().size() == 0) {
            this.replaceInParent(x, null);
        }
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        block25: {
            long hashCode64;
            SQLExpr item;
            SQLExpr expr;
            List<SQLExpr> targetList;
            block26: {
                SQLExpr first;
                Object value;
                SQLExpr item0;
                int i;
                x.getExpr().accept(this);
                for (SQLExpr item2 : x.getTargetList()) {
                    item2.accept(this);
                }
                targetList = x.getTargetList();
                HashMap<SQLExpr, Integer> indics = new HashMap<SQLExpr, Integer>();
                for (i = targetList.size() - 1; i >= 0; --i) {
                    SQLExpr itemExpr = targetList.get(i);
                    indics.put(itemExpr, i);
                }
                for (i = targetList.size() - 1; i >= 0; --i) {
                    SQLExpr item3 = targetList.get(i);
                    Integer idx = (Integer)indics.get(item3);
                    if (idx == null || idx >= i) continue;
                    targetList.remove(i);
                }
                expr = x.getExpr();
                if (targetList.size() == 1 && (item0 = targetList.get(0)) instanceof SQLLiteralExpr) {
                    String typeName;
                    if (expr instanceof SQLName) {
                        SQLName name = (SQLName)expr;
                        SQLDataType nameDataType = name.computeDataType();
                        if (item0 instanceof SQLLiteralExpr) {
                            SQLLiteralExpr literal = (SQLLiteralExpr)item0;
                            this.handleNameLiteral(x, name, literal);
                        }
                    }
                    if (expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).getResolvedColumn() != null && ("multivalue".equalsIgnoreCase(typeName = ((SQLIdentifierExpr)expr).getResolvedColumn().getDataType().getName()) || "varchar".equalsIgnoreCase(typeName))) {
                        return false;
                    }
                    if (expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getResolvedColumn() != null && ("multivalue".equalsIgnoreCase(typeName = ((SQLPropertyExpr)expr).getResolvedColumn().getDataType().getName()) || "varchar".equalsIgnoreCase(typeName))) {
                        return false;
                    }
                    SQLBinaryOpExpr binaryOpExpr = new SQLBinaryOpExpr(expr.clone(), x.isNot() ? SQLBinaryOperator.LessThanOrGreater : SQLBinaryOperator.Equality, item0.clone());
                    if (this.replaceInParent(x, binaryOpExpr)) {
                        binaryOpExpr.accept(this);
                        ++this.optimizedCount;
                        return false;
                    }
                }
                if (expr instanceof SQLValuableExpr && (value = ((SQLValuableExpr)expr).getValue()) != null) {
                    SQLBooleanExpr falseExpr;
                    Class<?> valueClass = value.getClass();
                    int typeMatchCount = 0;
                    for (int i2 = 0; i2 < targetList.size(); ++i2) {
                        item = targetList.get(i2);
                        if (!(item instanceof SQLValuableExpr)) continue;
                        Iterator<SQLExpr> itemValue = ((SQLValuableExpr)item).getValue();
                        if (value.equals(itemValue)) {
                            SQLBooleanExpr sQLBooleanExpr = new SQLBooleanExpr(!x.isNot());
                            if (!this.replaceInParent(x, sQLBooleanExpr)) continue;
                            ++this.optimizedCount;
                            return false;
                        }
                        if (itemValue == null || itemValue.getClass() != valueClass) continue;
                        ++typeMatchCount;
                    }
                    if (typeMatchCount == targetList.size() && this.replaceInParent(x, falseExpr = new SQLBooleanExpr(x.isNot()))) {
                        ++this.optimizedCount;
                        return false;
                    }
                }
                if (expr instanceof SQLName) {
                    SQLName name = (SQLName)expr;
                    SQLDataType nameDataType = name.computeDataType();
                    for (int i3 = targetList.size() - 1; i3 >= 0; --i3) {
                        SQLExpr item4 = targetList.get(i3);
                        if (nameDataType != null && nameDataType.isInt() && item4 instanceof SQLCharExpr && ((SQLCharExpr)item4).getText().length() == 0) {
                            targetList.remove(i3);
                            continue;
                        }
                        if (!(item4 instanceof SQLLiteralExpr)) continue;
                        SQLLiteralExpr literal = (SQLLiteralExpr)item4;
                        this.handleNameLiteral(x, name, literal);
                    }
                }
                if (targetList.size() > 0 && ((first = targetList.get(0)) instanceof SQLCharExpr || first instanceof SQLIdentifierExpr)) {
                    for (int i4 = 1; i4 < targetList.size(); ++i4) {
                        SQLCharExpr charExpr;
                        SQLExpr item5 = targetList.get(i4);
                        if (!(item5 instanceof SQLHexExpr) || (charExpr = ((SQLHexExpr)item5).toCharExpr()) == null) continue;
                        charExpr.setParent(x);
                        targetList.set(i4, charExpr);
                    }
                }
                if (targetList.size() == 0) {
                    SQLBooleanExpr falseExpr = new SQLBooleanExpr(x.isNot());
                    if (this.replaceInParent(x, falseExpr)) {
                        ++this.optimizedCount;
                        return false;
                    }
                    return false;
                }
                if (!(expr instanceof SQLMethodInvokeExpr)) break block25;
                SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)expr;
                SQLDataType methodDataType = methodInvokeExpr.computeDataType();
                hashCode64 = methodInvokeExpr.methodNameHashCode64();
                if (hashCode64 != FnvHash.Constants.CONCAT) break block26;
                boolean allChars = true;
                for (SQLExpr sQLExpr : targetList) {
                    if (sQLExpr instanceof SQLCharExpr) continue;
                    allChars = false;
                    break;
                }
                if (!allChars) break block25;
                SQLMethodInvokeExpr concat = methodInvokeExpr;
                for (SQLExpr item7 : concat.getArguments()) {
                    String text;
                    if (!(item7 instanceof SQLCharExpr) || (text = ((SQLCharExpr)item7).getText()) == null || text.length() == 0) continue;
                    boolean contains = false;
                    for (SQLExpr target : targetList) {
                        String value2 = ((SQLCharExpr)target).getText();
                        if (value2.indexOf(text) == -1) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    this.replaceInParent(x, new SQLBooleanExpr(x.isNot()));
                    return false;
                }
                break block25;
            }
            if (hashCode64 == FnvHash.Constants.STR_TO_DATE) {
                item = targetList.get(0);
                for (SQLExpr sQLExpr : targetList) {
                    if (!(sQLExpr instanceof SQLLiteralExpr)) continue;
                    SQLLiteralExpr literal = (SQLLiteralExpr)sQLExpr;
                    this.handleNameLiteral(x, expr, literal);
                }
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        List<SQLExpr> items = x.getItems();
        for (int i = 0; i < items.size(); ++i) {
            SQLExpr item = items.get(i);
            if (item == null) continue;
            if (item instanceof SQLCurrentTimeExpr) {
                SQLCurrentTimeExpr expr = (SQLCurrentTimeExpr)item;
                this.replaceInParent(expr, new SQLIdentifierExpr(expr.toString()));
                continue;
            }
            item.accept(this);
        }
        if (x.getHaving() != null) {
            x.getHaving().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectOrderByItem x) {
        if (x.getExpr() instanceof SQLCurrentTimeExpr) {
            SQLCurrentTimeExpr expr = (SQLCurrentTimeExpr)x.getExpr();
            this.replaceInParent(expr, new SQLIdentifierExpr(expr.toString()));
        } else {
            x.getExpr().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        SQLExpr expr;
        boolean isIntType;
        x.getTestExpr().accept(this);
        x.getBeginExpr().accept(this);
        x.getEndExpr().accept(this);
        SQLExpr testExpr = x.getTestExpr();
        SQLExpr beginExpr = x.getBeginExpr();
        SQLExpr endExpr = x.getEndExpr();
        SQLDataType testType = testExpr.computeDataType();
        SQLDataType beginType = beginExpr.computeDataType();
        SQLDataType endType = endExpr.computeDataType();
        boolean bl = isIntType = beginType != null && beginType.isInt() || endType != null && endType.isInt();
        if (isIntType && testType != null && testType.isString()) {
            boolean cast = true;
            if (testExpr instanceof SQLCharExpr) {
                String text = ((SQLCharExpr)testExpr).getText();
                try {
                    long l = Long.parseLong(text);
                    testExpr = SQLIntegerExpr.ofIntOrLong(l);
                    x.setTestExpr(testExpr);
                    testType = testExpr.computeDataType();
                    cast = false;
                }
                catch (NumberFormatException l) {
                    // empty catch block
                }
            }
            if (cast) {
                SQLCastExpr castExpr = new SQLCastExpr(testExpr.clone(), new SQLDataTypeImpl("BIGINT"));
                testExpr = castExpr;
                x.setTestExpr(testExpr);
                testType = testExpr.computeDataType();
            }
        }
        if ((expr = x.getTestExpr()) instanceof SQLName) {
            SQLName name = (SQLName)expr;
            if (x.getBeginExpr() instanceof SQLLiteralExpr) {
                this.handleNameLiteral(x, name, (SQLLiteralExpr)x.getBeginExpr());
            }
            if (x.getEndExpr() instanceof SQLLiteralExpr) {
                this.handleNameLiteral(x, name, (SQLLiteralExpr)x.getEndExpr());
            }
        } else if (expr instanceof SQLValuableExpr && x.getBeginExpr() instanceof SQLValuableExpr && x.getEndExpr() instanceof SQLValuableExpr) {
            boolean result;
            Object value = ((SQLValuableExpr)expr).getValue();
            Object begin = ((SQLValuableExpr)x.getBeginExpr()).getValue();
            Object end = ((SQLValuableExpr)x.getEndExpr()).getValue();
            if (value instanceof Integer && begin instanceof Integer && end instanceof Integer) {
                int valueInt = (Integer)value;
                int beginInt = (Integer)begin;
                int endInt = (Integer)end;
                boolean bl2 = result = valueInt >= beginInt && valueInt <= endInt;
                if (x.isNot()) {
                    boolean bl3 = result = !result;
                }
                if (this.replaceInParent(x, new SQLBooleanExpr(result))) {
                    ++this.optimizedCount;
                }
            }
            if (value instanceof String && begin instanceof String && end instanceof String) {
                String valueStr = (String)value;
                String beginStr = (String)begin;
                String endStr = (String)end;
                if (valueStr.length() != ((String)begin).length() || valueStr.length() != endStr.length()) {
                    return false;
                }
                boolean bl4 = result = valueStr.compareTo(beginStr) >= 0 && valueStr.compareTo(endStr) <= 0;
                if (x.isNot()) {
                    boolean bl5 = result = !result;
                }
                if (this.replaceInParent(x, new SQLBooleanExpr(result))) {
                    ++this.optimizedCount;
                    return false;
                }
            }
        } else if (expr.computeDataType() != null) {
            if (x.getBeginExpr() instanceof SQLLiteralExpr) {
                this.handleNameLiteral(x, expr, (SQLLiteralExpr)x.getBeginExpr());
            }
            if (x.getEndExpr() instanceof SQLLiteralExpr) {
                this.handleNameLiteral(x, expr, (SQLLiteralExpr)x.getEndExpr());
            }
        }
        if (x.getBeginExpr() instanceof SQLValuableExpr && x.getEndExpr() instanceof SQLValuableExpr) {
            int result;
            Object beginVal = ((SQLValuableExpr)x.getBeginExpr()).getValue();
            Object endVal = ((SQLValuableExpr)x.getEndExpr()).getValue();
            if (beginVal != null && endVal != null && beginVal.getClass() == endVal.getClass() && beginVal instanceof Comparable && beginVal.getClass() != String.class && (result = ((Comparable)beginVal).compareTo(endVal)) > 0) {
                this.replaceInParent(x, new SQLBooleanExpr(false));
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLExistsExpr x) {
        x.getSubQuery().accept(this);
        SQLSelect select = x.getSubQuery();
        SQLSelectQueryBlock queryBlock = select.getQueryBlock();
        if (queryBlock != null && queryBlock.getWhere() instanceof SQLBooleanExpr) {
            boolean value = ((SQLBooleanExpr)queryBlock.getWhere()).getBooleanValue();
            if (x.isNot() && !value) {
                this.replaceInParent(x, new SQLBooleanExpr(true));
            } else if (!x.isNot() && !value) {
                this.replaceInParent(x, new SQLBooleanExpr(false));
            }
        }
        return false;
    }

    public static boolean isBothName(SQLExpr x) {
        return x instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)x).isBothName();
    }

    public static boolean isLeftNameAndRightLiteral(SQLExpr x) {
        return x instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)x).isLeftNameAndRightLiteral();
    }

    public static boolean isNameAndLiteral(SQLExpr x) {
        return x instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)x).isNameAndLiteral();
    }

    @Override
    public boolean visit(SQLIntervalExpr x) {
        BigDecimal decimal;
        Number num;
        x.getValue().accept(this);
        SQLExpr value = x.getValue();
        if (value instanceof SQLNumberExpr && (num = ((SQLNumberExpr)value).getNumber()) instanceof BigDecimal && (decimal = (BigDecimal)num).toString().endsWith("0")) {
            BigDecimal truncatedVal = decimal.setScale(0, RoundingMode.FLOOR);
            x.setValue(new SQLNumberExpr(truncatedVal));
            ++this.optimizedCount;
        }
        return false;
    }
}

