/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLExistsExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import java.util.ArrayList;
import java.util.List;

public class DecorticateExistsWithAGG
extends OptimizerVisitor {
    private int tableALiasSeed = 1;

    protected String genTableAlias() {
        return "SM_T_" + this.tableALiasSeed++ + "_";
    }

    @Override
    public boolean visit(SQLExistsExpr x) {
        SQLSelect select = x.getSubQuery();
        SQLSelectQueryBlock queryBlock = select.getQueryBlock();
        if (queryBlock == null) {
            return true;
        }
        SQLSelectGroupByClause groupBy = queryBlock.getGroupBy();
        if (groupBy == null || groupBy.getItems().size() == 0) {
            return true;
        }
        SQLTableSource from = queryBlock.getFrom();
        if (from instanceof SQLJoinTableSource) {
            return true;
        }
        SQLExpr where = queryBlock.getWhere();
        if (where == null) {
            return true;
        }
        if (x.isNot()) {
            return true;
        }
        long aliasHashCode64 = from.aliasHashCode64();
        List<SQLExpr> items = SQLBinaryOpExpr.split(where, SQLBinaryOperator.BooleanAnd);
        ArrayList<SQLBinaryOpExpr> joinConditions = new ArrayList<SQLBinaryOpExpr>();
        for (SQLExpr item : items) {
            SQLBinaryOpExpr binaryOpItem;
            if (!(item instanceof SQLBinaryOpExpr) || !(binaryOpItem = (SQLBinaryOpExpr)item).isBothName()) continue;
            if (binaryOpItem.getOperator() != SQLBinaryOperator.Equality) {
                return true;
            }
            SQLExpr left = binaryOpItem.getLeft();
            if (left instanceof SQLIdentifierExpr) {
                return true;
            }
            SQLExpr sQLExpr = binaryOpItem.getRight();
            if (sQLExpr instanceof SQLIdentifierExpr) {
                return true;
            }
            joinConditions.add(binaryOpItem);
        }
        ArrayList<SQLPropertyExpr> array = new ArrayList<SQLPropertyExpr>();
        SQLListExpr selectArray = new SQLListExpr();
        ArrayList<SQLBinaryOpExpr> replacedConditions = new ArrayList<SQLBinaryOpExpr>();
        for (SQLBinaryOpExpr sQLBinaryOpExpr : joinConditions) {
            SQLPropertyExpr sQLPropertyExpr = (SQLPropertyExpr)sQLBinaryOpExpr.getLeft();
            SQLPropertyExpr right = (SQLPropertyExpr)sQLBinaryOpExpr.getRight();
            if (!(sQLPropertyExpr.getOwner() instanceof SQLIdentifierExpr)) {
                return true;
            }
            if (!(right.getOwner() instanceof SQLIdentifierExpr)) {
                return true;
            }
            SQLIdentifierExpr leftOwner = (SQLIdentifierExpr)sQLPropertyExpr.getOwner();
            SQLIdentifierExpr rightOwner = (SQLIdentifierExpr)right.getOwner();
            if (leftOwner.nameHashCode64() == aliasHashCode64 && rightOwner.nameHashCode64() == aliasHashCode64) {
                return true;
            }
            if (leftOwner.nameHashCode64() != aliasHashCode64 && rightOwner.nameHashCode64() != aliasHashCode64) {
                return true;
            }
            if (leftOwner.nameHashCode64() == aliasHashCode64 && rightOwner.nameHashCode64() != aliasHashCode64) {
                selectArray.addItem(sQLPropertyExpr.clone());
                array.add(right);
                replacedConditions.add(sQLBinaryOpExpr);
                continue;
            }
            if (leftOwner.nameHashCode64() == aliasHashCode64 || rightOwner.nameHashCode64() != aliasHashCode64) continue;
            array.add(sQLPropertyExpr);
            selectArray.addItem(right.clone());
            replacedConditions.add(sQLBinaryOpExpr);
        }
        SQLIdentifierExpr parentTable = null;
        for (SQLExpr sQLExpr : array) {
            SQLPropertyExpr propertyItem = (SQLPropertyExpr)sQLExpr;
            if (parentTable == null) {
                parentTable = (SQLIdentifierExpr)propertyItem.getOwner();
                continue;
            }
            if (parentTable.equals(propertyItem.getOwner())) continue;
            return true;
        }
        SQLSelectQueryBlock sQLSelectQueryBlock = queryBlock.clone();
        sQLSelectQueryBlock.getSelectList().clear();
        for (SQLExpr item : SQLBinaryOpExpr.split(sQLSelectQueryBlock.getWhere(), SQLBinaryOperator.BooleanAnd)) {
            if (!(item instanceof SQLBinaryOpExpr) || !((SQLBinaryOpExpr)item).isBothName()) continue;
            this.replaceInParent(item, null);
        }
        sQLSelectQueryBlock.setDistinct();
        SQLObject sQLObject = x.getParent();
        if (sQLObject == null) {
            return true;
        }
        SQLSelectQueryBlock parentQuery = null;
        if (sQLObject.getParent() instanceof SQLSelectQueryBlock) {
            parentQuery = (SQLSelectQueryBlock)sQLObject.getParent();
        }
        if (parentQuery == null) {
            return true;
        }
        SQLTableSource parentFrom = parentQuery.getFrom();
        SQLExpr parentWhere = parentQuery.getWhere();
        SQLTableSource parentTableSource = parentFrom.findTableSource(parentTable.nameHashCode64());
        if (parentTableSource == null) {
            return true;
        }
        ArrayList<SQLExpr> matchParentFilters = new ArrayList<SQLExpr>();
        List<SQLExpr> parentFilters = SQLBinaryOpExpr.split(parentWhere, SQLBinaryOperator.BooleanAnd);
        for (SQLExpr item : parentFilters) {
            SQLInListExpr in;
            SQLPropertyExpr name;
            if (item instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr parentFilter = (SQLBinaryOpExpr)item;
                SQLExpr left = parentFilter.getLeft();
                SQLExpr right = parentFilter.getRight();
                SQLPropertyExpr name2 = null;
                SQLLiteralExpr value = null;
                if (left instanceof SQLPropertyExpr && right instanceof SQLLiteralExpr) {
                    name2 = (SQLPropertyExpr)left;
                    value = (SQLLiteralExpr)right;
                } else if (right instanceof SQLPropertyExpr && left instanceof SQLLiteralExpr) {
                    name2 = (SQLPropertyExpr)right;
                    value = (SQLLiteralExpr)left;
                }
                if (name2 == null || value == null || !name2.getOwner().equals(parentTable)) continue;
                matchParentFilters.add(parentFilter);
                continue;
            }
            if (item instanceof SQLBetweenExpr) {
                SQLBetweenExpr betweenExpr = (SQLBetweenExpr)item;
                if (!(betweenExpr.getTestExpr() instanceof SQLPropertyExpr) || !(betweenExpr.getBeginExpr() instanceof SQLLiteralExpr) || !(betweenExpr.getEndExpr() instanceof SQLLiteralExpr) || !(name = (SQLPropertyExpr)betweenExpr.getTestExpr()).getOwner().equals(parentTable)) continue;
                matchParentFilters.add(item);
                continue;
            }
            if (!(item instanceof SQLInListExpr) || !((in = (SQLInListExpr)item).getExpr() instanceof SQLPropertyExpr) || !(name = (SQLPropertyExpr)in.getExpr()).getOwner().equals(parentTable)) continue;
            matchParentFilters.add(item);
        }
        String subQueryJoinToAlias = this.genTableAlias();
        SQLTableSource subQueryJoinTo = parentTableSource.clone();
        subQueryJoinTo.setAlias(subQueryJoinToAlias);
        String subQueryJoinToSubQueryAlias = this.genTableAlias();
        MySqlSelectQueryBlock subQueryJoinToSubQuery = new MySqlSelectQueryBlock();
        subQueryJoinToSubQuery.setDistinct();
        subQueryJoinToSubQuery.setFrom(subQueryJoinTo);
        for (SQLExpr item : selectArray.getItems()) {
            if (item instanceof SQLPropertyExpr) {
                subQueryJoinToSubQuery.addSelectItem(new SQLIdentifierExpr(((SQLPropertyExpr)item).getName()));
                continue;
            }
            if (item instanceof SQLIdentifierExpr) {
                subQueryJoinToSubQuery.addSelectItem(item.clone());
                continue;
            }
            return false;
        }
        SQLJoinTableSource join = new SQLJoinTableSource(sQLSelectQueryBlock.getFrom(), SQLJoinTableSource.JoinType.INNER_JOIN, new SQLSubqueryTableSource(subQueryJoinToSubQuery, subQueryJoinToSubQueryAlias), null);
        String leftAlias = sQLSelectQueryBlock.getFrom().computeAlias();
        for (int i = 0; i < array.size(); ++i) {
            SQLExpr arrayItem = ((SQLExpr)array.get(i)).clone();
            if (arrayItem instanceof SQLPropertyExpr) {
                ((SQLPropertyExpr)arrayItem).setOwner(leftAlias);
            } else if (arrayItem instanceof SQLIdentifierExpr) {
                arrayItem = new SQLPropertyExpr(leftAlias, ((SQLIdentifierExpr)arrayItem).getName());
            } else {
                return false;
            }
            SQLPropertyExpr subQueryColumn = new SQLPropertyExpr(subQueryJoinToSubQueryAlias, ((SQLName)selectArray.getItems().get(i)).getSimpleName());
            join.addCondition(new SQLBinaryOpExpr(arrayItem, SQLBinaryOperator.Equality, subQueryColumn));
            sQLSelectQueryBlock.getGroupBy().addItem(i, subQueryColumn.clone());
            sQLSelectQueryBlock.addSelectItem(subQueryColumn.clone());
        }
        sQLSelectQueryBlock.setFrom(join);
        for (SQLExpr item : matchParentFilters) {
            SQLExpr subQueryJoinToFilter = item.clone();
            SQLPropertyExpr name = null;
            if (item instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)subQueryJoinToFilter;
                SQLExpr left = binaryOpExpr.getLeft();
                SQLExpr right = binaryOpExpr.getRight();
                if (left instanceof SQLPropertyExpr) {
                    name = (SQLPropertyExpr)left;
                } else if (right instanceof SQLPropertyExpr) {
                    name = (SQLPropertyExpr)right;
                }
            } else if (item instanceof SQLBetweenExpr) {
                name = (SQLPropertyExpr)((SQLBetweenExpr)item).getTestExpr();
            } else if (item instanceof SQLInListExpr) {
                name = (SQLPropertyExpr)((SQLBetweenExpr)item).getTestExpr();
            } else {
                throw new IllegalStateException();
            }
            name.setOwner(subQueryJoinToAlias);
            subQueryJoinToSubQuery.addWhere(subQueryJoinToFilter);
        }
        SQLSubqueryTableSource tableSource = new SQLSubqueryTableSource(sQLSelectQueryBlock);
        String tableSourceAlias = this.genTableAlias();
        tableSource.setAlias(tableSourceAlias);
        SQLJoinTableSource join2 = new SQLJoinTableSource(parentFrom, SQLJoinTableSource.JoinType.INNER_JOIN, tableSource, null);
        for (int i = 0; i < array.size(); ++i) {
            SQLPropertyExpr subQueryColumn = new SQLPropertyExpr(tableSourceAlias, ((SQLName)selectArray.getItems().get(i)).getSimpleName());
            join2.addCondition(new SQLBinaryOpExpr(((SQLExpr)array.get(i)).clone(), SQLBinaryOperator.Equality, subQueryColumn));
        }
        for (SQLBinaryOpExpr item : joinConditions) {
            sQLSelectQueryBlock.removeCondition(item);
        }
        boolean replaced = this.replaceInParent(x, null);
        if (!replaced) {
            return true;
        }
        parentQuery.setFrom(join2);
        return true;
    }
}

