/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.oracle.ast.expr.OracleOuterExpr;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import java.util.Arrays;
import java.util.List;

public class ImplicitJoinRewrite
extends OptimizerVisitor {
    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        if (!(x.getFrom() instanceof SQLJoinTableSource)) {
            return super.visit(x);
        }
        SQLExpr where = x.getWhere();
        if (where == null) {
            return super.visit(x);
        }
        SQLJoinTableSource from = (SQLJoinTableSource)x.getFrom();
        List<SQLExpr> conditions = null;
        if (where instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)where).getOperator() == SQLBinaryOperator.BooleanAnd) {
            conditions = SQLBinaryOpExpr.split((SQLBinaryOpExpr)where);
        } else if (where instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)where).getOperator() == SQLBinaryOperator.Equality) {
            conditions = Arrays.asList(where);
        } else if (where instanceof SQLBinaryOpExprGroup && ((SQLBinaryOpExprGroup)where).getOperator() == SQLBinaryOperator.BooleanAnd) {
            conditions = ((SQLBinaryOpExprGroup)where).getItems();
        }
        if (conditions == null) {
            return super.visit(x);
        }
        for (int i = conditions.size() - 1; i >= 0; --i) {
            SQLBinaryOpExpr joinCondition;
            SQLJoinTableSource.JoinType joinType;
            SQLJoinTableSource join;
            SQLName right;
            SQLName left;
            SQLBinaryOpExpr condition;
            SQLBinaryOperator operator;
            SQLExpr item = conditions.get(i);
            if (!(item instanceof SQLBinaryOpExpr) || (operator = (condition = (SQLBinaryOpExpr)item).getOperator()) != SQLBinaryOperator.Equality) continue;
            SQLExpr conditionLeft = condition.getLeft();
            if (conditionLeft instanceof SQLName && condition.getRight() instanceof SQLName) {
                left = (SQLName)conditionLeft;
                right = (SQLName)condition.getRight();
                join = from.findTableSourceWithColumn(left, right);
                if (join == null) continue;
                joinType = join.getJoinType();
                if (joinType == SQLJoinTableSource.JoinType.COMMA || joinType == SQLJoinTableSource.JoinType.INNER_JOIN || joinType == SQLJoinTableSource.JoinType.CROSS_JOIN) {
                    joinCondition = condition.clone();
                    if (joinType == SQLJoinTableSource.JoinType.COMMA && join.getLeft() instanceof SQLExprTableSource && join.getRight() instanceof SQLExprTableSource) {
                        SQLColumnDefinition leftColumn = left.getResolvedColumn();
                        SQLColumnDefinition rightColumn = right.getResolvedColumn();
                        if (leftColumn == null || !leftColumn.isOnlyPrimaryKey() || rightColumn == null || !rightColumn.isOnlyPrimaryKey() || !SQLUtils.replaceInParent(item, null)) continue;
                        join.setJoinType(SQLJoinTableSource.JoinType.INNER_JOIN);
                        join.addCondition(joinCondition);
                        continue;
                    }
                }
            }
            if (!(conditionLeft instanceof OracleOuterExpr) || !(((OracleOuterExpr)conditionLeft).getExpr() instanceof SQLName) || !(condition.getRight() instanceof SQLName) || (join = from.findTableSourceWithColumn(left = (SQLName)((OracleOuterExpr)conditionLeft).getExpr(), right = (SQLName)condition.getRight())) == null || (joinType = join.getJoinType()) != SQLJoinTableSource.JoinType.COMMA && joinType != SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN) continue;
            joinCondition = new SQLBinaryOpExpr(left, operator, right, this.dbType);
            if (!SQLUtils.replaceInParent(item, null)) continue;
            if (joinType == SQLJoinTableSource.JoinType.COMMA) {
                join.setJoinType(SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN);
            }
            join.addCondition(joinCondition);
        }
        return super.visit(x);
    }
}

