/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import java.util.ArrayList;

public class MergeUnion
extends OptimizerVisitor {
    @Override
    public boolean visit(SQLUnionQuery x) {
        switch (x.getOperator()) {
            case UNION: {
                break;
            }
            default: {
                return true;
            }
        }
        if (x.getRelations().size() > 2) {
            int i;
            for (SQLSelectQuery relation : x.getRelations()) {
                relation.accept(this);
            }
            if (!(x.getRelations().get(0) instanceof SQLSelectQueryBlock)) {
                return false;
            }
            SQLSelectQueryBlock first = (SQLSelectQueryBlock)x.getRelations().get(0).clone();
            ArrayList<Integer> indics = new ArrayList<Integer>();
            for (i = 1; i < x.getRelations().size(); ++i) {
                SQLSelectQueryBlock right;
                SQLSelectQuery item = x.getRelations().get(i);
                if (!(item instanceof SQLSelectQueryBlock) || !first.equalsForMergeJoin(right = (SQLSelectQueryBlock)item) || right.getWhere() == null) continue;
                SQLExpr rightWhere = right.getWhere().clone();
                if (rightWhere instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)rightWhere).getOperator() == SQLBinaryOperator.BooleanAnd) {
                    ((SQLBinaryOpExpr)rightWhere).setBracket(true);
                }
                first.whereOr(rightWhere);
                if (first.getWhere() instanceof SQLBinaryOpExprGroup) {
                    ((SQLBinaryOpExprGroup)first.getWhere()).optimize();
                }
                indics.add(i);
            }
            if (indics.size() > 0) {
                for (i = indics.size() - 1; i >= 0; --i) {
                    x.getRelations().remove((Integer)indics.get(i));
                }
                x.getRelations().set(0, first);
                first.setParent(x);
            }
            return false;
        }
        x.getLeft().accept(this);
        x.getRight().accept(this);
        if (x.getLeft() instanceof SQLSelectQueryBlock && x.getRight() instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock parentParent;
            SQLObject parent;
            SQLSelectQueryBlock right;
            SQLSelectQueryBlock left = (SQLSelectQueryBlock)x.getLeft();
            if (!left.equalsForMergeJoin(right = (SQLSelectQueryBlock)x.getRight())) {
                return false;
            }
            SQLSelectQueryBlock queryBlock = left.clone();
            if (right.getWhere() != null) {
                SQLExpr rightWhere = right.getWhere().clone();
                if (rightWhere instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)rightWhere).getOperator() == SQLBinaryOperator.BooleanAnd) {
                    ((SQLBinaryOpExpr)rightWhere).setBracket(true);
                }
                queryBlock.whereOr(rightWhere);
                if (queryBlock.getWhere() instanceof SQLBinaryOpExprGroup) {
                    ((SQLBinaryOpExprGroup)queryBlock.getWhere()).optimize();
                }
            }
            if ((parent = x.getParent()) instanceof SQLUnionQuery) {
                SQLUnionQuery union = (SQLUnionQuery)parent;
                if (union.getLeft() == x) {
                    union.setLeft(queryBlock);
                } else {
                    union.setRight(queryBlock);
                }
                return false;
            }
            if (parent instanceof SQLUnionQueryTableSource && parent.getParent() instanceof SQLSelectQueryBlock && (parentParent = (SQLSelectQueryBlock)parent.getParent()).getFrom() == parent) {
                parentParent.setFrom(new SQLSubqueryTableSource(queryBlock));
                return false;
            }
        }
        return false;
    }
}

