/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateOption;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCastExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class MultiDistinctEagerAggregation
extends OptimizerVisitor {
    private int columnALiasSeed = 1;
    private int tableALiasSeed = 1;

    protected String genColumnAlias() {
        return "DEA_F_" + this.columnALiasSeed++ + "_";
    }

    protected String genTableAlias() {
        return "DEA_T_" + this.tableALiasSeed++ + "_";
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        List<SQLSelectItem> selectList;
        SQLSelectGroupByClause groupBy = x.getGroupBy();
        if (groupBy == null || groupBy.getItems().size() != 1 && groupBy.getItems().size() != 2) {
            return true;
        }
        int groupByItemSize = groupBy.getItems().size();
        SQLExpr having = groupBy.getHaving();
        if (having != null) {
            if (having instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)having;
                SQLExpr left = binaryOpExpr.getLeft();
                SQLExpr right = binaryOpExpr.getRight();
                if (left instanceof SQLAggregateExpr) {
                    boolean matched = false;
                    for (SQLSelectItem selectItem : x.getSelectList()) {
                        if (!selectItem.getExpr().equals(left)) continue;
                        matched = true;
                        break;
                    }
                    if (!matched) {
                        return true;
                    }
                    SQLAggregateExpr leftAgg = (SQLAggregateExpr)left;
                    if (leftAgg.getOver() != null && leftAgg.getArguments().size() != 1) {
                        return true;
                    }
                }
                if (!(right instanceof SQLLiteralExpr)) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if ((selectList = x.getSelectList()).size() < 2) {
            return true;
        }
        SQLExpr fistExpr = selectList.get(0).getExpr();
        if (fistExpr instanceof SQLAggregateExpr || !(fistExpr instanceof SQLMethodInvokeExpr) && !(fistExpr instanceof SQLName)) {
            return true;
        }
        SQLExpr secondExpr = null;
        if (groupByItemSize == 2 && ((secondExpr = selectList.get(1).getExpr()) instanceof SQLAggregateExpr || !(secondExpr instanceof SQLMethodInvokeExpr) && !(secondExpr instanceof SQLName))) {
            return true;
        }
        ArrayList<SQLAggregateExpr> countDistinctOrSumList = new ArrayList<SQLAggregateExpr>();
        for (int i = groupByItemSize; i < selectList.size(); ++i) {
            SQLExpr expr = selectList.get(i).getExpr();
            if (expr instanceof SQLBinaryOpExpr) {
                if (!this.extractBinaryOp(countDistinctOrSumList, (SQLBinaryOpExpr)expr)) continue;
                return true;
            }
            if (expr instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)expr).methodNameHashCode64() == FnvHash.Constants.ROUND && ((SQLMethodInvokeExpr)expr).getArguments().size() == 2 && ((SQLMethodInvokeExpr)expr).getArguments().get(1) instanceof SQLLiteralExpr) {
                SQLExpr arg0 = ((SQLMethodInvokeExpr)expr).getArguments().get(0);
                if (arg0 instanceof SQLBinaryOpExpr) {
                    if (!this.extractBinaryOp(countDistinctOrSumList, (SQLBinaryOpExpr)arg0)) continue;
                    return true;
                }
                return true;
            }
            if (!this.isCountDistinctOrSum(expr)) {
                return true;
            }
            if (countDistinctOrSumList.contains(expr)) continue;
            countDistinctOrSumList.add((SQLAggregateExpr)expr);
        }
        if (countDistinctOrSumList.size() < 2) {
            return true;
        }
        MySqlSelectQueryBlock subQuery = x.clone();
        for (int i = subQuery.getSelectList().size() - 1; i >= groupByItemSize; --i) {
            subQuery.getSelectList().remove(i);
        }
        subQuery.setLimit(null);
        subQuery.setOrderBy(null);
        subQuery.getGroupBy().setHaving(null);
        if (subQuery.getGroupBy().getItems().get(0).equals(subQuery.getSelectList().get(0).getExpr()) && !(subQuery.getGroupBy().getItems().get(0) instanceof SQLIntegerExpr)) {
            SQLIntegerExpr one = new SQLIntegerExpr(1);
            one.setParent(subQuery);
            subQuery.getGroupBy().getItems().set(0, one);
        }
        subQuery.getSelectList().get(0).setAlias(this.genColumnAlias());
        if (groupByItemSize == 2) {
            if (subQuery.getGroupBy().getItems().get(1).equals(subQuery.getSelectList().get(1).getExpr()) && !(subQuery.getGroupBy().getItems().get(1) instanceof SQLIntegerExpr)) {
                SQLIntegerExpr two = new SQLIntegerExpr(2);
                two.setParent(subQuery);
                subQuery.getGroupBy().getItems().set(1, two);
            }
            subQuery.getSelectList().get(1).setAlias(this.genColumnAlias());
        }
        for (SQLAggregateExpr aggregateExpr : countDistinctOrSumList) {
            SQLExpr itemExpr = aggregateExpr.methodNameHashCode64() == FnvHash.Constants.SUM ? aggregateExpr.clone() : aggregateExpr.getArguments().get(0).clone();
            subQuery.addSelectItem(itemExpr.clone(), this.genColumnAlias());
            if (aggregateExpr.methodNameHashCode64() == FnvHash.Constants.SUM) continue;
            subQuery.getGroupBy().addItem(new SQLIntegerExpr(subQuery.getSelectList().size()));
        }
        MySqlSelectQueryBlock queryBlock = new MySqlSelectQueryBlock();
        queryBlock.setFrom(subQuery, this.genTableAlias());
        queryBlock.addSelectItem(new SQLIdentifierExpr(subQuery.getSelectList().get(0).getAlias()), x.getSelectList().get(0).computeAlias());
        if (groupByItemSize == 2) {
            queryBlock.addSelectItem(new SQLIdentifierExpr(subQuery.getSelectList().get(1).getAlias()), x.getSelectList().get(1).computeAlias());
        }
        for (int i = groupByItemSize; i < x.getSelectList().size(); ++i) {
            SQLSelectItem item = x.getSelectList().get(i);
            SQLExpr itemExpr = item.getExpr();
            if (itemExpr instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)itemExpr).methodNameHashCode64() == FnvHash.Constants.ROUND && ((SQLMethodInvokeExpr)itemExpr).getArguments().size() == 2 && ((SQLMethodInvokeExpr)itemExpr).getArguments().get(1) instanceof SQLLiteralExpr) {
                SQLExpr newItem = itemExpr.clone();
                SQLBinaryOpExpr arg0 = (SQLBinaryOpExpr)((SQLMethodInvokeExpr)newItem).getArguments().get(0);
                SQLAggregateExpr leftAgg = null;
                SQLAggregateExpr rightAgg = null;
                SQLExpr left = arg0.getLeft();
                leftAgg = left instanceof SQLCastExpr ? (SQLAggregateExpr)((SQLCastExpr)left).getExpr() : (SQLAggregateExpr)left;
                rightAgg = (SQLAggregateExpr)arg0.getRight();
                String leftAlias = null;
                String rightAlias = null;
                for (SQLSelectItem subItem : subQuery.getSelectList()) {
                    SQLExpr subItemExpr = subItem.getExpr();
                    if (leftAgg.methodNameHashCode64() == FnvHash.Constants.SUM) {
                        if (subItemExpr.equals(leftAgg)) {
                            leftAlias = subItem.getAlias();
                        }
                    } else if (subItemExpr.equals(leftAgg.getArguments().get(0))) {
                        leftAlias = subItem.getAlias();
                    }
                    if (rightAgg.methodNameHashCode64() == FnvHash.Constants.SUM) {
                        if (!subItemExpr.equals(rightAgg)) continue;
                        rightAlias = subItem.getAlias();
                        continue;
                    }
                    if (!subItemExpr.equals(rightAgg.getArguments().get(0))) continue;
                    rightAlias = subItem.getAlias();
                }
                if (leftAlias == null || rightAlias == null) {
                    return true;
                }
                if (left instanceof SQLCastExpr) {
                    ((SQLCastExpr)left).setExpr(this.buildExpr(leftAgg, leftAlias));
                } else {
                    arg0.setLeft(this.buildExpr(leftAgg, leftAlias));
                }
                arg0.setRight(this.buildExpr(rightAgg, rightAlias));
                queryBlock.addSelectItem(newItem, item.getAlias());
                continue;
            }
            if (itemExpr instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)itemExpr.clone();
                String leftAlias = null;
                Object rightAlias = null;
                SQLAggregateExpr leftAgg = (SQLAggregateExpr)binaryOpExpr.getLeft();
                SQLAggregateExpr rightAgg = (SQLAggregateExpr)binaryOpExpr.getRight();
                for (SQLSelectItem subItem : subQuery.getSelectList()) {
                    SQLExpr subItemExpr = subItem.getExpr();
                    if (leftAgg.methodNameHashCode64() == FnvHash.Constants.SUM) {
                        if (subItemExpr.equals(leftAgg)) {
                            leftAlias = subItem.getAlias();
                        }
                    } else if (subItemExpr.equals(leftAgg.getArguments().get(0))) {
                        leftAlias = subItem.getAlias();
                    }
                    if (rightAgg.methodNameHashCode64() == FnvHash.Constants.SUM) {
                        if (!subItemExpr.equals(rightAgg)) continue;
                        rightAlias = subItem.getAlias();
                        continue;
                    }
                    if (!subItemExpr.equals(rightAgg.getArguments().get(0))) continue;
                    rightAlias = subItem.getAlias();
                }
                if (leftAlias == null || rightAlias == null) {
                    return true;
                }
                binaryOpExpr.setLeft(this.buildExpr(leftAgg, leftAlias));
                binaryOpExpr.setRight(this.buildExpr(rightAgg, (String)rightAlias));
                queryBlock.addSelectItem(binaryOpExpr, item.getAlias());
                continue;
            }
            SQLAggregateExpr aggExpr = (SQLAggregateExpr)itemExpr;
            String alias = null;
            for (SQLSelectItem subItem : subQuery.getSelectList()) {
                SQLExpr subItemExpr = subItem.getExpr();
                if (aggExpr.methodNameHashCode64() == FnvHash.Constants.SUM) {
                    if (!subItemExpr.equals(aggExpr)) continue;
                    alias = subItem.getAlias();
                    continue;
                }
                if (!subItemExpr.equals(aggExpr.getArguments().get(0))) continue;
                alias = subItem.getAlias();
            }
            SQLExpr builtItemExpr = this.buildExpr(aggExpr, alias);
            queryBlock.addSelectItem(builtItemExpr, item.getAlias());
        }
        queryBlock.setGroupBy(groupBy.clone());
        SQLIntegerExpr one = new SQLIntegerExpr(1);
        one.setParent(queryBlock);
        queryBlock.getGroupBy().getItems().set(0, one);
        if (groupByItemSize == 2) {
            SQLIntegerExpr two = new SQLIntegerExpr(2);
            two.setParent(queryBlock);
            queryBlock.getGroupBy().getItems().set(1, two);
        }
        if (x.getLimit() != null) {
            queryBlock.setLimit(x.getLimit().clone());
        }
        if (x.getOrderBy() != null) {
            queryBlock.setOrderBy(x.getOrderBy().clone());
        }
        if (having != null) {
            SQLBinaryOpExpr havingExpr = (SQLBinaryOpExpr)queryBlock.getGroupBy().getHaving();
            SQLAggregateExpr havingLeft = (SQLAggregateExpr)havingExpr.getLeft();
            String subAlias = null;
            for (SQLSelectItem subItem : subQuery.getSelectList()) {
                if (!subItem.getExpr().equals(havingLeft)) continue;
                subAlias = subItem.getAlias();
            }
            if (subAlias == null) {
                return true;
            }
            havingLeft.setArgument(0, new SQLIdentifierExpr(subAlias));
        }
        return !SQLUtils.replaceInParent(x, queryBlock);
    }

    private SQLExpr buildExpr(SQLAggregateExpr itemExpr, String alias) {
        return itemExpr.methodNameHashCode64() == FnvHash.Constants.SUM ? new SQLAggregateExpr("SUM", null, new SQLExpr[]{new SQLIdentifierExpr(alias)}) : new SQLAggregateExpr("COUNT", SQLAggregateOption.DISTINCT, new SQLIdentifierExpr(alias));
    }

    private boolean extractBinaryOp(List<SQLAggregateExpr> countDistinctOrSumList, SQLBinaryOpExpr expr) {
        SQLBinaryOpExpr binaryOpExpr = expr;
        SQLExpr left = binaryOpExpr.getLeft();
        if (left instanceof SQLCastExpr) {
            left = ((SQLCastExpr)left).getExpr();
        }
        if (!this.isCountDistinctOrSum(left)) {
            return true;
        }
        SQLExpr right = binaryOpExpr.getRight();
        if (!this.isCountDistinctOrSum(right)) {
            return true;
        }
        if (!countDistinctOrSumList.contains(left)) {
            countDistinctOrSumList.add((SQLAggregateExpr)left);
        }
        if (!countDistinctOrSumList.contains(right)) {
            countDistinctOrSumList.add((SQLAggregateExpr)right);
        }
        return false;
    }

    private boolean isCountDistinctOrSum(SQLExpr expr) {
        if (!(expr instanceof SQLAggregateExpr)) {
            return false;
        }
        SQLAggregateExpr aggExpr = (SQLAggregateExpr)expr;
        if (aggExpr.getOver() != null) {
            return false;
        }
        if (aggExpr.getArguments().size() != 1) {
            return false;
        }
        if (aggExpr.methodNameHashCode64() == FnvHash.Constants.SUM) {
            return true;
        }
        if (aggExpr.methodNameHashCode64() != FnvHash.Constants.COUNT) {
            return false;
        }
        return aggExpr.isDistinct();
    }
}

