/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCastExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNullExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLQueryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTinyIntExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.MySqlUtils;
import com.alibaba.fastsql.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class OptimizerVisitor
extends MySqlASTVisitorAdapter {
    protected TimeZone timeZone;
    protected int optimizedCount = 0;
    protected int repalceFailCount = 0;

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        x.getSelect().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        SQLWithSubqueryClause with = x.getWithSubQuery();
        if (with != null) {
            with.accept(this);
        }
        x.getQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLIdentifierExpr) {
            this.visit((SQLIdentifierExpr)expr);
        } else if (expr instanceof SQLPropertyExpr) {
            this.visit((SQLPropertyExpr)expr);
        } else {
            expr.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause x) {
        List<SQLWithSubqueryClause.Entry> entries = x.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            entries.get(i).accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.visit(x.getSelect());
        return false;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        x.getOwner().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLIdentifierExpr) {
            this.visit((SQLIdentifierExpr)expr);
        } else if (expr instanceof SQLMethodInvokeExpr) {
            this.visit((SQLMethodInvokeExpr)expr);
        } else {
            expr.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        for (SQLExpr arg : x.getArguments()) {
            arg.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLQueryExpr x) {
        this.visit(x.getSubQuery());
        return false;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        return this.visit((SQLSelectQueryBlock)x);
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        SQLLimit limit;
        SQLExpr sQLExpr;
        List<SQLSelectOrderByItem> sortBy;
        List<SQLSelectOrderByItem> distributeBy;
        SQLOrderBy orderBy;
        SQLSelectGroupByClause groupBy;
        SQLExpr connectBy;
        SQLExpr startWith;
        SQLExpr where;
        SQLExprTableSource into;
        for (SQLSelectItem selectItem : x.getSelectList()) {
            this.visit(selectItem);
        }
        SQLTableSource from = x.getFrom();
        if (from != null) {
            from.accept(this);
        }
        if ((into = x.getInto()) != null) {
            into.accept(this);
        }
        if ((where = x.getWhere()) != null) {
            where.accept(this);
        }
        if ((startWith = x.getStartWith()) != null) {
            startWith.accept(this);
        }
        if ((connectBy = x.getConnectBy()) != null) {
            connectBy.accept(this);
        }
        if ((groupBy = x.getGroupBy()) != null) {
            groupBy.accept(this);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            orderBy.accept(this);
        }
        if ((distributeBy = x.getDistributeByDirect()) != null) {
            for (SQLSelectOrderByItem sQLSelectOrderByItem : distributeBy) {
                sQLSelectOrderByItem.accept(this);
            }
        }
        if ((sortBy = x.getSortByDirect()) != null) {
            for (SQLSelectOrderByItem item : sortBy) {
                item.accept(this);
            }
        }
        if ((sQLExpr = x.getWaitTime()) != null) {
            sQLExpr.accept(this);
        }
        if ((limit = x.getLimit()) != null) {
            limit.accept(this);
        }
        return false;
    }

    protected boolean isGroup(SQLBinaryOpExpr x) {
        SQLBinaryOperator operator = x.getOperator();
        if (operator == SQLBinaryOperator.BooleanAnd || operator == SQLBinaryOperator.BooleanOr) {
            SQLExpr left = x.getLeft();
            if (left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)left).getOperator() == operator) {
                return true;
            }
            SQLExpr right = x.getRight();
            if (right instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)right).getOperator() == operator) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        if (this.isGroup(x)) {
            SQLBinaryOpExprGroup group = new SQLBinaryOpExprGroup(x.getOperator());
            SQLBinaryOpExpr.split(group.getItems(), x, x.getOperator());
            for (SQLExpr item : group.getItems()) {
                item.setParent(group);
            }
            if (SQLUtils.replaceInParent(x, group)) {
                group.accept(this);
                return false;
            }
        }
        x.getLeft().accept(this);
        x.getRight().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExprGroup x) {
        for (int i = 0; i < x.getItems().size(); ++i) {
            x.getItems().get(i).accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        for (int i = x.getItems().size() - 1; i >= 0; --i) {
            SQLSelectOrderByItem item = x.getItems().get(i);
            item.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectOrderByItem x) {
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLLimit x) {
        SQLExpr rowCount;
        SQLExpr offset = x.getOffset();
        if (offset != null) {
            offset.accept(this);
        }
        if ((rowCount = x.getRowCount()) != null) {
            rowCount.accept(this);
        }
        return false;
    }

    public int getReplaceCount() {
        return this.optimizedCount;
    }

    public void handleNameLiteral(SQLExpr x, SQLExpr name, SQLLiteralExpr literal) {
        block118: {
            String chars;
            String text;
            SQLDataType dataType = name.computeDataType();
            if (dataType == null) {
                return;
            }
            long dataTypeNameHash = dataType.nameHashCode64();
            if (dataTypeNameHash == FnvHash.Constants.TINYINT) {
                if (literal instanceof SQLCharExpr) {
                    text = ((SQLCharExpr)literal).getText();
                    SQLTinyIntExpr replaceTo = null;
                    try {
                        text = text.trim();
                        byte val = Byte.parseByte(text);
                        replaceTo = new SQLTinyIntExpr(val);
                    }
                    catch (NumberFormatException val) {
                        // empty catch block
                    }
                    if (replaceTo != null && this.replaceInParent(literal, replaceTo)) {
                        ++this.optimizedCount;
                        return;
                    }
                } else if (literal instanceof SQLIntegerExpr) {
                    SQLTinyIntExpr replaceTo = null;
                    try {
                        int intValue = ((SQLIntegerExpr)literal).getNumber().intValue();
                        if (intValue >= -128 && intValue <= 127) {
                            replaceTo = new SQLTinyIntExpr((byte)intValue);
                        }
                    }
                    catch (NumberFormatException intValue) {
                        // empty catch block
                    }
                    if (replaceTo != null && this.replaceInParent(literal, replaceTo)) {
                        ++this.optimizedCount;
                        return;
                    }
                }
            }
            if (dataType.isInt()) {
                SQLBooleanExpr booleanExpr;
                boolean booleanValue;
                SQLIntegerExpr intExpr;
                if (literal instanceof SQLCharExpr) {
                    SQLIntegerExpr replaceTo;
                    block117: {
                        text = ((SQLCharExpr)literal).getText();
                        replaceTo = null;
                        try {
                            text = text.trim();
                            long val = Long.parseLong(text);
                            replaceTo = SQLIntegerExpr.ofIntOrLong(val);
                            if (dataTypeNameHash == FnvHash.Constants.INT && (val < Integer.MIN_VALUE || val > Integer.MAX_VALUE) && x instanceof SQLInListExpr) {
                                ((SQLInListExpr)x).getTargetList().remove(literal);
                            }
                        }
                        catch (NumberFormatException ex) {
                            if (x instanceof SQLBinaryOpExpr) {
                                switch (((SQLBinaryOpExpr)x).getOperator()) {
                                    case Equality: {
                                        if (!this.replaceInParent(x, new SQLBooleanExpr(false))) break;
                                        ++this.optimizedCount;
                                        break;
                                    }
                                    default: {
                                        if (StringUtils.isEmpty(text) || "null".equalsIgnoreCase(text)) {
                                            ((SQLBinaryOpExpr)x).setRight(new SQLNullExpr());
                                            ++this.optimizedCount;
                                            break;
                                        }
                                        SQLCastExpr literalCast = new SQLCastExpr(literal, new SQLDataTypeImpl(dataType.getName()));
                                        literalCast.setTry(true);
                                        ((SQLBinaryOpExpr)x).setRight(literalCast);
                                        ++this.optimizedCount;
                                    }
                                }
                                return;
                            }
                            if (literal.getParent() instanceof SQLInListExpr) {
                                this.replaceInParent(literal, null);
                                return;
                            }
                            if (!(literal.getParent() instanceof SQLBetweenExpr)) {
                                SQLCastExpr nameCast = new SQLCastExpr(name.clone(), new SQLDataTypeImpl("VARCHAR"));
                                this.replaceInParent(name, nameCast);
                                return;
                            }
                            if (!(literal.getParent() instanceof SQLBetweenExpr) || !"null".equalsIgnoreCase(text)) break block117;
                            this.replaceInParent(literal, new SQLNullExpr());
                            ++this.optimizedCount;
                        }
                    }
                    if (replaceTo != null && this.replaceInParent(literal, replaceTo)) {
                        ++this.optimizedCount;
                        return;
                    }
                } else if (literal instanceof SQLNumberExpr) {
                    BigDecimal decimal;
                    SQLNumberExpr numberExpr = (SQLNumberExpr)literal;
                    Number number = numberExpr.getNumber();
                    if (number instanceof BigDecimal && (decimal = (BigDecimal)number).doubleValue() == (double)decimal.longValue()) {
                        BigInteger integer = decimal.toBigInteger();
                        numberExpr.setNumber(integer);
                    }
                } else if (literal instanceof SQLBooleanExpr && this.replaceInParent(literal, intExpr = (booleanValue = (booleanExpr = (SQLBooleanExpr)literal).getBooleanValue()) ? new SQLIntegerExpr(1) : new SQLIntegerExpr(0))) {
                    ++this.optimizedCount;
                }
            } else if (dataType.isString()) {
                SQLCharExpr charExpr;
                if (literal instanceof SQLIntegerExpr) {
                    boolean cmp = false;
                    if (x instanceof SQLBinaryOpExpr) {
                        SQLBinaryOperator op = ((SQLBinaryOpExpr)x).getOperator();
                        switch (op) {
                            case Equality: 
                            case NotEqual: 
                            case LessThanOrGreater: 
                            case LessThan: 
                            case LessThanOrEqual: 
                            case GreaterThan: 
                            case GreaterThanOrEqual: {
                                cmp = true;
                                break;
                            }
                        }
                    } else if (x instanceof SQLInListExpr) {
                        cmp = true;
                    } else if (x instanceof SQLBetweenExpr) {
                        cmp = true;
                    } else if (x instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)x).methodNameHashCode64() == FnvHash.Constants.COALESCE) {
                        cmp = true;
                    }
                    if (cmp) {
                        String text2 = literal.toString();
                        SQLCharExpr charExpr2 = new SQLCharExpr(text2);
                        if (this.replaceInParent(literal, charExpr2)) {
                            ++this.optimizedCount;
                        }
                    } else {
                        SQLCastExpr cast = new SQLCastExpr(name.clone(), SQLIntegerExpr.DATA_TYPE.clone());
                        if (this.replaceInParent(name, cast)) {
                            ++this.optimizedCount;
                        }
                    }
                } else if (literal instanceof SQLBooleanExpr) {
                    SQLCharExpr charExpr3;
                    text = "false";
                    if (((SQLBooleanExpr)literal).getBooleanValue()) {
                        text = "true";
                    }
                    if (this.replaceInParent(literal, charExpr3 = new SQLCharExpr(text))) {
                        ++this.optimizedCount;
                    }
                } else if (literal instanceof SQLNumberExpr && ((SQLNumberExpr)literal).getNumber() instanceof BigDecimal && this.replaceInParent(literal, charExpr = new SQLCharExpr(literal.toString()))) {
                    ++this.optimizedCount;
                }
            } else if (dataTypeNameHash == FnvHash.Constants.DATE) {
                text = null;
                if (literal instanceof SQLCharExpr) {
                    text = ((SQLCharExpr)literal).getText();
                } else if (literal instanceof SQLIntegerExpr) {
                    text = literal.toString();
                }
                if (text != null) {
                    if (text.length() == 0) {
                        this.replaceInParent(literal, new SQLNullExpr());
                        return;
                    }
                    if (text.length() == 21 && text.endsWith(" 00:00:00.0")) {
                        text = text.substring(0, 10);
                    } else if (text.length() == 19 && text.endsWith(" 00:00:00")) {
                        text = text.substring(0, 10);
                    } else if (text.length() == 7 && text.charAt(4) == '-') {
                        this.replaceInParent(x, new SQLBooleanExpr(false));
                        return;
                    }
                    SQLExprImpl replaceTo = null;
                    replaceTo = text.length() == 19 || text.length() == 21 ? new SQLTimestampExpr(text) : new SQLDateExpr(text);
                    this.replaceInParent(literal, replaceTo);
                }
            } else if (dataTypeNameHash == FnvHash.Constants.TIMESTAMP) {
                if (OptimizerVisitor.repalceToTimestamp(literal, this.timeZone)) {
                    ++this.optimizedCount;
                }
            } else if (dataTypeNameHash == FnvHash.Constants.TIME) {
                SQLTimeExpr timeExpr;
                if (literal instanceof SQLCharExpr && this.replaceInParent(literal, timeExpr = new SQLTimeExpr(text = ((SQLCharExpr)literal).getText()))) {
                    ++this.optimizedCount;
                }
            } else if (dataTypeNameHash == FnvHash.Constants.DOUBLE) {
                if (literal instanceof SQLNumberExpr) {
                    double value = ((SQLNumberExpr)literal).getNumber().doubleValue();
                    SQLNumberExpr numberExpr = new SQLNumberExpr(value);
                    if (this.replaceInParent(literal, numberExpr)) {
                        ++this.optimizedCount;
                    }
                } else if (literal instanceof SQLCharExpr) {
                    chars = ((SQLCharExpr)literal).getText();
                    try {
                        double value = Double.parseDouble(chars);
                        SQLNumberExpr numberExpr = new SQLNumberExpr(value);
                        if (this.replaceInParent(literal, numberExpr)) {
                            ++this.optimizedCount;
                        }
                    }
                    catch (NumberFormatException e) {
                        if (x instanceof SQLBinaryOpExpr && "null".equalsIgnoreCase(chars) && (((SQLBinaryOpExpr)x).getOperator() == SQLBinaryOperator.NotEqual || ((SQLBinaryOpExpr)x).getOperator() == SQLBinaryOperator.LessThanOrGreater)) {
                            this.replaceInParent(literal, new SQLNullExpr());
                            break block118;
                        }
                        SQLBooleanExpr booleanExpr = new SQLBooleanExpr(false);
                        this.replaceInParent(x, booleanExpr);
                    }
                } else if (literal instanceof SQLBooleanExpr) {
                    boolean booleanValue = ((SQLBooleanExpr)literal).getBooleanValue();
                    SQLNumberExpr numberExpr = new SQLNumberExpr(0.0);
                    if (booleanValue) {
                        numberExpr = new SQLNumberExpr(1.0);
                    }
                    this.replaceInParent(literal, numberExpr);
                }
            } else if (dataTypeNameHash == FnvHash.Constants.FLOAT) {
                if (literal instanceof SQLNumberExpr) {
                    float value = ((SQLNumberExpr)literal).getNumber().floatValue();
                    SQLNumberExpr numberExpr = new SQLNumberExpr(Float.valueOf(value));
                    if (this.replaceInParent(literal, numberExpr)) {
                        ++this.optimizedCount;
                    }
                } else {
                    if (literal instanceof SQLCharExpr) {
                        chars = ((SQLCharExpr)literal).getText();
                        try {
                            float value = Float.parseFloat(chars);
                            SQLNumberExpr numberExpr = new SQLNumberExpr(Float.valueOf(value));
                            if (this.replaceInParent(literal, numberExpr)) {
                                ++this.optimizedCount;
                            }
                            break block118;
                        }
                        catch (NumberFormatException e) {
                            if (x instanceof SQLBinaryOpExpr && "null".equalsIgnoreCase(chars) && (((SQLBinaryOpExpr)x).getOperator() == SQLBinaryOperator.NotEqual || ((SQLBinaryOpExpr)x).getOperator() == SQLBinaryOperator.LessThanOrGreater)) {
                                this.replaceInParent(literal, new SQLNullExpr());
                            } else {
                                SQLBooleanExpr booleanExpr = new SQLBooleanExpr(false);
                                if (this.replaceInParent(literal, booleanExpr)) {
                                    ++this.optimizedCount;
                                }
                            }
                            break block118;
                        }
                    }
                    if (literal instanceof SQLBooleanExpr) {
                        boolean booleanValue = ((SQLBooleanExpr)literal).getBooleanValue();
                        SQLNumberExpr numberExpr = new SQLNumberExpr(0.0);
                        if (booleanValue) {
                            numberExpr = new SQLNumberExpr(1.0);
                        }
                        if (this.replaceInParent(literal, numberExpr)) {
                            ++this.optimizedCount;
                        }
                    }
                }
            } else if (dataTypeNameHash == FnvHash.Constants.DECIMAL) {
                if (literal instanceof SQLCharExpr) {
                    chars = ((SQLCharExpr)literal).getText();
                    try {
                        BigDecimal value = new BigDecimal(chars);
                        SQLNumberExpr numberExpr = new SQLNumberExpr(value);
                        if (this.replaceInParent(literal, numberExpr)) {
                            ++this.optimizedCount;
                        }
                        break block118;
                    }
                    catch (NumberFormatException e) {
                        if (x instanceof SQLBinaryOpExpr && "null".equalsIgnoreCase(chars) && (((SQLBinaryOpExpr)x).getOperator() == SQLBinaryOperator.NotEqual || ((SQLBinaryOpExpr)x).getOperator() == SQLBinaryOperator.LessThanOrGreater)) {
                            this.replaceInParent(literal, new SQLNullExpr());
                        } else {
                            SQLBooleanExpr booleanExpr = new SQLBooleanExpr(false);
                            if (this.replaceInParent(literal, booleanExpr)) {
                                ++this.optimizedCount;
                            }
                        }
                        break block118;
                    }
                }
                if (literal instanceof SQLBooleanExpr) {
                    boolean booleanValue = ((SQLBooleanExpr)literal).getBooleanValue();
                    SQLNumberExpr numberExpr = new SQLNumberExpr(0.0);
                    if (booleanValue) {
                        numberExpr = new SQLNumberExpr(1.0);
                    }
                    if (this.replaceInParent(literal, numberExpr)) {
                        ++this.optimizedCount;
                    }
                }
            } else if (dataTypeNameHash == FnvHash.Constants.BOOLEAN && literal instanceof SQLIntegerExpr) {
                int val = ((SQLIntegerExpr)literal).getNumber().intValue();
                SQLBooleanExpr bool = null;
                if (val == 1) {
                    bool = new SQLBooleanExpr(true);
                } else if (val == 0) {
                    bool = new SQLBooleanExpr(false);
                }
                if (bool != null && this.replaceInParent(literal, bool)) {
                    ++this.optimizedCount;
                }
            }
        }
    }

    public static boolean repalceToTimestamp(SQLLiteralExpr literal, TimeZone timeZone) {
        int dotIndex;
        SimpleDateFormat dateFormat;
        SimpleDateFormat dateFormat2;
        String str;
        String text = null;
        if (literal instanceof SQLDateExpr) {
            text = ((SQLDateExpr)literal).getLiteral();
        } else if (literal instanceof SQLCharExpr) {
            text = ((SQLCharExpr)literal).getText();
        } else if (literal instanceof SQLTimestampExpr && (str = ((SQLTimestampExpr)literal).getLiteral()).length() < 19) {
            text = str;
        }
        if (text == null || "".equals(text.trim())) {
            return false;
        }
        if ((text = text.trim()).length() == 19) {
            dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                if (timeZone != null) {
                    dateFormat2.setTimeZone(timeZone);
                }
                Date date = dateFormat2.parse(text);
                text = dateFormat2.format(date);
                return SQLUtils.replaceInParent(literal, new SQLTimestampExpr(text));
            }
            catch (ParseException date) {}
        } else if (text.length() == 20 && text.indexOf("  ") > 0) {
            dateFormat2 = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
            try {
                if (timeZone != null) {
                    dateFormat2.setTimeZone(timeZone);
                }
                Date date = dateFormat2.parse(text);
                text = dateFormat2.format(date);
                SQLTimestampExpr replaceTo = new SQLTimestampExpr(date, timeZone);
                return SQLUtils.replaceInParent(literal, replaceTo);
            }
            catch (ParseException date) {
                // empty catch block
            }
        }
        if (text.length() < 19) {
            Date date = MySqlUtils.parseDate(text, timeZone);
            if (date == null && text.length() == 16 && text.charAt(13) == ':') {
                date = MySqlUtils.parseDate(text + ":00", timeZone);
            }
            if (date != null) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (timeZone != null) {
                    dateFormat.setTimeZone(timeZone);
                }
                text = dateFormat.format(date);
                return SQLUtils.replaceInParent(literal, new SQLTimestampExpr(text));
            }
        }
        if ((dotIndex = text.indexOf(46)) == -1) {
            Date date = MySqlUtils.parseDate(text, timeZone);
            if (date != null) {
                SQLTimestampExpr replaceTo = new SQLTimestampExpr(date, timeZone);
                return SQLUtils.replaceInParent(literal, replaceTo);
            }
        } else if (dotIndex == 19 && text.length() > 23) {
            text = text.substring(0, 23);
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            if (timeZone != null) {
                dateFormat.setTimeZone(timeZone);
            }
            Date date = MySqlUtils.parseDate(text, timeZone);
            text = dateFormat.format(date);
        }
        if (text.length() == 20 && text.endsWith(":000")) {
            text = text.substring(0, text.length() - 1);
        } else if (text.length() == 22 && text.endsWith(":00:00:00")) {
            text = text.substring(0, text.length() - 3);
        }
        return SQLUtils.replaceInParent(literal, new SQLTimestampExpr(text));
    }

    public boolean replaceInParent(SQLExpr x, SQLExpr target) {
        boolean result = SQLUtils.replaceInParent(x, target);
        if (!result) {
            ++this.repalceFailCount;
        } else {
            ++this.optimizedCount;
        }
        return result;
    }
}

