/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import java.util.List;

public class Ordinal
extends OptimizerVisitor {
    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        SQLOrderBy orderBy;
        List<SQLSelectItem> selectItems = x.getSelectList();
        for (SQLSelectItem item : selectItems) {
            SQLExpr expr = item.getExpr();
            if (expr instanceof SQLAllColumnExpr) {
                return true;
            }
            if (!(expr instanceof SQLPropertyExpr) || !((SQLPropertyExpr)expr).getName().equals("*")) continue;
            return true;
        }
        SQLSelectGroupByClause groupBy = x.getGroupBy();
        SQLTableSource from = x.getFrom();
        if (groupBy != null && !groupBy.isWithCube() && !groupBy.isWithRollUp()) {
            block1: for (int i = 0; i < groupBy.getItems().size(); ++i) {
                SQLExpr expr = groupBy.getItems().get(i);
                if (expr instanceof SQLIntegerExpr) continue;
                for (int j = 0; j < selectItems.size(); ++j) {
                    SQLIntegerExpr indexExpr;
                    SQLSelectItem selectItem = selectItems.get(j);
                    SQLExpr selectItemExpr = selectItem.getExpr();
                    String alias = selectItem.getAlias();
                    if (expr.equals(selectItemExpr)) {
                        indexExpr = new SQLIntegerExpr(j + 1);
                        indexExpr.setParent(x);
                        groupBy.getItems().set(i, indexExpr);
                        ++this.optimizedCount;
                        continue block1;
                    }
                    if (alias == null || !(expr instanceof SQLIdentifierExpr) || selectItem.getExpr() instanceof SQLAggregateExpr || selectItem.alias_hash() != ((SQLIdentifierExpr)expr).nameHashCode64()) continue;
                    indexExpr = new SQLIntegerExpr(j + 1);
                    indexExpr.setParent(x);
                    groupBy.getItems().set(i, indexExpr);
                    ++this.optimizedCount;
                }
            }
        }
        if ((orderBy = x.getOrderBy()) != null && (groupBy == null || !groupBy.isWithCube() && !groupBy.isWithRollUp())) {
            SQLSelectOrderByItem orderByItem;
            int i;
            List<SQLSelectOrderByItem> orderByItems = orderBy.getItems();
            block3: for (i = 0; i < orderByItems.size(); ++i) {
                orderByItem = orderByItems.get(i);
                SQLExpr expr = orderByItem.getExpr();
                if (expr instanceof SQLLiteralExpr) continue;
                for (int j = 0; j < selectItems.size(); ++j) {
                    SQLSelectItem selectItem = selectItems.get(j);
                    SQLExpr selectItemExpr = selectItem.getExpr();
                    String alias = selectItem.getAlias();
                    if (expr.equals(selectItemExpr)) {
                        orderByItem.setExpr(new SQLIntegerExpr(j + 1));
                        ++this.optimizedCount;
                        continue block3;
                    }
                    if (alias == null || !(expr instanceof SQLIdentifierExpr) || selectItem.alias_hash() != ((SQLIdentifierExpr)expr).nameHashCode64()) continue;
                    orderByItem.setExpr(new SQLIntegerExpr(j + 1));
                    ++this.optimizedCount;
                    continue block3;
                }
            }
            for (i = orderByItems.size() - 1; i >= 0; --i) {
                orderByItem = orderByItems.get(i);
                int index = orderByItems.indexOf(orderByItem);
                if (index == i) continue;
                orderByItems.remove(i);
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        return false;
    }
}

