/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateOption;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionOperator;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.fastsql.sql.optimizer.rules.ConstFolding;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastsql.sql.visitor.SQLSubQueryGroupVisitor;
import com.alibaba.fastsql.sql.visitor.SQLTableAliasCollectVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class PushDown
extends OptimizerVisitor {
    @Override
    public boolean visit(SQLSelect x) {
        SQLExpr rowCount;
        SQLExpr offset;
        SQLOrderBy orderBy;
        SQLSelectQuery query;
        this.visitTPCDSQ58(x);
        this.dupSubQueryToCTE(x);
        this.visitYouku01(x);
        int optimizeCount = this.optimizedCount;
        SQLWithSubqueryClause withSubQuery = x.getWithSubQuery();
        if (withSubQuery != null) {
            withSubQuery.accept(this);
        }
        if ((query = x.getQuery()) != null) {
            query.accept(this);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            orderBy.accept(this);
        }
        if ((offset = x.getOffset()) != null) {
            offset.accept(this);
        }
        if ((rowCount = x.getRowCount()) != null) {
            rowCount.accept(this);
        }
        if (optimizeCount != this.optimizedCount && x.getParent() instanceof SQLStatement) {
            this.dupSubQueryToCTE(x);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        List<SQLSelectItem> subSelectList;
        SQLTableSource from;
        List<SQLSelectItem> selectList = x.getSelectList();
        for (SQLSelectItem selectItem : selectList) {
            selectItem.accept(this);
        }
        SQLExpr where = x.getWhere();
        if (where != null) {
            where.accept(this);
        }
        if ((from = x.getFrom()) != null) {
            from.accept(this);
        }
        this.visitTPCDS88(x);
        this.visitTPCDSQ34(x);
        this.visitTPCDSQ44(x);
        this.visitTPCDSQ74(x);
        this.visitTPCDSQ76(x);
        from = x.getFrom();
        if (!(from instanceof SQLSubqueryTableSource) || !(((SQLSubqueryTableSource)from).getSelect().getQuery() instanceof SQLSelectQueryBlock)) {
            return false;
        }
        SQLSelectQueryBlock subQuery = ((SQLSubqueryTableSource)from).getSelect().getQueryBlock();
        for (SQLSelectItem selectItem : subQuery.getSelectList()) {
            SQLExpr expr = selectItem.getExpr();
            if (!(expr instanceof SQLAggregateExpr) || ((SQLAggregateExpr)expr).getOver() == null) continue;
            return false;
        }
        boolean allColumnMatched = false;
        if (selectList.size() == 1) {
            SQLAggregateExpr aggExpr;
            SQLExpr expr = selectList.get(0).getExpr();
            if (expr instanceof SQLAllColumnExpr) {
                allColumnMatched = true;
            } else if (expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getName().equals("*")) {
                allColumnMatched = true;
            } else if (expr instanceof SQLAggregateExpr && (aggExpr = ((SQLAggregateExpr)expr).clone()).getArguments().size() == 1 && aggExpr.methodNameHashCode64() == FnvHash.Constants.COUNT) {
                SQLExpr arg = aggExpr.getArguments().get(0);
                ExprReplaceVisitor replaceVisitor = new ExprReplaceVisitor(x, subQuery);
                arg.accept(replaceVisitor);
                if (replaceVisitor.repalcedFailCount > 0) {
                    return false;
                }
            }
        }
        boolean aggregateMatch = false;
        if (!allColumnMatched && (subSelectList = subQuery.getSelectList()).size() >= selectList.size()) {
            boolean match = true;
            for (int i = 0; i < selectList.size(); ++i) {
                SQLExpr selectItemExpr = selectList.get(i).getExpr();
                SQLSelectItem subSelectItem = subSelectList.get(i);
                if (selectItemExpr instanceof SQLIdentifierExpr || selectItemExpr instanceof SQLPropertyExpr) {
                    long subSelectItemHashCode;
                    long nameHashCode64 = ((SQLName)selectItemExpr).nameHashCode64();
                    if (nameHashCode64 == (subSelectItemHashCode = FnvHash.hashCode64(subSelectItem.computeAlias()))) continue;
                    match = false;
                    break;
                }
                if (selectItemExpr instanceof SQLAggregateExpr && subSelectList.size() == 1 && ((SQLAggregateExpr)selectItemExpr).methodNameHashCode64() == FnvHash.Constants.COUNT && ((SQLAggregateExpr)selectItemExpr).getArguments().size() == 1) {
                    long subSelectItemHashCode;
                    SQLExpr arg = ((SQLAggregateExpr)selectItemExpr).getArguments().get(0);
                    if (!(arg instanceof SQLIdentifierExpr) && !(arg instanceof SQLPropertyExpr)) continue;
                    long nameHashCode64 = ((SQLName)arg).nameHashCode64();
                    if (nameHashCode64 != (subSelectItemHashCode = FnvHash.hashCode64(subSelectItem.computeAlias()))) {
                        match = false;
                        break;
                    }
                    aggregateMatch = true;
                    continue;
                }
                match = false;
                break;
            }
            if (match) {
                allColumnMatched = true;
            }
        }
        SQLExpr where2 = null;
        if (x.getWhere() != null) {
            where2 = x.getWhere().clone();
            ExprReplaceVisitor whereVisitor = new ExprReplaceVisitor(x, subQuery);
            where2.accept(whereVisitor);
            if (whereVisitor.repalcedFailCount > 0) {
                return false;
            }
        }
        if (allColumnMatched) {
            SQLObject parent;
            SQLOrderBy orderBy;
            SQLSelectQueryBlock queryBlock = subQuery.clone();
            if (aggregateMatch) {
                SQLSelectItem subSelectItem = queryBlock.getSelectItem(0);
                SQLSelectItem selectItem = selectList.get(0);
                SQLExpr subSelectItemExpr = subSelectItem.getExpr().clone();
                SQLAggregateExpr aggregateExpr = (SQLAggregateExpr)selectItem.getExpr().clone();
                subSelectItemExpr.setParent(aggregateExpr);
                aggregateExpr.getArguments().set(0, subSelectItemExpr);
                subSelectItem.setExpr(aggregateExpr);
                if (selectItem.getAlias() != null) {
                    subSelectItem.setAlias(selectItem.getAlias());
                }
                if (queryBlock.getDistionOption() == 2 && aggregateExpr.getOption() == SQLAggregateOption.DISTINCT) {
                    queryBlock.setDistionOption(0);
                }
            }
            if ((orderBy = x.getOrderBy()) != null) {
                orderBy = orderBy.clone();
                for (SQLSelectOrderByItem orderByItem : orderBy.getItems()) {
                    int index;
                    SQLExpr expr = orderByItem.getExpr();
                    if (expr instanceof SQLIntegerExpr && (index = ((SQLIntegerExpr)expr).getNumber().intValue()) >= 0 && index < x.getSelectList().size()) {
                        expr = x.getSelectList().get(index).getExpr();
                    }
                    SQLSelectItem subSelectItem = null;
                    if (expr instanceof SQLPropertyExpr) {
                        SQLPropertyExpr propertyExpr = (SQLPropertyExpr)expr;
                        if (propertyExpr.getOwner() instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)propertyExpr.getOwner()).nameHashCode64() == from.aliasHashCode64()) {
                            long nameHash = propertyExpr.nameHashCode64();
                            subSelectItem = queryBlock.findSelectItem(nameHash);
                        }
                    } else if (expr instanceof SQLIdentifierExpr) {
                        long nameHash = ((SQLIdentifierExpr)expr).nameHashCode64();
                        subSelectItem = queryBlock.findSelectItem(nameHash);
                    }
                    if (subSelectItem == null) {
                        return false;
                    }
                    orderByItem.setExpr(subSelectItem.getExpr().clone());
                    if (queryBlock.containsOrderBy(orderByItem)) continue;
                    queryBlock.addOrderBy(orderByItem);
                }
            }
            final AtomicBoolean aggregate = new AtomicBoolean();
            if (queryBlock.getGroupBy() != null) {
                if (where2 != null && x.getGroupBy() != null) {
                    return false;
                }
                aggregate.set(true);
            }
            if (aggregate.get() && where2 != null) {
                SQLASTVisitorAdapter v = new SQLASTVisitorAdapter(){

                    @Override
                    public boolean visit(SQLAggregateExpr x) {
                        aggregate.set(true);
                        return false;
                    }
                };
                where2.accept(v);
            }
            if (aggregate.get()) {
                queryBlock.addHaving(where2);
            } else {
                queryBlock.addWhere(where2);
            }
            SQLLimit limit = x.getLimit();
            if (limit != null) {
                if (queryBlock.getLimit() == null) {
                    queryBlock.setLimit(limit);
                } else {
                    return false;
                }
            }
            if ((parent = x.getParent()) instanceof SQLSelect) {
                SQLSelect select = (SQLSelect)x.getParent();
                select.setQuery(queryBlock);
                queryBlock.accept(this);
            } else if (parent instanceof SQLUnionQuery) {
                SQLUnionQuery union = (SQLUnionQuery)x.getParent();
                if (union.getLeft() == x) {
                    union.setLeft(queryBlock);
                } else {
                    union.setRight(queryBlock);
                }
                queryBlock.accept(this);
            }
        }
        return false;
    }

    public void visitTPCDS88(SQLSelectQueryBlock x) {
        List nameLiterals;
        SQLName name;
        SQLExpr where = x.getWhere();
        if (where == null) {
            return;
        }
        List<SQLExpr> conditions = SQLBinaryOpExpr.split(where, SQLBinaryOperator.BooleanAnd);
        if (conditions.size() < 2) {
            return;
        }
        LinkedHashMap<SQLName, ArrayList<SQLBinaryOpExpr>> lsNameLiteralsMap = new LinkedHashMap<SQLName, ArrayList<SQLBinaryOpExpr>>();
        ArrayList<SQLBinaryOpExpr> l2NameLiterals = new ArrayList<SQLBinaryOpExpr>();
        LinkedHashMap<Long, SQLName> l1Names = new LinkedHashMap<Long, SQLName>();
        int orCount = 0;
        int orItemCount = 0;
        for (SQLExpr condition : conditions) {
            if (ConstFolding.isLeftNameAndRightLiteral(condition)) {
                SQLBinaryOpExpr nameLiteral = (SQLBinaryOpExpr)condition;
                name = (SQLName)nameLiteral.getLeft();
                l1Names.put(name.nameHashCode64(), name);
                continue;
            }
            if (ConstFolding.isBothName(condition)) {
                SQLBinaryOpExpr nameName = (SQLBinaryOpExpr)condition;
                SQLName leftNamename = (SQLName)nameName.getLeft();
                SQLName rightRame = (SQLName)nameName.getRight();
                l1Names.put(leftNamename.nameHashCode64(), leftNamename);
                l1Names.put(rightRame.nameHashCode64(), rightRame);
                continue;
            }
            if (condition instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)condition).getOperator() == SQLBinaryOperator.BooleanOr) {
                return;
            }
            if (condition instanceof SQLBinaryOpExprGroup && ((SQLBinaryOpExprGroup)condition).getOperator() == SQLBinaryOperator.BooleanOr) {
                ++orCount;
                SQLBinaryOpExprGroup orCondition = (SQLBinaryOpExprGroup)condition;
                for (SQLExpr item : orCondition.getItems()) {
                    if (item instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)item).getOperator() == SQLBinaryOperator.BooleanAnd) {
                        List<SQLExpr> itemItems = SQLBinaryOpExpr.split(item, SQLBinaryOperator.BooleanAnd);
                        ++orItemCount;
                        for (SQLExpr itemItem : itemItems) {
                            if (ConstFolding.isLeftNameAndRightLiteral(itemItem)) {
                                l2NameLiterals.add((SQLBinaryOpExpr)itemItem);
                                continue;
                            }
                            return;
                        }
                        continue;
                    }
                    return;
                }
                continue;
            }
            return;
        }
        if (orCount != 1) {
            return;
        }
        for (int i = l2NameLiterals.size() - 1; i >= 0; --i) {
            SQLBinaryOpExpr nameLiteral = (SQLBinaryOpExpr)l2NameLiterals.get(i);
            SQLExpr left = nameLiteral.getLeft();
            ArrayList<SQLBinaryOpExpr> literals = (ArrayList<SQLBinaryOpExpr>)lsNameLiteralsMap.get(left);
            if (literals == null) {
                literals = new ArrayList<SQLBinaryOpExpr>();
                lsNameLiteralsMap.put((SQLName)left, literals);
            }
            literals.add(nameLiteral);
        }
        if (lsNameLiteralsMap.size() == 0) {
            return;
        }
        SQLTableSource resolvedTableSource = null;
        for (Map.Entry entry : lsNameLiteralsMap.entrySet()) {
            name = (SQLName)entry.getKey();
            if (l1Names.containsKey(name.nameHashCode64())) {
                return;
            }
            nameLiterals = (List)entry.getValue();
            if (nameLiterals.size() != orItemCount) {
                return;
            }
            if (!(name instanceof SQLPropertyExpr)) continue;
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)name;
            if (resolvedTableSource == null) {
                resolvedTableSource = propertyExpr.getResolvedTableSource();
                continue;
            }
            if (resolvedTableSource == propertyExpr.getResolvedTableSource()) continue;
            return;
        }
        if (resolvedTableSource == null) {
            return;
        }
        for (Map.Entry entry : lsNameLiteralsMap.entrySet()) {
            name = (SQLName)entry.getKey();
            nameLiterals = (List)entry.getValue();
            boolean allEq = true;
            for (SQLBinaryOpExpr nameLiteral : nameLiterals) {
                if (nameLiteral.getOperator() == SQLBinaryOperator.Equality) continue;
                allEq = false;
                break;
            }
            SQLExprImpl pushDownCondition = null;
            if (allEq) {
                SQLInListExpr in = new SQLInListExpr(name.clone());
                for (SQLBinaryOpExpr nameLiteral : nameLiterals) {
                    in.addTarget(nameLiteral.getRight().clone());
                }
                pushDownCondition = in;
            } else {
                SQLBinaryOpExprGroup group = new SQLBinaryOpExprGroup(SQLBinaryOperator.BooleanOr);
                for (SQLBinaryOpExpr nameLiteral : nameLiterals) {
                    group.add(nameLiteral.clone());
                }
                new ConstFolding().visit(group);
                pushDownCondition = group;
            }
            if (resolvedTableSource instanceof SQLExprTableSource) {
                resolvedTableSource = this.pushDownNameLiterals((SQLExprTableSource)resolvedTableSource, (SQLExpr)pushDownCondition);
                continue;
            }
            if (!(resolvedTableSource instanceof SQLSubqueryTableSource)) continue;
            this.pushDownNameLiterals((SQLSubqueryTableSource)resolvedTableSource, (SQLExpr)pushDownCondition);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitTPCDSQ76(SQLSelectQueryBlock x) {
        int i;
        SQLSelectQueryBlock queryBlock;
        SQLSelectGroupByClause groupBy = x.getGroupBy();
        if (groupBy == null || groupBy.getItems().size() == 0 || groupBy.getHaving() != null) {
            return;
        }
        for (SQLExpr item : groupBy.getItems()) {
            if (item instanceof SQLIdentifierExpr) continue;
            return;
        }
        for (SQLSelectItem selectItem : x.getSelectList()) {
            SQLExpr expr = selectItem.getExpr();
            if (expr instanceof SQLIdentifierExpr) continue;
            if (!(expr instanceof SQLAggregateExpr)) return;
            if (selectItem.getAlias() == null) {
                return;
            }
            SQLAggregateExpr aggExpr = (SQLAggregateExpr)expr;
            if (aggExpr.getOver() != null || aggExpr.getOverRef() != null || aggExpr.getArguments().size() != 1) {
                return;
            }
            if (aggExpr.methodNameHashCode64() != FnvHash.Constants.COUNT && aggExpr.methodNameHashCode64() != FnvHash.Constants.SUM && aggExpr.methodNameHashCode64() != FnvHash.Constants.MAX && aggExpr.methodNameHashCode64() != FnvHash.Constants.MIN) {
                return;
            }
            SQLExpr arg = aggExpr.getArguments().get(0);
            if (arg instanceof SQLAllColumnExpr || arg instanceof SQLIdentifierExpr) continue;
            return;
        }
        if (!(x.getFrom() instanceof SQLUnionQueryTableSource)) {
            return;
        }
        SQLSelectQueryBlock x1 = x.clone();
        SQLUnionQuery union = ((SQLUnionQueryTableSource)x1.getFrom()).getUnion();
        ArrayList<SQLSelectQuery> queries = new ArrayList<SQLSelectQuery>();
        SQLSelectGroupByClause groupBy2 = x1.getGroupBy();
        SQLUnionOperator operator = union.getOperator();
        SQLSelectQuery left = union.getLeft();
        SQLSelectQuery right = union.getRight();
        if (left instanceof SQLUnionQuery && ((SQLUnionQuery)left).getOperator() == operator) {
            SQLSelectQuery leftRight;
            SQLSelectQuery leftLeft;
            SQLUnionQuery leftUnion = (SQLUnionQuery)left;
            queries.add(right);
            while (true) {
                leftLeft = leftUnion.getLeft();
                leftRight = leftUnion.getRight();
                if (leftUnion.isBracket() || leftUnion.getOrderBy() != null || leftLeft.isBracket() || leftRight.isBracket() || !(leftLeft instanceof SQLUnionQuery) || ((SQLUnionQuery)leftLeft).getOperator() != operator) break;
                queries.add(leftRight);
                leftUnion = (SQLUnionQuery)leftLeft;
            }
            queries.add(leftRight);
            queries.add(leftLeft);
            for (int i2 = queries.size() - 1; i2 >= 0; --i2) {
                SQLSelectQuery item = (SQLSelectQuery)queries.get(i2);
                item.accept(this);
            }
        }
        for (SQLSelectQuery query : queries) {
            if (!(query instanceof SQLSelectQueryBlock)) {
                return;
            }
            queryBlock = (SQLSelectQueryBlock)query;
            if (queryBlock.getGroupBy() == null) continue;
            return;
        }
        LinkedHashSet<Object> literalValues = new LinkedHashSet<Object>();
        int firstLiteralItemCount = 0;
        if (queries.size() > 0) {
            SQLExpr expr;
            queryBlock = (SQLSelectQueryBlock)queries.get(0);
            for (int i3 = 0; i3 < queryBlock.getSelectList().size() && (expr = queryBlock.getSelectList().get(i3).getExpr()) instanceof SQLValuableExpr; ++i3) {
                firstLiteralItemCount = i3;
                if (i3 != 0) continue;
                literalValues.add(((SQLValuableExpr)expr).getValue());
            }
        }
        if (firstLiteralItemCount == 0) {
            return;
        }
        for (i = 1; i < queries.size(); ++i) {
            SQLExpr expr;
            int literalItemCount = 0;
            SQLSelectQueryBlock queryBlock2 = (SQLSelectQueryBlock)queries.get(i);
            for (int j = 0; j < queryBlock2.getSelectList().size() && (expr = queryBlock2.getSelectList().get(j).getExpr()) instanceof SQLValuableExpr; ++j) {
                literalItemCount = j;
                if (j != 0) continue;
                literalValues.add(((SQLValuableExpr)expr).getValue());
            }
            if (literalItemCount >= firstLiteralItemCount) continue;
            return;
        }
        if (literalValues.size() != queries.size()) {
            return;
        }
        for (i = 0; i < queries.size(); ++i) {
            SQLExpr selectItemExpr;
            SQLSelectQueryBlock queryBlock3 = (SQLSelectQueryBlock)queries.get(i);
            SQLSelectGroupByClause subGroupBy = groupBy2.clone();
            List<SQLExpr> subGroupByItems = subGroupBy.getItems();
            for (int j = subGroupByItems.size() - 1; j >= 0; --j) {
                SQLExpr item = subGroupByItems.get(j);
                SQLIdentifierExpr identItem = (SQLIdentifierExpr)item;
                SQLSelectItem selectItem = queryBlock3.findSelectItem(identItem.hashCode64());
                if (selectItem == null) {
                    return;
                }
                selectItemExpr = selectItem.getExpr();
                if (selectItemExpr instanceof SQLLiteralExpr) {
                    subGroupByItems.remove(i);
                    continue;
                }
                if (selectItemExpr.equals(item)) continue;
                SQLExpr selectItemExpr2 = selectItemExpr.clone();
                selectItemExpr2.setParent(subGroupBy);
                subGroupByItems.set(i, selectItemExpr2);
            }
            queryBlock3.setGroupBy(subGroupBy);
            ArrayList<SQLSelectItem> newSelectItems = new ArrayList<SQLSelectItem>(x.getSelectList().size());
            for (SQLSelectItem selectItem : x.getSelectList()) {
                SQLSelectItem newSelectItem;
                selectItemExpr = selectItem.getExpr();
                if (selectItemExpr instanceof SQLIdentifierExpr) {
                    SQLSelectItem subSelectItem = queryBlock3.findSelectItem(((SQLIdentifierExpr)selectItemExpr).hashCode64());
                    if (subSelectItem == null) {
                        return;
                    }
                    newSelectItem = subSelectItem.clone();
                } else {
                    if (!(selectItemExpr instanceof SQLAggregateExpr)) return;
                    SQLExpr aggArg = ((SQLAggregateExpr)selectItemExpr).getArguments().get(0);
                    if (aggArg instanceof SQLAllColumnExpr) {
                        newSelectItem = selectItem.clone();
                    } else {
                        if (!(aggArg instanceof SQLIdentifierExpr)) return;
                        newSelectItem = selectItem.clone();
                        SQLSelectItem subSelectItem = queryBlock3.findSelectItem(((SQLIdentifierExpr)aggArg).hashCode64());
                        if (!subSelectItem.getExpr().equals(aggArg)) {
                            if (!(subSelectItem.getExpr() instanceof SQLName)) return;
                            SQLExpr arg2 = subSelectItem.getExpr().clone();
                            SQLAggregateExpr agg = (SQLAggregateExpr)newSelectItem.getExpr();
                            agg.setArgument(0, arg2);
                        }
                    }
                }
                newSelectItem.setParent(queryBlock3);
                newSelectItems.add(newSelectItem);
            }
            queryBlock3.getSelectList().clear();
            queryBlock3.getSelectList().addAll(newSelectItems);
        }
        for (SQLSelectItem selectItem : x1.getSelectList()) {
            SQLExpr selectItemExpr = selectItem.getExpr();
            if (!(selectItemExpr instanceof SQLAggregateExpr)) continue;
            SQLAggregateExpr aggregateExpr = (SQLAggregateExpr)selectItemExpr;
            if (aggregateExpr.methodNameHashCode64() == FnvHash.Constants.COUNT) {
                aggregateExpr.setMethodName("SUM");
            }
            SQLIdentifierExpr arg = new SQLIdentifierExpr(selectItem.getAlias());
            aggregateExpr.setArgument(0, arg);
        }
        x.replaceInParent(x1);
    }

    public void visitTPCDSQ34(SQLSelectQueryBlock x) {
        SQLObject parent = x.getParent();
        if (!(parent instanceof SQLSelect)) {
            return;
        }
        SQLSelect select = (SQLSelect)parent;
        if (!(select.getParent() instanceof SQLSelectStatement)) {
            return;
        }
        SQLWithSubqueryClause with = select.getWithSubQuery();
        if (with == null || with.getRecursive() != null) {
            return;
        }
        SQLTableSource from = x.getFrom();
        ArrayList<SQLTableSource> outTableSources = new ArrayList<SQLTableSource>();
        if (from instanceof SQLExprTableSource) {
            outTableSources.add(from);
        } else if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)from;
            join.splitTo(outTableSources, join.getJoinType());
        } else {
            return;
        }
        HashMap<Long, SQLTableSource> tableSourceMap = new HashMap<Long, SQLTableSource>();
        for (SQLTableSource tableSource : outTableSources) {
            if (!(tableSource instanceof SQLExprTableSource)) {
                return;
            }
            SQLExpr expr = ((SQLExprTableSource)tableSource).getExpr();
            if (!(expr instanceof SQLIdentifierExpr)) {
                return;
            }
            if (tableSource.getAlias() == null) {
                tableSourceMap.put(((SQLIdentifierExpr)expr).nameHashCode64(), tableSource);
                continue;
            }
            tableSourceMap.put(tableSource.aliasHashCode64(), tableSource);
        }
        SQLExpr where = x.getWhere();
        if (where == null) {
            return;
        }
        HashMap tableNameLiteralMap = new HashMap();
        List<SQLExpr> conditions = SQLBinaryOpExpr.split(where, SQLBinaryOperator.BooleanAnd);
        for (int i = conditions.size() - 1; i >= 0; --i) {
            Object literals;
            SQLTableSource tableSource;
            long hashCode;
            SQLExprImpl name;
            SQLExpr condition = conditions.get(i);
            if (!ConstFolding.isLeftNameAndRightLiteral(condition)) continue;
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)condition;
            SQLExpr left = binaryOpExpr.getLeft();
            if (left instanceof SQLPropertyExpr) {
                name = (SQLPropertyExpr)left;
                if (!(((SQLPropertyExpr)name).getOwner() instanceof SQLIdentifierExpr)) {
                    return;
                }
                SQLIdentifierExpr owner = (SQLIdentifierExpr)((SQLPropertyExpr)name).getOwner();
                long ownerHashCode64 = owner.nameHashCode64();
                hashCode = ((SQLPropertyExpr)name).nameHashCode64();
                tableSource = (SQLTableSource)tableSourceMap.get(ownerHashCode64);
            } else if (left instanceof SQLIdentifierExpr) {
                name = (SQLIdentifierExpr)left;
                hashCode = ((SQLIdentifierExpr)name).nameHashCode64();
                tableSource = from.findTableSourceWithColumn((SQLName)((Object)name));
                if (!(tableSource instanceof SQLExprTableSource)) {
                    return;
                }
                if (!(((SQLExprTableSource)tableSource).getExpr() instanceof SQLIdentifierExpr)) {
                    return;
                }
            } else {
                return;
            }
            if (tableSource == null) continue;
            SQLIdentifierExpr tableSourceExpr = (SQLIdentifierExpr)((SQLExprTableSource)tableSource).getExpr();
            HashMap<Long, Object> nameLiterals = (HashMap<Long, Object>)tableNameLiteralMap.get(tableSourceExpr.nameHashCode64());
            if (nameLiterals == null) {
                nameLiterals = new HashMap<Long, Object>();
                tableNameLiteralMap.put(tableSourceExpr.nameHashCode64(), nameLiterals);
            }
            if ((literals = (List)nameLiterals.get(hashCode)) == null) {
                literals = new ArrayList();
                nameLiterals.put(hashCode, literals);
            }
            literals.add((SQLBinaryOpExpr)binaryOpExpr);
            conditions.remove(i);
        }
        for (Map.Entry tableNameLiteralMapEntry : tableNameLiteralMap.entrySet()) {
            long tableNameHashCode = (Long)tableNameLiteralMapEntry.getKey();
            Map nameLiterals = (Map)tableNameLiteralMapEntry.getValue();
            if (nameLiterals.size() == 0) continue;
            int matchCount = 0;
            for (Map.Entry entry : nameLiterals.entrySet()) {
                long hashCode64 = (Long)entry.getKey();
                MatchName v = new MatchName(hashCode64);
                for (SQLExpr condition : conditions) {
                    condition.accept(v);
                }
                matchCount = v.matchCount;
                if (matchCount <= 0) continue;
            }
            if (matchCount > 0) continue;
            SQLWithSubqueryClause.Entry entry = with.findEntry(tableNameHashCode);
            if (entry == null) {
                return;
            }
            for (List literals : nameLiterals.values()) {
                SQLExpr condition;
                SQLBinaryOpExpr firstLiteral = (SQLBinaryOpExpr)literals.get(0);
                boolean allEq = true;
                for (SQLBinaryOpExpr literal : literals) {
                    if (literal.getOperator() == SQLBinaryOperator.Equality) continue;
                    allEq = false;
                    break;
                }
                SQLIdentifierExpr name = new SQLIdentifierExpr(((SQLName)firstLiteral.getLeft()).getSimpleName());
                if (literals.size() == 1) {
                    condition = new SQLBinaryOpExpr((SQLExpr)name, firstLiteral.getOperator(), firstLiteral.getRight());
                } else {
                    if (!allEq) continue;
                    SQLInListExpr inList = new SQLInListExpr(name);
                    List<SQLExpr> inListTargetList = inList.getTargetList();
                    for (SQLBinaryOpExpr literal : literals) {
                        SQLExpr value = literal.getRight().clone();
                        if (inListTargetList.contains(value)) continue;
                        inList.addTarget(value);
                    }
                    if (inListTargetList.size() == 1) {
                        condition = new SQLBinaryOpExpr(inList.getExpr(), SQLBinaryOperator.Equality, inListTargetList.get(0));
                    } else {
                        inList.sortTargetList();
                        condition = inList;
                    }
                }
                this.pushDownNameLiterals(entry.getSubQuery().getQuery(), condition);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SQLTableSource pushDownNameLiterals(SQLExprTableSource tableSource, SQLExpr condition) {
        SQLExpr left;
        SQLExpr expr = tableSource.getExpr();
        if (!(expr instanceof SQLIdentifierExpr)) {
            return tableSource;
        }
        SQLExprTableSource subTableSource = tableSource.clone();
        subTableSource.setAlias(null);
        SQLIdentifierExpr table = (SQLIdentifierExpr)expr;
        SQLSelectQueryBlock queryBlock = new SQLSelectQueryBlock(this.dbType);
        queryBlock.addSelectItem(new SQLAllColumnExpr());
        queryBlock.setFrom(subTableSource);
        queryBlock.addWhere(condition);
        String alias = tableSource.getAlias();
        if (alias == null) {
            alias = table.normalizedName();
        }
        ArrayList<SQLName> names = new ArrayList<SQLName>();
        if (condition instanceof SQLInListExpr) {
            left = ((SQLInListExpr)condition).getExpr();
            if (!(left instanceof SQLName)) return tableSource;
            names.add((SQLName)left);
        } else if (condition instanceof SQLBinaryOpExpr) {
            left = ((SQLBinaryOpExpr)condition).getLeft();
            if (!(left instanceof SQLName)) return tableSource;
            names.add((SQLName)left);
        } else {
            if (!(condition instanceof SQLBinaryOpExprGroup)) return tableSource;
            SQLBinaryOpExprGroup group = (SQLBinaryOpExprGroup)condition;
            for (SQLExpr item : group.getItems()) {
                if (!(item instanceof SQLBinaryOpExpr)) return tableSource;
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)item;
                if (!(binaryOpExpr.getLeft() instanceof SQLName)) return tableSource;
                names.add((SQLName)binaryOpExpr.getLeft());
            }
        }
        for (SQLName name : names) {
            SQLPropertyExpr propertyExpr;
            if (!(name instanceof SQLPropertyExpr) || !table.equals((propertyExpr = (SQLPropertyExpr)name).getOwner()) || SQLUtils.replaceInParent(name, new SQLIdentifierExpr(propertyExpr.getName()))) continue;
            return tableSource;
        }
        SQLSubqueryTableSource subqueryTableSource = new SQLSubqueryTableSource(queryBlock, alias);
        if (!SQLUtils.replaceInParent(tableSource, subqueryTableSource)) return tableSource;
        ++this.optimizedCount;
        return subqueryTableSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pushDownNameLiterals(SQLSubqueryTableSource tableSource, SQLExpr condition) {
        SQLExpr left;
        String alias = tableSource.getAlias();
        if (alias == null) {
            return;
        }
        ArrayList<SQLName> names = new ArrayList<SQLName>();
        if (condition instanceof SQLInListExpr) {
            left = ((SQLInListExpr)condition).getExpr();
            if (!(left instanceof SQLName)) return;
            names.add((SQLName)left);
        } else if (condition instanceof SQLBinaryOpExpr) {
            left = ((SQLBinaryOpExpr)condition).getLeft();
            if (!(left instanceof SQLName)) return;
            names.add((SQLName)left);
        } else {
            if (!(condition instanceof SQLBinaryOpExprGroup)) return;
            SQLBinaryOpExprGroup group = (SQLBinaryOpExprGroup)condition;
            for (SQLExpr item : group.getItems()) {
                if (!(item instanceof SQLBinaryOpExpr)) return;
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)item;
                if (!(binaryOpExpr.getLeft() instanceof SQLName)) return;
                names.add((SQLName)binaryOpExpr.getLeft());
            }
        }
        long aliasHashCode64 = FnvHash.hashCode64(alias);
        for (SQLName name : names) {
            if (!(name instanceof SQLPropertyExpr)) continue;
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)name;
            SQLExpr owner = propertyExpr.getOwner();
            if (!(owner instanceof SQLIdentifierExpr) || ((SQLIdentifierExpr)owner).nameHashCode64() != aliasHashCode64) return;
            if (SQLUtils.replaceInParent(name, new SQLIdentifierExpr(propertyExpr.getName()))) continue;
            return;
        }
        this.pushDownNameLiterals(tableSource.getSelect().getQuery(), condition);
    }

    private void pushDownNameLiterals(SQLSelectQuery query, SQLExpr condition) {
        if (query instanceof SQLUnionQuery) {
            SQLUnionQuery union = (SQLUnionQuery)query;
            this.pushDownNameLiterals(union.getLeft(), condition.clone());
            this.pushDownNameLiterals(union.getRight(), condition.clone());
            return;
        }
        if (query instanceof SQLSelectQueryBlock) {
            SQLObject column;
            SQLExpr selectItemExpr;
            SQLIdentifierExpr name;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            if (condition instanceof SQLInListExpr) {
                name = (SQLIdentifierExpr)((SQLInListExpr)condition).getExpr();
            } else if (condition instanceof SQLBinaryOpExpr) {
                name = (SQLIdentifierExpr)((SQLBinaryOpExpr)condition).getLeft();
            } else {
                return;
            }
            SQLTableSource from = queryBlock.getFrom();
            SQLObject resolveColum = queryBlock.resolveColum(name.hashCode64());
            if (resolveColum instanceof SQLSelectItem) {
                SQLSelectItem selectItem = (SQLSelectItem)resolveColum;
                selectItemExpr = selectItem.getExpr();
                if (!SQLUtils.replaceInParent(name, selectItemExpr.clone())) {
                    return;
                }
            } else if (resolveColum instanceof SQLColumnDefinition) {
                selectItemExpr = name;
            } else {
                return;
            }
            if (from instanceof SQLSubqueryTableSource) {
                if (!(selectItemExpr instanceof SQLIdentifierExpr)) {
                    if (selectItemExpr instanceof SQLPropertyExpr) {
                        return;
                    }
                    return;
                }
                this.pushDownNameLiterals(((SQLSubqueryTableSource)from).getSelect().getQuery(), condition);
                return;
            }
            if (from instanceof SQLUnionQueryTableSource) {
                if (!(selectItemExpr instanceof SQLIdentifierExpr)) {
                    if (selectItemExpr instanceof SQLPropertyExpr) {
                        return;
                    }
                    return;
                }
                this.pushDownNameLiterals(((SQLUnionQueryTableSource)from).getUnion(), condition);
                return;
            }
            if (selectItemExpr instanceof SQLIdentifierExpr && (column = queryBlock.resolveColum(((SQLIdentifierExpr)selectItemExpr).nameHashCode64())) != null) {
                List<SQLExpr> items;
                SQLExpr where = queryBlock.getWhere();
                if (where != null && (items = SQLBinaryOpExpr.split(where, SQLBinaryOperator.BooleanAnd)).contains(condition)) {
                    return;
                }
                queryBlock.addWhere(condition.clone());
                ++this.optimizedCount;
            }
        }
    }

    public void visitTPCDSQ58(SQLSelect select) {
        if (!(select.getParent() instanceof SQLSelectStatement)) {
            return;
        }
        SQLWithSubqueryClause with = select.getWithSubQuery();
        if (with == null) {
            return;
        }
        ArrayList<SQLInSubQueryExpr> inSubQueryExprList = new ArrayList<SQLInSubQueryExpr>();
        for (SQLWithSubqueryClause.Entry entry : with.getEntries()) {
            SQLSelectQueryBlock queryBlock = entry.getSubQuery().getQueryBlock();
            if (queryBlock == null) {
                return;
            }
            SQLExpr where = queryBlock.getWhere();
            if (where == null) {
                return;
            }
            if (where == null) continue;
            List<SQLExpr> list = SQLBinaryOpExpr.split(where, SQLBinaryOperator.BooleanAnd);
            for (SQLExpr item : list) {
                if (!(item instanceof SQLInSubQueryExpr)) continue;
                inSubQueryExprList.add((SQLInSubQueryExpr)item);
            }
        }
        if (inSubQueryExprList.size() < 2) {
            return;
        }
        SQLInSubQueryExpr first = (SQLInSubQueryExpr)inSubQueryExprList.get(0);
        for (int i = 1; i < inSubQueryExprList.size(); ++i) {
            if (first.getSubQuery().equals(((SQLInSubQueryExpr)inSubQueryExprList.get(0)).getSubQuery())) continue;
            return;
        }
        SQLSelectQueryBlock firstQueryBlock = first.getSubQuery().getQueryBlock();
        if (firstQueryBlock == null || firstQueryBlock.getSelectList().size() != 1) {
            return;
        }
        SQLTableAliasCollectVisitor v = new SQLTableAliasCollectVisitor();
        select.accept(v);
        String alias = v.genAlias(1);
        if (alias == null) {
            return;
        }
        SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry(alias, first.getSubQuery().clone());
        entry.setParent(with);
        with.getEntries().add(0, entry);
        SQLSelectQueryBlock inQueryBlock = new SQLSelectQueryBlock(this.dbType);
        inQueryBlock.setFrom(new SQLExprTableSource(new SQLIdentifierExpr(alias)));
        inQueryBlock.addSelectItem(firstQueryBlock.getSelectItem(0).clone());
        for (SQLInSubQueryExpr inSubQueryExpr : inSubQueryExprList) {
            inSubQueryExpr.setSubQuery(new SQLSelect(inQueryBlock.clone()));
        }
    }

    public void dupSubQueryToCTE(SQLSelect select) {
        if (!(select.getParent() instanceof SQLSelectStatement)) {
            return;
        }
        SQLWithSubqueryClause with = select.getWithSubQuery();
        if (with != null) {
            return;
        }
        SQLSelectQueryBlock queryBlock = select.getQueryBlock();
        if (queryBlock == null) {
            return;
        }
        SQLTableSource from = queryBlock.getFrom();
        if (!(from instanceof SQLJoinTableSource)) {
            return;
        }
        ArrayList<List<SQLSubqueryTableSource>> groupedSubqueryTableSources = new ArrayList<List<SQLSubqueryTableSource>>();
        SQLASTVisitorAdapter v = new SQLSubQueryGroupVisitor(this.dbType);
        from.accept(v);
        for (List<SQLSubqueryTableSource> subqueryTableSources : ((SQLSubQueryGroupVisitor)v).getGroupedSubqueryTableSources()) {
            if (subqueryTableSources.size() < 2) continue;
            groupedSubqueryTableSources.add(subqueryTableSources);
        }
        if (groupedSubqueryTableSources.size() == 0) {
            return;
        }
        v = new SQLTableAliasCollectVisitor();
        select.accept(v);
        int seed = 1;
        for (List list : groupedSubqueryTableSources) {
            String alias = ((SQLTableAliasCollectVisitor)v).genAlias(seed);
            seed = ((SQLTableAliasCollectVisitor)v).getSeed();
            SQLSubqueryTableSource first = (SQLSubqueryTableSource)list.get(0);
            if (with == null) {
                with = new SQLWithSubqueryClause();
                select.setWithSubQuery(with);
            }
            SQLSelect entrySelect = first.getSelect().clone();
            SQLWithSubqueryClause.Entry withEntry = new SQLWithSubqueryClause.Entry(alias, entrySelect);
            with.addEntry(withEntry);
            for (SQLSubqueryTableSource tableSource : list) {
                SQLIdentifierExpr entryRef = new SQLIdentifierExpr(alias);
                entryRef.setResolvedTableSource(withEntry);
                SQLUtils.replaceInParent(tableSource, new SQLExprTableSource(entryRef, tableSource.getAlias()));
            }
        }
    }

    public void visitTPCDSQ74(SQLSelectQueryBlock x) {
        SQLObject parent = x.getParent();
        if (!(parent instanceof SQLSelect)) {
            return;
        }
        SQLSelect select = (SQLSelect)parent;
        if (!(select.getParent() instanceof SQLSelectStatement)) {
            return;
        }
        SQLWithSubqueryClause with = select.getWithSubQuery();
        if (with == null || with.getRecursive() != null || with.getEntries().size() != 1) {
            return;
        }
        SQLWithSubqueryClause.Entry withEntry = with.getEntries().get(0);
        long entryAliasHashCode64 = withEntry.aliasHashCode64();
        SQLSelectQuery withEntryQuery = withEntry.getSubQuery().getQuery();
        if (!(withEntryQuery instanceof SQLUnionQuery)) {
            return;
        }
        SQLUnionQuery withEntryUnion = (SQLUnionQuery)withEntryQuery;
        List<SQLSelectQuery> withEntryUnionQueries = withEntryUnion.getChildren();
        for (SQLSelectQuery withEntryUnionQuery : withEntryUnionQueries) {
            if (withEntryUnionQuery instanceof SQLSelectQueryBlock) continue;
            return;
        }
        SQLTableSource from = x.getFrom();
        if (!(from instanceof SQLJoinTableSource)) {
            return;
        }
        SQLJoinTableSource join = (SQLJoinTableSource)from;
        ArrayList<SQLTableSource> tableSources = new ArrayList<SQLTableSource>();
        join.splitTo(tableSources, join.getJoinType());
        HashMap<Long, SQLTableSource> tableSourceMap = new HashMap<Long, SQLTableSource>();
        for (SQLTableSource tableSource : tableSources) {
            if (!(tableSource instanceof SQLExprTableSource)) {
                return;
            }
            SQLExpr expr = ((SQLExprTableSource)tableSource).getExpr();
            if (!(expr instanceof SQLIdentifierExpr)) {
                return;
            }
            if (((SQLIdentifierExpr)expr).nameHashCode64() != entryAliasHashCode64) {
                return;
            }
            tableSourceMap.put(tableSource.aliasHashCode64(), tableSource);
        }
        HashMap<Long, ArrayList<SQLBinaryOpExpr>> columnCondtionMap = new HashMap<Long, ArrayList<SQLBinaryOpExpr>>();
        HashMap<Long, ArrayList<SQLBinaryOpExpr>> tableSourceCondtionMap = new HashMap<Long, ArrayList<SQLBinaryOpExpr>>();
        List<SQLExpr> conditions = SQLBinaryOpExpr.split(x.getWhere(), SQLBinaryOperator.BooleanAnd);
        for (SQLExpr item : conditions) {
            if (!(item instanceof SQLBinaryOpExpr)) continue;
            SQLBinaryOpExpr condition = (SQLBinaryOpExpr)item;
            if (!ConstFolding.isLeftNameAndRightLiteral(item)) continue;
            if (condition.getLeft() instanceof SQLPropertyExpr) {
                ArrayList<SQLBinaryOpExpr> columnConditions;
                SQLPropertyExpr name = (SQLPropertyExpr)condition.getLeft();
                if (name.getOwner() instanceof SQLIdentifierExpr) {
                    SQLIdentifierExpr owner = (SQLIdentifierExpr)name.getOwner();
                    long nameHashCode64 = owner.nameHashCode64();
                    columnConditions = (ArrayList<SQLBinaryOpExpr>)tableSourceCondtionMap.get(nameHashCode64);
                    if (columnConditions == null) {
                        columnConditions = new ArrayList<SQLBinaryOpExpr>();
                        tableSourceCondtionMap.put(nameHashCode64, columnConditions);
                    }
                } else {
                    return;
                }
                columnConditions.add(condition);
                long nameHashCode64 = name.nameHashCode64();
                ArrayList<SQLBinaryOpExpr> columnConditions2 = (ArrayList<SQLBinaryOpExpr>)columnCondtionMap.get(nameHashCode64);
                if (columnConditions2 == null) {
                    columnConditions2 = new ArrayList<SQLBinaryOpExpr>();
                    columnCondtionMap.put(nameHashCode64, columnConditions2);
                }
                columnConditions2.add(condition);
                continue;
            }
            return;
        }
        HashMap<Long, SQLSelectQueryBlock> tableLiteralQueryMap = new HashMap<Long, SQLSelectQueryBlock>();
        HashMap<Long, SQLLiteralExpr> tableLiteralMap = new HashMap<Long, SQLLiteralExpr>();
        HashMap<Long, SQLBinaryOpExpr> tableConditionMap = new HashMap<Long, SQLBinaryOpExpr>();
        LinkedHashMap<SQLLiteralExpr, SQLSelectQueryBlock> LiteralQueryMap = new LinkedHashMap<SQLLiteralExpr, SQLSelectQueryBlock>();
        LinkedHashMap<SQLLiteralExpr, SQLWithSubqueryClause.Entry> LiteralEntryMap = new LinkedHashMap<SQLLiteralExpr, SQLWithSubqueryClause.Entry>();
        int aliasSeed = 1;
        for (Map.Entry entry : tableSourceCondtionMap.entrySet()) {
            List tableConditions = (List)entry.getValue();
            for (SQLBinaryOpExpr tableCondition : tableConditions) {
                SQLPropertyExpr name = (SQLPropertyExpr)tableCondition.getLeft();
                SQLIdentifierExpr owner = (SQLIdentifierExpr)name.getOwner();
                boolean matchLiteralColumnAllEntryQueries = true;
                SQLSelectQueryBlock matchedLiteralQuery = null;
                for (SQLSelectQuery withEntryUnionQuery : withEntryUnionQueries) {
                    SQLSelectQueryBlock selectQueryBlock = (SQLSelectQueryBlock)withEntryUnionQuery;
                    SQLSelectItem selectItem = selectQueryBlock.findSelectItem(name.nameHashCode64());
                    if (!(selectItem.getExpr() instanceof SQLLiteralExpr)) {
                        matchLiteralColumnAllEntryQueries = false;
                        break;
                    }
                    if (!selectItem.getExpr().equals(tableCondition.getRight())) continue;
                    matchedLiteralQuery = selectQueryBlock;
                }
                SQLLiteralExpr right = (SQLLiteralExpr)tableCondition.getRight();
                if (!matchLiteralColumnAllEntryQueries || matchedLiteralQuery == null) continue;
                tableLiteralQueryMap.put(owner.nameHashCode64(), matchedLiteralQuery);
                tableLiteralMap.put(owner.nameHashCode64(), right);
                tableConditionMap.put(owner.nameHashCode64(), tableCondition);
                if (LiteralQueryMap.containsKey(right)) continue;
                SQLSelectQueryBlock literalQuery = matchedLiteralQuery.clone();
                LiteralQueryMap.put(right, literalQuery);
                SQLWithSubqueryClause.Entry literalEntry = new SQLWithSubqueryClause.Entry();
                literalEntry.setSubQuery(new SQLSelect(literalQuery));
                String withEntryAlias = withEntry.getAlias2();
                String literalEntryAlias = null;
                while (aliasSeed < 100) {
                    String alias = withEntryAlias + "_" + aliasSeed++;
                    long aliasHashCode64 = FnvHash.hashCode64(alias);
                    if (tableLiteralQueryMap.containsKey(aliasHashCode64)) continue;
                    literalEntryAlias = alias;
                    break;
                }
                if (literalEntryAlias == null) {
                    return;
                }
                literalEntry.setAlias(literalEntryAlias);
                LiteralEntryMap.put(right, literalEntry);
            }
        }
        if (LiteralEntryMap.size() != withEntryUnionQueries.size()) {
            return;
        }
        with.getEntries().clear();
        for (SQLWithSubqueryClause.Entry literalEntry : LiteralEntryMap.values()) {
            with.addEntry(literalEntry);
        }
        for (Map.Entry itemEntry : tableSourceMap.entrySet()) {
            long aliasHashCode64 = (Long)itemEntry.getKey();
            SQLExprTableSource tableSource = (SQLExprTableSource)itemEntry.getValue();
            SQLLiteralExpr literalExpr = (SQLLiteralExpr)tableLiteralMap.get(aliasHashCode64);
            String literalEntryAlias = ((SQLWithSubqueryClause.Entry)LiteralEntryMap.get(literalExpr)).getAlias();
            SQLIdentifierExpr tableExpr = new SQLIdentifierExpr(literalEntryAlias);
            tableSource.setExpr(tableExpr);
        }
        for (SQLBinaryOpExpr condition : tableConditionMap.values()) {
            SQLUtils.replaceInParent(condition, null);
        }
        tableLiteralQueryMap.size();
    }

    public void visitTPCDSQ44(SQLSelectQueryBlock x) {
        SQLObject parent = x.getParent();
        if (!(parent instanceof SQLSelect)) {
            return;
        }
        SQLSelect select = (SQLSelect)parent;
        if (!(select.getParent() instanceof SQLSelectStatement)) {
            return;
        }
        SQLWithSubqueryClause with = select.getWithSubQuery();
        if (with != null) {
            return;
        }
        SQLTableSource from = x.getFrom();
        if (!(from instanceof SQLJoinTableSource)) {
            return;
        }
        SQLJoinTableSource join = (SQLJoinTableSource)from;
        ArrayList<SQLTableSource> outTableSources = new ArrayList<SQLTableSource>();
        join.splitTo(outTableSources, join.getJoinType());
        ArrayList<SQLSubqueryTableSource> subqueryTableSources = new ArrayList<SQLSubqueryTableSource>();
        for (SQLTableSource tableSource : outTableSources) {
            SQLSelectQueryBlock subQueryBlock2;
            SQLTableSource subFrom2;
            SQLSelectQueryBlock subQueryBlock;
            SQLTableSource subFrom;
            SQLSelectQueryBlock queryBlock;
            if (!(tableSource instanceof SQLSubqueryTableSource) || (queryBlock = ((SQLSubqueryTableSource)tableSource).getSelect().getQueryBlock()) == null || !((subFrom = queryBlock.getFrom()) instanceof SQLSubqueryTableSource) || (subQueryBlock = ((SQLSubqueryTableSource)subFrom).getSelect().getQueryBlock()) == null || !((subFrom2 = subQueryBlock.getFrom()) instanceof SQLSubqueryTableSource) || (subQueryBlock2 = ((SQLSubqueryTableSource)subFrom2).getSelect().getQueryBlock()) == null) continue;
            subqueryTableSources.add((SQLSubqueryTableSource)subFrom2);
        }
        if (subqueryTableSources.size() < 2) {
            return;
        }
        SQLSubqueryTableSource first = (SQLSubqueryTableSource)subqueryTableSources.get(0);
        for (int i = 1; i < subqueryTableSources.size(); ++i) {
            SQLSubqueryTableSource subqueryTableSource = (SQLSubqueryTableSource)subqueryTableSources.get(i);
            if (first.getSelect().equals(subqueryTableSource.getSelect())) continue;
            return;
        }
        SQLTableAliasCollectVisitor v = new SQLTableAliasCollectVisitor();
        select.accept(v);
        String alias = v.genAlias(1);
        if (alias == null) {
            return;
        }
        SQLWithSubqueryClause.Entry withEntry = new SQLWithSubqueryClause.Entry(alias, first.getSelect().clone());
        if (with == null) {
            with = new SQLWithSubqueryClause();
            select.setWithSubQuery(with);
        }
        with.addEntry(withEntry);
        for (SQLSubqueryTableSource subqueryTableSource : subqueryTableSources) {
            SQLIdentifierExpr tableRef = new SQLIdentifierExpr(alias);
            tableRef.setResolvedTableSource(withEntry);
            SQLExprTableSource tableRefTableSource = new SQLExprTableSource(tableRef, subqueryTableSource.getAlias());
            SQLSelectQueryBlock subQueryBlock = (SQLSelectQueryBlock)subqueryTableSource.getParent();
            subQueryBlock.setFrom(tableRefTableSource);
        }
    }

    public void visitYouku01(SQLSelect select) {
        if (!(select.getParent() instanceof SQLSelectStatement)) {
            return;
        }
        SQLSelectQueryBlock queryBlock = select.getQueryBlock();
        if (queryBlock == null) {
            return;
        }
        SQLTableSource from = queryBlock.getFrom();
        if (!(from instanceof SQLUnionQueryTableSource)) {
            return;
        }
        SQLUnionQuery union = ((SQLUnionQueryTableSource)from).getUnion();
        List<SQLSelectQuery> unionSelectQueries = union.getChildren();
        if (unionSelectQueries.size() < 2) {
            return;
        }
        SQLSelectQueryBlock first = null;
        for (int i = 0; i < unionSelectQueries.size(); ++i) {
            SQLSelectQuery item = unionSelectQueries.get(i);
            if (!(item instanceof SQLSelectQueryBlock)) {
                return;
            }
            SQLTableSource unionQueryFrom = ((SQLSelectQueryBlock)item).getFrom();
            if (!(unionQueryFrom instanceof SQLExprTableSource)) {
                return;
            }
            SQLExpr expr = ((SQLExprTableSource)unionQueryFrom).getExpr();
            if (!(expr instanceof SQLName)) {
                return;
            }
            SQLSelectQueryBlock unionQueryBlock = (SQLSelectQueryBlock)item.clone();
            SQLSelectGroupByClause groupBy = unionQueryBlock.getGroupBy();
            if (groupBy != null) {
                boolean partitionByGroup = false;
                for (SQLExpr groupByExpr : groupBy.getItems()) {
                    SQLColumnDefinition resolvedColumn;
                    if (groupByExpr instanceof MySqlOrderingExpr) {
                        groupByExpr = ((MySqlOrderingExpr)groupByExpr).getExpr();
                    }
                    if (!(groupByExpr instanceof SQLName) || (resolvedColumn = ((SQLName)groupByExpr).getResolvedColumn()) == null || !resolvedColumn.isPartitionBy()) continue;
                    partitionByGroup = true;
                    break;
                }
                if (partitionByGroup) continue;
            }
            unionQueryBlock.getSelectList().clear();
            unionQueryBlock.addSelectItem(new SQLIntegerExpr(1));
            unionQueryBlock.setGroupBy(null);
            if (first == null) {
                first = unionQueryBlock;
                continue;
            }
            if (first.equals(unionQueryBlock)) continue;
            return;
        }
        if (first == null) {
            return;
        }
        final LinkedHashSet columns = new LinkedHashSet();
        SQLASTVisitorAdapter v = new SQLASTVisitorAdapter(){

            @Override
            public boolean visit(SQLIdentifierExpr x) {
                columns.add(x);
                return false;
            }

            @Override
            public boolean visit(SQLPropertyExpr x) {
                columns.add(x);
                return false;
            }

            @Override
            public boolean visit(SQLExprTableSource x) {
                return false;
            }

            @Override
            public boolean visit(SQLSubqueryTableSource x) {
                return false;
            }
        };
        for (SQLSelectQuery item : unionSelectQueries) {
            item.accept(v);
        }
        first.getSelectList().clear();
        for (SQLName column : columns) {
            first.addSelectItem(column);
        }
        SQLWithSubqueryClause with = select.getWithSubQuery();
        if (with == null) {
            with = new SQLWithSubqueryClause();
            select.setWithSubQuery(with);
        }
        SQLTableAliasCollectVisitor v2 = new SQLTableAliasCollectVisitor();
        select.accept(v2);
        String alias = v2.genAlias(1);
        SQLWithSubqueryClause.Entry withEntry = new SQLWithSubqueryClause.Entry(alias, new SQLSelect(first));
        with.addEntry(withEntry);
        for (int i = 0; i < unionSelectQueries.size(); ++i) {
            SQLIdentifierExpr entryRef = new SQLIdentifierExpr(alias);
            entryRef.setResolvedTableSource(withEntry);
            SQLSelectQueryBlock unionQuery = (SQLSelectQueryBlock)unionSelectQueries.get(i);
            unionQuery.setFrom(new SQLExprTableSource(entryRef));
            unionQuery.setWhere(null);
        }
    }

    static class MatchName
    extends SQLASTVisitorAdapter {
        public final long nameHashCode64;
        public int matchCount;

        public MatchName(long nameHashCode64) {
            this.nameHashCode64 = nameHashCode64;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            if (x.nameHashCode64() == this.nameHashCode64) {
                ++this.matchCount;
            }
            return false;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            if (x.nameHashCode64() == this.nameHashCode64) {
                ++this.matchCount;
            }
            return true;
        }
    }

    class ExprReplaceVisitor
    extends SQLASTVisitorAdapter {
        private final SQLSelectQueryBlock queryBlock;
        private final SQLSelectQueryBlock subQueryBlock;
        private int repalcedFailCount = 0;

        public ExprReplaceVisitor(SQLSelectQueryBlock queryBlock, SQLSelectQueryBlock subQueryBlock) {
            this.queryBlock = queryBlock;
            this.subQueryBlock = subQueryBlock;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            SQLSelectItem selectItem = this.subQueryBlock.findSelectItem(x.nameHashCode64());
            if (selectItem == null) {
                ++this.repalcedFailCount;
                return false;
            }
            if (!SQLUtils.replaceInParent(x, selectItem.getExpr().clone())) {
                ++this.repalcedFailCount;
            }
            return false;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            if (!(x.getOwner() instanceof SQLIdentifierExpr)) {
                ++this.repalcedFailCount;
                return false;
            }
            SQLIdentifierExpr owner = (SQLIdentifierExpr)x.getOwner();
            if (this.queryBlock.getFrom().aliasHashCode64() != owner.nameHashCode64()) {
                ++this.repalcedFailCount;
                return false;
            }
            if (x.getName().equals("*")) {
                if (!SQLUtils.replaceInParent(x, new SQLAllColumnExpr())) {
                    ++this.repalcedFailCount;
                }
                return false;
            }
            SQLSelectItem selectItem = this.subQueryBlock.findSelectItem(x.nameHashCode64());
            if (selectItem == null) {
                ++this.repalcedFailCount;
                return false;
            }
            if (!SQLUtils.replaceInParent(x, selectItem.getExpr().clone())) {
                ++this.repalcedFailCount;
            }
            return false;
        }
    }
}

