/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAllExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAnyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCastExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLExistsExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLSomeExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class PushUp
extends OptimizerVisitor {
    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        SQLSelectQueryBlock queryBlock = x.getSelect().getQueryBlock();
        SQLObject parent = x.getParent();
        if (parent instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)parent;
            if (queryBlock != null && queryBlock.getWhere() != null && join.getJoinType() != SQLJoinTableSource.JoinType.INNER_JOIN) {
                return true;
            }
        }
        SQLSelect select = x.getSelect();
        SQLSelectQueryBlock parentQuery = null;
        SQLObject parent2 = x.getParent();
        while (parent2 instanceof SQLJoinTableSource) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof SQLSelectQueryBlock) {
            parentQuery = (SQLSelectQueryBlock)parent2;
            for (SQLSelectItem selectItem : parentQuery.getSelectList()) {
                SQLExpr expr = selectItem.getExpr();
                if (expr instanceof SQLAllColumnExpr) {
                    return super.visit(x);
                }
                if (expr instanceof SQLPropertyExpr && ((SQLPropertyExpr)expr).getSimpleName().equalsIgnoreCase("*")) {
                    return super.visit(x);
                }
                if (!(expr instanceof SQLAggregateExpr)) continue;
                SQLAggregateExpr agg = (SQLAggregateExpr)expr;
                for (SQLExpr arg : agg.getArguments()) {
                    if (arg instanceof SQLAllColumnExpr) {
                        return super.visit(x);
                    }
                    if (!(arg instanceof SQLPropertyExpr) || !((SQLPropertyExpr)arg).getSimpleName().equalsIgnoreCase("*")) continue;
                    return super.visit(x);
                }
            }
        }
        parent2 = x.getParent();
        SQLSelectQuery query = select.getQuery();
        query.accept(this);
        final String alias = x.getAlias();
        if (query instanceof SQLSelectQueryBlock) {
            SQLASTVisitorAdapter visitor;
            SQLSelectQueryBlock queryBlock2 = (SQLSelectQueryBlock)query;
            if (queryBlock2.getFrom() == null) {
                return true;
            }
            SQLTableSource clonedFrom = queryBlock2.getFrom().clone();
            SQLExpr where = queryBlock2.getWhere();
            if (alias != null && where != null) {
                where = where.clone();
                final SQLExpr fromTable = clonedFrom instanceof SQLExprTableSource ? ((SQLExprTableSource)clonedFrom).getExpr() : null;
                visitor = new SQLASTVisitorAdapter(){

                    @Override
                    public boolean visit(SQLSubqueryTableSource x) {
                        return false;
                    }

                    @Override
                    public boolean visit(SQLInSubQueryExpr x) {
                        x.getExpr().accept(this);
                        return false;
                    }

                    @Override
                    public boolean visit(SQLExistsExpr x) {
                        return false;
                    }

                    @Override
                    public boolean visit(SQLAnyExpr x) {
                        return false;
                    }

                    @Override
                    public boolean visit(SQLAllExpr x) {
                        return false;
                    }

                    @Override
                    public boolean visit(SQLSomeExpr x) {
                        return false;
                    }

                    @Override
                    public boolean visit(SQLIdentifierExpr x) {
                        if (x.equals(fromTable)) {
                            SQLUtils.replaceInParent(x, new SQLIdentifierExpr(alias));
                            return false;
                        }
                        if (x.getParent() instanceof SQLPropertyExpr) {
                            return false;
                        }
                        SQLUtils.replaceInParent(x, new SQLPropertyExpr(alias, x.getName()));
                        return false;
                    }

                    @Override
                    public boolean visit(SQLPropertyExpr x) {
                        if (x.equals(fromTable)) {
                            SQLUtils.replaceInParent(x, new SQLIdentifierExpr(alias));
                            return false;
                        }
                        return true;
                    }
                };
                where.accept(visitor);
            }
            if (PushUp.isSimpleQueryBlock(queryBlock2)) {
                final AtomicBoolean aliasUsed = new AtomicBoolean();
                if (clonedFrom instanceof SQLJoinTableSource && x.getAlias() != null) {
                    visitor = new SQLASTVisitorAdapter(){

                        @Override
                        public boolean visit(SQLIdentifierExpr x) {
                            if (x.getName().equals(alias) && x.getParent() instanceof SQLPropertyExpr) {
                                aliasUsed.set(true);
                            }
                            return false;
                        }
                    };
                    parentQuery.accept(visitor);
                    if (aliasUsed.get()) {
                        return super.visit(x);
                    }
                }
                String xAlias = x.getAlias();
                if (clonedFrom instanceof SQLJoinTableSource) {
                    if (x.getParent() instanceof SQLJoinTableSource) {
                        return super.visit(x);
                    }
                } else {
                    clonedFrom.setAlias(xAlias);
                }
                if (parent2 instanceof SQLJoinTableSource) {
                    SQLJoinTableSource join = (SQLJoinTableSource)parent2;
                    if (join.replace(x, clonedFrom)) {
                        ++this.optimizedCount;
                        join.addCondition(where);
                        if (join.getJoinType() == SQLJoinTableSource.JoinType.INNER_JOIN && join.getLeft() instanceof SQLExprTableSource && join.getRight() instanceof SQLJoinTableSource) {
                            SQLTableSource tmp = join.getLeft();
                            join.setLeft(join.getRight());
                            join.setRight(tmp);
                        }
                    }
                } else if (parent2 instanceof SQLSelectQueryBlock) {
                    SQLSelectQueryBlock parentQueryBlock = (SQLSelectQueryBlock)parent2;
                    boolean allMatch = true;
                    if (parentQueryBlock.getSelectList().size() == queryBlock2.getSelectList().size()) {
                        for (int i = 0; i < parentQueryBlock.getSelectList().size(); ++i) {
                            SQLSelectItem pItem = parentQueryBlock.getSelectList().get(i);
                            SQLExpr pExpr = pItem.getExpr();
                            SQLSelectItem item = queryBlock2.getSelectList().get(i);
                            if (pExpr instanceof SQLCastExpr) {
                                pExpr = ((SQLCastExpr)pExpr).getExpr();
                            }
                            if (pItem.equals(item) || pExpr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)pExpr).getName().equals(item.computeAlias())) continue;
                            allMatch = false;
                            break;
                        }
                    } else {
                        allMatch = false;
                    }
                    if (allMatch && parentQuery.getFrom() == x) {
                        parentQuery.setFrom(clonedFrom);
                        ++this.optimizedCount;
                        this.replaceAlas(queryBlock2, parentQuery, alias);
                        parentQuery.addCondition(where);
                    }
                } else {
                    return super.visit(x);
                }
            }
        }
        return super.visit(x);
    }

    private void replaceAlas(SQLSelectQueryBlock queryBlock, SQLSelectQueryBlock parent, final String tabSrcAlias) {
        final HashMap<Long, SQLExpr> map = new HashMap<Long, SQLExpr>();
        for (SQLSelectItem selectItem : queryBlock.getSelectList()) {
            String alias = selectItem.getAlias();
            SQLExpr expr = selectItem.getExpr().clone();
            boolean changed = false;
            if (alias != null) {
                if (expr instanceof SQLName) {
                    if (!alias.equals(expr.toString())) {
                        changed = true;
                    }
                } else {
                    changed = true;
                }
            }
            if (!changed) continue;
            SQLASTVisitorAdapter visitor = new SQLASTVisitorAdapter(){

                @Override
                public boolean visit(SQLIdentifierExpr x) {
                    SQLUtils.replaceInParent(x, new SQLPropertyExpr(tabSrcAlias, x.getName()));
                    return false;
                }
            };
            expr.accept(visitor);
            map.put(selectItem.alias_hash(), expr);
        }
        if (map.size() == 0) {
            return;
        }
        SQLASTVisitorAdapter visitor = new SQLASTVisitorAdapter(){

            @Override
            public boolean visit(SQLIdentifierExpr x) {
                Long hash = x.nameHashCode64();
                SQLExpr expr = (SQLExpr)map.get(hash);
                if (expr != null) {
                    SQLUtils.replaceInParent(x, expr.clone());
                }
                return false;
            }
        };
        parent.accept(visitor);
    }

    private static boolean isSimpleQueryBlock(SQLSelectQueryBlock x) {
        if (x.getDistionOption() != 0) {
            return false;
        }
        if (x.getLimit() != null || x.getOrderBy() != null || x.getGroupBy() != null) {
            return false;
        }
        for (SQLSelectItem selectItem : x.getSelectList()) {
            SQLExpr expr = selectItem.getExpr();
            if (expr instanceof SQLCastExpr) {
                expr = ((SQLCastExpr)expr).getExpr();
            }
            if (expr instanceof SQLName) continue;
            return false;
        }
        return PushUp.isSimple(x.getFrom());
    }

    private static boolean isSimple(SQLTableSource tableSource) {
        if (tableSource instanceof SQLExprTableSource && ((SQLExprTableSource)tableSource).getExpr() instanceof SQLName) {
            return true;
        }
        if (tableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
            return PushUp.isSimple(join.getLeft()) && PushUp.isSimple(join.getRight());
        }
        return false;
    }

    public static String optimize(String sql, DbType dbType) {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType, new SQLParserFeature[0]);
        PushUp visitor = new PushUp();
        for (int i = 0; i < stmtList.size(); ++i) {
            SQLStatement stmt = stmtList.get(i);
            stmt.accept(visitor);
        }
        return SQLUtils.toSQLString(stmtList, dbType);
    }
}

