/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.funtions.FunctionDef;
import com.alibaba.fastsql.funtions.FunctionRepository;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCaseExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCastExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNotExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTextLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.fastsql.sql.optimizer.rules.ConstFolding;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.sql.repository.SchemaObject;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.MySqlUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class TypeInference
extends OptimizerVisitor {
    private FunctionRepository functionRepository = FunctionRepository.MY_SQL;

    public TypeInference() {
    }

    public TypeInference(DbType dbType, TimeZone timeZone) {
        this.dbType = dbType;
        this.timeZone = timeZone;
    }

    public TypeInference(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        return this.visit((SQLInsertStatement)x);
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        SQLSelect select;
        SQLExprTableSource tableSource = x.getTableSource();
        if (tableSource != null) {
            tableSource.accept(this);
        }
        List<SQLExpr> columns = x.getColumns();
        for (SQLExpr sQLExpr : columns) {
            sQLExpr.accept(this);
        }
        List<SQLInsertStatement.ValuesClause> valuesList = x.getValuesList();
        for (SQLInsertStatement.ValuesClause item : valuesList) {
            item.accept(this);
        }
        SQLSelect sQLSelect = x.getQuery();
        if (sQLSelect != null) {
            sQLSelect.accept(this);
        }
        if ((select = x.getQuery()) == null) {
            return false;
        }
        ArrayList<SQLDataType> dataTypes = new ArrayList<SQLDataType>();
        List<SQLExpr> columns2 = x.getColumns();
        if (columns2.size() > 0) {
            for (SQLExpr column : columns2) {
                dataTypes.add(column.computeDataType());
            }
        } else {
            SchemaObject schemaObject = x.getTableSource().getSchemaObject();
            if (schemaObject != null && schemaObject.getStatement() instanceof SQLCreateTableStatement) {
                SQLCreateTableStatement ddl = (SQLCreateTableStatement)schemaObject.getStatement();
                List<SQLColumnDefinition> columnDefinitions = ddl.getColumnDefinitions();
                for (SQLColumnDefinition columnDefinition : columnDefinitions) {
                    dataTypes.add(columnDefinition.getDataType());
                }
            }
        }
        this.inference(dataTypes, select.getQuery());
        return false;
    }

    private void inference(List<SQLDataType> dataTypes, SQLSelectQuery query) {
        if (query instanceof SQLSelectQueryBlock) {
            this.inference(dataTypes, (SQLSelectQueryBlock)query);
        } else if (query instanceof SQLUnionQuery) {
            // empty if block
        }
    }

    private void inference(List<SQLDataType> dataTypes, SQLSelectQueryBlock queryBlock) {
        List<SQLSelectItem> selectList = queryBlock.getSelectList();
        for (int i = 0; i < selectList.size() && i < dataTypes.size(); ++i) {
            SQLSelectItem selectItem;
            SQLExpr expr;
            SQLDataType exprDataType;
            SQLDataType dataType = dataTypes.get(i);
            if (dataType == null || (exprDataType = (expr = (selectItem = selectList.get(i)).getExpr()).computeDataType()) == null) continue;
            long exprDataTypeHash = exprDataType.nameHashCode64();
            SQLExprImpl replaceTo = null;
            long dataTypeHash = dataType.nameHashCode64();
            if (exprDataTypeHash == dataTypeHash) continue;
            if (dataTypeHash == FnvHash.Constants.DATETIME) {
                if (expr instanceof SQLCharExpr) {
                    replaceTo = new SQLTimestampExpr(((SQLCharExpr)expr).getText());
                } else if (exprDataType.isInt() || exprDataType.isString()) {
                    replaceTo = new SQLCastExpr(expr.clone(), dataType.clone());
                }
            } else if (dataTypeHash == FnvHash.Constants.BIGINT || dataTypeHash == FnvHash.Constants.INT || dataTypeHash == FnvHash.Constants.INTEGER || dataTypeHash == FnvHash.Constants.SMALLINT || dataTypeHash == FnvHash.Constants.TINYINT) {
                if (expr instanceof SQLCharExpr) {
                    String text = ((SQLCharExpr)expr).getText();
                    try {
                        long value = Long.parseLong(text);
                        replaceTo = SQLIntegerExpr.ofIntOrLong(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (exprDataTypeHash == FnvHash.Constants.VARCHAR || exprDataTypeHash == FnvHash.Constants.CHAR || exprDataTypeHash == FnvHash.Constants.FLOAT || exprDataTypeHash == FnvHash.Constants.DOUBLE || exprDataTypeHash == FnvHash.Constants.NUMBER) {
                    replaceTo = new SQLCastExpr(expr.clone(), dataType.clone());
                } else if (exprDataTypeHash == FnvHash.Constants.BIGINT && (dataTypeHash == FnvHash.Constants.INT || dataTypeHash == FnvHash.Constants.INTEGER || dataTypeHash == FnvHash.Constants.SMALLINT || dataTypeHash == FnvHash.Constants.TINYINT)) {
                    replaceTo = new SQLCastExpr(expr.clone(), dataType.clone());
                }
            } else if (dataTypeHash == FnvHash.Constants.CHAR || dataTypeHash == FnvHash.Constants.VARCHAR) {
                if (expr instanceof SQLNumericLiteralExpr) {
                    replaceTo = new SQLCharExpr(expr.toString());
                } else if (exprDataType.isInt()) {
                    replaceTo = new SQLCastExpr(expr.clone(), dataType.clone());
                }
            }
            if (replaceTo == null) continue;
            selectItem.setExpr(replaceTo);
        }
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        if (this.isGroup(x)) {
            return super.visit(x);
        }
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        left.accept(this);
        right.accept(this);
        SQLDataType leftDataType = left.computeDataType();
        SQLDataType rightDataType = right.computeDataType();
        if (leftDataType == null) {
            return false;
        }
        long leftTypeHash = leftDataType.nameHashCode64();
        long rightTypeHash = rightDataType != null ? rightDataType.nameHashCode64() : 0L;
        switch (x.getOperator()) {
            case Like: 
            case NotLike: {
                if (!leftDataType.isInt() && leftTypeHash != FnvHash.Constants.FLOAT && leftTypeHash != FnvHash.Constants.DOUBLE && leftTypeHash != FnvHash.Constants.NUMBER && leftTypeHash != FnvHash.Constants.DECIMAL && leftTypeHash != FnvHash.Constants.DATE && leftTypeHash != FnvHash.Constants.DATETIME && leftTypeHash != FnvHash.Constants.TIMESTAMP && leftTypeHash != FnvHash.Constants.TIME) break;
                x.setLeft(new SQLCastExpr(left, new SQLCharacterDataType("CHAR")));
                break;
            }
            case Add: 
            case Subtract: {
                SQLCastExpr castExpr;
                if (leftTypeHash == FnvHash.Constants.CHAR || leftTypeHash == FnvHash.Constants.VARCHAR) {
                    if (right instanceof SQLIntervalExpr) {
                        if (left instanceof SQLCharExpr) {
                            String text = ((SQLCharExpr)left).getText();
                            Date date = MySqlUtils.parseDate(text, this.timeZone);
                            if (date == null) {
                                return false;
                            }
                            SQLTimestampExpr ts = new SQLTimestampExpr(date, this.timeZone);
                            x.setLeft(ts);
                            break;
                        }
                        SQLCastExpr castExpr2 = new SQLCastExpr(left.clone(), new SQLDataTypeImpl("TIMESTAMP"));
                        x.setLeft(castExpr2);
                        break;
                    }
                    if (rightDataType != null && rightDataType.isInt()) {
                        castExpr = new SQLCastExpr(left.clone(), new SQLDataTypeImpl("BIGINT"));
                        x.setLeft(castExpr);
                    }
                } else if (leftDataType != null && leftDataType.isInt() && rightTypeHash == FnvHash.Constants.TIMESTAMP && this.dbType == DbType.mysql) {
                    SQLExprImpl replaceTo = null;
                    if (right instanceof SQLTimestampExpr) {
                        Date date = ((SQLTimestampExpr)right).getDate(this.timeZone);
                        if (date != null) {
                            Number number;
                            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                            if (this.timeZone != null) {
                                format.setTimeZone(this.timeZone);
                            }
                            String dateStr = format.format(date);
                            long intVal = Long.parseLong(dateStr);
                            if (left instanceof SQLIntegerExpr && ((number = ((SQLIntegerExpr)left).getNumber()) instanceof Integer || number instanceof Long)) {
                                long leftValue = number.longValue();
                                long result = x.getOperator() == SQLBinaryOperator.Add ? leftValue + intVal : leftValue - intVal;
                                if (SQLUtils.replaceInParent(x, new SQLIntegerExpr(result))) {
                                    return false;
                                }
                            }
                            replaceTo = new SQLIntegerExpr(intVal);
                        }
                    } else {
                        SQLMethodInvokeExpr chars = new SQLMethodInvokeExpr("date_format", null, right.clone(), new SQLCharExpr("%Y%m%d%H%i%s"));
                        replaceTo = new SQLCastExpr(chars, new SQLDataTypeImpl("BIGINT"));
                    }
                    if (replaceTo != null) {
                        x.setRight(replaceTo);
                    }
                }
                if (!leftDataType.isString() || left instanceof SQLTextLiteralExpr || rightTypeHash != FnvHash.Constants.NUMBER) break;
                castExpr = new SQLCastExpr(left.clone(), SQLNumberExpr.DATA_TYPE_DOUBLE.clone());
                x.setLeft(castExpr);
                break;
            }
            case Multiply: 
            case Divide: 
            case DIV: {
                if (leftDataType.isString() && !(left instanceof SQLTextLiteralExpr)) {
                    if (rightTypeHash == FnvHash.Constants.NUMBER) {
                        SQLCastExpr castExpr = new SQLCastExpr(left.clone(), SQLNumberExpr.DATA_TYPE_DOUBLE.clone());
                        x.setLeft(castExpr);
                        ++this.optimizedCount;
                        break;
                    }
                    if (!(right instanceof SQLIntegerExpr)) break;
                    SQLCastExpr castExpr = new SQLCastExpr(left.clone(), SQLIntegerExpr.DATA_TYPE.clone());
                    x.setLeft(castExpr);
                    ++this.optimizedCount;
                    break;
                }
                if (!leftDataType.isString() || !(left instanceof SQLTextLiteralExpr) || !rightDataType.isInt() && rightTypeHash != FnvHash.Constants.NUMBER) break;
                SQLCastExpr castExpr = new SQLCastExpr(left.clone(), SQLNumberExpr.DATA_TYPE_DOUBLE.clone());
                x.setLeft(castExpr);
                ++this.optimizedCount;
                break;
            }
            case LessThan: 
            case LessThanOrEqual: 
            case GreaterThanOrEqual: 
            case GreaterThan: 
            case Equality: 
            case NotEqual: 
            case LessThanOrGreater: {
                if (leftDataType == null) break;
                long leftDateTypeHash = leftDataType.nameHashCode64();
                if (leftDateTypeHash == FnvHash.Constants.INT || leftDateTypeHash == FnvHash.Constants.INTEGER || leftDateTypeHash == FnvHash.Constants.BIGINT) {
                    if (right instanceof SQLCharExpr) {
                        String text = ((SQLCharExpr)right).getText();
                        try {
                            long val = Long.parseLong(text);
                            x.setRight(new SQLIntegerExpr(val));
                            ++this.optimizedCount;
                        }
                        catch (NumberFormatException val) {}
                        break;
                    }
                    if (rightDataType == null || !rightDataType.isString() || !(right instanceof SQLName)) break;
                    SQLCastExpr cast = new SQLCastExpr(right.clone(), leftDataType.clone());
                    cast.setTry(true);
                    x.setRight(cast);
                    break;
                }
                if (leftDateTypeHash == FnvHash.Constants.DOUBLE || leftDateTypeHash == FnvHash.Constants.FLOAT || leftDateTypeHash == FnvHash.Constants.DECIMAL || leftDateTypeHash == FnvHash.Constants.NUMBER || leftDateTypeHash == FnvHash.Constants.NUMERIC) {
                    if (!(right instanceof SQLCharExpr)) break;
                    String text = ((SQLCharExpr)right).getText();
                    try {
                        if (text.indexOf(46) != -1 || text.indexOf(101) != -1 || text.indexOf(69) != -1) break;
                        long val = Long.parseLong(text);
                        x.setRight(new SQLNumberExpr(val));
                        ++this.optimizedCount;
                    }
                    catch (NumberFormatException val) {}
                    break;
                }
                if (leftDateTypeHash == FnvHash.Constants.CHAR || leftDateTypeHash == FnvHash.Constants.VARCHAR) {
                    if (!(right instanceof SQLNumericLiteralExpr)) break;
                    if (x.getOperator() != SQLBinaryOperator.NotEqual && x.getOperator() != SQLBinaryOperator.Equality) {
                        Number number = ((SQLNumericLiteralExpr)right).getNumber();
                        SQLCastExpr cast = null;
                        if (number instanceof Integer || number instanceof Long) {
                            cast = new SQLCastExpr(left.clone(), new SQLDataTypeImpl("BIGINT"));
                        } else if (number instanceof Float || number instanceof Double || number instanceof BigDecimal) {
                            cast = new SQLCastExpr(left.clone(), new SQLDataTypeImpl("DOUBLE"));
                        }
                        if (cast == null) break;
                        cast.setTry(true);
                        x.setLeft(cast);
                        ++this.optimizedCount;
                        break;
                    }
                    if (left instanceof SQLAggregateExpr) break;
                    String str = right.toString();
                    SQLCharExpr charExpr = new SQLCharExpr(str);
                    x.setRight(charExpr);
                    ++this.optimizedCount;
                    break;
                }
                if (leftDateTypeHash == FnvHash.Constants.BOOLEAN) {
                    if (right instanceof SQLCharExpr) {
                        String str = ((SQLCharExpr)right).getText();
                        if ("true".equalsIgnoreCase(str) || "1".equals(str)) {
                            SQLBooleanExpr booleanExpr = new SQLBooleanExpr(true);
                            x.setRight(booleanExpr);
                            ++this.optimizedCount;
                            break;
                        }
                        if (!"false".equalsIgnoreCase(str) && !"0".equals(str)) break;
                        SQLBooleanExpr booleanExpr = new SQLBooleanExpr(false);
                        x.setRight(booleanExpr);
                        ++this.optimizedCount;
                        break;
                    }
                    if (!(right instanceof SQLIntegerExpr)) break;
                    Number num = ((SQLIntegerExpr)right).getNumber();
                    if (num.equals(1)) {
                        SQLBooleanExpr booleanExpr = new SQLBooleanExpr(true);
                        x.setRight(booleanExpr);
                        ++this.optimizedCount;
                        break;
                    }
                    if (!num.equals(0)) break;
                    SQLBooleanExpr booleanExpr = new SQLBooleanExpr(false);
                    x.setRight(booleanExpr);
                    ++this.optimizedCount;
                    break;
                }
                if (leftDateTypeHash != FnvHash.Constants.TIME || !(right instanceof SQLCharExpr)) break;
                String str = ((SQLCharExpr)right).getText();
                x.setRight(new SQLTimeExpr(str));
                ++this.optimizedCount;
                break;
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        return this.visit((SQLMethodInvokeExpr)x);
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        long hash = x.methodNameHashCode64();
        if (x.getResolvedReturnDataType() == null && (hash == FnvHash.Constants.DATEDIFF || hash == FnvHash.Constants.DATE_DIFF)) {
            x.setResolvedReturnDataType(SQLIntegerExpr.DATA_TYPE);
        }
        if (x.methodNameHashCode64() == FnvHash.Constants.IF) {
            this.func_if(x);
            return true;
        }
        FunctionDef functionDef = this.findFunction(hash);
        List<SQLExpr> arguments = x.getArguments();
        if (functionDef != null) {
            if (!functionDef.isVarArgs() && arguments.size() > functionDef.getParameterTypes().size()) {
                return true;
            }
            for (int i = 0; i < arguments.size(); ++i) {
                long argTypeHash;
                SQLCastExpr castExpr;
                SQLObject replaceTo = null;
                SQLDataType type = functionDef.getParemeterType(i);
                SQLExpr arg = arguments.get(i);
                SQLDataType argDataType = arg.computeDataType();
                if (type == null) continue;
                if (FnvHash.Constants.CHAR == type.nameHashCode64()) {
                    long argTypeHash2;
                    if (arg instanceof SQLIntegerExpr) {
                        String chars = ((SQLIntegerExpr)arg).getNumber().toString();
                        SQLCharExpr charExpr = new SQLCharExpr(chars);
                        charExpr.setParent(x);
                        arguments.set(i, charExpr);
                        ++this.optimizedCount;
                        continue;
                    }
                    if (arg instanceof SQLTimestampExpr) {
                        String chars = ((SQLTimestampExpr)arg).getLiteral();
                        SQLCharExpr charExpr = new SQLCharExpr(chars);
                        charExpr.setParent(x);
                        arguments.set(i, charExpr);
                        ++this.optimizedCount;
                        continue;
                    }
                    if (argDataType == null && arg instanceof SQLMethodInvokeExpr) {
                        SQLMethodInvokeExpr argFunction = (SQLMethodInvokeExpr)arg;
                        FunctionDef paramFunctionDef = this.findFunction(argFunction.methodNameHashCode64());
                        if (paramFunctionDef != null) {
                            argDataType = paramFunctionDef.getReturnType();
                        } else if (argFunction.methodNameHashCode64() == FnvHash.Constants.ROUND) {
                            argDataType = SQLNumberExpr.DATA_TYPE_NUMBER;
                        }
                    }
                    if (argDataType != null && ((argTypeHash2 = argDataType.nameHashCode64()) == FnvHash.Constants.TINYINT || argTypeHash2 == FnvHash.Constants.SMALLINT || argTypeHash2 == FnvHash.Constants.INT || argTypeHash2 == FnvHash.Constants.INTEGER || argTypeHash2 == FnvHash.Constants.BIGINT || argTypeHash2 == FnvHash.Constants.FLOAT || argTypeHash2 == FnvHash.Constants.DOUBLE || argTypeHash2 == FnvHash.Constants.NUMBER || argTypeHash2 == FnvHash.Constants.DECIMAL || argTypeHash2 == FnvHash.Constants.DATE || argTypeHash2 == FnvHash.Constants.DATETIME || argTypeHash2 == FnvHash.Constants.TIMESTAMP || argTypeHash2 == FnvHash.Constants.TIME)) {
                        replaceTo = new SQLCastExpr(arg, new SQLCharacterDataType("VARCHAR"));
                    }
                } else if (FnvHash.Constants.TIMESTAMP == type.nameHashCode64()) {
                    long argTypeHash3;
                    if (arg instanceof SQLCharExpr) {
                        Date date;
                        String text = ((SQLCharExpr)arg).getText();
                        if (text.length() == 10) {
                            Date date2 = MySqlUtils.parseDate(text, this.timeZone);
                            if (date2 != null) {
                                replaceTo = new SQLDateExpr(text);
                            }
                        } else if (text.length() > 10 && (date = MySqlUtils.parseDate(text, this.timeZone)) != null) {
                            replaceTo = new SQLTimestampExpr(text);
                        }
                    } else if (argDataType != null && ((argTypeHash3 = argDataType.nameHashCode64()) == FnvHash.Constants.VARCHAR || argTypeHash3 == FnvHash.Constants.CHAR)) {
                        castExpr = new SQLCastExpr(arg, new SQLCharacterDataType("TIMESTAMP"));
                        castExpr.setParent(x);
                        arguments.set(i, castExpr);
                        ++this.optimizedCount;
                    }
                } else if (FnvHash.Constants.DATE == type.nameHashCode64()) {
                    long argTypeHash4;
                    if (arg instanceof SQLCharExpr && ((SQLCharExpr)arg).getText().length() > 10) {
                        replaceTo = new SQLTimestampExpr(((SQLCharExpr)arg).getText());
                    } else if (argDataType != null && ((argTypeHash4 = argDataType.nameHashCode64()) == FnvHash.Constants.VARCHAR || argTypeHash4 == FnvHash.Constants.CHAR)) {
                        castExpr = new SQLCastExpr(arg, new SQLCharacterDataType("DATE"));
                        castExpr.setParent(x);
                        arguments.set(i, castExpr);
                        ++this.optimizedCount;
                    }
                } else if (FnvHash.Constants.BIGINT == type.nameHashCode64()) {
                    if (arg instanceof SQLCharExpr) {
                        String text = ((SQLCharExpr)arg).getText();
                        try {
                            long intVal = Long.parseLong(text);
                            replaceTo = new SQLIntegerExpr(intVal);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (FnvHash.Constants.VARBINARY == type.nameHashCode64() && argDataType != null && ((argTypeHash = argDataType.nameHashCode64()) == FnvHash.Constants.VARCHAR || argTypeHash == FnvHash.Constants.CHAR)) {
                    castExpr = new SQLCastExpr(arg, new SQLCharacterDataType("VARBINARY"));
                    castExpr.setParent(x);
                    arguments.set(i, castExpr);
                    ++this.optimizedCount;
                }
                if (replaceTo == null) continue;
                replaceTo.setParent(x);
                arguments.set(i, (SQLExpr)replaceTo);
                ++this.optimizedCount;
            }
            return true;
        }
        return true;
    }

    public FunctionDef findFunction(long nameHash) {
        return this.functionRepository.find(nameHash);
    }

    public void func_if(SQLMethodInvokeExpr x) {
        List<SQLExpr> arguments = x.getArguments();
        if (arguments.size() != 3) {
            return;
        }
        SQLExpr arg0 = arguments.get(0);
        SQLExpr arg1 = arguments.get(1);
        SQLExpr arg2 = arguments.get(2);
        SQLDataType trueExprType = arg1.computeDataType();
        if (trueExprType == null) {
            return;
        }
        SQLDataType falseExprType = arg2.computeDataType();
        if (falseExprType == null) {
            return;
        }
        if (trueExprType.isInt() && falseExprType.isString()) {
            SQLCastExpr cast = new SQLCastExpr(arg2.clone(), trueExprType.clone());
            cast.setTry(true);
            x.setArgument(2, cast);
        }
    }

    @Override
    public boolean visit(SQLCaseExpr x) {
        SQLCastExpr castExpr;
        SQLExpr firstValueExpr;
        List<SQLCaseExpr.Item> items = x.getItems();
        if (items.size() == 0) {
            return true;
        }
        if (x.getValueExpr() == null) {
            for (SQLCaseExpr.Item item : items) {
                SQLDataType conditionDataType;
                SQLExpr conditionExpr = item.getConditionExpr();
                if (conditionExpr instanceof SQLIntegerExpr) {
                    Number num = ((SQLIntegerExpr)conditionExpr).getNumber();
                    if (num instanceof Integer && num.intValue() == 1) {
                        item.setConditionExpr(new SQLBooleanExpr(true));
                        continue;
                    }
                    if (num instanceof Integer && num.intValue() == 0) {
                        item.setConditionExpr(new SQLBooleanExpr(false));
                        continue;
                    }
                }
                if ((conditionDataType = conditionExpr.computeDataType()) == null || !conditionDataType.isInt()) continue;
                SQLCastExpr cast = new SQLCastExpr(conditionExpr.clone(), conditionDataType.clone());
                item.setConditionExpr(cast);
            }
        }
        if ((firstValueExpr = items.get(0).getValueExpr()) == null) {
            return true;
        }
        SQLDataType firstValueDataType = firstValueExpr.computeDataType();
        if (firstValueDataType == null) {
            return true;
        }
        for (int i = 1; i < items.size(); ++i) {
            SQLCastExpr castExpr2;
            SQLDataType valueDataType;
            SQLCaseExpr.Item item = items.get(i);
            SQLExpr valueExpr = item.getValueExpr();
            if (valueExpr == null || (valueDataType = valueExpr.computeDataType()) == null) continue;
            if (firstValueDataType.isString()) {
                if (valueDataType.isString() || valueDataType.nameHashCode64() != FnvHash.Constants.TIMESTAMP) continue;
                castExpr2 = new SQLCastExpr(valueExpr.clone(), firstValueDataType.clone());
                items.get(i).setValueExpr(castExpr2);
                ++this.optimizedCount;
                continue;
            }
            if (firstValueDataType.nameHashCode64() != FnvHash.Constants.TIMESTAMP) continue;
            if (valueExpr instanceof SQLCharExpr) {
                item.setValueExpr(new SQLTimestampExpr(((SQLCharExpr)valueExpr).getText()));
                ++this.optimizedCount;
                continue;
            }
            if (!valueDataType.isString()) continue;
            castExpr2 = new SQLCastExpr(valueExpr.clone(), firstValueDataType.clone());
            x.setElseExpr(castExpr2);
            ++this.optimizedCount;
        }
        SQLExpr elseExpr = x.getElseExpr();
        if (elseExpr == null) {
            return true;
        }
        SQLDataType elseDataType = elseExpr.computeDataType();
        if (elseDataType == null) {
            return true;
        }
        if (firstValueDataType.isString()) {
            if (elseDataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP) {
                castExpr = new SQLCastExpr(elseExpr.clone(), firstValueDataType.clone());
                x.setElseExpr(castExpr);
                ++this.optimizedCount;
            }
        } else if (firstValueDataType.nameHashCode64() == FnvHash.Constants.TIMESTAMP) {
            if (elseExpr instanceof SQLCharExpr) {
                x.setElseExpr(new SQLTimestampExpr(((SQLCharExpr)elseExpr).getText()));
                ++this.optimizedCount;
            } else if (elseDataType.isString()) {
                castExpr = new SQLCastExpr(elseExpr.clone(), firstValueDataType.clone());
                x.setElseExpr(castExpr);
                ++this.optimizedCount;
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        block10: {
            SQLDataType dataType;
            SQLExpr expr;
            List<SQLExpr> list;
            block9: {
                list = x.getTargetList();
                if (list.size() == 0) {
                    return true;
                }
                SQLDataType firstDataType = list.get(0).computeDataType();
                if (firstDataType == null) {
                    return true;
                }
                for (int i = 1; i < list.size(); ++i) {
                    SQLDataType itemDataType = list.get(i).computeDataType();
                    if (itemDataType != null && itemDataType.equals(firstDataType)) continue;
                    return true;
                }
                expr = x.getExpr();
                if (expr instanceof SQLCastExpr) {
                    SQLCastExpr cast = (SQLCastExpr)expr;
                    SQLDataType castExprDataType = cast.getExpr().computeDataType();
                    if (cast.getDataType().isString() && firstDataType.isInt() && castExprDataType.isInt()) {
                        x.setExpr(cast.getExpr().clone());
                        ++this.optimizedCount;
                    }
                }
                if ((dataType = expr.computeDataType()) == null || !dataType.isInt()) break block9;
                for (int i = list.size() - 1; i >= 0; --i) {
                    SQLExpr item = list.get(i);
                    if (!(item instanceof SQLCharExpr)) continue;
                    String str = ((SQLCharExpr)item).getText();
                    try {
                        long l = Long.parseLong(str);
                        SQLIntegerExpr intExpr = SQLIntegerExpr.ofIntOrLong(l);
                        intExpr.setParent(x);
                        list.set(i, intExpr);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break block10;
            }
            if (dataType == null || dataType.nameHashCode64() != FnvHash.Constants.DATE && dataType.nameHashCode64() != FnvHash.Constants.TIMESTAMP && dataType.nameHashCode64() != FnvHash.Constants.TIME) break block10;
            for (int i = list.size() - 1; i >= 0; --i) {
                SQLExpr item = list.get(i);
                if (!(item instanceof SQLCharExpr)) continue;
                this.handleNameLiteral(x, expr, (SQLCharExpr)item);
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        x.getBeginExpr().accept(this);
        x.getEndExpr().accept(this);
        SQLDataType beginType = x.getBeginExpr().computeDataType();
        SQLDataType endType = x.getEndExpr().computeDataType();
        SQLDataType testType = x.getTestExpr().computeDataType();
        if (beginType == null || endType == null) {
            return false;
        }
        if (beginType.isString() && endType.isInt()) {
            SQLCastExpr cast = new SQLCastExpr(x.getBeginExpr().clone(), endType.clone());
            x.setBeginExpr(cast);
            ++this.optimizedCount;
        } else if (endType.isString() && beginType.isInt()) {
            SQLCastExpr cast = new SQLCastExpr(x.getEndExpr().clone(), beginType.clone());
            x.setEndExpr(cast);
            ++this.optimizedCount;
        } else if (testType != null && testType.nameHashCode64() == FnvHash.Constants.TIMESTAMP) {
            if (x.getBeginExpr() instanceof SQLLiteralExpr && ConstFolding.repalceToTimestamp((SQLLiteralExpr)x.getBeginExpr(), this.timeZone)) {
                ++this.optimizedCount;
            }
            if (x.getEndExpr() instanceof SQLLiteralExpr && ConstFolding.repalceToTimestamp((SQLLiteralExpr)x.getEndExpr(), this.timeZone)) {
                ++this.optimizedCount;
            }
        } else if (beginType.nameHashCode64() == FnvHash.Constants.DATE && endType.nameHashCode64() == FnvHash.Constants.DATE && x.getTestExpr() instanceof SQLCharExpr) {
            SQLDateExpr sqlDateExpr = new SQLDateExpr(((SQLCharExpr)x.getTestExpr()).getText());
            x.setTestExpr(sqlDateExpr);
            ++this.optimizedCount;
        }
        return false;
    }

    @Override
    public boolean visit(SQLNotExpr x) {
        Number number;
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLIntegerExpr && (number = ((SQLIntegerExpr)expr).getNumber()) instanceof Integer) {
            if (number.intValue() == 1) {
                x.setExpr(new SQLBooleanExpr(true));
            } else if (number.intValue() == 0) {
                x.setExpr(new SQLBooleanExpr(false));
            }
        }
        return true;
    }
}

