/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.sql.repository.SchemaObject;
import com.alibaba.fastsql.sql.repository.SchemaRepository;
import com.alibaba.fastsql.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ViewRewrite
extends OptimizerVisitor {
    private List<SchemaObject> views = new ArrayList<SchemaObject>();
    private SchemaRepository repository;
    private boolean backQuotedNames = false;

    public ViewRewrite(SchemaRepository repository) {
        this.repository = repository;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        SQLExpr expr;
        String alias2;
        String alias = x.getAlias();
        String string = alias2 = this.backQuotedNames ? StringUtils.backquoteAlias(alias) : StringUtils.quoteAlias(alias);
        if (alias2 != alias) {
            x.setAlias(alias2);
        }
        if ((expr = x.getExpr()) instanceof SQLName && this.repository != null) {
            SchemaObject view;
            String name = SQLUtils.normalize(((SQLName)expr).getSimpleName());
            SQLTableSource resolvedTableSource = null;
            if (expr instanceof SQLIdentifierExpr) {
                resolvedTableSource = ((SQLIdentifierExpr)expr).getResolvedTableSource();
            }
            if (resolvedTableSource == null && x.getSchemaObject() == null && (view = this.repository.findView(name)) != null && !this.views.contains(view)) {
                this.views.add(view);
                SQLSelect subQuery = ((SQLCreateViewStatement)view.getStatement()).getSubQuery();
                subQuery.getQueryBlock().getFrom().accept(this);
            }
        }
        return super.visit(x);
    }

    @Override
    public void endVisit(SQLSelect x) {
        SQLWithSubqueryClause withSubQuery = x.getWithSubQuery();
        if (withSubQuery == null && this.views != null && this.views.size() > 0) {
            withSubQuery = new SQLWithSubqueryClause();
            x.setWithSubQuery(withSubQuery);
        }
        for (int i = this.views.size() - 1; i >= 0; --i) {
            SchemaObject view = this.views.get(i);
            SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
            SQLSelect subQuery = ((SQLCreateViewStatement)view.getStatement()).getSubQuery();
            entry.setSubQuery(subQuery.clone());
            entry.setAlias(view.getName());
            withSubQuery.addEntry(entry);
        }
    }

    public boolean isBackQuotedNames() {
        return this.backQuotedNames;
    }

    public void setBackQuotedNames(boolean backQuotedNames) {
        this.backQuotedNames = backQuotedNames;
    }
}

