/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.visitor;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastsql.util.FnvHash;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class SQLTableAliasCollectVisitor
extends SQLASTVisitorAdapter {
    protected Map<Long, SQLTableSource> tableSourceMap = new LinkedHashMap<Long, SQLTableSource>();
    protected volatile int seed;

    @Override
    public boolean visit(SQLLateralViewTableSource x) {
        String alias = x.getAlias();
        if (alias == null) {
            return false;
        }
        long hashCode64 = FnvHash.hashCode64(alias);
        this.tableSourceMap.put(hashCode64, x);
        return true;
    }

    @Override
    public boolean visit(SQLValuesTableSource x) {
        String alias = x.getAlias();
        if (alias == null) {
            return false;
        }
        long hashCode64 = FnvHash.hashCode64(alias);
        this.tableSourceMap.put(hashCode64, x);
        return true;
    }

    @Override
    public boolean visit(SQLUnionQueryTableSource x) {
        String alias = x.getAlias();
        if (alias == null) {
            x.getUnion().accept(this);
            return false;
        }
        long hashCode64 = FnvHash.hashCode64(alias);
        this.tableSourceMap.put(hashCode64, x);
        return true;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        String alias = x.getAlias();
        if (alias == null) {
            x.getSelect().accept(this);
            return false;
        }
        long hashCode64 = FnvHash.hashCode64(alias);
        this.tableSourceMap.put(hashCode64, x);
        return true;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        String alias = x.getAlias();
        if (alias == null) {
            return true;
        }
        long hashCode64 = FnvHash.hashCode64(alias);
        this.tableSourceMap.put(hashCode64, x);
        return true;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        String alias = x.getAlias();
        if (alias == null) {
            return true;
        }
        long hashCode64 = FnvHash.hashCode64(alias);
        this.tableSourceMap.put(hashCode64, x);
        return true;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        String alias = x.getAlias();
        if (alias == null) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLName) {
                long hashCode64 = ((SQLName)expr).nameHashCode64();
                this.tableSourceMap.put(hashCode64, x);
                return false;
            }
            return true;
        }
        return true;
    }

    public Collection<SQLTableSource> getTableSources() {
        return this.tableSourceMap.values();
    }

    public SQLTableSource getTableSource(long hashCode64) {
        return this.tableSourceMap.get(hashCode64);
    }

    public boolean containsTableSource(String alias) {
        if (alias == null) {
            return false;
        }
        long hashCode64 = FnvHash.hashCode64(alias);
        return this.tableSourceMap.containsKey(hashCode64);
    }

    public String genAlias(int seed) {
        String alias = null;
        while (seed < 100) {
            String str = "G" + seed++;
            if (this.containsTableSource(str)) continue;
            alias = str;
            this.seed = seed;
            break;
        }
        return alias;
    }

    public int getSeed() {
        return this.seed;
    }
}

