/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.wall;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.util.Utils;
import com.alibaba.fastsql.wall.WallConfigMBean;
import com.alibaba.fastsql.wall.WallUpdateCheckHandler;
import com.alibaba.fastsql.wall.spi.WallVisitorUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class WallConfig
implements WallConfigMBean {
    private boolean noneBaseStatementAllow = false;
    private boolean callAllow = true;
    private boolean selelctAllow = true;
    private boolean selectIntoAllow = true;
    private boolean selectIntoOutfileAllow = false;
    private boolean selectWhereAlwayTrueCheck = true;
    private boolean selectHavingAlwayTrueCheck = true;
    private boolean selectUnionCheck = true;
    private boolean selectMinusCheck = true;
    private boolean selectExceptCheck = true;
    private boolean selectIntersectCheck = true;
    private boolean createTableAllow = true;
    private boolean dropTableAllow = true;
    private boolean alterTableAllow = true;
    private boolean renameTableAllow = true;
    private boolean hintAllow = true;
    private boolean lockTableAllow = true;
    private boolean startTransactionAllow = true;
    private boolean blockAllow = true;
    private boolean conditionAndAlwayTrueAllow = false;
    private boolean conditionAndAlwayFalseAllow = false;
    private boolean conditionDoubleConstAllow = false;
    private boolean conditionLikeTrueAllow = true;
    private boolean selectAllColumnAllow = true;
    private boolean deleteAllow = true;
    private boolean deleteWhereAlwayTrueCheck = true;
    private boolean deleteWhereNoneCheck = false;
    private boolean updateAllow = true;
    private boolean updateWhereAlayTrueCheck = true;
    private boolean updateWhereNoneCheck = false;
    private boolean insertAllow = true;
    private boolean mergeAllow = true;
    private boolean minusAllow = true;
    private boolean intersectAllow = true;
    private boolean replaceAllow = true;
    private boolean setAllow = true;
    private boolean commitAllow = true;
    private boolean rollbackAllow = true;
    private boolean useAllow = true;
    private boolean multiStatementAllow = false;
    private boolean truncateAllow = true;
    private boolean commentAllow = false;
    private boolean strictSyntaxCheck = true;
    private boolean constArithmeticAllow = true;
    private boolean limitZeroAllow = false;
    private boolean describeAllow = true;
    private boolean showAllow = true;
    private boolean schemaCheck = true;
    private boolean tableCheck = true;
    private boolean functionCheck = true;
    private boolean objectCheck = true;
    private boolean variantCheck = true;
    private boolean mustParameterized = false;
    private boolean doPrivilegedAllow = false;
    protected final Set<String> denyFunctions = new ConcurrentSkipListSet<String>();
    protected final Set<String> denyTables = new ConcurrentSkipListSet<String>();
    protected final Set<String> denySchemas = new ConcurrentSkipListSet<String>();
    protected final Set<String> denyVariants = new ConcurrentSkipListSet<String>();
    protected final Set<String> denyObjects = new ConcurrentSkipListSet<String>();
    protected final Set<String> permitFunctions = new ConcurrentSkipListSet<String>();
    protected final Set<String> permitTables = new ConcurrentSkipListSet<String>();
    protected final Set<String> permitSchemas = new ConcurrentSkipListSet<String>();
    protected final Set<String> permitVariants = new ConcurrentSkipListSet<String>();
    protected final Set<String> readOnlyTables = new ConcurrentSkipListSet<String>();
    private String dir;
    private boolean inited;
    private String tenantTablePattern;
    private String tenantColumn;
    private TenantCallBack tenantCallBack;
    private boolean wrapAllow = true;
    private boolean metadataAllow = true;
    private boolean conditionOpXorAllow = false;
    private boolean conditionOpBitwseAllow = true;
    private boolean caseConditionConstAllow = false;
    private boolean completeInsertValuesCheck = false;
    private int insertValuesCheckSize = 3;
    private int selectLimit = -1;
    protected Map<String, Set<String>> updateCheckColumns = new HashMap<String, Set<String>>();
    protected WallUpdateCheckHandler updateCheckHandler;

    public WallConfig() {
        this.configFromProperties(System.getProperties());
    }

    public boolean isCaseConditionConstAllow() {
        return this.caseConditionConstAllow;
    }

    public void setCaseConditionConstAllow(boolean caseConditionConstAllow) {
        this.caseConditionConstAllow = caseConditionConstAllow;
    }

    public boolean isConditionDoubleConstAllow() {
        return this.conditionDoubleConstAllow;
    }

    public void setConditionDoubleConstAllow(boolean conditionDoubleConstAllow) {
        this.conditionDoubleConstAllow = conditionDoubleConstAllow;
    }

    public boolean isConditionLikeTrueAllow() {
        return this.conditionLikeTrueAllow;
    }

    public void setConditionLikeTrueAllow(boolean conditionLikeTrueAllow) {
        this.conditionLikeTrueAllow = conditionLikeTrueAllow;
    }

    public boolean isLimitZeroAllow() {
        return this.limitZeroAllow;
    }

    public void setLimitZeroAllow(boolean limitZero) {
        this.limitZeroAllow = limitZero;
    }

    public boolean isUseAllow() {
        return this.useAllow;
    }

    public void setUseAllow(boolean useAllow) {
        this.useAllow = useAllow;
    }

    public boolean isCommitAllow() {
        return this.commitAllow;
    }

    public void setCommitAllow(boolean commitAllow) {
        this.commitAllow = commitAllow;
    }

    public boolean isRollbackAllow() {
        return this.rollbackAllow;
    }

    public void setRollbackAllow(boolean rollbackAllow) {
        this.rollbackAllow = rollbackAllow;
    }

    public boolean isIntersectAllow() {
        return this.intersectAllow;
    }

    public void setIntersectAllow(boolean intersectAllow) {
        this.intersectAllow = intersectAllow;
    }

    public boolean isMinusAllow() {
        return this.minusAllow;
    }

    public void setMinusAllow(boolean minusAllow) {
        this.minusAllow = minusAllow;
    }

    public boolean isConditionOpXorAllow() {
        return this.conditionOpXorAllow;
    }

    public void setConditionOpXorAllow(boolean conditionOpXorAllow) {
        this.conditionOpXorAllow = conditionOpXorAllow;
    }

    public String getTenantTablePattern() {
        return this.tenantTablePattern;
    }

    public void setTenantTablePattern(String tenantTablePattern) {
        this.tenantTablePattern = tenantTablePattern;
    }

    public String getTenantColumn() {
        return this.tenantColumn;
    }

    public void setTenantColumn(String tenantColumn) {
        this.tenantColumn = tenantColumn;
    }

    public TenantCallBack getTenantCallBack() {
        return this.tenantCallBack;
    }

    public void setTenantCallBack(TenantCallBack tenantCallBack) {
        this.tenantCallBack = tenantCallBack;
    }

    public boolean isMetadataAllow() {
        return this.metadataAllow;
    }

    public void setMetadataAllow(boolean metadataAllow) {
        this.metadataAllow = metadataAllow;
    }

    public boolean isWrapAllow() {
        return this.wrapAllow;
    }

    public void setWrapAllow(boolean wrapAllow) {
        this.wrapAllow = wrapAllow;
    }

    public boolean isDoPrivilegedAllow() {
        return this.doPrivilegedAllow;
    }

    public void setDoPrivilegedAllow(boolean doPrivilegedAllow) {
        this.doPrivilegedAllow = doPrivilegedAllow;
    }

    public boolean isSelectAllColumnAllow() {
        return this.selectAllColumnAllow;
    }

    public void setSelectAllColumnAllow(boolean selectAllColumnAllow) {
        this.selectAllColumnAllow = selectAllColumnAllow;
    }

    @Override
    public boolean isInited() {
        return this.inited;
    }

    public WallConfig(String dir) {
        this();
        this.dir = dir;
        this.init();
    }

    @Override
    public String getDir() {
        return this.dir;
    }

    @Override
    public void setDir(String dir) {
        this.dir = dir;
    }

    @Override
    public final void init() {
        this.loadConfig(this.dir);
    }

    @Override
    public void loadConfig(String dir) {
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        WallVisitorUtils.loadResource(this.denyVariants, dir + "/deny-variant.txt");
        WallVisitorUtils.loadResource(this.denySchemas, dir + "/deny-schema.txt");
        WallVisitorUtils.loadResource(this.denyFunctions, dir + "/deny-function.txt");
        WallVisitorUtils.loadResource(this.denyTables, dir + "/deny-table.txt");
        WallVisitorUtils.loadResource(this.denyObjects, dir + "/deny-object.txt");
        WallVisitorUtils.loadResource(this.readOnlyTables, dir + "/readonly-table.txt");
        WallVisitorUtils.loadResource(this.permitFunctions, dir + "/permit-function.txt");
        WallVisitorUtils.loadResource(this.permitTables, dir + "/permit-table.txt");
        WallVisitorUtils.loadResource(this.permitSchemas, dir + "/permit-schema.txt");
        WallVisitorUtils.loadResource(this.permitVariants, dir + "/permit-variant.txt");
    }

    @Override
    public boolean isNoneBaseStatementAllow() {
        return this.noneBaseStatementAllow;
    }

    @Override
    public void setNoneBaseStatementAllow(boolean noneBaseStatementAllow) {
        this.noneBaseStatementAllow = noneBaseStatementAllow;
    }

    public boolean isDescribeAllow() {
        return this.describeAllow;
    }

    public void setDescribeAllow(boolean describeAllow) {
        this.describeAllow = describeAllow;
    }

    public boolean isShowAllow() {
        return this.showAllow;
    }

    public void setShowAllow(boolean showAllow) {
        this.showAllow = showAllow;
    }

    @Override
    public boolean isTruncateAllow() {
        return this.truncateAllow;
    }

    @Override
    public void setTruncateAllow(boolean truncateAllow) {
        this.truncateAllow = truncateAllow;
    }

    @Override
    public boolean isSelectIntoAllow() {
        return this.selectIntoAllow;
    }

    @Override
    public void setSelectIntoAllow(boolean selectIntoAllow) {
        this.selectIntoAllow = selectIntoAllow;
    }

    @Override
    public boolean isSelectIntoOutfileAllow() {
        return this.selectIntoOutfileAllow;
    }

    @Override
    public void setSelectIntoOutfileAllow(boolean selectIntoOutfileAllow) {
        this.selectIntoOutfileAllow = selectIntoOutfileAllow;
    }

    public boolean isCreateTableAllow() {
        return this.createTableAllow;
    }

    public void setCreateTableAllow(boolean createTableAllow) {
        this.createTableAllow = createTableAllow;
    }

    public boolean isDropTableAllow() {
        return this.dropTableAllow;
    }

    public void setDropTableAllow(boolean dropTableAllow) {
        this.dropTableAllow = dropTableAllow;
    }

    public boolean isAlterTableAllow() {
        return this.alterTableAllow;
    }

    public void setAlterTableAllow(boolean alterTableAllow) {
        this.alterTableAllow = alterTableAllow;
    }

    public boolean isRenameTableAllow() {
        return this.renameTableAllow;
    }

    public void setRenameTableAllow(boolean renameTableAllow) {
        this.renameTableAllow = renameTableAllow;
    }

    @Override
    public boolean isSelectUnionCheck() {
        return this.selectUnionCheck;
    }

    @Override
    public void setSelectUnionCheck(boolean selectUnionCheck) {
        this.selectUnionCheck = selectUnionCheck;
    }

    public boolean isSelectMinusCheck() {
        return this.selectMinusCheck;
    }

    public void setSelectMinusCheck(boolean selectMinusCheck) {
        this.selectMinusCheck = selectMinusCheck;
    }

    public boolean isSelectExceptCheck() {
        return this.selectExceptCheck;
    }

    public void setSelectExceptCheck(boolean selectExceptCheck) {
        this.selectExceptCheck = selectExceptCheck;
    }

    public boolean isSelectIntersectCheck() {
        return this.selectIntersectCheck;
    }

    public void setSelectIntersectCheck(boolean selectIntersectCheck) {
        this.selectIntersectCheck = selectIntersectCheck;
    }

    @Override
    public boolean isDeleteAllow() {
        return this.deleteAllow;
    }

    @Override
    public void setDeleteAllow(boolean deleteAllow) {
        this.deleteAllow = deleteAllow;
    }

    public boolean isDeleteWhereNoneCheck() {
        return this.deleteWhereNoneCheck;
    }

    public void setDeleteWhereNoneCheck(boolean deleteWhereNoneCheck) {
        this.deleteWhereNoneCheck = deleteWhereNoneCheck;
    }

    @Override
    public boolean isUpdateAllow() {
        return this.updateAllow;
    }

    @Override
    public void setUpdateAllow(boolean updateAllow) {
        this.updateAllow = updateAllow;
    }

    public boolean isUpdateWhereNoneCheck() {
        return this.updateWhereNoneCheck;
    }

    public void setUpdateWhereNoneCheck(boolean updateWhereNoneCheck) {
        this.updateWhereNoneCheck = updateWhereNoneCheck;
    }

    @Override
    public boolean isInsertAllow() {
        return this.insertAllow;
    }

    @Override
    public void setInsertAllow(boolean insertAllow) {
        this.insertAllow = insertAllow;
    }

    public boolean isReplaceAllow() {
        return this.replaceAllow;
    }

    public void setReplaceAllow(boolean replaceAllow) {
        this.replaceAllow = replaceAllow;
    }

    public boolean isSetAllow() {
        return this.setAllow;
    }

    public void setSetAllow(boolean value) {
        this.setAllow = value;
    }

    @Override
    public boolean isMergeAllow() {
        return this.mergeAllow;
    }

    @Override
    public void setMergeAllow(boolean mergeAllow) {
        this.mergeAllow = mergeAllow;
    }

    @Override
    public boolean isMultiStatementAllow() {
        return this.multiStatementAllow;
    }

    @Override
    public void setMultiStatementAllow(boolean multiStatementAllow) {
        this.multiStatementAllow = multiStatementAllow;
    }

    @Override
    public boolean isSchemaCheck() {
        return this.schemaCheck;
    }

    @Override
    public void setSchemaCheck(boolean schemaCheck) {
        this.schemaCheck = schemaCheck;
    }

    @Override
    public boolean isTableCheck() {
        return this.tableCheck;
    }

    @Override
    public void setTableCheck(boolean tableCheck) {
        this.tableCheck = tableCheck;
    }

    @Override
    public boolean isFunctionCheck() {
        return this.functionCheck;
    }

    @Override
    public void setFunctionCheck(boolean functionCheck) {
        this.functionCheck = functionCheck;
    }

    @Override
    public boolean isVariantCheck() {
        return this.variantCheck;
    }

    @Override
    public void setVariantCheck(boolean variantCheck) {
        this.variantCheck = variantCheck;
    }

    @Override
    public boolean isObjectCheck() {
        return this.objectCheck;
    }

    @Override
    public void setObjectCheck(boolean objectCheck) {
        this.objectCheck = objectCheck;
    }

    @Override
    public boolean isCommentAllow() {
        return this.commentAllow;
    }

    @Override
    public void setCommentAllow(boolean commentAllow) {
        this.commentAllow = commentAllow;
    }

    public boolean isStrictSyntaxCheck() {
        return this.strictSyntaxCheck;
    }

    public void setStrictSyntaxCheck(boolean strictSyntaxCheck) {
        this.strictSyntaxCheck = strictSyntaxCheck;
    }

    public boolean isConstArithmeticAllow() {
        return this.constArithmeticAllow;
    }

    public void setConstArithmeticAllow(boolean constArithmeticAllow) {
        this.constArithmeticAllow = constArithmeticAllow;
    }

    @Override
    public Set<String> getDenyFunctions() {
        return this.denyFunctions;
    }

    @Override
    public Set<String> getDenyTables() {
        return this.denyTables;
    }

    @Override
    public Set<String> getDenySchemas() {
        return this.denySchemas;
    }

    @Override
    public Set<String> getDenyVariants() {
        return this.denyVariants;
    }

    @Override
    public Set<String> getDenyObjects() {
        return this.denyObjects;
    }

    @Override
    public Set<String> getReadOnlyTables() {
        return this.readOnlyTables;
    }

    public void addReadOnlyTable(String tableName) {
        this.readOnlyTables.add(tableName);
    }

    public boolean isReadOnly(String tableName) {
        return this.readOnlyTables.contains(tableName);
    }

    public Set<String> getPermitFunctions() {
        return this.permitFunctions;
    }

    public Set<String> getPermitTables() {
        return this.permitTables;
    }

    public Set<String> getPermitSchemas() {
        return this.permitSchemas;
    }

    public Set<String> getPermitVariants() {
        return this.permitVariants;
    }

    public boolean isMustParameterized() {
        return this.mustParameterized;
    }

    public void setMustParameterized(boolean mustParameterized) {
        this.mustParameterized = mustParameterized;
    }

    @Override
    public boolean isDenyObjects(String name) {
        if (!this.objectCheck) {
            return false;
        }
        name = WallVisitorUtils.form(name);
        return this.denyObjects.contains(name);
    }

    @Override
    public boolean isDenySchema(String name) {
        if (!this.schemaCheck) {
            return false;
        }
        name = WallVisitorUtils.form(name);
        return this.denySchemas.contains(name);
    }

    @Override
    public boolean isDenyFunction(String name) {
        if (!this.functionCheck) {
            return false;
        }
        name = WallVisitorUtils.form(name);
        return this.denyFunctions.contains(name);
    }

    public boolean isCallAllow() {
        return this.callAllow;
    }

    public void setCallAllow(boolean callAllow) {
        this.callAllow = callAllow;
    }

    public boolean isHintAllow() {
        return this.hintAllow;
    }

    public void setHintAllow(boolean hintAllow) {
        this.hintAllow = hintAllow;
    }

    @Override
    public boolean isSelelctAllow() {
        return this.selelctAllow;
    }

    @Override
    public void setSelelctAllow(boolean selelctAllow) {
        this.selelctAllow = selelctAllow;
    }

    @Override
    public boolean isSelectWhereAlwayTrueCheck() {
        return this.selectWhereAlwayTrueCheck;
    }

    @Override
    public void setSelectWhereAlwayTrueCheck(boolean selectWhereAlwayTrueCheck) {
        this.selectWhereAlwayTrueCheck = selectWhereAlwayTrueCheck;
    }

    @Override
    public boolean isSelectHavingAlwayTrueCheck() {
        return this.selectHavingAlwayTrueCheck;
    }

    @Override
    public void setSelectHavingAlwayTrueCheck(boolean selectHavingAlwayTrueCheck) {
        this.selectHavingAlwayTrueCheck = selectHavingAlwayTrueCheck;
    }

    public boolean isConditionAndAlwayTrueAllow() {
        return this.conditionAndAlwayTrueAllow;
    }

    public void setConditionAndAlwayTrueAllow(boolean conditionAndAlwayTrueAllow) {
        this.conditionAndAlwayTrueAllow = conditionAndAlwayTrueAllow;
    }

    public boolean isConditionAndAlwayFalseAllow() {
        return this.conditionAndAlwayFalseAllow;
    }

    public void setConditionAndAlwayFalseAllow(boolean conditionAndAlwayFalseAllow) {
        this.conditionAndAlwayFalseAllow = conditionAndAlwayFalseAllow;
    }

    @Override
    public boolean isDeleteWhereAlwayTrueCheck() {
        return this.deleteWhereAlwayTrueCheck;
    }

    @Override
    public void setDeleteWhereAlwayTrueCheck(boolean deleteWhereAlwayTrueCheck) {
        this.deleteWhereAlwayTrueCheck = deleteWhereAlwayTrueCheck;
    }

    @Override
    public boolean isUpdateWhereAlayTrueCheck() {
        return this.updateWhereAlayTrueCheck;
    }

    @Override
    public void setUpdateWhereAlayTrueCheck(boolean updateWhereAlayTrueCheck) {
        this.updateWhereAlayTrueCheck = updateWhereAlayTrueCheck;
    }

    public boolean isConditionOpBitwseAllow() {
        return this.conditionOpBitwseAllow;
    }

    public void setConditionOpBitwseAllow(boolean conditionOpBitwseAllow) {
        this.conditionOpBitwseAllow = conditionOpBitwseAllow;
    }

    public void setInited(boolean inited) {
        this.inited = inited;
    }

    public boolean isLockTableAllow() {
        return this.lockTableAllow;
    }

    public void setLockTableAllow(boolean lockTableAllow) {
        this.lockTableAllow = lockTableAllow;
    }

    public boolean isStartTransactionAllow() {
        return this.startTransactionAllow;
    }

    public void setStartTransactionAllow(boolean startTransactionAllow) {
        this.startTransactionAllow = startTransactionAllow;
    }

    public boolean isCompleteInsertValuesCheck() {
        return this.completeInsertValuesCheck;
    }

    public void setCompleteInsertValuesCheck(boolean completeInsertValuesCheck) {
        this.completeInsertValuesCheck = completeInsertValuesCheck;
    }

    public int getInsertValuesCheckSize() {
        return this.insertValuesCheckSize;
    }

    public void setInsertValuesCheckSize(int insertValuesCheckSize) {
        this.insertValuesCheckSize = insertValuesCheckSize;
    }

    public boolean isBlockAllow() {
        return this.blockAllow;
    }

    public void setBlockAllow(boolean blockAllow) {
        this.blockAllow = blockAllow;
    }

    public int getSelectLimit() {
        return this.selectLimit;
    }

    public void setSelectLimit(int selectLimit) {
        this.selectLimit = selectLimit;
    }

    public void configFromProperties(Properties properties) {
        String[] items;
        Object propertyValue = properties.getProperty("fastsql.wall.tenantColumn");
        if (propertyValue != null) {
            this.setTenantColumn((String)propertyValue);
        }
        if ((propertyValue = Utils.getBoolean(properties, "fastsql.wall.selelctAllow")) != null) {
            this.setSelelctAllow((Boolean)propertyValue);
        }
        if ((propertyValue = Utils.getBoolean(properties, "fastsql.wall.updateAllow")) != null) {
            this.setUpdateAllow((Boolean)propertyValue);
        }
        if ((propertyValue = Utils.getBoolean(properties, "fastsql.wall.deleteAllow")) != null) {
            this.setDeleteAllow((Boolean)propertyValue);
        }
        if ((propertyValue = Utils.getBoolean(properties, "fastsql.wall.insertAllow")) != null) {
            this.setInsertAllow((Boolean)propertyValue);
        }
        if ((propertyValue = Utils.getBoolean(properties, "fastsql.wall.multiStatementAllow")) != null) {
            this.setMultiStatementAllow((Boolean)propertyValue);
        }
        if ((propertyValue = Utils.getInteger(properties, "fastsql.wall.selectLimit")) != null) {
            this.setSelectLimit((Integer)propertyValue);
        }
        if ((propertyValue = properties.getProperty("fastsql.wall.updateCheckColumns")) != null) {
            for (String item : items = ((String)propertyValue).split(",")) {
                this.addUpdateCheckCoumns(item);
            }
        }
        if ((propertyValue = Utils.getBoolean(properties, "fastsql.wall.updateWhereNoneCheck")) != null) {
            this.setUpdateWhereNoneCheck((Boolean)propertyValue);
        }
        if ((propertyValue = Utils.getBoolean(properties, "fastsql.wall.deleteWhereNoneCheck")) != null) {
            this.setDeleteWhereNoneCheck((Boolean)propertyValue);
        }
        if ((propertyValue = properties.getProperty("druid.wall.updateCheckColumns")) != null) {
            for (String item : items = ((String)propertyValue).split(",")) {
                this.addUpdateCheckCoumns(item);
            }
        }
        if ((propertyValue = Utils.getBoolean(properties, "druid.wall.updateWhereNoneCheck")) != null) {
            this.setUpdateWhereNoneCheck((Boolean)propertyValue);
        }
        if ((propertyValue = Utils.getBoolean(properties, "druid.wall.deleteWhereNoneCheck")) != null) {
            this.setDeleteWhereNoneCheck((Boolean)propertyValue);
        }
    }

    public void addUpdateCheckCoumns(String columnInfo) {
        String[] items = columnInfo.split("\\.");
        if (items.length != 2) {
            return;
        }
        String table = SQLUtils.normalize(items[0]).toLowerCase();
        String column = SQLUtils.normalize(items[1]).toLowerCase();
        Set<String> columns = this.updateCheckColumns.get(table);
        if (columns == null) {
            columns = new LinkedHashSet<String>();
            this.updateCheckColumns.put(table, columns);
        }
        columns.add(column);
    }

    public boolean isUpdateCheckTable(String tableName) {
        if (this.updateCheckColumns.isEmpty()) {
            return false;
        }
        String tableNameLower = SQLUtils.normalize(tableName).toLowerCase();
        return this.updateCheckColumns.containsKey(tableNameLower);
    }

    public Set<String> getUpdateCheckTable(String tableName) {
        if (this.updateCheckColumns.isEmpty()) {
            return null;
        }
        String tableNameLower = SQLUtils.normalize(tableName).toLowerCase();
        return this.updateCheckColumns.get(tableNameLower);
    }

    public WallUpdateCheckHandler getUpdateCheckHandler() {
        return this.updateCheckHandler;
    }

    public void setUpdateCheckHandler(WallUpdateCheckHandler updateCheckHandler) {
        this.updateCheckHandler = updateCheckHandler;
    }

    public static interface TenantCallBack {
        public Object getTenantValue(StatementType var1, String var2);

        public String getTenantColumn(StatementType var1, String var2);

        public String getHiddenColumn(String var1);

        public void filterResultsetTenantColumn(Object var1);

        public static enum StatementType {
            SELECT,
            UPDATE,
            INSERT,
            DELETE;

        }
    }
}

