/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.wall;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.wall.WallSqlFunctionStat;
import com.alibaba.fastsql.wall.WallSqlStat;
import com.alibaba.fastsql.wall.WallSqlTableStat;
import com.alibaba.fastsql.wall.WallUpdateCheckItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WallContext {
    private static final ThreadLocal<WallContext> contextLocal = new ThreadLocal();
    private WallSqlStat sqlStat;
    private Map<String, WallSqlTableStat> tableStats;
    private Map<String, WallSqlFunctionStat> functionStats;
    private final DbType dbType;
    private int commentCount;
    private int warnings = 0;
    private int unionWarnings = 0;
    private int updateNoneConditionWarnings = 0;
    private int deleteNoneConditionWarnings = 0;
    private int likeNumberWarnings = 0;
    private List<WallUpdateCheckItem> wallUpdateCheckItems;

    public WallContext(DbType dbType) {
        this.dbType = dbType;
    }

    public void incrementFunctionInvoke(String tableName) {
        String lowerCaseName;
        WallSqlFunctionStat stat;
        if (this.functionStats == null) {
            this.functionStats = new HashMap<String, WallSqlFunctionStat>();
        }
        if ((stat = this.functionStats.get(lowerCaseName = tableName.toLowerCase())) == null) {
            if (this.functionStats.size() > 100) {
                return;
            }
            stat = new WallSqlFunctionStat();
            this.functionStats.put(tableName, stat);
        }
        stat.incrementInvokeCount();
    }

    public WallSqlTableStat getTableStat(String tableName) {
        String lowerCaseName;
        WallSqlTableStat stat;
        if (this.tableStats == null) {
            this.tableStats = new HashMap<String, WallSqlTableStat>(2);
        }
        if ((stat = this.tableStats.get(lowerCaseName = tableName.toLowerCase())) == null) {
            if (this.tableStats.size() > 100) {
                return null;
            }
            stat = new WallSqlTableStat();
            this.tableStats.put(tableName, stat);
        }
        return stat;
    }

    public static WallContext createIfNotExists(DbType dbType) {
        WallContext context = contextLocal.get();
        if (context == null) {
            context = new WallContext(dbType);
            contextLocal.set(context);
        }
        return context;
    }

    public static WallContext create(DbType dbType) {
        WallContext context = new WallContext(dbType);
        contextLocal.set(context);
        return context;
    }

    public static WallContext current() {
        return contextLocal.get();
    }

    public static void clearContext() {
        contextLocal.remove();
    }

    public static void setContext(WallContext context) {
        contextLocal.set(context);
    }

    public WallSqlStat getSqlStat() {
        return this.sqlStat;
    }

    public void setSqlStat(WallSqlStat sqlStat) {
        this.sqlStat = sqlStat;
    }

    public Map<String, WallSqlTableStat> getTableStats() {
        return this.tableStats;
    }

    public Map<String, WallSqlFunctionStat> getFunctionStats() {
        return this.functionStats;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public void incrementCommentCount() {
        if (this.commentCount == 0) {
            ++this.warnings;
        }
        ++this.commentCount;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public void incrementWarnings() {
        ++this.warnings;
    }

    public int getLikeNumberWarnings() {
        return this.likeNumberWarnings;
    }

    public void incrementLikeNumberWarnings() {
        if (this.likeNumberWarnings == 0) {
            ++this.warnings;
        }
        ++this.likeNumberWarnings;
    }

    public int getUnionWarnings() {
        return this.unionWarnings;
    }

    public void incrementUnionWarnings() {
        if (this.unionWarnings == 0) {
            this.incrementWarnings();
        }
        ++this.unionWarnings;
    }

    public int getUpdateNoneConditionWarnings() {
        return this.updateNoneConditionWarnings;
    }

    public void incrementUpdateNoneConditionWarnings() {
        ++this.updateNoneConditionWarnings;
    }

    public int getDeleteNoneConditionWarnings() {
        return this.deleteNoneConditionWarnings;
    }

    public void incrementDeleteNoneConditionWarnings() {
        ++this.deleteNoneConditionWarnings;
    }

    public List<WallUpdateCheckItem> getWallUpdateCheckItems() {
        return this.wallUpdateCheckItems;
    }

    public void setWallUpdateCheckItems(List<WallUpdateCheckItem> wallUpdateCheckItems) {
        this.wallUpdateCheckItems = wallUpdateCheckItems;
    }
}

