/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql;

import com.alibaba.otter.canal.parse.driver.mysql.MysqlConnector;
import com.alibaba.otter.canal.parse.driver.mysql.MysqlQueryExecutor;
import com.alibaba.otter.canal.parse.driver.mysql.MysqlUpdateExecutor;
import com.alibaba.otter.canal.parse.driver.mysql.packets.GTIDSet;
import com.alibaba.otter.canal.parse.driver.mysql.packets.HeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.BinlogDumpCommandPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.BinlogDumpGTIDCommandPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.RegisterSlaveCommandPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.SemiAckCommandPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ErrorPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ResultSetPacket;
import com.alibaba.otter.canal.parse.driver.mysql.socket.SocketChannel;
import com.alibaba.otter.canal.parse.driver.mysql.utils.GtidUtil;
import com.alibaba.otter.canal.parse.driver.mysql.utils.PacketManager;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.ErosaConnection;
import com.alibaba.otter.canal.parse.inbound.MultiStageCoprocessor;
import com.alibaba.otter.canal.parse.inbound.SinkFunction;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlMultiStageCoprocessor;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.DirectLogFetcher;
import com.alibaba.otter.canal.parse.support.AuthenticationInfo;
import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogContext;
import com.taobao.tddl.dbsync.binlog.LogDecoder;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlConnection
implements ErosaConnection {
    private static final Logger logger = LoggerFactory.getLogger(MysqlConnection.class);
    private MysqlConnector connector;
    private long slaveId;
    private Charset charset = Charset.forName("UTF-8");
    private BinlogFormat binlogFormat;
    private BinlogImage binlogImage;
    private AuthenticationInfo authInfo;
    protected int connTimeout = 5000;
    protected int soTimeout = 3600000;
    private int binlogChecksum = 0;
    private AtomicLong receivedBinlogBytes;

    public MysqlConnection() {
    }

    public MysqlConnection(InetSocketAddress address, String username, String password) {
        this.authInfo = new AuthenticationInfo();
        this.authInfo.setAddress(address);
        this.authInfo.setUsername(username);
        this.authInfo.setPassword(password);
        this.connector = new MysqlConnector(address, username, password);
        this.connector.setSoTimeout(this.soTimeout);
        this.connector.setConnTimeout(this.connTimeout);
    }

    public MysqlConnection(InetSocketAddress address, String username, String password, byte charsetNumber, String defaultSchema) {
        this.authInfo = new AuthenticationInfo();
        this.authInfo.setAddress(address);
        this.authInfo.setUsername(username);
        this.authInfo.setPassword(password);
        this.authInfo.setDefaultDatabaseName(defaultSchema);
        this.connector = new MysqlConnector(address, username, password, charsetNumber, defaultSchema);
        this.connector.setSoTimeout(this.soTimeout);
        this.connector.setConnTimeout(this.connTimeout);
    }

    @Override
    public void connect() throws IOException {
        this.connector.connect();
    }

    @Override
    public void reconnect() throws IOException {
        this.connector.reconnect();
    }

    @Override
    public void disconnect() throws IOException {
        this.connector.disconnect();
    }

    public boolean isConnected() {
        return this.connector.isConnected();
    }

    public ResultSetPacket query(String cmd) throws IOException {
        MysqlQueryExecutor exector = new MysqlQueryExecutor(this.connector);
        return exector.query(cmd);
    }

    public List<ResultSetPacket> queryMulti(String cmd) throws IOException {
        MysqlQueryExecutor exector = new MysqlQueryExecutor(this.connector);
        return exector.queryMulti(cmd);
    }

    public void update(String cmd) throws IOException {
        MysqlUpdateExecutor exector = new MysqlUpdateExecutor(this.connector);
        exector.update(cmd);
    }

    @Override
    public void seek(String binlogfilename, Long binlogPosition, String gtid, SinkFunction func) throws IOException {
        this.updateSettings();
        this.loadBinlogChecksum();
        this.sendBinlogDump(binlogfilename, binlogPosition);
        DirectLogFetcher fetcher = new DirectLogFetcher(this.connector.getReceiveBufferSize());
        fetcher.start(this.connector.getChannel());
        LogDecoder decoder = new LogDecoder();
        decoder.handle(4);
        decoder.handle(15);
        decoder.handle(2);
        decoder.handle(16);
        LogContext context = new LogContext();
        if (StringUtils.isNotEmpty((String)gtid)) {
            GTIDSet gtidSet = GtidUtil.parseGtidSet((String)gtid, (boolean)this.isMariaDB());
            if (this.isMariaDB()) {
                decoder.handle(162);
                decoder.handle(163);
            } else {
                decoder.handle(33);
            }
            context.setGtidSet(gtidSet);
        }
        context.setFormatDescription(new FormatDescriptionLogEvent(4, this.binlogChecksum));
        while (fetcher.fetch()) {
            this.accumulateReceivedBytes(fetcher.limit());
            LogEvent event = null;
            event = decoder.decode((LogBuffer)fetcher, context);
            if (event == null) {
                throw new CanalParseException("parse failed");
            }
            if (func.sink(event)) continue;
            break;
        }
    }

    @Override
    public void dump(String binlogfilename, Long binlogPosition, SinkFunction func) throws IOException {
        this.updateSettings();
        this.loadBinlogChecksum();
        this.sendRegisterSlave();
        this.sendBinlogDump(binlogfilename, binlogPosition);
        DirectLogFetcher fetcher = new DirectLogFetcher(this.connector.getReceiveBufferSize());
        fetcher.start(this.connector.getChannel());
        LogDecoder decoder = new LogDecoder(0, 165);
        LogContext context = new LogContext();
        context.setFormatDescription(new FormatDescriptionLogEvent(4, this.binlogChecksum));
        while (fetcher.fetch()) {
            this.accumulateReceivedBytes(fetcher.limit());
            LogEvent event = null;
            event = decoder.decode((LogBuffer)fetcher, context);
            if (event == null) {
                throw new CanalParseException("parse failed");
            }
            if (!func.sink(event)) break;
            if (event.getSemival() != 1) continue;
            this.sendSemiAck(context.getLogPosition().getFileName(), context.getLogPosition().getPosition());
        }
    }

    @Override
    public void dump(GTIDSet gtidSet, SinkFunction func) throws IOException {
        this.updateSettings();
        this.loadBinlogChecksum();
        this.sendBinlogDumpGTID(gtidSet);
        try (DirectLogFetcher fetcher = new DirectLogFetcher(this.connector.getReceiveBufferSize());){
            fetcher.start(this.connector.getChannel());
            LogDecoder decoder = new LogDecoder(0, 165);
            LogContext context = new LogContext();
            context.setFormatDescription(new FormatDescriptionLogEvent(4, this.binlogChecksum));
            context.setGtidSet(gtidSet);
            while (fetcher.fetch()) {
                this.accumulateReceivedBytes(fetcher.limit());
                LogEvent event = null;
                event = decoder.decode((LogBuffer)fetcher, context);
                if (event == null) {
                    throw new CanalParseException("parse failed");
                }
                if (func.sink(event)) continue;
                break;
            }
        }
    }

    @Override
    public void dump(long timestamp, SinkFunction func) throws IOException {
        throw new NullPointerException("Not implement yet");
    }

    @Override
    public void dump(String binlogfilename, Long binlogPosition, MultiStageCoprocessor coprocessor) throws IOException {
        this.updateSettings();
        this.loadBinlogChecksum();
        this.sendRegisterSlave();
        this.sendBinlogDump(binlogfilename, binlogPosition);
        ((MysqlMultiStageCoprocessor)coprocessor).setConnection(this);
        ((MysqlMultiStageCoprocessor)coprocessor).setBinlogChecksum(this.binlogChecksum);
        try (DirectLogFetcher fetcher = new DirectLogFetcher(this.connector.getReceiveBufferSize());){
            fetcher.start(this.connector.getChannel());
            while (fetcher.fetch()) {
                this.accumulateReceivedBytes(fetcher.limit());
                LogBuffer buffer = fetcher.duplicate();
                fetcher.consume(fetcher.limit());
                if (coprocessor.publish(buffer)) continue;
                break;
            }
        }
    }

    @Override
    public void dump(long timestamp, MultiStageCoprocessor coprocessor) throws IOException {
        throw new NullPointerException("Not implement yet");
    }

    @Override
    public void dump(GTIDSet gtidSet, MultiStageCoprocessor coprocessor) throws IOException {
        this.updateSettings();
        this.loadBinlogChecksum();
        this.sendBinlogDumpGTID(gtidSet);
        ((MysqlMultiStageCoprocessor)coprocessor).setConnection(this);
        ((MysqlMultiStageCoprocessor)coprocessor).setBinlogChecksum(this.binlogChecksum);
        try (DirectLogFetcher fetcher = new DirectLogFetcher(this.connector.getReceiveBufferSize());){
            fetcher.start(this.connector.getChannel());
            while (fetcher.fetch()) {
                this.accumulateReceivedBytes(fetcher.limit());
                LogBuffer buffer = fetcher.duplicate();
                fetcher.consume(fetcher.limit());
                if (coprocessor.publish(buffer)) continue;
                break;
            }
        }
    }

    private void sendRegisterSlave() throws IOException {
        RegisterSlaveCommandPacket cmd = new RegisterSlaveCommandPacket();
        SocketAddress socketAddress = this.connector.getChannel().getLocalSocketAddress();
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            return;
        }
        InetSocketAddress address = (InetSocketAddress)socketAddress;
        String host = address.getHostString();
        int port = address.getPort();
        cmd.reportHost = host;
        cmd.reportPort = port;
        cmd.reportPasswd = this.authInfo.getPassword();
        cmd.reportUser = this.authInfo.getUsername();
        cmd.serverId = this.slaveId;
        byte[] cmdBody = cmd.toBytes();
        logger.info("Register slave {}", (Object)cmd);
        HeaderPacket header = new HeaderPacket();
        header.setPacketBodyLength(cmdBody.length);
        header.setPacketSequenceNumber((byte)0);
        PacketManager.writePkg((SocketChannel)this.connector.getChannel(), (byte[][])new byte[][]{header.toBytes(), cmdBody});
        header = PacketManager.readHeader((SocketChannel)this.connector.getChannel(), (int)4);
        byte[] body = PacketManager.readBytes((SocketChannel)this.connector.getChannel(), (int)header.getPacketBodyLength());
        assert (body != null);
        if (body[0] < 0) {
            if (body[0] == -1) {
                ErrorPacket err = new ErrorPacket();
                err.fromBytes(body);
                throw new IOException("Error When doing Register slave:" + err.toString());
            }
            throw new IOException("unpexpected packet with field_count=" + body[0]);
        }
    }

    private void sendBinlogDump(String binlogfilename, Long binlogPosition) throws IOException {
        BinlogDumpCommandPacket binlogDumpCmd = new BinlogDumpCommandPacket();
        binlogDumpCmd.binlogFileName = binlogfilename;
        binlogDumpCmd.binlogPosition = binlogPosition;
        binlogDumpCmd.slaveServerId = this.slaveId;
        byte[] cmdBody = binlogDumpCmd.toBytes();
        logger.info("COM_BINLOG_DUMP with position:{}", (Object)binlogDumpCmd);
        HeaderPacket binlogDumpHeader = new HeaderPacket();
        binlogDumpHeader.setPacketBodyLength(cmdBody.length);
        binlogDumpHeader.setPacketSequenceNumber((byte)0);
        PacketManager.writePkg((SocketChannel)this.connector.getChannel(), (byte[][])new byte[][]{binlogDumpHeader.toBytes(), cmdBody});
        this.connector.setDumping(true);
    }

    public void sendSemiAck(String binlogfilename, Long binlogPosition) throws IOException {
        SemiAckCommandPacket semiAckCmd = new SemiAckCommandPacket();
        semiAckCmd.binlogFileName = binlogfilename;
        semiAckCmd.binlogPosition = binlogPosition;
        byte[] cmdBody = semiAckCmd.toBytes();
        logger.info("SEMI ACK with position:{}", (Object)semiAckCmd);
        HeaderPacket semiAckHeader = new HeaderPacket();
        semiAckHeader.setPacketBodyLength(cmdBody.length);
        semiAckHeader.setPacketSequenceNumber((byte)0);
        PacketManager.writePkg((SocketChannel)this.connector.getChannel(), (byte[][])new byte[][]{semiAckHeader.toBytes(), cmdBody});
    }

    private void sendBinlogDumpGTID(GTIDSet gtidSet) throws IOException {
        if (this.isMariaDB()) {
            this.sendMariaBinlogDumpGTID(gtidSet);
            return;
        }
        this.sendMySQLBinlogDumpGTID(gtidSet);
    }

    private void sendMySQLBinlogDumpGTID(GTIDSet gtidSet) throws IOException {
        BinlogDumpGTIDCommandPacket binlogDumpCmd = new BinlogDumpGTIDCommandPacket();
        binlogDumpCmd.slaveServerId = this.slaveId;
        binlogDumpCmd.gtidSet = gtidSet;
        byte[] cmdBody = binlogDumpCmd.toBytes();
        logger.info("COM_BINLOG_DUMP_GTID:{}", (Object)binlogDumpCmd);
        HeaderPacket binlogDumpHeader = new HeaderPacket();
        binlogDumpHeader.setPacketBodyLength(cmdBody.length);
        binlogDumpHeader.setPacketSequenceNumber((byte)0);
        PacketManager.writePkg((SocketChannel)this.connector.getChannel(), (byte[][])new byte[][]{binlogDumpHeader.toBytes(), cmdBody});
        this.connector.setDumping(true);
    }

    private void sendMariaBinlogDumpGTID(GTIDSet gtidSet) throws IOException {
        this.update("SET @slave_connect_state = '" + new String(gtidSet.encode()) + "'");
        this.update("SET @slave_gtid_strict_mode = 0");
        this.update("SET @slave_gtid_ignore_duplicates = 0");
        this.sendRegisterSlave();
        this.sendBinlogDump("", 0L);
        this.connector.setDumping(true);
    }

    @Override
    public MysqlConnection fork() {
        MysqlConnection connection = new MysqlConnection();
        connection.setCharset(this.getCharset());
        connection.setSlaveId(this.getSlaveId());
        connection.setConnector(this.connector.fork());
        connection.setAuthInfo(this.authInfo);
        return connection;
    }

    @Override
    public long queryServerId() throws IOException {
        ResultSetPacket resultSetPacket = this.query("show variables like 'server_id'");
        List fieldValues = resultSetPacket.getFieldValues();
        if (fieldValues == null || fieldValues.size() != 2) {
            return 0L;
        }
        return NumberUtils.toLong((String)((String)fieldValues.get(1)));
    }

    private void updateSettings() throws IOException {
        block18: {
            block17: {
                block16: {
                    try {
                        this.update("set wait_timeout=9999999");
                    }
                    catch (Exception e) {
                        logger.warn("update wait_timeout failed", (Throwable)e);
                    }
                    try {
                        this.update("set net_write_timeout=7200");
                    }
                    catch (Exception e) {
                        logger.warn("update net_write_timeout failed", (Throwable)e);
                    }
                    try {
                        this.update("set net_read_timeout=7200");
                    }
                    catch (Exception e) {
                        logger.warn("update net_read_timeout failed", (Throwable)e);
                    }
                    try {
                        this.update("set names 'binary'");
                    }
                    catch (Exception e) {
                        logger.warn("update names failed", (Throwable)e);
                    }
                    try {
                        this.update("set @master_binlog_checksum= @@global.binlog_checksum");
                    }
                    catch (Exception e) {
                        if (StringUtils.contains((String)e.getMessage(), (String)"Unknown system variable")) break block16;
                        logger.warn("update master_binlog_checksum failed", (Throwable)e);
                    }
                }
                try {
                    this.update("set @slave_uuid=uuid()");
                }
                catch (Exception e) {
                    if (StringUtils.contains((String)e.getMessage(), (String)"Unknown system variable")) break block17;
                    logger.warn("update slave_uuid failed", (Throwable)e);
                }
            }
            try {
                this.update("SET @mariadb_slave_capability='4'");
            }
            catch (Exception e) {
                if (StringUtils.contains((String)e.getMessage(), (String)"Unknown system variable")) break block18;
                logger.warn("update mariadb_slave_capability failed", (Throwable)e);
            }
        }
        try {
            long periodNano = TimeUnit.SECONDS.toNanos(15L);
            this.update("SET @master_heartbeat_period=" + periodNano);
        }
        catch (Exception e) {
            logger.warn("update master_heartbeat_period failed", (Throwable)e);
        }
    }

    private void loadBinlogFormat() {
        ResultSetPacket rs = null;
        try {
            rs = this.query("show variables like 'binlog_format'");
        }
        catch (IOException e) {
            throw new CanalParseException(e);
        }
        List columnValues = rs.getFieldValues();
        if (columnValues == null || columnValues.size() != 2) {
            logger.warn("unexpected binlog format query result, this may cause unexpected result, so throw exception to request network to io shutdown.");
            throw new IllegalStateException("unexpected binlog format query result:" + rs.getFieldValues());
        }
        this.binlogFormat = BinlogFormat.valuesOf((String)columnValues.get(1));
        if (this.binlogFormat == null) {
            throw new IllegalStateException("unexpected binlog format query result:" + rs.getFieldValues());
        }
    }

    private void loadBinlogImage() {
        ResultSetPacket rs = null;
        try {
            rs = this.query("show variables like 'binlog_row_image'");
        }
        catch (IOException e) {
            throw new CanalParseException(e);
        }
        List columnValues = rs.getFieldValues();
        this.binlogImage = columnValues == null || columnValues.size() != 2 ? BinlogImage.FULL : BinlogImage.valuesOf((String)columnValues.get(1));
        if (this.binlogFormat == null) {
            throw new IllegalStateException("unexpected binlog image query result:" + rs.getFieldValues());
        }
    }

    private void loadBinlogChecksum() {
        ResultSetPacket rs = null;
        try {
            rs = this.query("select @@global.binlog_checksum");
            List columnValues = rs.getFieldValues();
            this.binlogChecksum = columnValues != null && columnValues.size() >= 1 && columnValues.get(0) != null && ((String)columnValues.get(0)).toUpperCase().equals("CRC32") ? 1 : 0;
        }
        catch (Throwable e) {
            this.binlogChecksum = 0;
        }
    }

    private void accumulateReceivedBytes(long x) {
        if (this.receivedBinlogBytes != null) {
            this.receivedBinlogBytes.addAndGet(x);
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public long getSlaveId() {
        return this.slaveId;
    }

    public void setSlaveId(long slaveId) {
        this.slaveId = slaveId;
    }

    public MysqlConnector getConnector() {
        return this.connector;
    }

    public void setConnector(MysqlConnector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinlogFormat getBinlogFormat() {
        if (this.binlogFormat == null) {
            MysqlConnection mysqlConnection = this;
            synchronized (mysqlConnection) {
                this.loadBinlogFormat();
            }
        }
        return this.binlogFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinlogImage getBinlogImage() {
        if (this.binlogImage == null) {
            MysqlConnection mysqlConnection = this;
            synchronized (mysqlConnection) {
                this.loadBinlogImage();
            }
        }
        return this.binlogImage;
    }

    public InetSocketAddress getAddress() {
        return this.authInfo.getAddress();
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public AuthenticationInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(AuthenticationInfo authInfo) {
        this.authInfo = authInfo;
    }

    public void setReceivedBinlogBytes(AtomicLong receivedBinlogBytes) {
        this.receivedBinlogBytes = receivedBinlogBytes;
    }

    public boolean isMariaDB() {
        return this.connector.getServerVersion() != null && this.connector.getServerVersion().toLowerCase().contains("mariadb");
    }

    public static enum BinlogImage {
        FULL("FULL"),
        MINIMAL("MINIMAL"),
        NOBLOB("NOBLOB");

        private String value;

        public boolean isFull() {
            return this == FULL;
        }

        public boolean isMinimal() {
            return this == MINIMAL;
        }

        public boolean isNoBlob() {
            return this == NOBLOB;
        }

        private BinlogImage(String value) {
            this.value = value;
        }

        public static BinlogImage valuesOf(String value) {
            BinlogImage[] formats;
            for (BinlogImage format : formats = BinlogImage.values()) {
                if (!format.value.equalsIgnoreCase(value)) continue;
                return format;
            }
            return null;
        }
    }

    public static enum BinlogFormat {
        STATEMENT("STATEMENT"),
        ROW("ROW"),
        MIXED("MIXED");

        private String value;

        public boolean isStatement() {
            return this == STATEMENT;
        }

        public boolean isRow() {
            return this == ROW;
        }

        public boolean isMixed() {
            return this == MIXED;
        }

        private BinlogFormat(String value) {
            this.value = value;
        }

        public static BinlogFormat valuesOf(String value) {
            BinlogFormat[] formats;
            for (BinlogFormat format : formats = BinlogFormat.values()) {
                if (!format.value.equalsIgnoreCase(value)) continue;
                return format;
            }
            return null;
        }
    }
}

