/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.CacheObject;
import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.InstructionSet;
import java.util.List;
import org.apache.commons.logging.Log;

public abstract class ExpressRemoteCacheRunner {
    public void loadCache(String expressName, String text) {
        try {
            InstructionSet instructionSet = this.getExpressRunner().parseInstructionSet(text);
            CacheObject cache = new CacheObject();
            cache.setExpressName(expressName);
            cache.setText(text);
            cache.setInstructionSet(instructionSet);
            this.putCache(expressName, cache);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790\u6307\u4ee4\u5e76\u7f13\u5b58\u8fc7\u7a0b\u51fa\u73b0\u9519\u8bef.", e);
        }
    }

    public Object execute(String name, IExpressContext<String, Object> context, List<String> errorList, boolean isTrace, boolean isCatchException, Log aLog) {
        try {
            CacheObject cache = (CacheObject)this.getCache(name);
            if (cache == null) {
                throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u7f13\u5b58\u5bf9\u8c61.");
            }
            return this.getExpressRunner().execute(cache.getInstructionSet(), context, errorList, isTrace, isCatchException, aLog);
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u7f13\u5b58\u4fe1\u606f\uff0c\u5e76\u4e14\u6267\u884c\u6307\u4ee4\u96c6\u51fa\u73b0\u9519\u8bef.", e);
        }
    }

    public abstract ExpressRunner getExpressRunner();

    public abstract Object getCache(String var1);

    public abstract void putCache(String var1, Object var2);
}

