/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.op;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.DynamicParamsUtil;
import com.ql.util.express.ExpressUtil;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.op.CanClone;
import com.ql.util.express.instruction.op.OperatorBase;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class OperatorSelfDefineClassFunction
extends OperatorBase
implements CanClone {
    String functionName;
    String[] parameterTypes;
    Class<?>[] parameterClasses;
    Class<?> operClass;
    Object operInstance;
    Method method;
    boolean isReturnVoid;
    boolean maybeDynamicParams;

    public OperatorSelfDefineClassFunction(String aOperName, String aClassName, String aFunctionName, Class<?>[] aParameterClassTypes, String[] aParameterDesc, String[] aParameterAnnotation, String aErrorInfo) throws Exception {
        if (this.errorInfo != null && this.errorInfo.trim().length() == 0) {
            this.errorInfo = null;
        }
        this.name = aOperName;
        this.errorInfo = aErrorInfo;
        this.functionName = aFunctionName;
        this.parameterClasses = aParameterClassTypes;
        this.parameterTypes = new String[aParameterClassTypes.length];
        this.operDataDesc = aParameterDesc;
        this.operDataAnnotation = aParameterAnnotation;
        for (int i = 0; i < this.parameterClasses.length; ++i) {
            this.parameterTypes[i] = this.parameterClasses[i].getName();
        }
        this.operClass = ExpressUtil.getJavaClass(aClassName);
        this.method = this.operClass.getMethod(this.functionName, this.parameterClasses);
        this.isReturnVoid = this.method.getReturnType().equals(Void.TYPE);
        this.maybeDynamicParams = DynamicParamsUtil.maybeDynamicParams(this.parameterClasses);
    }

    public OperatorSelfDefineClassFunction(String aOperName, String aClassName, String aFunctionName, String[] aParameterTypes, String[] aParameterDesc, String[] aParameterAnnotation, String aErrorInfo) throws Exception {
        if (this.errorInfo != null && this.errorInfo.trim().length() == 0) {
            this.errorInfo = null;
        }
        this.name = aOperName;
        this.errorInfo = aErrorInfo;
        this.functionName = aFunctionName;
        this.parameterTypes = aParameterTypes;
        this.operDataDesc = aParameterDesc;
        this.operDataAnnotation = aParameterAnnotation;
        this.parameterClasses = new Class[this.parameterTypes.length];
        for (int i = 0; i < this.parameterClasses.length; ++i) {
            this.parameterClasses[i] = ExpressUtil.getJavaClass(this.parameterTypes[i]);
        }
        this.operClass = ExpressUtil.getJavaClass(aClassName);
        this.method = this.operClass.getMethod(this.functionName, this.parameterClasses);
        this.maybeDynamicParams = DynamicParamsUtil.maybeDynamicParams(this.parameterClasses);
    }

    @Override
    public OperatorBase cloneMe(String opName, String errorInfo) throws Exception {
        OperatorSelfDefineClassFunction result = new OperatorSelfDefineClassFunction(opName, this.operClass.getName(), this.functionName, this.parameterClasses, this.operDataDesc, this.operDataAnnotation, errorInfo);
        return result;
    }

    @Override
    public OperateData executeInner(InstructionSetContext context, ArraySwap list) throws Exception {
        Object[] parameres = DynamicParamsUtil.transferDynamicParams(context, list, this.parameterClasses, this.maybeDynamicParams);
        Object obj = null;
        if (Modifier.isStatic(this.method.getModifiers())) {
            obj = this.method.invoke(null, ExpressUtil.transferArray(parameres, this.parameterClasses));
        } else {
            if (this.operInstance == null) {
                this.operInstance = this.operClass.newInstance();
            }
            obj = this.method.invoke(this.operInstance, ExpressUtil.transferArray(parameres, this.parameterClasses));
        }
        if (obj != null) {
            return OperateDataCacheManager.fetchOperateData(obj, obj.getClass());
        }
        if (this.isReturnVoid) {
            return OperateDataCacheManager.fetchOperateDataAttr("null", Void.TYPE);
        }
        return OperateDataCacheManager.fetchOperateDataAttr("null", null);
    }
}

