/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.match;

import com.ql.util.express.match.IDataNode;
import com.ql.util.express.match.INodeType;
import com.ql.util.express.match.INodeTypeManager;
import com.ql.util.express.match.MatchMode;
import com.ql.util.express.match.QLMatchResult;
import com.ql.util.express.match.QLMatchResultTree;
import com.ql.util.express.match.QLPatternNode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QLPattern {
    private static final Log log = LogFactory.getLog(QLPattern.class);

    public static QLPatternNode createPattern(INodeTypeManager nodeTypeManager, String name, String pattern) throws Exception {
        return new QLPatternNode(nodeTypeManager, name, pattern);
    }

    public static QLMatchResult findMatchStatement(INodeTypeManager aManager, QLPatternNode pattern, List<? extends IDataNode> nodes, int point) throws Exception {
        AtomicLong maxMatchPoint = new AtomicLong();
        QLMatchResult result = QLPattern.findMatchStatementWithAddRoot(aManager, pattern, nodes, point, true, maxMatchPoint);
        if (result == null || result.matchs.size() == 0) {
            throw new Exception("\u7a0b\u5e8f\u9519\u8bef\uff0c\u4e0d\u6ee1\u8db3\u8bed\u6cd5\u89c4\u8303\uff0c\u6ca1\u6709\u5339\u914d\u5230\u5408\u9002\u7684\u8bed\u6cd5,\u6700\u5927\u5339\u914d\u81f4[0:" + (maxMatchPoint.longValue() - 1L) + "]");
        }
        if (result != null && result.matchs.size() != 1) {
            throw new Exception("\u7a0b\u5e8f\u9519\u8bef\uff0c\u4e0d\u6ee1\u8db3\u8bed\u6cd5\u89c4\u8303\uff0c\u5fc5\u987b\u6709\u4e00\u4e2a\u6839\u8282\u70b9\uff1a" + pattern + ",\u6700\u5927\u5339\u914d\u81f4[0:" + (maxMatchPoint.longValue() - 1L) + "]");
        }
        return result;
    }

    private static QLMatchResult findMatchStatementWithAddRoot(INodeTypeManager aManager, QLPatternNode pattern, List<? extends IDataNode> nodes, int point, boolean isRoot, AtomicLong maxMatchPoint) throws Exception {
        QLMatchResult result;
        block17: {
            result = null;
            List<QLMatchResultTree> tempList = null;
            int count = 0;
            int lastPoint = point;
            do {
                QLMatchResult tempResult = null;
                if (pattern.matchMode == MatchMode.DETAIL) {
                    tempResult = QLPattern.matchDetailOneTime(aManager, pattern, nodes, lastPoint, maxMatchPoint);
                } else if (pattern.matchMode == MatchMode.AND) {
                    tempResult = QLPattern.matchAndOneTime(aManager, pattern, nodes, lastPoint, maxMatchPoint);
                } else if (pattern.matchMode == MatchMode.OR) {
                    tempResult = QLPattern.matchOrOneTime(aManager, pattern, nodes, lastPoint, maxMatchPoint);
                } else {
                    throw new Exception("\u4e0d\u6b63\u786e\u7684\u7c7b\u578b\uff1a" + pattern.matchMode.toString());
                }
                if (tempResult == null) {
                    if (count >= pattern.minMatchNum && count <= pattern.maxMatchNum) {
                        if (tempList == null) {
                            tempList = new ArrayList();
                        }
                        result = new QLMatchResult(tempList, lastPoint);
                    } else {
                        result = null;
                    }
                    break block17;
                }
                if (tempList == null) {
                    tempList = new ArrayList<QLMatchResultTree>();
                }
                lastPoint = tempResult.matchLastIndex;
                if (pattern.isTreeRoot) {
                    if (tempResult.matchs.size() > 1) {
                        throw new Exception("\u6839\u8282\u70b9\u7684\u6570\u91cf\u5fc5\u987b\u662f1");
                    }
                    if (tempList.size() == 0) {
                        tempList.addAll(tempResult.matchs);
                        continue;
                    }
                    tempResult.matchs.get(0).addLeftAll(tempList);
                    tempList = tempResult.matchs;
                    continue;
                }
                tempList.addAll(tempResult.matchs);
            } while (++count != pattern.maxMatchNum);
            result = new QLMatchResult(tempList, lastPoint);
        }
        if (result != null && pattern.isSkip) {
            result.matchs.clear();
        }
        if (result != null && result.matchs.size() > 0 && pattern.rootNodeType != null) {
            QLMatchResultTree tempTree = new QLMatchResultTree(pattern.rootNodeType, nodes.get(0).createExpressNode(pattern.rootNodeType, null));
            tempTree.addLeftAll(result.matchs);
            result.matchs.clear();
            result.matchs.add(tempTree);
        }
        return result;
    }

    private static QLMatchResult matchDetailOneTime(INodeTypeManager aManager, QLPatternNode pattern, List<? extends IDataNode> nodes, int point, AtomicLong maxMatchPoint) throws Exception {
        QLMatchResult result = null;
        if (pattern.nodeType == aManager.findNodeType("EOF") && point == nodes.size()) {
            result = new QLMatchResult(new ArrayList<QLMatchResultTree>(), point + 1);
        } else if (pattern.nodeType == aManager.findNodeType("EOF") && point < nodes.size() && nodes.get(point).getValue().equals("}")) {
            result = new QLMatchResult(new ArrayList<QLMatchResultTree>(), point);
        } else if (point == nodes.size() && pattern.nodeType.getPatternNode() != null) {
            result = QLPattern.findMatchStatementWithAddRoot(aManager, pattern.nodeType.getPatternNode(), nodes, point, false, maxMatchPoint);
        } else if (point < nodes.size()) {
            ArrayList<QLMatchResultTree> tempList;
            INodeType tempNodeType = nodes.get(point).getTreeType();
            if (tempNodeType == null) {
                tempNodeType = nodes.get(point).getNodeType();
            }
            if (tempNodeType != null && !tempNodeType.equals(pattern.nodeType)) {
                tempNodeType = null;
            }
            if (tempNodeType != null) {
                tempList = new ArrayList<QLMatchResultTree>();
                tempList.add(new QLMatchResultTree(tempNodeType, nodes.get(point), pattern.targetNodeType));
                result = new QLMatchResult(tempList, ++point);
                QLPattern.traceLog(pattern, result, nodes, point - 1, 1);
            } else if (pattern.nodeType.getPatternNode() != null) {
                result = QLPattern.findMatchStatementWithAddRoot(aManager, pattern.nodeType.getPatternNode(), nodes, point, false, maxMatchPoint);
                if (pattern.targetNodeType != null && result != null && result.matchs.size() > 0) {
                    if (result.matchs.size() > 1) {
                        throw new Exception("\u8bbe\u7f6e\u4e86\u7c7b\u578b\u8f6c\u6362\u7684\u8bed\u6cd5\uff0c\u53ea\u80fd\u6709\u4e00\u4e2a\u6839\u8282\u70b9");
                    }
                    result.matchs.get((int)0).targetNodeType = pattern.targetNodeType;
                }
            }
            if (pattern.blame) {
                if (result == null) {
                    tempList = new ArrayList();
                    tempList.add(new QLMatchResultTree(tempNodeType, nodes.get(point), null));
                    result = new QLMatchResult(tempList, ++point);
                } else {
                    result = null;
                }
            }
        }
        if (result != null && (long)result.matchLastIndex > maxMatchPoint.longValue()) {
            maxMatchPoint.set(result.matchLastIndex);
        }
        return result;
    }

    private static QLMatchResult matchOrOneTime(INodeTypeManager aManager, QLPatternNode pattern, List<? extends IDataNode> nodes, int point, AtomicLong maxMatchPoint) throws Exception {
        QLMatchResult result = null;
        for (QLPatternNode item : pattern.children) {
            QLMatchResult tempResult = QLPattern.findMatchStatementWithAddRoot(aManager, item, nodes, point, false, maxMatchPoint);
            if (tempResult == null) continue;
            return tempResult;
        }
        return result;
    }

    private static QLMatchResult matchAndOneTime(INodeTypeManager aManager, QLPatternNode pattern, List<? extends IDataNode> nodes, int point, AtomicLong maxMatchPoint) throws Exception {
        int orgiPoint = point;
        QLMatchResultTree root = null;
        int matchCount = 0;
        ArrayList<QLMatchResultTree> tempList = null;
        for (QLPatternNode item : pattern.children) {
            if (point > nodes.size()) {
                return null;
            }
            QLMatchResult tempResult = QLPattern.findMatchStatementWithAddRoot(aManager, item, nodes, point, false, maxMatchPoint);
            if (tempResult != null) {
                if (tempResult.matchs.size() > 0) {
                    ++matchCount;
                }
                if (tempList == null) {
                    tempList = new ArrayList<QLMatchResultTree>();
                }
                point = tempResult.matchLastIndex;
                if (item.isTreeRoot && tempResult.matchs.size() > 0) {
                    if (tempResult.matchs.size() > 1) {
                        throw new Exception("\u6839\u8282\u70b9\u7684\u6570\u91cf\u5fc5\u987b\u662f1");
                    }
                    if (root == null) {
                        QLMatchResultTree tempTree = tempResult.matchs.get(0);
                        while (tempTree.getLeft() != null && tempTree.getLeft().size() > 0) {
                            tempTree = tempTree.getLeft().get(0);
                        }
                        tempTree.addLeftAll(tempList);
                        tempList.clear();
                    } else {
                        tempResult.matchs.get(0).addLeft(root);
                    }
                    root = tempResult.matchs.get(0);
                    continue;
                }
                if (root != null) {
                    root.addRightAll(tempResult.matchs);
                    continue;
                }
                tempList.addAll(tempResult.matchs);
                continue;
            }
            return null;
        }
        if (root != null) {
            tempList.add(root);
        }
        QLMatchResult result = new QLMatchResult((List<QLMatchResultTree>)tempList, point);
        QLPattern.traceLog(pattern, result, nodes, orgiPoint, matchCount);
        return result;
    }

    public static void traceLog(QLPatternNode pattern, QLMatchResult result, List<? extends IDataNode> nodes, int point, int matchCount) {
        if (log.isTraceEnabled() && (pattern.matchMode == MatchMode.DETAIL || pattern.matchMode == MatchMode.AND && matchCount > 1 && !pattern.name.equals("ANONY_PATTERN"))) {
            log.trace((Object)("\u5339\u914d--" + pattern.name + "[" + point + ":" + (result.matchLastIndex - 1) + "]:" + pattern));
        }
    }
}

