/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.parse;

import com.ql.util.express.match.INodeTypeManager;
import com.ql.util.express.parse.KeyWordDefine4Java;
import com.ql.util.express.parse.KeyWordDefine4SQL;
import com.ql.util.express.parse.NodeType;
import com.ql.util.express.parse.NodeTypeKind;
import com.ql.util.express.parse.WordSplit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeTypeManager
implements INodeTypeManager {
    private static final Log log = LogFactory.getLog(NodeTypeManager.class);
    public String[] splitWord;
    private String[] keyWords;
    private String[] nodeTypeDefines;
    protected String[][] instructionFacotryMapping;
    protected Map<String, NodeType> nodeTypes = new HashMap<String, NodeType>();
    protected Map<String, String> functions = new HashMap<String, String>();

    public NodeTypeManager() {
        this(new KeyWordDefine4Java());
    }

    public NodeTypeManager(KeyWordDefine4SQL keyWorkdDefine) {
        this.splitWord = keyWorkdDefine.splitWord;
        this.keyWords = keyWorkdDefine.keyWords;
        this.nodeTypeDefines = keyWorkdDefine.nodeTypeDefines;
        this.initial();
    }

    public NodeTypeManager(KeyWordDefine4Java keyWorkdDefine) {
        this.splitWord = keyWorkdDefine.splitWord;
        WordSplit.sortSplitWord(this.splitWord);
        this.keyWords = keyWorkdDefine.keyWords;
        this.nodeTypeDefines = keyWorkdDefine.nodeTypeDefines;
        this.instructionFacotryMapping = keyWorkdDefine.instructionFacotryMapping;
        this.initial();
        this.addOperatorWithRealNodeType("and", "&&");
        this.addOperatorWithRealNodeType("or", "||");
    }

    public void initial() {
        int i;
        int i2;
        NodeType[] tempKeyWordNodeTypes = new NodeType[this.splitWord.length + this.keyWords.length];
        for (i2 = 0; i2 < this.splitWord.length; ++i2) {
            tempKeyWordNodeTypes[i2] = this.createNodeType(this.splitWord[i2] + ":TYPE=KEYWORD");
        }
        for (i2 = 0; i2 < this.keyWords.length; ++i2) {
            tempKeyWordNodeTypes[i2 + this.splitWord.length] = this.createNodeType(this.keyWords[i2] + ":TYPE=KEYWORD");
        }
        for (i2 = 0; i2 < tempKeyWordNodeTypes.length; ++i2) {
            tempKeyWordNodeTypes[i2].initial();
        }
        NodeType[] nodeTypes = new NodeType[this.nodeTypeDefines.length];
        for (i = 0; i < this.nodeTypeDefines.length; ++i) {
            nodeTypes[i] = this.createNodeType(this.nodeTypeDefines[i]);
        }
        for (i = 0; i < nodeTypes.length; ++i) {
            nodeTypes[i].initial();
        }
        if (this.instructionFacotryMapping != null) {
            for (String[] list : this.instructionFacotryMapping) {
                for (String s : list[0].split(",")) {
                    this.findNodeType(s).setInstructionFactory(list[1]);
                }
            }
        }
    }

    public NodeType createNodeType(String aDefineStr) {
        int index = aDefineStr.indexOf(":", 1);
        String name = aDefineStr.substring(0, index).trim();
        NodeType define = this.nodeTypes.get(name);
        if (define != null) {
            log.warn((Object)("\u8282\u70b9\u7c7b\u578b\u5b9a\u4e49\u91cd\u590d:" + name + " \u5b9a\u4e491=" + define.getDefineStr() + " \u5b9a\u4e492=" + aDefineStr));
            throw new RuntimeException("\u8282\u70b9\u7c7b\u578b\u5b9a\u4e49\u91cd\u590d:" + name + " \u5b9a\u4e491=" + define.getDefineStr() + " \u5b9a\u4e492=" + aDefineStr);
        }
        define = new NodeType(this, name, aDefineStr);
        this.nodeTypes.put(name, define);
        return define;
    }

    @Override
    public NodeType findNodeType(String name) {
        NodeType result = this.nodeTypes.get(name);
        if (result == null) {
            throw new RuntimeException("\u6ca1\u6709\u5b9a\u4e49\u7684\u8282\u70b9\u7c7b\u578b\uff1a" + name);
        }
        while (result.getRealNodeType() != null) {
            result = result.getRealNodeType();
        }
        return result;
    }

    public void addOperatorWithRealNodeType(String keyWordName, String realName) {
        NodeType target = this.createNodeType(keyWordName + ":TYPE=KEYWORD,REAL=" + realName);
        target.initial();
    }

    public void addOperatorWithLevelOfReference(String operName, String refOperName) throws Exception {
        NodeType target = this.createNodeType(operName + ":TYPE=KEYWORD");
        target.initial();
        NodeType[] list = this.getNodeTypesByKind(NodeTypeKind.OPERATOR);
        NodeType refNodeType = this.findNodeType(refOperName);
        target.setInstructionFactory(refNodeType.getInstructionFactory());
        for (NodeType item : list) {
            if (!item.isContainerChild(refNodeType)) continue;
            item.addChild(target);
            return;
        }
    }

    public NodeType isExistNodeTypeDefine(String name) {
        NodeType result = this.nodeTypes.get(name);
        if (result != null && result.getRealNodeType() != null) {
            result = result.getRealNodeType();
        }
        return result;
    }

    public NodeType[] getNodeTypesByKind(NodeTypeKind aKind) {
        ArrayList<NodeType> result = new ArrayList<NodeType>();
        for (NodeType item : this.nodeTypes.values()) {
            if (item.getKind() != aKind) continue;
            result.add(item);
        }
        return result.toArray(new NodeType[0]);
    }

    public boolean isFunction(String name) {
        return this.functions.containsKey(name);
    }

    public void addFunctionName(String name) {
        this.functions.put(name, name);
    }
}

