/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import okhttp3.Authenticator;

public final class ConnectionConfigurations {
    private static final String PROXY_HOST_ENV = "DASHSCOPE_PROXY_HOST";
    private static final String PROXY_PORT_ENV = "DASHSCOPE_PROXY_PORT";
    private static final Integer defaultProxyPort = 443;
    private String proxyHost;
    private Integer proxyPort;
    private Authenticator proxyAuthenticator;
    private static final String CONNECTION_POOL_SIZE_ENV = "DASHSCOPE_CONNECTION_POOL_SIZE";
    private static final String CONNECTION_IDLE_TIMEOUT_ENV = "DASHSCOPE_CONNECTION_IDLE_TIME";
    private static final String MAXIMUM_ASYNC_REQUESTS_ENV = "DASHSCOPE_MAXIMUM_ASYNC_REQUESTS";
    private static final String MAXIMUM_ASYNC_REQUESTS_PER_HOST_ENV = "DASHSCOPE_MAXIMUM_ASYNC_REQUESTS_PER_HOST";
    private static final String WRITE_TIMEOUT_ENV = "DASHSCOPE_WRITE_TIMEOUT";
    private static final String READ_TIMEOUT_ENV = "DASHSCOPE_READ_TIMEOUT";
    private static final String CONNECTION_TIMEOUT_ENV = "DASHSCOPE_CONNECTION_TIMEOUT";
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(120L);
    private static final Duration DEFAULT_WRITE_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(300L);
    private static final Duration DEFAULT_CONNECTION_IDLE_TIMEOUT = Duration.ofSeconds(300L);
    private static final Integer DEFAULT_CONNECTION_POOL_SIZE = 32;
    private static final Integer DEFAULT_MAXIMUM_ASYNC_REQUESTS = 32;
    private static final Integer DEFAULT_MAXIMUM_ASYNC_REQUESTS_PER_HOST = 32;
    private Duration connectTimeout;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;
    private Duration connectionIdleTimeout;
    private Integer connectionPoolSize;
    private Integer maximumAsyncRequests;
    private Integer maximumAsyncRequestsPerHost;

    public Duration getConnectTimeout() {
        return this.getDuration(this.connectTimeout, DEFAULT_CONNECT_TIMEOUT, CONNECTION_TIMEOUT_ENV);
    }

    public Duration getWriteTimeout() {
        return this.getDuration(this.writeTimeout, DEFAULT_WRITE_TIMEOUT, WRITE_TIMEOUT_ENV);
    }

    public Duration getReadTimeout() {
        return this.getDuration(this.readTimeout, DEFAULT_READ_TIMEOUT, READ_TIMEOUT_ENV);
    }

    public Duration getConnectionIdleTimeout() {
        return this.getDuration(this.connectionIdleTimeout, DEFAULT_CONNECTION_IDLE_TIMEOUT, CONNECTION_IDLE_TIMEOUT_ENV);
    }

    public Integer getConnectionPoolSize() {
        try {
            if (this.connectionPoolSize != null) {
                return this.connectionPoolSize;
            }
            Integer n = Integer.parseInt(System.getenv(CONNECTION_POOL_SIZE_ENV));
            return n;
        }
        catch (NumberFormatException e) {
            return DEFAULT_CONNECTION_POOL_SIZE;
        }
    }

    public Integer getMaximumAsyncRequests() {
        try {
            if (this.maximumAsyncRequests != null) {
                return this.maximumAsyncRequests;
            }
            Integer n = Integer.parseInt(System.getenv(MAXIMUM_ASYNC_REQUESTS_ENV));
            return n;
        }
        catch (NumberFormatException e) {
            return DEFAULT_MAXIMUM_ASYNC_REQUESTS;
        }
    }

    public Integer getMaximumAsyncRequestsPerHost() {
        try {
            if (this.maximumAsyncRequestsPerHost != null) {
                return this.maximumAsyncRequestsPerHost;
            }
            Integer n = Integer.parseInt(System.getenv(MAXIMUM_ASYNC_REQUESTS_PER_HOST_ENV));
            return n;
        }
        catch (NumberFormatException e) {
            return DEFAULT_MAXIMUM_ASYNC_REQUESTS_PER_HOST;
        }
    }

    private Duration getDuration(Duration target, Duration defaultValue, String env) {
        if (target == null) {
            try {
                long dur = Integer.parseInt(System.getenv(env));
                return Duration.ofSeconds(dur);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return target;
    }

    public String getProxyHost() {
        if (this.proxyHost != null) {
            return this.proxyHost;
        }
        String envHost = System.getenv(PROXY_HOST_ENV);
        return envHost;
    }

    public Integer getProxyPort() {
        if (this.proxyPort != null) {
            return this.proxyPort;
        }
        String envPort = System.getenv(PROXY_PORT_ENV);
        if (envPort == null) {
            return defaultProxyPort;
        }
        return Integer.parseInt(envPort);
    }

    public Proxy getProxy() {
        String host = this.getProxyHost();
        if (host != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, (int)this.getProxyPort()));
        }
        return null;
    }

    protected ConnectionConfigurations(ConnectionConfigurationsBuilder<?, ?> b) {
        this.proxyHost = ((ConnectionConfigurationsBuilder)b).proxyHost;
        this.proxyPort = ((ConnectionConfigurationsBuilder)b).proxyPort;
        this.proxyAuthenticator = ((ConnectionConfigurationsBuilder)b).proxyAuthenticator;
        this.connectTimeout = ((ConnectionConfigurationsBuilder)b).connectTimeout;
        this.writeTimeout = ((ConnectionConfigurationsBuilder)b).writeTimeout;
        this.responseTimeout = ((ConnectionConfigurationsBuilder)b).responseTimeout;
        this.readTimeout = ((ConnectionConfigurationsBuilder)b).readTimeout;
        this.connectionIdleTimeout = ((ConnectionConfigurationsBuilder)b).connectionIdleTimeout;
        this.connectionPoolSize = ((ConnectionConfigurationsBuilder)b).connectionPoolSize;
        this.maximumAsyncRequests = ((ConnectionConfigurationsBuilder)b).maximumAsyncRequests;
        this.maximumAsyncRequestsPerHost = ((ConnectionConfigurationsBuilder)b).maximumAsyncRequestsPerHost;
    }

    public static ConnectionConfigurationsBuilder<?, ?> builder() {
        return new ConnectionConfigurationsBuilderImpl();
    }

    public Authenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyAuthenticator(Authenticator proxyAuthenticator) {
        this.proxyAuthenticator = proxyAuthenticator;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConnectionIdleTimeout(Duration connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    public void setConnectionPoolSize(Integer connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public void setMaximumAsyncRequests(Integer maximumAsyncRequests) {
        this.maximumAsyncRequests = maximumAsyncRequests;
    }

    public void setMaximumAsyncRequestsPerHost(Integer maximumAsyncRequestsPerHost) {
        this.maximumAsyncRequestsPerHost = maximumAsyncRequestsPerHost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionConfigurations)) {
            return false;
        }
        ConnectionConfigurations other = (ConnectionConfigurations)o;
        Integer this$proxyPort = this.getProxyPort();
        Integer other$proxyPort = other.getProxyPort();
        if (this$proxyPort == null ? other$proxyPort != null : !((Object)this$proxyPort).equals(other$proxyPort)) {
            return false;
        }
        Integer this$connectionPoolSize = this.getConnectionPoolSize();
        Integer other$connectionPoolSize = other.getConnectionPoolSize();
        if (this$connectionPoolSize == null ? other$connectionPoolSize != null : !((Object)this$connectionPoolSize).equals(other$connectionPoolSize)) {
            return false;
        }
        Integer this$maximumAsyncRequests = this.getMaximumAsyncRequests();
        Integer other$maximumAsyncRequests = other.getMaximumAsyncRequests();
        if (this$maximumAsyncRequests == null ? other$maximumAsyncRequests != null : !((Object)this$maximumAsyncRequests).equals(other$maximumAsyncRequests)) {
            return false;
        }
        Integer this$maximumAsyncRequestsPerHost = this.getMaximumAsyncRequestsPerHost();
        Integer other$maximumAsyncRequestsPerHost = other.getMaximumAsyncRequestsPerHost();
        if (this$maximumAsyncRequestsPerHost == null ? other$maximumAsyncRequestsPerHost != null : !((Object)this$maximumAsyncRequestsPerHost).equals(other$maximumAsyncRequestsPerHost)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
            return false;
        }
        Authenticator this$proxyAuthenticator = this.getProxyAuthenticator();
        Authenticator other$proxyAuthenticator = other.getProxyAuthenticator();
        if (this$proxyAuthenticator == null ? other$proxyAuthenticator != null : !this$proxyAuthenticator.equals(other$proxyAuthenticator)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$writeTimeout = this.getWriteTimeout();
        Duration other$writeTimeout = other.getWriteTimeout();
        if (this$writeTimeout == null ? other$writeTimeout != null : !((Object)this$writeTimeout).equals(other$writeTimeout)) {
            return false;
        }
        Duration this$responseTimeout = this.getResponseTimeout();
        Duration other$responseTimeout = other.getResponseTimeout();
        if (this$responseTimeout == null ? other$responseTimeout != null : !((Object)this$responseTimeout).equals(other$responseTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Duration this$connectionIdleTimeout = this.getConnectionIdleTimeout();
        Duration other$connectionIdleTimeout = other.getConnectionIdleTimeout();
        return !(this$connectionIdleTimeout == null ? other$connectionIdleTimeout != null : !((Object)this$connectionIdleTimeout).equals(other$connectionIdleTimeout));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $proxyPort = this.getProxyPort();
        result = result * 59 + ($proxyPort == null ? 43 : ((Object)$proxyPort).hashCode());
        Integer $connectionPoolSize = this.getConnectionPoolSize();
        result = result * 59 + ($connectionPoolSize == null ? 43 : ((Object)$connectionPoolSize).hashCode());
        Integer $maximumAsyncRequests = this.getMaximumAsyncRequests();
        result = result * 59 + ($maximumAsyncRequests == null ? 43 : ((Object)$maximumAsyncRequests).hashCode());
        Integer $maximumAsyncRequestsPerHost = this.getMaximumAsyncRequestsPerHost();
        result = result * 59 + ($maximumAsyncRequestsPerHost == null ? 43 : ((Object)$maximumAsyncRequestsPerHost).hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
        Authenticator $proxyAuthenticator = this.getProxyAuthenticator();
        result = result * 59 + ($proxyAuthenticator == null ? 43 : $proxyAuthenticator.hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $writeTimeout = this.getWriteTimeout();
        result = result * 59 + ($writeTimeout == null ? 43 : ((Object)$writeTimeout).hashCode());
        Duration $responseTimeout = this.getResponseTimeout();
        result = result * 59 + ($responseTimeout == null ? 43 : ((Object)$responseTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Duration $connectionIdleTimeout = this.getConnectionIdleTimeout();
        result = result * 59 + ($connectionIdleTimeout == null ? 43 : ((Object)$connectionIdleTimeout).hashCode());
        return result;
    }

    public String toString() {
        return "ConnectionConfigurations(proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", proxyAuthenticator=" + this.getProxyAuthenticator() + ", connectTimeout=" + this.getConnectTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", responseTimeout=" + this.getResponseTimeout() + ", readTimeout=" + this.getReadTimeout() + ", connectionIdleTimeout=" + this.getConnectionIdleTimeout() + ", connectionPoolSize=" + this.getConnectionPoolSize() + ", maximumAsyncRequests=" + this.getMaximumAsyncRequests() + ", maximumAsyncRequestsPerHost=" + this.getMaximumAsyncRequestsPerHost() + ")";
    }

    private static final class ConnectionConfigurationsBuilderImpl
    extends ConnectionConfigurationsBuilder<ConnectionConfigurations, ConnectionConfigurationsBuilderImpl> {
        private ConnectionConfigurationsBuilderImpl() {
        }

        @Override
        protected ConnectionConfigurationsBuilderImpl self() {
            return this;
        }

        @Override
        public ConnectionConfigurations build() {
            return new ConnectionConfigurations(this);
        }
    }

    public static abstract class ConnectionConfigurationsBuilder<C extends ConnectionConfigurations, B extends ConnectionConfigurationsBuilder<C, B>> {
        private String proxyHost;
        private Integer proxyPort;
        private Authenticator proxyAuthenticator;
        private Duration connectTimeout;
        private Duration writeTimeout;
        private Duration responseTimeout;
        private Duration readTimeout;
        private Duration connectionIdleTimeout;
        private Integer connectionPoolSize;
        private Integer maximumAsyncRequests;
        private Integer maximumAsyncRequestsPerHost;

        public B proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this.self();
        }

        public B proxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
            return this.self();
        }

        public B proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this.self();
        }

        public B connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this.self();
        }

        public B writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this.self();
        }

        public B responseTimeout(Duration responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this.self();
        }

        public B readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this.self();
        }

        public B connectionIdleTimeout(Duration connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this.self();
        }

        public B connectionPoolSize(Integer connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this.self();
        }

        public B maximumAsyncRequests(Integer maximumAsyncRequests) {
            this.maximumAsyncRequests = maximumAsyncRequests;
            return this.self();
        }

        public B maximumAsyncRequestsPerHost(Integer maximumAsyncRequestsPerHost) {
            this.maximumAsyncRequestsPerHost = maximumAsyncRequestsPerHost;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ConnectionConfigurations.ConnectionConfigurationsBuilder(proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyAuthenticator=" + this.proxyAuthenticator + ", connectTimeout=" + this.connectTimeout + ", writeTimeout=" + this.writeTimeout + ", responseTimeout=" + this.responseTimeout + ", readTimeout=" + this.readTimeout + ", connectionIdleTimeout=" + this.connectionIdleTimeout + ", connectionPoolSize=" + this.connectionPoolSize + ", maximumAsyncRequests=" + this.maximumAsyncRequests + ", maximumAsyncRequestsPerHost=" + this.maximumAsyncRequestsPerHost + ")";
        }
    }
}

