/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.bigquery.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQueryCreateTableStatement;
import com.alibaba.druid.sql.dialect.bigquery.parser.BigQuerySelectParser;
import com.alibaba.druid.sql.dialect.db2.parser.DB2ExprParser;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class BigQueryCreateTableParser
extends SQLCreateTableParser {
    public BigQueryCreateTableParser(String sql) {
        super(new DB2ExprParser(sql));
    }

    public BigQueryCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    protected SQLCreateTableStatement newCreateStatement() {
        return new BigQueryCreateTableStatement();
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new BigQuerySelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    protected void parseCreateTableRest(SQLCreateTableStatement x) {
        BigQueryCreateTableStatement stmt = (BigQueryCreateTableStatement)x;
        block0: while (true) {
            if (this.lexer.nextIf(Token.DEFAULT)) {
                this.acceptIdentifier("COLLATE");
                SQLExpr collate = this.exprParser.expr();
                stmt.setCollate(collate);
            }
            if (this.lexer.nextIf(Token.PARTITION)) {
                this.accept(Token.BY);
                this.exprParser.exprList(stmt.getPartitionBy(), stmt);
                continue;
            }
            if (this.lexer.nextIfIdentifier("CLUSTER")) {
                this.accept(Token.BY);
                while (true) {
                    SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
                    item.setParent(stmt);
                    stmt.getClusteredBy().add(item);
                    if (!this.lexer.nextIf(Token.COMMA)) continue block0;
                }
            }
            if (this.lexer.nextIfIdentifier("OPTIONS")) {
                this.exprParser.parseAssignItem(stmt.getTableOptions(), (SQLObject)stmt);
                continue;
            }
            if (this.lexer.nextIfIdentifier("CLONE")) {
                stmt.setLike(this.exprParser.name());
                continue;
            }
            if (this.lexer.nextIfIdentifier(FnvHash.Constants.LIFECYCLE)) {
                this.lexer.nextIf(Token.EQ);
                stmt.setLifeCycle(this.exprParser.primary());
                continue;
            }
            if (!this.lexer.nextIf(Token.AS)) break;
            stmt.setSelect(this.createSQLSelectParser().select());
        }
    }

    @Override
    protected void createTableBefore(SQLCreateTableStatement createTable) {
        if (this.lexer.nextIfIdentifier("TEMPORARY") || this.lexer.nextIfIdentifier("TEMP")) {
            createTable.setTemporary(true);
        }
        if (this.lexer.nextIf(Token.OR)) {
            this.accept(Token.REPLACE);
            createTable.config(SQLCreateTableStatement.Feature.OrReplace);
        }
        if (this.lexer.nextIfIdentifier("TEMPORARY") || this.lexer.nextIfIdentifier("TEMP")) {
            createTable.setTemporary(true);
        }
    }

    @Override
    protected SQLSelect createTableQueryRest() {
        return new BigQuerySelectParser(this.exprParser, this.selectListCache).select();
    }
}

