/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.executor;

import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.enums.WriteDirectionEnum;
import com.alibaba.excel.enums.WriteTemplateAnalysisCellTypeEnum;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.util.WriteHandlerUtils;
import com.alibaba.excel.write.executor.AbstractExcelWriteExecutor;
import com.alibaba.excel.write.metadata.fill.AnalysisCell;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.fill.FillWrapper;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.beans.BeanMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelWriteFillExecutor
extends AbstractExcelWriteExecutor {
    private static final String ESCAPE_FILL_PREFIX = "\\\\\\{";
    private static final String ESCAPE_FILL_SUFFIX = "\\\\\\}";
    private static final String FILL_PREFIX = "{";
    private static final String FILL_SUFFIX = "}";
    private static final char IGNORE_CHAR = '\\';
    private static final String COLLECTION_PREFIX = ".";
    private final Map<String, List<AnalysisCell>> templateAnalysisCache = new HashMap<String, List<AnalysisCell>>(8);
    private final Map<String, List<AnalysisCell>> templateCollectionAnalysisCache = new HashMap<String, List<AnalysisCell>>(8);
    private final Map<String, Map<AnalysisCell, CellStyle>> collectionFieldStyleCache = new HashMap<String, Map<AnalysisCell, CellStyle>>(8);
    private final Map<String, Short> collectionRowHeightCache = new HashMap<String, Short>(8);
    private final Map<String, Map<AnalysisCell, Integer>> collectionLastIndexCache = new HashMap<String, Map<AnalysisCell, Integer>>(8);
    private final Map<String, Integer> relativeRowIndexMap = new HashMap<String, Integer>(8);
    private String currentDataPrefix;
    private String currentUniqueDataFlag;

    public ExcelWriteFillExecutor(WriteContext writeContext) {
        super(writeContext);
    }

    public void fill(Object data, FillConfig fillConfig) {
        Object realData;
        if (data == null) {
            data = new HashMap(16);
        }
        if (fillConfig == null) {
            fillConfig = FillConfig.builder().build(true);
        }
        fillConfig.init();
        if (data instanceof FillWrapper) {
            FillWrapper fillWrapper = (FillWrapper)((Object)data);
            this.currentDataPrefix = fillWrapper.getName();
            realData = fillWrapper.getCollectionData();
        } else {
            realData = data;
            this.currentDataPrefix = null;
        }
        this.currentUniqueDataFlag = this.uniqueDataFlag(this.writeContext.writeSheetHolder(), this.currentDataPrefix);
        if (realData instanceof Collection) {
            List<AnalysisCell> analysisCellList = this.readTemplateData(this.templateCollectionAnalysisCache);
            Collection collectionData = (Collection)realData;
            if (CollectionUtils.isEmpty(collectionData)) {
                return;
            }
            Iterator iterator = collectionData.iterator();
            if (WriteDirectionEnum.VERTICAL.equals((Object)fillConfig.getDirection()) && fillConfig.getForceNewRow().booleanValue()) {
                this.shiftRows(collectionData.size(), analysisCellList);
            }
            while (iterator.hasNext()) {
                this.doFill(analysisCellList, iterator.next(), fillConfig, this.getRelativeRowIndex());
            }
        } else {
            this.doFill(this.readTemplateData(this.templateAnalysisCache), realData, fillConfig, null);
        }
    }

    private void shiftRows(int size, List<AnalysisCell> analysisCellList) {
        if (CollectionUtils.isEmpty(analysisCellList)) {
            return;
        }
        int maxRowIndex = 0;
        Map<AnalysisCell, Integer> collectionLastIndexMap = this.collectionLastIndexCache.get(this.currentUniqueDataFlag);
        for (AnalysisCell analysisCell : analysisCellList) {
            Integer lastRowIndex;
            if (collectionLastIndexMap != null && (lastRowIndex = collectionLastIndexMap.get(analysisCell)) != null) {
                if (lastRowIndex <= maxRowIndex) continue;
                maxRowIndex = lastRowIndex;
                continue;
            }
            if (analysisCell.getRowIndex() <= maxRowIndex) continue;
            maxRowIndex = analysisCell.getRowIndex();
        }
        Sheet cachedSheet = this.writeContext.writeSheetHolder().getCachedSheet();
        int lastRowIndex = cachedSheet.getLastRowNum();
        if (maxRowIndex >= lastRowIndex) {
            return;
        }
        Sheet sheet = this.writeContext.writeSheetHolder().getCachedSheet();
        int number = size;
        if (collectionLastIndexMap == null) {
            --number;
        }
        if (number <= 0) {
            return;
        }
        sheet.shiftRows(maxRowIndex + 1, lastRowIndex, number, true, false);
        String tablePrefix = this.tablePrefix(this.currentUniqueDataFlag);
        this.increaseRowIndex(this.templateAnalysisCache, number, maxRowIndex, tablePrefix);
        this.increaseRowIndex(this.templateCollectionAnalysisCache, number, maxRowIndex, tablePrefix);
    }

    private void increaseRowIndex(Map<String, List<AnalysisCell>> templateAnalysisCache, int number, int maxRowIndex, String tablePrefix) {
        for (Map.Entry<String, List<AnalysisCell>> entry : templateAnalysisCache.entrySet()) {
            if (!tablePrefix.equals(this.tablePrefix(entry.getKey()))) continue;
            for (AnalysisCell analysisCell : entry.getValue()) {
                if (analysisCell.getRowIndex() <= maxRowIndex) continue;
                analysisCell.setRowIndex(analysisCell.getRowIndex() + number);
            }
        }
    }

    private void doFill(List<AnalysisCell> analysisCellList, Object oneRowData, FillConfig fillConfig, Integer relativeRowIndex) {
        Map dataMap = oneRowData instanceof Map ? (Map)oneRowData : BeanMap.create((Object)oneRowData);
        WriteSheetHolder writeSheetHolder = this.writeContext.writeSheetHolder();
        Map<String, ExcelContentProperty> fieldNameContentPropertyMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getFieldNameContentPropertyMap();
        for (AnalysisCell analysisCell : analysisCellList) {
            Cell cell = this.getOneCell(analysisCell, fillConfig);
            if (analysisCell.getOnlyOneVariable().booleanValue()) {
                String variable = analysisCell.getVariableList().get(0);
                if (!dataMap.containsKey(variable)) continue;
                Object value = dataMap.get(variable);
                CellData cellData = this.converterAndSet(writeSheetHolder, value == null ? null : value.getClass(), cell, value, fieldNameContentPropertyMap.get(variable), null, relativeRowIndex);
                WriteHandlerUtils.afterCellDispose(this.writeContext, cellData, cell, null, relativeRowIndex, Boolean.FALSE);
                continue;
            }
            StringBuilder cellValueBuild = new StringBuilder();
            int index = 0;
            ArrayList<CellData> cellDataList = new ArrayList<CellData>();
            for (String variable : analysisCell.getVariableList()) {
                cellValueBuild.append(analysisCell.getPrepareDataList().get(index++));
                if (!dataMap.containsKey(variable)) continue;
                Object value = dataMap.get(variable);
                CellData cellData = this.convert(writeSheetHolder, value == null ? null : value.getClass(), cell, value, fieldNameContentPropertyMap.get(variable));
                cellDataList.add(cellData);
                CellDataTypeEnum type = cellData.getType();
                if (type == null) continue;
                switch (type) {
                    case STRING: {
                        cellValueBuild.append(cellData.getStringValue());
                        break;
                    }
                    case BOOLEAN: {
                        cellValueBuild.append(cellData.getBooleanValue());
                        break;
                    }
                    case NUMBER: {
                        cellValueBuild.append(cellData.getNumberValue());
                        break;
                    }
                }
            }
            cellValueBuild.append(analysisCell.getPrepareDataList().get(index));
            cell.setCellValue(cellValueBuild.toString());
            WriteHandlerUtils.afterCellDispose(this.writeContext, cellDataList, cell, null, relativeRowIndex, Boolean.FALSE);
        }
    }

    private Integer getRelativeRowIndex() {
        Integer relativeRowIndex = this.relativeRowIndexMap.get(this.currentUniqueDataFlag);
        if (relativeRowIndex == null) {
            relativeRowIndex = 0;
        } else {
            Integer n = relativeRowIndex;
            Integer n2 = relativeRowIndex = Integer.valueOf(relativeRowIndex + 1);
        }
        this.relativeRowIndexMap.put(this.currentUniqueDataFlag, relativeRowIndex);
        return relativeRowIndex;
    }

    private Cell getOneCell(AnalysisCell analysisCell, FillConfig fillConfig) {
        Integer lastColumnIndex;
        Integer lastRowIndex;
        Sheet cachedSheet = this.writeContext.writeSheetHolder().getCachedSheet();
        if (WriteTemplateAnalysisCellTypeEnum.COMMON.equals((Object)analysisCell.getCellType())) {
            return cachedSheet.getRow(analysisCell.getRowIndex()).getCell(analysisCell.getColumnIndex());
        }
        Sheet sheet = this.writeContext.writeSheetHolder().getSheet();
        Map<AnalysisCell, Integer> collectionLastIndexMap = this.collectionLastIndexCache.get(this.currentUniqueDataFlag);
        if (collectionLastIndexMap == null) {
            collectionLastIndexMap = new HashMap<AnalysisCell, Integer>(16);
            this.collectionLastIndexCache.put(this.currentUniqueDataFlag, collectionLastIndexMap);
        }
        boolean isOriginalCell = false;
        switch (fillConfig.getDirection()) {
            case VERTICAL: {
                lastRowIndex = collectionLastIndexMap.get(analysisCell);
                if (lastRowIndex == null) {
                    lastRowIndex = analysisCell.getRowIndex();
                    collectionLastIndexMap.put(analysisCell, lastRowIndex);
                    isOriginalCell = true;
                } else {
                    lastRowIndex = lastRowIndex + 1;
                    collectionLastIndexMap.put(analysisCell, lastRowIndex);
                }
                lastColumnIndex = analysisCell.getColumnIndex();
                break;
            }
            case HORIZONTAL: {
                lastRowIndex = analysisCell.getRowIndex();
                lastColumnIndex = collectionLastIndexMap.get(analysisCell);
                if (lastColumnIndex == null) {
                    lastColumnIndex = analysisCell.getColumnIndex();
                    collectionLastIndexMap.put(analysisCell, lastColumnIndex);
                    isOriginalCell = true;
                    break;
                }
                lastColumnIndex = lastColumnIndex + 1;
                collectionLastIndexMap.put(analysisCell, lastColumnIndex);
                break;
            }
            default: {
                throw new ExcelGenerateException("The wrong direction.");
            }
        }
        Row row = this.createRowIfNecessary(sheet, cachedSheet, lastRowIndex, fillConfig, analysisCell, isOriginalCell);
        Cell cell = this.createCellIfNecessary(row, lastColumnIndex);
        Map<AnalysisCell, CellStyle> collectionFieldStyleMap = this.collectionFieldStyleCache.get(this.currentUniqueDataFlag);
        if (collectionFieldStyleMap == null) {
            collectionFieldStyleMap = new HashMap<AnalysisCell, CellStyle>(16);
            this.collectionFieldStyleCache.put(this.currentUniqueDataFlag, collectionFieldStyleMap);
        }
        if (isOriginalCell) {
            collectionFieldStyleMap.put(analysisCell, cell.getCellStyle());
        } else {
            CellStyle cellStyle = collectionFieldStyleMap.get(analysisCell);
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
        }
        return cell;
    }

    private Cell createCellIfNecessary(Row row, Integer lastColumnIndex) {
        Cell cell = row.getCell(lastColumnIndex.intValue());
        if (cell != null) {
            return cell;
        }
        WriteHandlerUtils.beforeCellCreate(this.writeContext, row, null, lastColumnIndex, null, Boolean.FALSE);
        cell = row.createCell(lastColumnIndex.intValue());
        WriteHandlerUtils.afterCellCreate(this.writeContext, cell, null, null, Boolean.FALSE);
        return cell;
    }

    private Row createRowIfNecessary(Sheet sheet, Sheet cachedSheet, Integer lastRowIndex, FillConfig fillConfig, AnalysisCell analysisCell, boolean isOriginalCell) {
        Row row = sheet.getRow(lastRowIndex.intValue());
        if (row != null) {
            return row;
        }
        row = cachedSheet.getRow(lastRowIndex.intValue());
        if (row == null) {
            WriteHandlerUtils.beforeRowCreate(this.writeContext, lastRowIndex, null, Boolean.FALSE);
            if (fillConfig.getForceNewRow().booleanValue()) {
                row = cachedSheet.createRow(lastRowIndex.intValue());
            } else {
                try {
                    row = sheet.createRow(lastRowIndex.intValue());
                }
                catch (IllegalArgumentException ignore) {
                    row = cachedSheet.createRow(lastRowIndex.intValue());
                }
            }
            this.checkRowHeight(analysisCell, fillConfig, isOriginalCell, row);
            WriteHandlerUtils.afterRowCreate(this.writeContext, row, null, Boolean.FALSE);
        } else {
            this.checkRowHeight(analysisCell, fillConfig, isOriginalCell, row);
        }
        return row;
    }

    private void checkRowHeight(AnalysisCell analysisCell, FillConfig fillConfig, boolean isOriginalCell, Row row) {
        if (!analysisCell.getFirstRow().booleanValue() || !WriteDirectionEnum.VERTICAL.equals((Object)fillConfig.getDirection())) {
            return;
        }
        if (isOriginalCell) {
            this.collectionRowHeightCache.put(this.currentUniqueDataFlag, row.getHeight());
            return;
        }
        Short rowHeight = this.collectionRowHeightCache.get(this.currentUniqueDataFlag);
        if (rowHeight != null) {
            row.setHeight(rowHeight.shortValue());
        }
    }

    private List<AnalysisCell> readTemplateData(Map<String, List<AnalysisCell>> analysisCache) {
        List<AnalysisCell> analysisCellList = analysisCache.get(this.currentUniqueDataFlag);
        if (analysisCellList != null) {
            return analysisCellList;
        }
        Sheet sheet = this.writeContext.writeSheetHolder().getCachedSheet();
        HashMap<String, Set<Integer>> firstRowCache = new HashMap<String, Set<Integer>>(8);
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                String preparedData;
                Cell cell = row.getCell(j);
                if (cell == null || (preparedData = this.prepareData(cell, i, j, firstRowCache)) == null) continue;
                cell.setCellValue(preparedData);
            }
        }
        return analysisCache.get(this.currentUniqueDataFlag);
    }

    private String prepareData(Cell cell, int rowIndex, int columnIndex, Map<String, Set<Integer>> firstRowCache) {
        int prefixIndex;
        if (!CellType.STRING.equals((Object)cell.getCellTypeEnum())) {
            return null;
        }
        String value = cell.getStringCellValue();
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        StringBuilder preparedData = new StringBuilder();
        AnalysisCell analysisCell = null;
        int startIndex = 0;
        int length = value.length();
        int lastPrepareDataIndex = 0;
        block0: while (startIndex < length && (prefixIndex = value.indexOf(FILL_PREFIX, startIndex)) >= 0) {
            String variable;
            char prefixPrefixChar;
            if (prefixIndex != 0 && (prefixPrefixChar = value.charAt(prefixIndex - 1)) == '\\') {
                startIndex = prefixIndex + 1;
                continue;
            }
            int suffixIndex = -1;
            while (suffixIndex == -1 && startIndex < length) {
                suffixIndex = value.indexOf(FILL_SUFFIX, startIndex + 1);
                if (suffixIndex < 0) break block0;
                startIndex = suffixIndex + 1;
                char prefixSuffixChar = value.charAt(suffixIndex - 1);
                if (prefixSuffixChar != '\\') continue;
                suffixIndex = -1;
            }
            if (analysisCell == null) {
                analysisCell = this.initAnalysisCell(rowIndex, columnIndex);
            }
            if (StringUtils.isEmpty(variable = value.substring(prefixIndex + 1, suffixIndex))) continue;
            int collectPrefixIndex = variable.indexOf(COLLECTION_PREFIX);
            if (collectPrefixIndex > -1) {
                if (collectPrefixIndex != 0) {
                    analysisCell.setPrefix(variable.substring(0, collectPrefixIndex));
                }
                if (StringUtils.isEmpty(variable = variable.substring(collectPrefixIndex + 1))) continue;
                analysisCell.setCellType(WriteTemplateAnalysisCellTypeEnum.COLLECTION);
            }
            analysisCell.getVariableList().add(variable);
            if (lastPrepareDataIndex == prefixIndex) {
                analysisCell.getPrepareDataList().add("");
            } else {
                String data = this.convertPrepareData(value.substring(lastPrepareDataIndex, prefixIndex));
                preparedData.append(data);
                analysisCell.getPrepareDataList().add(data);
                analysisCell.setOnlyOneVariable(Boolean.FALSE);
            }
            lastPrepareDataIndex = suffixIndex + 1;
        }
        return this.dealAnalysisCell(analysisCell, value, rowIndex, lastPrepareDataIndex, length, firstRowCache, preparedData);
    }

    private String dealAnalysisCell(AnalysisCell analysisCell, String value, int rowIndex, int lastPrepareDataIndex, int length, Map<String, Set<Integer>> firstRowCache, StringBuilder preparedData) {
        if (analysisCell != null) {
            if (lastPrepareDataIndex == length) {
                analysisCell.getPrepareDataList().add("");
            } else {
                analysisCell.getPrepareDataList().add(this.convertPrepareData(value.substring(lastPrepareDataIndex)));
                analysisCell.setOnlyOneVariable(Boolean.FALSE);
            }
            String uniqueDataFlag = this.uniqueDataFlag(this.writeContext.writeSheetHolder(), analysisCell.getPrefix());
            if (WriteTemplateAnalysisCellTypeEnum.COMMON.equals((Object)analysisCell.getCellType())) {
                List<AnalysisCell> analysisCellList = this.templateAnalysisCache.get(uniqueDataFlag);
                if (analysisCellList == null) {
                    analysisCellList = new ArrayList<AnalysisCell>();
                    this.templateAnalysisCache.put(uniqueDataFlag, analysisCellList);
                }
                analysisCellList.add(analysisCell);
            } else {
                List<AnalysisCell> collectionAnalysisCellList;
                Set<Integer> uniqueFirstRowCache = firstRowCache.get(uniqueDataFlag);
                if (uniqueFirstRowCache == null) {
                    uniqueFirstRowCache = new HashSet<Integer>();
                    firstRowCache.put(uniqueDataFlag, uniqueFirstRowCache);
                }
                if (!uniqueFirstRowCache.contains(rowIndex)) {
                    analysisCell.setFirstRow(Boolean.TRUE);
                    uniqueFirstRowCache.add(rowIndex);
                }
                if ((collectionAnalysisCellList = this.templateCollectionAnalysisCache.get(uniqueDataFlag)) == null) {
                    collectionAnalysisCellList = new ArrayList<AnalysisCell>();
                    this.templateCollectionAnalysisCache.put(uniqueDataFlag, collectionAnalysisCellList);
                }
                collectionAnalysisCellList.add(analysisCell);
            }
            return preparedData.toString();
        }
        return null;
    }

    private AnalysisCell initAnalysisCell(Integer rowIndex, Integer columnIndex) {
        AnalysisCell analysisCell = new AnalysisCell();
        analysisCell.setRowIndex(rowIndex);
        analysisCell.setColumnIndex(columnIndex);
        analysisCell.setOnlyOneVariable(Boolean.TRUE);
        ArrayList<String> variableList = new ArrayList<String>();
        analysisCell.setVariableList(variableList);
        ArrayList<String> prepareDataList = new ArrayList<String>();
        analysisCell.setPrepareDataList(prepareDataList);
        analysisCell.setCellType(WriteTemplateAnalysisCellTypeEnum.COMMON);
        analysisCell.setFirstRow(Boolean.FALSE);
        return analysisCell;
    }

    private String convertPrepareData(String prepareData) {
        prepareData = prepareData.replaceAll(ESCAPE_FILL_PREFIX, FILL_PREFIX);
        prepareData = prepareData.replaceAll(ESCAPE_FILL_SUFFIX, FILL_SUFFIX);
        return prepareData;
    }

    private String uniqueDataFlag(WriteSheetHolder writeSheetHolder, String wrapperName) {
        String prefix = writeSheetHolder.getSheetNo() != null ? writeSheetHolder.getSheetNo().toString() : writeSheetHolder.getSheetName().toString();
        if (StringUtils.isEmpty(wrapperName)) {
            return prefix + "-";
        }
        return prefix + "-" + wrapperName;
    }

    private String tablePrefix(String uniqueDataFlag) {
        return uniqueDataFlag.substring(0, uniqueDataFlag.indexOf("-") + 1);
    }
}

