/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api;

import com.alipay.api.internal.util.AlipayUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileItem {
    private String fileName;
    private String mimeType;
    private byte[] content;
    private File file;

    public FileItem(File file) {
        this.file = file;
    }

    public FileItem(String filePath) {
        this(new File(filePath));
    }

    public FileItem(String fileName, byte[] content) {
        this.fileName = fileName;
        this.content = content;
    }

    public FileItem(String fileName, byte[] content, String mimeType) {
        this(fileName, content);
        this.mimeType = mimeType;
    }

    public String getFileName() {
        if (this.fileName == null && this.file != null && this.file.exists()) {
            this.fileName = this.file.getName();
        }
        return this.fileName;
    }

    public String getMimeType() throws IOException {
        if (this.mimeType == null) {
            this.mimeType = AlipayUtils.getMimeType(this.getContent());
        }
        return this.mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContent() throws IOException {
        if (this.content == null && this.file != null && this.file.exists()) {
            FileInputStream in;
            block7: {
                in = null;
                ByteArrayOutputStream out = null;
                try {
                    int ch;
                    in = new FileInputStream(this.file);
                    out = new ByteArrayOutputStream();
                    while ((ch = ((InputStream)in).read()) != -1) {
                        out.write(ch);
                    }
                    this.content = out.toByteArray();
                    Object var5_4 = null;
                    if (out == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    throw throwable;
                }
                out.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return this.content;
    }
}

