/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.metaserver;

import com.alipay.remoting.Connection;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.constants.ValueConstants;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.metaserver.GetNodesRequest;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.metaserver.ReNewNodesRequest;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.jraft.bootstrap.RaftClient;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DataServerChangeItem;
import com.alipay.sofa.registry.server.data.node.DataServerNode;
import com.alipay.sofa.registry.server.data.remoting.MetaNodeExchanger;
import com.alipay.sofa.registry.server.data.remoting.dataserver.DataServerNodeFactory;
import com.alipay.sofa.registry.server.data.remoting.metaserver.IMetaServerService;
import com.alipay.sofa.registry.server.data.remoting.metaserver.MetaServerConnectionFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultMetaServiceImpl
implements IMetaServerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMetaServiceImpl.class);
    @Autowired
    private DataServerConfig dataServerBootstrapConfig;
    @Autowired
    private MetaNodeExchanger metaNodeExchanger;
    @Autowired
    private MetaServerConnectionFactory metaServerConnectionFactory;
    private RaftClient raftClient;
    private AtomicBoolean clientStart = new AtomicBoolean(false);

    @Override
    public Map<String, Set<String>> getMetaServerMap() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        Set<String> set = this.dataServerBootstrapConfig.getMetaServerIpAddresses();
        Map<String, Connection> connectionMap = this.metaServerConnectionFactory.getConnections(this.dataServerBootstrapConfig.getLocalDataCenter());
        Connection connection = null;
        try {
            NodeChangeResult result;
            Map metaNodesMap;
            connection = connectionMap.isEmpty() ? ((BoltChannel)this.metaNodeExchanger.connect(new URL(set.iterator().next(), this.dataServerBootstrapConfig.getMetaServerPort()))).getConnection() : connectionMap.values().iterator().next();
            final GetNodesRequest request = new GetNodesRequest(Node.NodeType.META);
            final Connection finalConnection = connection;
            Object obj = this.metaNodeExchanger.request(new Request(){

                public Object getRequestBody() {
                    return request;
                }

                public URL getRequestUrl() {
                    return new URL(finalConnection.getRemoteIP(), finalConnection.getRemotePort());
                }
            }).getResult();
            if (obj instanceof NodeChangeResult && (metaNodesMap = (result = (NodeChangeResult)obj).getNodes()) != null && !metaNodesMap.isEmpty()) {
                Map metaNodeMap = (Map)metaNodesMap.get(this.dataServerBootstrapConfig.getLocalDataCenter());
                if (metaNodeMap != null && !metaNodeMap.isEmpty()) {
                    map.put(this.dataServerBootstrapConfig.getLocalDataCenter(), metaNodeMap.keySet());
                } else {
                    LOGGER.error("[DefaultMetaServiceImpl] refresh connections from metaServer {} has no result!", (Object)connection.getRemoteIP());
                }
            }
        }
        catch (Exception e) {
            String con = connection != null ? connection.getRemoteIP() : "null";
            LOGGER.error("[DefaultMetaServiceImpl] refresh connections from metaServer error : {}", (Object)con, (Object)e);
            LOGGER.warn("[DefaultMetaServiceImpl] refresh connections from metaServer error,refresh leader : {}", (Object)con);
        }
        return map;
    }

    @Override
    public DataServerNode getDataServer(String dataCenter, String dataInfoId) {
        return DataServerNodeFactory.computeDataServerNode(dataCenter, dataInfoId);
    }

    @Override
    public List<DataServerNode> getDataServers(String dataCenter, String dataInfoId) {
        return DataServerNodeFactory.computeDataServerNodes(dataCenter, dataInfoId, this.dataServerBootstrapConfig.getStoreNodes());
    }

    @Override
    public DataServerChangeItem getDateServers() {
        Connection connection;
        String leader;
        Map<String, Connection> connectionMap = this.metaServerConnectionFactory.getConnections(this.dataServerBootstrapConfig.getLocalDataCenter());
        if (connectionMap.containsKey(leader = this.getLeader().getIp()) && (connection = connectionMap.get(leader)).isFine()) {
            try {
                final GetNodesRequest request = new GetNodesRequest(Node.NodeType.DATA);
                Object obj = this.metaNodeExchanger.request(new Request(){

                    public Object getRequestBody() {
                        return request;
                    }

                    public URL getRequestUrl() {
                        return new URL(connection.getRemoteIP(), connection.getRemotePort());
                    }
                }).getResult();
                if (obj instanceof NodeChangeResult) {
                    NodeChangeResult result = (NodeChangeResult)obj;
                    Map versionMap = result.getDataCenterListVersions();
                    versionMap.put(result.getLocalDataCenter(), result.getVersion());
                    return new DataServerChangeItem(result.getNodes(), versionMap);
                }
            }
            catch (Exception e) {
                LOGGER.error("[ConnectionRefreshTask] refresh connections from metaServer error : {}", (Object)leader, (Object)e);
                String newip = this.refreshLeader().getIp();
                LOGGER.warn("[ConnectionRefreshTask] refresh connections from metaServer error,refresh leader : {}", (Object)newip);
            }
        }
        String newip = this.refreshLeader().getIp();
        LOGGER.warn("[ConnectionRefreshTask] refresh connections metaServer not fine,refresh leader : {}", (Object)newip);
        return null;
    }

    @Override
    public List<String> getOtherDataCenters() {
        HashSet<String> all = new HashSet<String>(DataServerNodeFactory.getAllDataCenters());
        all.remove(this.dataServerBootstrapConfig.getLocalDataCenter());
        return new ArrayList<String>(all);
    }

    @Override
    public void reNewNodeTask() {
        Map<String, Connection> connectionMap = this.metaServerConnectionFactory.getConnections(this.dataServerBootstrapConfig.getLocalDataCenter());
        for (Map.Entry<String, Connection> connectEntry : connectionMap.entrySet()) {
            String ip = connectEntry.getKey();
            if (!ip.equals(this.getLeader().getIp())) continue;
            final Connection connection = connectEntry.getValue();
            if (connection.isFine()) {
                try {
                    final ReNewNodesRequest reNewNodesRequest = new ReNewNodesRequest((Node)new DataNode(new URL(DataServerConfig.IP), this.dataServerBootstrapConfig.getLocalDataCenter()));
                    this.metaNodeExchanger.request(new Request(){

                        public Object getRequestBody() {
                            return reNewNodesRequest;
                        }

                        public URL getRequestUrl() {
                            return new URL(connection.getRemoteIP(), connection.getRemotePort());
                        }
                    }).getResult();
                }
                catch (Exception e) {
                    LOGGER.error("[ReNewNodeTask] reNew data node to metaServer error : {}", (Object)ip, (Object)e);
                    String newip = this.refreshLeader().getIp();
                    LOGGER.warn("[ReNewNodeTask] reNew data node to metaServer error,leader refresh: {}", (Object)newip);
                }
                continue;
            }
            String newip = this.refreshLeader().getIp();
            LOGGER.warn("[ReNewNodeTask] reNew data node to metaServer not fine,leader refresh: {}", (Object)newip);
        }
    }

    @Override
    public void startRaftClient() {
        try {
            if (this.clientStart.compareAndSet(false, true)) {
                String serverConf = this.getServerConfig();
                this.raftClient = new RaftClient(this.getGroup(), serverConf);
                this.raftClient.start();
            }
        }
        catch (Exception e) {
            LOGGER.error("Start raft client error!", (Throwable)e);
            throw new RuntimeException("Start raft client error!", e);
        }
    }

    private String getServerConfig() {
        String ret = "";
        Set<String> ips = this.dataServerBootstrapConfig.getMetaServerIpAddresses();
        if (ips != null && !ips.isEmpty()) {
            ret = ips.stream().map(ip -> ip + ":" + ValueConstants.RAFT_SERVER_PORT).collect(Collectors.joining(","));
        }
        if (ret.isEmpty()) {
            throw new IllegalArgumentException("Init raft server config error!");
        }
        return ret;
    }

    private String getGroup() {
        return ValueConstants.RAFT_SERVER_GROUP + "_" + this.dataServerBootstrapConfig.getLocalDataCenter();
    }

    @Override
    public PeerId getLeader() {
        PeerId leader;
        if (this.raftClient == null) {
            this.startRaftClient();
        }
        if ((leader = this.raftClient.getLeader()) == null) {
            LOGGER.error("[DefaultMetaServiceImpl] register MetaServer get no leader!");
            throw new RuntimeException("[DefaultMetaServiceImpl] register MetaServer get no leader!");
        }
        return leader;
    }

    @Override
    public PeerId refreshLeader() {
        PeerId leader;
        if (this.raftClient == null) {
            this.startRaftClient();
        }
        if ((leader = this.raftClient.refreshLeader()) == null) {
            LOGGER.error("[RaftClientManager] refresh MetaServer get no leader!");
            throw new RuntimeException("[RaftClientManager] refresh MetaServer get no leader!");
        }
        return leader;
    }
}

