/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.metaserver.handler;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.event.DataServerChangeEvent;
import com.alipay.sofa.registry.server.data.event.EventCenter;
import com.alipay.sofa.registry.server.data.event.MetaServerChangeEvent;
import com.alipay.sofa.registry.server.data.executor.ExecutorFactory;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractClientHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class ServerChangeHandler
extends AbstractClientHandler<NodeChangeResult> {
    @Autowired
    private EventCenter eventCenter;
    @Autowired
    private DataServerConfig dataServerConfig;

    @Override
    public void checkParam(NodeChangeResult request) throws RuntimeException {
    }

    @Override
    public Object doHandle(Channel channel, NodeChangeResult request) {
        ExecutorFactory.getCommonExecutor().execute(() -> {
            Map metaNodeMap;
            Map metaNodesMap;
            if (request.getNodeType() == Node.NodeType.DATA) {
                this.eventCenter.post(new DataServerChangeEvent(request.getNodes(), request.getDataCenterListVersions()));
            } else if (request.getNodeType() == Node.NodeType.META && (metaNodesMap = request.getNodes()) != null && !metaNodesMap.isEmpty() && (metaNodeMap = (Map)metaNodesMap.get(this.dataServerConfig.getLocalDataCenter())) != null && !metaNodeMap.isEmpty()) {
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
                map.put(this.dataServerConfig.getLocalDataCenter(), metaNodeMap.keySet());
                this.eventCenter.post(new MetaServerChangeEvent(map));
            }
        });
        return CommonResponse.buildSuccessResponse();
    }

    public CommonResponse buildFailedResponse(String msg) {
        return CommonResponse.buildFailedResponse((String)msg);
    }

    @Override
    public Class interest() {
        return NodeChangeResult.class;
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

