/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.resource;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="digest")
public class DataDigestResource {
    @GET
    @Path(value="datum/query")
    @Produces(value={"application/json"})
    public Map<String, Datum> getDatumByDataInfoId(@QueryParam(value="dataId") String dataId, @QueryParam(value="group") String group, @QueryParam(value="instanceId") String instanceId, @QueryParam(value="dataCenter") String dataCenter) {
        Map<String, Datum> retList = new HashMap<String, Datum>();
        if (!(this.isBlank(dataId) || this.isBlank(instanceId) || this.isBlank(group))) {
            String dataInfoId = DataInfo.toDataInfoId((String)dataId, (String)instanceId, (String)group);
            if (this.isBlank(dataCenter)) {
                retList = DatumCache.get(dataInfoId);
            } else {
                retList.put(dataCenter, DatumCache.get(dataCenter, dataInfoId));
            }
        }
        return retList;
    }

    @POST
    @Path(value="connect/query")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Publisher>> getPublishersByConnectId(Map<String, String> map) {
        HashMap<String, Map<String, Publisher>> ret = new HashMap<String, Map<String, Publisher>>();
        if (map != null && !map.isEmpty()) {
            map.forEach((ip, port) -> {
                Map<String, Publisher> publisherMap;
                String connectId = NetUtil.genHost((String)ip, (int)Integer.valueOf(port));
                if (!connectId.isEmpty() && (publisherMap = DatumCache.getByHost(connectId)) != null && !publisherMap.isEmpty()) {
                    ret.put(connectId, publisherMap);
                }
            });
        }
        return ret;
    }

    @GET
    @Path(value="datum/count")
    @Produces(value={"application/json"})
    public String getDatumCount() {
        StringBuilder sb = new StringBuilder("CacheDigest");
        try {
            Map<String, Map<String, Datum>> allMap = DatumCache.getAll();
            if (!allMap.isEmpty()) {
                for (Map.Entry<String, Map<String, Datum>> dataCenterEntry : allMap.entrySet()) {
                    String dataCenter = dataCenterEntry.getKey();
                    Map<String, Datum> datumMap = dataCenterEntry.getValue();
                    sb.append(String.format(" [Datum] size of datum in %s is %s", dataCenter, datumMap.size()));
                    int pubCount = datumMap.values().stream().map(Datum::getPubMap).filter(map -> map != null && !map.isEmpty()).mapToInt(Map::size).sum();
                    sb.append(String.format(",[Publisher] size of publisher in %s is %s", dataCenter, pubCount));
                }
            } else {
                sb.append(" datum cache is empty");
            }
        }
        catch (Throwable t) {
            sb.append(" cache digest error!");
        }
        return sb.toString();
    }

    private boolean isBlank(String dataInfoId) {
        return dataInfoId == null || dataInfoId.isEmpty();
    }
}

