/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.aft.impl;

import com.alipay.sofa.rpc.client.aft.FaultToleranceConfigManager;
import com.alipay.sofa.rpc.client.aft.InvocationStatDimension;
import com.alipay.sofa.rpc.client.aft.MeasureResultDetail;
import com.alipay.sofa.rpc.client.aft.RegulationStrategy;
import com.alipay.sofa.rpc.common.struct.ConcurrentHashSet;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Extension(value="serviceHorizontal")
public class ServiceHorizontalRegulationStrategy
implements RegulationStrategy {
    protected final ConcurrentHashMap<String, ConcurrentHashSet<String>> appServiceDegradeIps = new ConcurrentHashMap();
    private final Lock ipsLock = new ReentrantLock();

    @Override
    public boolean isDegradeEffective(MeasureResultDetail measureResultDetail) {
        InvocationStatDimension statDimension = measureResultDetail.getInvocationStatDimension();
        return FaultToleranceConfigManager.isDegradeEffective(statDimension.getAppName());
    }

    protected ConcurrentHashSet<String> getDegradeProviders(String key) {
        ConcurrentHashSet<String> old;
        ConcurrentHashSet<String> ips = this.appServiceDegradeIps.get(key);
        if (ips == null && (old = this.appServiceDegradeIps.putIfAbsent(key, ips = new ConcurrentHashSet())) != null) {
            ips = old;
        }
        return ips;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReachMaxDegradeIpCount(MeasureResultDetail measureResultDetail) {
        String ip;
        InvocationStatDimension statDimension = measureResultDetail.getInvocationStatDimension();
        ConcurrentHashSet<String> ips = this.getDegradeProviders(statDimension.getDimensionKey());
        if (ips.contains(ip = statDimension.getIp())) {
            return false;
        }
        int degradeMaxIpCount = FaultToleranceConfigManager.getDegradeMaxIpCount(statDimension.getAppName());
        this.ipsLock.lock();
        try {
            if (ips.size() < degradeMaxIpCount) {
                ips.add(ip);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.ipsLock.unlock();
        }
    }

    @Override
    public boolean isExistInTheDegradeList(MeasureResultDetail measureResultDetail) {
        InvocationStatDimension statDimension = measureResultDetail.getInvocationStatDimension();
        ConcurrentHashSet<String> ips = this.getDegradeProviders(statDimension.getDimensionKey());
        return ips != null && ips.contains(statDimension.getIp());
    }

    @Override
    public void removeFromDegradeList(MeasureResultDetail measureResultDetail) {
        if (measureResultDetail.isRecoveredOriginWeight()) {
            InvocationStatDimension statDimension = measureResultDetail.getInvocationStatDimension();
            this.getDegradeProviders(statDimension.getDimensionKey()).remove(statDimension.getIp());
        }
    }
}

